/*
 * Decompiled with CFR 0.152.
 */
package org.openide.util.lookup;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openide.util.Lookup;
import org.openide.util.lookup.AbstractLookup;
import org.openide.util.lookup.implspi.SharedClassObjectBridge;

final class MetaInfServicesLookup
extends AbstractLookup {
    private static final Logger LOGGER = Logger.getLogger(MetaInfServicesLookup.class.getName());
    static final Executor RP;
    private static int knownInstancesCount;
    private static final List<Reference<Object>> knownInstances;
    private final Map<Class<?>, Object> classes = new WeakHashMap();
    private final ClassLoader loader;
    private final String prefix;

    public MetaInfServicesLookup(ClassLoader loader, String prefix) {
        this.loader = loader;
        this.prefix = prefix;
        LOGGER.log(Level.FINE, "Created: {0}", this);
    }

    @Override
    public String toString() {
        return "MetaInfServicesLookup[" + this.loader + "]";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected final void beforeLookup(Lookup.Template<?> t) {
        Class<?> c = t.getType();
        ArrayList toAdd = null;
        MetaInfServicesLookup metaInfServicesLookup = this;
        synchronized (metaInfServicesLookup) {
            if (this.classes.get(c) != null) {
                return;
            }
            toAdd = new ArrayList();
        }
        if (toAdd != null) {
            this.search(c, toAdd);
        }
        metaInfServicesLookup = this;
        synchronized (metaInfServicesLookup) {
            if (this.classes.put(c, "") == null) {
                LinkedHashSet<AbstractLookup.Pair<?>> arr = this.getPairsAsLHS();
                arr.addAll(toAdd);
                this.setPairs(arr, RP);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void search(Class<?> clazz, Collection<AbstractLookup.Pair<?>> result) {
        Enumeration<URL> en;
        if (LOGGER.isLoggable(Level.FINER)) {
            LOGGER.log(Level.FINER, "Searching for {0} in {1} from {2}", new Object[]{clazz.getName(), clazz.getClassLoader(), this});
        }
        String res = this.prefix + clazz.getName();
        try {
            en = this.loader.getResources(res);
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            return;
        }
        ArrayList<Item> foundClasses = new ArrayList<Item>();
        ArrayList removeClasses = new ArrayList();
        boolean foundOne = false;
        while (en.hasMoreElements()) {
            if (!foundOne) {
                foundOne = true;
                Class<?> realMcCoy = null;
                try {
                    realMcCoy = this.loader.loadClass(clazz.getName());
                }
                catch (ClassNotFoundException cnfe) {
                    // empty catch block
                }
                if (realMcCoy != clazz) {
                    if (realMcCoy != null) {
                        LOGGER.log(Level.WARNING, "{0} is not the real McCoy! Actually found it in {1} but searched for from {2}", new Object[]{clazz.getName(), realMcCoy.getClassLoader(), clazz.getClassLoader()});
                    } else {
                        LOGGER.log(Level.WARNING, "{0} could not be found in {1}", new Object[]{clazz.getName(), this.loader});
                    }
                    return;
                }
            }
            URL url = en.nextElement();
            Item currentItem = null;
            try {
                InputStream is = url.openStream();
                try {
                    String line;
                    BufferedReader reader = new BufferedReader(new InputStreamReader(is, "UTF-8"));
                    while ((line = reader.readLine()) != null) {
                        if ((line = line.trim()).startsWith("#position=")) {
                            if (currentItem == null) {
                                LOGGER.log(Level.WARNING, "Found line '{0}' in {1} but there is no item to associate it with", new Object[]{line, url});
                                continue;
                            }
                            try {
                                currentItem.position = Integer.parseInt(line.substring(10));
                            }
                            catch (NumberFormatException e) {
                                e.printStackTrace();
                            }
                        }
                        if (currentItem != null) {
                            this.insertItem(currentItem, foundClasses);
                            currentItem = null;
                        }
                        if (line.length() == 0) continue;
                        boolean remove = false;
                        if (line.charAt(0) == '#') {
                            if (line.length() == 1 || line.charAt(1) != '-') continue;
                            remove = true;
                            line = line.substring(2);
                        }
                        Class<?> inst = null;
                        try {
                            inst = Class.forName(line, false, this.loader);
                        }
                        catch (LinkageError err) {
                            if (remove) continue;
                            throw new ClassNotFoundException(err.getMessage(), err);
                        }
                        catch (ClassNotFoundException cnfe) {
                            if (remove) continue;
                            throw cnfe;
                        }
                        if (!clazz.isAssignableFrom(inst)) {
                            throw new ClassNotFoundException(MetaInfServicesLookup.clazzToString(inst) + " not a subclass of " + MetaInfServicesLookup.clazzToString(clazz));
                        }
                        if (remove) {
                            removeClasses.add(inst);
                            continue;
                        }
                        currentItem = new Item();
                        currentItem.clazz = inst;
                    }
                    if (currentItem == null) continue;
                    this.insertItem(currentItem, foundClasses);
                    currentItem = null;
                }
                finally {
                    is.close();
                }
            }
            catch (ClassNotFoundException ex) {
                LOGGER.log(Level.WARNING, null, ex);
            }
            catch (IOException ex) {
                LOGGER.log(Level.WARNING, null, ex);
            }
        }
        LOGGER.log(Level.FINER, "Found impls of {0}: {1} and removed: {2} from: {3}", new Object[]{clazz.getName(), foundClasses, removeClasses, this});
        for (Item item : foundClasses) {
            if (removeClasses.contains(item.clazz)) continue;
            result.add(new P(item.clazz));
        }
    }

    private static String clazzToString(Class<?> clazz) {
        return clazz.getName() + "@" + clazz.getClassLoader() + ":" + clazz.getProtectionDomain().getCodeSource().getLocation();
    }

    private void insertItem(Item item, List<Item> list) {
        if (item.position == -1) {
            list.add(item);
            return;
        }
        int index = -1;
        for (Item i : list) {
            ++index;
            if (i.position == -1) {
                list.add(index, item);
                return;
            }
            if (i.position <= item.position) continue;
            list.add(index, item);
            return;
        }
        list.add(item);
    }

    static {
        Executor res = null;
        try {
            Class<?> seek = Class.forName("org.openide.util.RequestProcessor");
            res = (Executor)seek.newInstance();
        }
        catch (Throwable t) {
            res = Executors.newSingleThreadExecutor();
        }
        RP = res;
        knownInstances = new ArrayList<Reference<Object>>();
        for (int i = 0; i < 512; ++i) {
            knownInstances.add(null);
        }
    }

    private static final class P
    extends AbstractLookup.Pair<Object> {
        private Object object;

        public P(Class<?> clazz) {
            this.object = clazz;
        }

        private Class<? extends Object> clazz() {
            Object o = this.object;
            if (o instanceof Class) {
                return (Class)o;
            }
            if (o != null) {
                return o.getClass();
            }
            return Object.class;
        }

        public boolean equals(Object o) {
            if (o instanceof P) {
                return ((P)o).clazz().equals(this.clazz());
            }
            return false;
        }

        public int hashCode() {
            return this.clazz().hashCode();
        }

        @Override
        protected boolean instanceOf(Class<?> c) {
            return c.isAssignableFrom(this.clazz());
        }

        @Override
        public Class<?> getType() {
            return this.clazz();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object getInstance() {
            Object o = this.object;
            if (o instanceof Class) {
                Object object = o;
                synchronized (object) {
                    try {
                        int i;
                        int size;
                        Class c = (Class)o;
                        o = null;
                        List list = knownInstances;
                        synchronized (list) {
                            size = knownInstances.size();
                            int index = P.hashForClass(c, size);
                            for (i = 0; i < size; ++i) {
                                Object obj;
                                Reference ref = (Reference)knownInstances.get(index);
                                Object object2 = obj = ref == null ? null : (Object)ref.get();
                                if (obj == null) break;
                                if (c == obj.getClass()) {
                                    o = obj;
                                    break;
                                }
                                if (++index != size) continue;
                                index = 0;
                            }
                        }
                        if (o == null) {
                            o = SharedClassObjectBridge.newInstance(c);
                            list = knownInstances;
                            synchronized (list) {
                                P.hashPut(o);
                                size = knownInstances.size();
                                if (knownInstancesCount > size * 2 / 3) {
                                    LOGGER.log(Level.CONFIG, "Cache of size {0} is 2/3 full. Rehashing.", size);
                                    HashSet all = new HashSet();
                                    all.addAll(knownInstances);
                                    for (i = 0; i < size; ++i) {
                                        knownInstances.set(i, null);
                                    }
                                    for (i = 0; i < size; ++i) {
                                        knownInstances.add(null);
                                    }
                                    knownInstancesCount = 0;
                                    for (Reference r : all) {
                                        Object instance;
                                        if (r == null || (instance = r.get()) == null) continue;
                                        P.hashPut(instance);
                                    }
                                }
                            }
                        }
                        this.object = o;
                    }
                    catch (Exception ex) {
                        LOGGER.log(Level.WARNING, "Cannot create " + this.object, ex);
                        this.object = null;
                    }
                    catch (LinkageError x) {
                        LOGGER.log(Level.WARNING, "Cannot create " + this.object, x);
                        this.object = null;
                    }
                }
            }
            return this.object;
        }

        @Override
        public String getDisplayName() {
            return this.clazz().getName();
        }

        @Override
        public String getId() {
            return this.clazz().getName();
        }

        @Override
        protected boolean creatorOf(Object obj) {
            return obj == this.object;
        }

        private static int hashForClass(Class<?> c, int size) {
            return Math.abs(c.hashCode() % size);
        }

        private static void hashPut(Object o) {
            Class<?> c = o.getClass();
            int size = knownInstances.size();
            int index = P.hashForClass(c, size);
            for (int i = 0; i < size; ++i) {
                Object obj;
                Reference ref = (Reference)knownInstances.get(index);
                Object v0 = obj = ref == null ? null : ref.get();
                if (obj == null) {
                    knownInstances.set(index, new WeakReference<Object>(o));
                    knownInstancesCount++;
                    break;
                }
                if (++index != size) continue;
                index = 0;
            }
        }
    }

    private static class Item {
        private Class<?> clazz;
        private int position = -1;

        private Item() {
        }

        public String toString() {
            return "MetaInfServicesLookup.Item[" + this.clazz.getName() + "]";
        }
    }
}

