/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.spi.java.project.support.ui;

import java.awt.Dialog;
import java.awt.Frame;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import javax.swing.JButton;
import javax.swing.SwingUtilities;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.modules.java.project.BrokenReferencesAlertPanel;
import org.netbeans.modules.java.project.BrokenReferencesCustomizer;
import org.netbeans.modules.java.project.BrokenReferencesModel;
import org.netbeans.modules.java.project.JavaProjectSettings;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.support.ant.ReferenceHelper;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.util.Parameters;
import org.openide.windows.WindowManager;

public class BrokenReferencesSupport {
    private static long brokenAlertLastTime = 0L;
    private static boolean brokenAlertShown = false;
    private static int BROKEN_ALERT_TIMEOUT = 1000;

    private BrokenReferencesSupport() {
    }

    public static boolean isBroken(AntProjectHelper projectHelper, ReferenceHelper referenceHelper, String[] properties, String[] platformProperties) {
        Parameters.notNull((CharSequence)"projectHelper", (Object)projectHelper);
        Parameters.notNull((CharSequence)"referenceHelper", (Object)referenceHelper);
        Parameters.notNull((CharSequence)"properties", (Object)properties);
        Parameters.notNull((CharSequence)"platformProperties", (Object)platformProperties);
        return BrokenReferencesModel.isBroken(projectHelper, referenceHelper, projectHelper.getStandardPropertyEvaluator(), properties, platformProperties);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void showCustomizer(AntProjectHelper projectHelper, ReferenceHelper referenceHelper, String[] properties, String[] platformProperties) {
        BrokenReferencesModel model = new BrokenReferencesModel(projectHelper, referenceHelper, properties, platformProperties);
        BrokenReferencesCustomizer customizer = new BrokenReferencesCustomizer(model);
        JButton close = new JButton(NbBundle.getMessage(BrokenReferencesCustomizer.class, (String)"LBL_BrokenLinksCustomizer_Close"));
        close.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(BrokenReferencesCustomizer.class, (String)"ACSD_BrokenLinksCustomizer_Close"));
        String projectDisplayName = "???";
        try {
            Project project = ProjectManager.getDefault().findProject(projectHelper.getProjectDirectory());
            if (project != null) {
                projectDisplayName = ProjectUtils.getInformation((Project)project).getDisplayName();
            }
        }
        catch (IOException e) {
            Exceptions.printStackTrace((Throwable)e);
        }
        DialogDescriptor dd = new DialogDescriptor((Object)customizer, NbBundle.getMessage(BrokenReferencesCustomizer.class, (String)"LBL_BrokenLinksCustomizer_Title", (Object)projectDisplayName), true, new Object[]{close}, (Object)close, 0, null, null);
        Dialog dlg = null;
        try {
            dlg = DialogDisplayer.getDefault().createDialog(dd);
            dlg.setVisible(true);
        }
        finally {
            if (dlg != null) {
                dlg.dispose();
            }
        }
    }

    public static synchronized void showAlert() {
        if (brokenAlertShown || brokenAlertLastTime + (long)BROKEN_ALERT_TIMEOUT > System.currentTimeMillis() || !JavaProjectSettings.isShowAgainBrokenRefAlert()) {
            return;
        }
        brokenAlertShown = true;
        final Runnable task = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    JButton closeOption = new JButton(NbBundle.getMessage(BrokenReferencesAlertPanel.class, (String)"CTL_Broken_References_Close"));
                    closeOption.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(BrokenReferencesAlertPanel.class, (String)"AD_Broken_References_Close"));
                    DialogDescriptor dd = new DialogDescriptor((Object)new BrokenReferencesAlertPanel(), NbBundle.getMessage(BrokenReferencesAlertPanel.class, (String)"MSG_Broken_References_Title"), true, new Object[]{closeOption}, (Object)closeOption, 0, null, null);
                    dd.setMessageType(2);
                    Dialog dlg = DialogDisplayer.getDefault().createDialog(dd);
                    dlg.setVisible(true);
                }
                finally {
                    Class<BrokenReferencesSupport> clazz = BrokenReferencesSupport.class;
                    synchronized (BrokenReferencesSupport.class) {
                        brokenAlertLastTime = System.currentTimeMillis();
                        brokenAlertShown = false;
                        // ** MonitorExit[var1_1] (shouldn't be in output)
                    }
                }
            }
        };
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                Frame f = WindowManager.getDefault().getMainWindow();
                if (f == null || f.isShowing()) {
                    task.run();
                } else {
                    new MainWindowListener(f, task);
                }
            }
        });
    }

    private static class MainWindowListener
    extends WindowAdapter {
        private Frame frame;
        private Runnable task;

        public MainWindowListener(Frame frame, Runnable task) {
            assert (frame != null && task != null);
            assert (SwingUtilities.isEventDispatchThread());
            this.frame = frame;
            this.task = task;
            frame.addWindowListener(this);
        }

        @Override
        public void windowOpened(WindowEvent e) {
            this.frame.removeWindowListener(this);
            SwingUtilities.invokeLater(this.task);
        }
    }
}

