/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.spi.mobility.project.ui.customizer.support;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.lang.reflect.Method;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.swing.ComboBoxEditor;
import javax.swing.ComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JRadioButton;
import javax.swing.JSlider;
import javax.swing.JSpinner;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.spi.mobility.project.ui.customizer.VisualPropertyGroup;
import org.openide.ErrorManager;

public final class VisualPropertySupport {
    private static final String WRONG_TYPE = "WrongType";
    private static final String CONFIG_PREFFIX = "configs.";
    private static Reference<VisualPropertySupport> cache = new WeakReference<Object>(null);
    private final Map<String, Object> backup;
    private final ComponentListener componentListener;
    private final CheckBoxListener listener;
    final Map<String, Object> properties;
    final HashMap<Object, Object> component2property;
    final HashMap<JCheckBox, VisualPropertyGroup> checkbox2group;
    private String configuration;

    public static VisualPropertySupport getDefault(Map<String, Object> properties) {
        VisualPropertySupport vps = cache.get();
        if (vps == null || vps.properties != properties) {
            vps = new VisualPropertySupport(properties);
            cache = new WeakReference<VisualPropertySupport>(vps);
        }
        return vps;
    }

    public static String translatePropertyName(String configuration, String propertyName, boolean useDefault) {
        return useDefault || configuration == null ? propertyName : VisualPropertySupport.prefixPropertyName(configuration, propertyName);
    }

    public static String prefixPropertyName(String configuration, String propertyName) {
        return CONFIG_PREFFIX + configuration + '.' + propertyName;
    }

    private VisualPropertySupport(Map<String, Object> properties) {
        this.properties = properties;
        this.backup = new HashMap<String, Object>();
        this.component2property = new HashMap(10);
        this.componentListener = new ComponentListener();
        this.checkbox2group = new HashMap();
        this.listener = new CheckBoxListener();
    }

    public void register(JCheckBox check, String configuration, VisualPropertyGroup group) {
        check.removeActionListener(this.listener);
        this.configuration = configuration;
        this.checkbox2group.put(check, group);
        check.setEnabled(configuration != null);
        boolean useDefaults = !this.testForNonDefaultValue(group.getGroupPropertyNames());
        check.setSelected(useDefaults);
        this.refreshGroup(group, useDefaults);
        check.addActionListener(this.listener);
    }

    public void register(JCheckBox component, String propertyName, boolean useDefault) {
        this.register(component, VisualPropertySupport.translatePropertyName(this.configuration, propertyName, useDefault));
        component.setEnabled(!useDefault);
    }

    public void register(JCheckBox component, String propertyName) {
        component.removeActionListener(this.componentListener);
        Object value = this.properties.get(propertyName);
        this.component2property.put(component, propertyName);
        component.setSelected(value instanceof Boolean && (Boolean)value != false || value instanceof String && Boolean.parseBoolean((String)value));
        component.addActionListener(this.componentListener);
    }

    public void register(JTextComponent component, String propertyName, boolean useDefault) {
        this.register(component, VisualPropertySupport.translatePropertyName(this.configuration, propertyName, useDefault));
        component.setEnabled(!useDefault);
        component.setEditable(!useDefault);
    }

    public void register(JTextComponent component, String propertyName) {
        component.getDocument().removeDocumentListener(this.componentListener);
        this.component2property.put(component.getDocument(), propertyName);
        component.setText(String.valueOf(this.properties.get(propertyName)));
        component.getDocument().addDocumentListener(this.componentListener);
    }

    public void register(JComboBox component, Object[] items, String propertyName, boolean useDefault) {
        this.register(component, items, VisualPropertySupport.translatePropertyName(this.configuration, propertyName, useDefault));
        component.setEnabled(!useDefault);
    }

    private Document getDocumentFor(JComboBox box) {
        Component c;
        ComboBoxEditor cbe;
        if (box.isEditable() && (cbe = box.getEditor()) != null && (c = cbe.getEditorComponent()) instanceof JTextComponent) {
            return ((JTextComponent)c).getDocument();
        }
        return null;
    }

    public void register(JComboBox component, Object[] items, String propertyName) {
        int i;
        component.removeActionListener(this.componentListener);
        Document doc = this.getDocumentFor(component);
        if (doc != null) {
            doc.removeDocumentListener(this.componentListener);
        }
        Object value = this.properties.get(propertyName);
        this.component2property.put(component, propertyName);
        if (doc != null) {
            this.component2property.put(doc, propertyName);
        }
        if (items == null) {
            ComboBoxModel model = component.getModel();
            items = new Object[model.getSize()];
            for (i = 0; i < items.length; ++i) {
                items[i] = model.getElementAt(i);
            }
        }
        component.removeAllItems();
        boolean selected = false;
        for (i = 0; i < items.length; ++i) {
            component.addItem(items[i]);
            if (!items[i].equals(value)) continue;
            selected = true;
            component.setSelectedIndex(i);
        }
        if (!selected) {
            if (component.isEditable()) {
                component.setSelectedItem(value);
            } else if (items.length > 0) {
                component.setSelectedIndex(0);
                this.properties.put(propertyName, items[0]);
            }
        }
        component.addActionListener(this.componentListener);
        if (doc != null) {
            doc.addDocumentListener(this.componentListener);
        }
    }

    public void register(JSlider component, String propertyName, boolean useDefault) {
        this.register(component, VisualPropertySupport.translatePropertyName(this.configuration, propertyName, useDefault));
        component.setEnabled(!useDefault);
        Enumeration en = component.getLabelTable().elements();
        while (en.hasMoreElements()) {
            ((JComponent)en.nextElement()).setEnabled(!useDefault);
        }
    }

    public void register(JSlider component, String propertyName) {
        component.removeChangeListener(this.componentListener);
        Object value = this.properties.get(propertyName);
        this.component2property.put(component, propertyName);
        component.setValue(value instanceof Number ? ((Number)value).intValue() : (value instanceof String ? Integer.parseInt((String)value) : component.getMinimum()));
        component.addChangeListener(this.componentListener);
    }

    public void register(JSpinner component, String propertyName, boolean useDefault) {
        this.register(component, VisualPropertySupport.translatePropertyName(this.configuration, propertyName, useDefault));
        component.setEnabled(!useDefault);
    }

    public void register(JSpinner component, String propertyName) {
        component.removeChangeListener(this.componentListener);
        Object value = this.properties.get(propertyName);
        this.component2property.put(component, propertyName);
        component.setValue(value instanceof Number ? ((Number)value).intValue() : (value instanceof String ? Integer.parseInt((String)value) : 0));
        component.addChangeListener(this.componentListener);
    }

    public void register(JRadioButton component, String propertyName, boolean useDefault) {
        this.register(component, VisualPropertySupport.translatePropertyName(this.configuration, propertyName, useDefault));
        component.setEnabled(!useDefault);
    }

    public void register(JRadioButton component, String propertyName) {
        component.removeActionListener(this.componentListener);
        Object value = this.properties.get(propertyName);
        this.component2property.put(component, propertyName);
        component.setSelected(value != null && value.toString().equals(VisualPropertySupport.readValue(component)));
        component.addActionListener(this.componentListener);
    }

    public static String[] translatePropertyNames(String configuration, String[] propertyNames, boolean useDefault) {
        String[] names = new String[propertyNames.length];
        for (int i = 0; i < propertyNames.length; ++i) {
            names[i] = VisualPropertySupport.translatePropertyName(configuration, propertyNames[i], useDefault);
        }
        return names;
    }

    public void register(StorableTableModel component, String[] propertyNames, boolean useDefault) {
        this.register(component, VisualPropertySupport.translatePropertyNames(this.configuration, propertyNames, useDefault));
    }

    public void register(StorableTableModel component, String[] propertyNames) {
        component.removeTableModelListener(this.componentListener);
        Object[] values = new Object[propertyNames.length];
        for (int i = 0; i < values.length; ++i) {
            values[i] = this.properties.get(propertyNames[i]);
        }
        this.component2property.put(component, propertyNames);
        component.setDataDelegates(values);
        component.addTableModelListener(this.componentListener);
    }

    protected static Boolean readValue(JCheckBox checkBox) {
        return checkBox.isSelected() ? Boolean.TRUE : Boolean.FALSE;
    }

    protected static String readValue(Document document) {
        try {
            return document.getText(0, document.getLength());
        }
        catch (BadLocationException e) {
            assert (false) : "Invalid document ";
            return "";
        }
    }

    protected static String readValue(JComboBox comboBox) {
        Object selectedItem = comboBox.getSelectedItem();
        if (selectedItem == null) {
            return null;
        }
        return selectedItem.toString();
    }

    protected static Integer readValue(JSlider slider) {
        return new Integer(slider.getValue());
    }

    protected static Object readValue(JSpinner slider) {
        return slider.getValue();
    }

    protected static String readValue(JRadioButton radio) {
        return radio.getActionCommand();
    }

    private boolean testForNonDefaultValue(String[] propertyNames) {
        if (this.configuration == null) {
            return true;
        }
        for (int i = 0; i < propertyNames.length; ++i) {
            if (this.properties.get(VisualPropertySupport.prefixPropertyName(this.configuration, propertyNames[i])) == null) continue;
            return true;
        }
        return false;
    }

    private void removeConfigProperties(String[] propertyNames) {
        if (this.configuration == null) {
            return;
        }
        for (int i = 0; i < propertyNames.length; ++i) {
            String name = VisualPropertySupport.prefixPropertyName(this.configuration, propertyNames[i]);
            this.backup.put(name, this.properties.remove(name));
        }
    }

    private void copyFromDefaults(String[] propertyNames) {
        if (this.configuration == null) {
            return;
        }
        Class[] cl = new Class[]{};
        Object[] ob = new Object[]{};
        for (int i = 0; i < propertyNames.length; ++i) {
            String prefName = VisualPropertySupport.prefixPropertyName(this.configuration, propertyNames[i]);
            if (this.properties.get(prefName) != null) continue;
            Object backValue = this.backup.get(prefName);
            if (backValue == null && (backValue = this.properties.get(propertyNames[i])) instanceof Cloneable) {
                try {
                    Method m = backValue.getClass().getMethod("clone", cl);
                    if (m != null) {
                        backValue = m.invoke(backValue, ob);
                    }
                }
                catch (Exception e) {
                    ErrorManager.getDefault().notify(1, (Throwable)e);
                }
            }
            this.properties.put(prefName, backValue);
        }
    }

    protected void refreshGroup(VisualPropertyGroup g, boolean useDefaults) {
        if (useDefaults) {
            this.removeConfigProperties(g.getGroupPropertyNames());
            g.initGroupValues(true);
        } else {
            this.copyFromDefaults(g.getGroupPropertyNames());
            g.initGroupValues(false);
        }
    }

    public static interface StorableTableModel
    extends TableModel {
        public Object[] getDataDelegates();

        public void setDataDelegates(Object[] var1);
    }

    private class CheckBoxListener
    implements ActionListener {
        private CheckBoxListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JCheckBox cb = (JCheckBox)e.getSource();
            VisualPropertyGroup g = VisualPropertySupport.this.checkbox2group.get(cb);
            if (g != null) {
                VisualPropertySupport.this.refreshGroup(g, cb.isSelected());
            }
        }
    }

    private class ComponentListener
    implements ActionListener,
    DocumentListener,
    ChangeListener,
    TableModelListener {
        private ComponentListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Object source = e.getSource();
            String propertyName = (String)VisualPropertySupport.this.component2property.get(source);
            if (propertyName != null) {
                if (source instanceof JCheckBox) {
                    VisualPropertySupport.this.properties.put(propertyName, VisualPropertySupport.readValue((JCheckBox)source));
                } else if (source instanceof JComboBox) {
                    VisualPropertySupport.this.properties.put(propertyName, VisualPropertySupport.readValue((JComboBox)source));
                } else if (source instanceof JRadioButton) {
                    VisualPropertySupport.this.properties.put(propertyName, VisualPropertySupport.readValue((JRadioButton)source));
                }
            }
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            Document document = e.getDocument();
            String propertyName = (String)VisualPropertySupport.this.component2property.get(document);
            if (propertyName != null) {
                VisualPropertySupport.this.properties.put(propertyName, VisualPropertySupport.readValue(document));
            }
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            this.changedUpdate(e);
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            this.changedUpdate(e);
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            JSpinner source;
            Object objectSource = e.getSource();
            String propertyName = null;
            if (objectSource instanceof JSlider) {
                JSlider source2 = (JSlider)objectSource;
                propertyName = (String)VisualPropertySupport.this.component2property.get(source2);
                if (propertyName != null) {
                    VisualPropertySupport.this.properties.put(propertyName, VisualPropertySupport.readValue(source2));
                }
            } else if (objectSource instanceof JSpinner && (propertyName = (String)VisualPropertySupport.this.component2property.get(source = (JSpinner)objectSource)) != null) {
                VisualPropertySupport.this.properties.put(propertyName, VisualPropertySupport.readValue(source));
            }
        }

        @Override
        public void tableChanged(TableModelEvent e) {
            StorableTableModel source = (StorableTableModel)e.getSource();
            String[] propertyNames = (String[])VisualPropertySupport.this.component2property.get(source);
            if (propertyNames != null) {
                Object[] values = source.getDataDelegates();
                for (int i = 0; i < propertyNames.length; ++i) {
                    VisualPropertySupport.this.properties.put(propertyNames[i], values[i]);
                }
            }
        }
    }
}

