/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.project.ui.actions.support;

import org.netbeans.modules.php.project.PhpProject;
import org.netbeans.modules.php.project.ProjectPropertiesSupport;
import org.netbeans.modules.php.project.connections.RemoteConnections;
import org.netbeans.modules.php.project.ui.actions.UploadCommand;
import org.netbeans.modules.php.project.ui.actions.support.CommandUtils;
import org.netbeans.modules.php.project.ui.actions.support.ConfigActionLocal;
import org.netbeans.modules.php.project.ui.customizer.PhpProjectProperties;
import org.netbeans.modules.php.project.ui.customizer.RunAsValidator;
import org.openide.filesystems.FileObject;
import org.openide.util.Lookup;

class ConfigActionRemote
extends ConfigActionLocal {
    protected ConfigActionRemote(PhpProject project) {
        super(project);
    }

    @Override
    public boolean isValid(boolean indexFileNeeded) {
        boolean valid = super.isValid(indexFileNeeded);
        if (!valid) {
            return false;
        }
        String remoteConnection = ProjectPropertiesSupport.getRemoteConnection(this.project);
        if (remoteConnection == null || RemoteConnections.get().remoteConfigurationForName(remoteConnection) == null) {
            valid = false;
        } else if (RunAsValidator.validateUploadDirectory(ProjectPropertiesSupport.getRemoteDirectory(this.project), true) != null) {
            valid = false;
        }
        if (!valid) {
            this.showCustomizer();
        }
        return valid;
    }

    @Override
    public void runProject() {
        this.eventuallyUploadFiles();
        super.runProject();
    }

    @Override
    public void debugProject() {
        this.eventuallyUploadFiles();
        super.debugProject();
    }

    @Override
    protected void preShowUrl(Lookup context) {
        this.eventuallyUploadFiles(CommandUtils.filesForContextOrSelectedNodes(context));
    }

    private void eventuallyUploadFiles() {
        this.eventuallyUploadFiles(null);
    }

    private void eventuallyUploadFiles(FileObject ... preselectedFiles) {
        UploadCommand uploadCommand = (UploadCommand)CommandUtils.getCommand(this.project, "upload");
        if (!uploadCommand.isActionEnabled(null)) {
            return;
        }
        PhpProjectProperties.UploadFiles uploadFiles = ProjectPropertiesSupport.getRemoteUpload(this.project);
        assert (uploadFiles != null);
        if (PhpProjectProperties.UploadFiles.ON_RUN.equals((Object)uploadFiles)) {
            uploadCommand.uploadFiles(new FileObject[]{ProjectPropertiesSupport.getSourcesDirectory(this.project)}, preselectedFiles);
        }
    }
}

