/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.versioning.util;

import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import org.openide.awt.UndoRedo;

public class DelegatingUndoRedo
implements UndoRedo,
ChangeListener {
    private List<ChangeListener> listeners = new ArrayList<ChangeListener>(2);
    private UndoRedo delegate = UndoRedo.NONE;

    public void setDiffView(JComponent componentDelegate) {
        if (componentDelegate == null) {
            this.setDelegate(UndoRedo.NONE);
        } else {
            UndoRedo delegate = (UndoRedo)componentDelegate.getClientProperty(UndoRedo.class);
            if (delegate == null) {
                delegate = UndoRedo.NONE;
            }
            this.setDelegate(delegate);
        }
    }

    private void setDelegate(UndoRedo newDelegate) {
        if (newDelegate == this.delegate) {
            return;
        }
        this.delegate.removeChangeListener((ChangeListener)this);
        this.delegate = newDelegate;
        this.stateChanged(new ChangeEvent(this));
        this.delegate.addChangeListener((ChangeListener)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stateChanged(ChangeEvent e) {
        List<ChangeListener> currentListeners;
        DelegatingUndoRedo delegatingUndoRedo = this;
        synchronized (delegatingUndoRedo) {
            currentListeners = this.listeners;
        }
        for (ChangeListener listener : currentListeners) {
            listener.stateChanged(e);
        }
    }

    public boolean canUndo() {
        return this.delegate.canUndo();
    }

    public boolean canRedo() {
        return this.delegate.canRedo();
    }

    public void undo() throws CannotUndoException {
        this.delegate.undo();
    }

    public void redo() throws CannotRedoException {
        this.delegate.redo();
    }

    public synchronized void addChangeListener(ChangeListener l) {
        ArrayList<ChangeListener> newListeners = new ArrayList<ChangeListener>(this.listeners);
        newListeners.add(l);
        this.listeners = newListeners;
    }

    public synchronized void removeChangeListener(ChangeListener l) {
        ArrayList<ChangeListener> newListeners = new ArrayList<ChangeListener>(this.listeners);
        newListeners.remove(l);
        this.listeners = newListeners;
    }

    public String getUndoPresentationName() {
        return this.delegate.getUndoPresentationName();
    }

    public String getRedoPresentationName() {
        return this.delegate.getRedoPresentationName();
    }
}

