/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.nb.runtime.load;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import org.jruby.nb.Ruby;
import org.jruby.nb.ast.executable.Script;
import org.jruby.nb.runtime.Block;
import org.jruby.nb.runtime.builtin.IRubyObject;
import org.jruby.nb.runtime.load.Library;
import org.jruby.nb.runtime.load.LoadServiceResource;
import org.jruby.nb.util.JRubyClassLoader;
import org.objectweb.asm.ClassReader;

public class JavaCompiledScript
implements Library {
    private final LoadServiceResource resource;

    public JavaCompiledScript(LoadServiceResource resource) {
        this.resource = resource;
    }

    @Override
    public void load(Ruby runtime, boolean wrap) {
        InputStream in = null;
        try {
            in = new BufferedInputStream(this.resource.getURL().openStream());
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            byte[] buf = new byte[8196];
            int read = 0;
            while ((read = in.read(buf)) != -1) {
                baos.write(buf, 0, read);
            }
            buf = baos.toByteArray();
            JRubyClassLoader jcl = runtime.getJRubyClassLoader();
            ClassReader cr = new ClassReader(buf);
            String className = cr.getClassName().replace('/', '.');
            Class<?> clazz = null;
            try {
                clazz = jcl.loadClass(className);
            }
            catch (ClassNotFoundException cnfe) {
                clazz = jcl.defineClass(className, buf);
            }
            if (Script.class.isAssignableFrom(clazz)) {
                ((Script)clazz.newInstance()).load(runtime.getCurrentContext(), runtime.getTopSelf(), IRubyObject.NULL_ARRAY, Block.NULL_BLOCK);
            }
        }
        catch (IOException e) {
            throw runtime.newIOErrorFromException(e);
        }
        catch (InstantiationException ie) {
            throw runtime.newLoadError("Error loading compiled script: " + ie);
        }
        catch (IllegalAccessException iae) {
            throw runtime.newLoadError("Error loading compiled script: " + iae);
        }
        finally {
            try {
                in.close();
            }
            catch (IOException ioe) {
                throw runtime.newIOErrorFromException(ioe);
            }
        }
    }
}

