/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.nb.runtime;

import java.util.HashMap;
import java.util.Map;
import org.jruby.nb.Ruby;
import org.jruby.nb.RubyArray;
import org.jruby.nb.RubyClass;
import org.jruby.nb.RubyKernel;
import org.jruby.nb.RubyModule;
import org.jruby.nb.RubyObject;
import org.jruby.nb.RubyString;
import org.jruby.nb.RubyThread;
import org.jruby.nb.evaluator.ASTInterpreter;
import org.jruby.nb.exceptions.JumpException;
import org.jruby.nb.internal.runtime.JumpTarget;
import org.jruby.nb.internal.runtime.methods.DefaultMethod;
import org.jruby.nb.libraries.FiberLibrary;
import org.jruby.nb.parser.BlockStaticScope;
import org.jruby.nb.parser.LocalStaticScope;
import org.jruby.nb.parser.StaticScope;
import org.jruby.nb.runtime.Binding;
import org.jruby.nb.runtime.Block;
import org.jruby.nb.runtime.CallType;
import org.jruby.nb.runtime.DynamicScope;
import org.jruby.nb.runtime.Frame;
import org.jruby.nb.runtime.InterpretedBlock;
import org.jruby.nb.runtime.RubyEvent;
import org.jruby.nb.runtime.Visibility;
import org.jruby.nb.runtime.builtin.IRubyObject;
import org.jruby.nb.runtime.scope.ManyVarsDynamicScope;

public final class ThreadContext {
    private static final int INITIAL_SIZE = 10;
    private static final String UNKNOWN_NAME = "(unknown)";
    private final Ruby runtime;
    private boolean isWithinTrace;
    private boolean isWithinDefined;
    private RubyThread thread;
    private FiberLibrary.Fiber fiber;
    private IRubyObject errorInfo;
    private RubyModule[] parentStack = new RubyModule[10];
    private int parentIndex = -1;
    private Frame[] frameStack = new Frame[10];
    private int frameIndex = -1;
    private DynamicScope[] scopeStack = new DynamicScope[10];
    private int scopeIndex = -1;
    private RubyKernel.CatchTarget[] catchStack = new RubyKernel.CatchTarget[10];
    private int catchIndex = -1;
    private String file = "";
    private int line = 0;
    private int rubyFrameDelta = 0;
    CallType lastCallType;
    Visibility lastVisibility;
    IRubyObject lastExitStatus;
    int calls = 0;
    public static final Map<String, FrameType> INTERPRETED_FRAMES = new HashMap<String, FrameType>();

    public static synchronized ThreadContext newContext(Ruby runtime) {
        ThreadContext context = new ThreadContext(runtime);
        return context;
    }

    private ThreadContext(Ruby runtime) {
        this.runtime = runtime;
        this.errorInfo = runtime.getNil();
        LocalStaticScope topStaticScope = new LocalStaticScope(null);
        this.pushScope(new ManyVarsDynamicScope(topStaticScope, null));
        for (int i = 0; i < this.frameStack.length; ++i) {
            this.frameStack[i] = new Frame();
        }
    }

    protected void finalize() throws Throwable {
        this.thread.dispose();
    }

    public final Ruby getRuntime() {
        return this.runtime;
    }

    public IRubyObject getErrorInfo() {
        return this.errorInfo;
    }

    public IRubyObject setErrorInfo(IRubyObject errorInfo) {
        this.errorInfo = errorInfo;
        return errorInfo;
    }

    public JumpException.ReturnJump returnJump(IRubyObject value) {
        return new JumpException.ReturnJump(this.getFrameJumpTarget(), value);
    }

    public void setLastCallStatus(CallType callType) {
        this.lastCallType = callType;
    }

    public CallType getLastCallType() {
        return this.lastCallType;
    }

    public void setLastVisibility(Visibility visibility) {
        this.lastVisibility = visibility;
    }

    public Visibility getLastVisibility() {
        return this.lastVisibility;
    }

    public void setLastCallStatusAndVisibility(CallType callType, Visibility visibility) {
        this.lastCallType = callType;
        this.lastVisibility = visibility;
    }

    public IRubyObject getLastExitStatus() {
        return this.lastExitStatus;
    }

    public void setLastExitStatus(IRubyObject lastExitStatus) {
        this.lastExitStatus = lastExitStatus;
    }

    public void printScope() {
        System.out.println("SCOPE STACK:");
        for (int i = 0; i <= this.scopeIndex; ++i) {
            System.out.println(this.scopeStack[i]);
        }
    }

    public DynamicScope getCurrentScope() {
        return this.scopeStack[this.scopeIndex];
    }

    public DynamicScope getPreviousScope() {
        return this.scopeStack[this.scopeIndex - 1];
    }

    private void expandFramesIfNecessary() {
        int newSize = this.frameStack.length * 2;
        this.frameStack = this.fillNewFrameStack(new Frame[newSize], newSize);
    }

    private Frame[] fillNewFrameStack(Frame[] newFrameStack, int newSize) {
        System.arraycopy(this.frameStack, 0, newFrameStack, 0, this.frameStack.length);
        for (int i = this.frameStack.length; i < newSize; ++i) {
            newFrameStack[i] = new Frame();
        }
        return newFrameStack;
    }

    private void expandParentsIfNecessary() {
        int newSize = this.parentStack.length * 2;
        RubyModule[] newParentStack = new RubyModule[newSize];
        System.arraycopy(this.parentStack, 0, newParentStack, 0, this.parentStack.length);
        this.parentStack = newParentStack;
    }

    public void pushScope(DynamicScope scope) {
        int index = ++this.scopeIndex;
        DynamicScope[] stack = this.scopeStack;
        stack[index] = scope;
        if (index + 1 == stack.length) {
            this.expandScopesIfNecessary();
        }
    }

    public void popScope() {
        this.scopeStack[this.scopeIndex--] = null;
    }

    private void expandScopesIfNecessary() {
        int newSize = this.scopeStack.length * 2;
        DynamicScope[] newScopeStack = new DynamicScope[newSize];
        System.arraycopy(this.scopeStack, 0, newScopeStack, 0, this.scopeStack.length);
        this.scopeStack = newScopeStack;
    }

    public RubyThread getThread() {
        return this.thread;
    }

    public void setThread(RubyThread thread) {
        this.thread = thread;
    }

    public FiberLibrary.Fiber getFiber() {
        return this.fiber;
    }

    public void setFiber(FiberLibrary.Fiber fiber) {
        this.fiber = fiber;
    }

    private void expandCatchIfNecessary() {
        int newSize = this.catchStack.length * 2;
        RubyKernel.CatchTarget[] newCatchStack = new RubyKernel.CatchTarget[newSize];
        System.arraycopy(this.catchStack, 0, newCatchStack, 0, this.catchStack.length);
        this.catchStack = newCatchStack;
    }

    public void pushCatch(RubyKernel.CatchTarget catchTarget) {
        int index = ++this.catchIndex;
        RubyKernel.CatchTarget[] stack = this.catchStack;
        stack[index] = catchTarget;
        if (index + 1 == stack.length) {
            this.expandCatchIfNecessary();
        }
    }

    public void popCatch() {
        --this.catchIndex;
    }

    public RubyKernel.CatchTarget[] getActiveCatches() {
        int index = this.catchIndex;
        if (index < 0) {
            return new RubyKernel.CatchTarget[0];
        }
        RubyKernel.CatchTarget[] activeCatches = new RubyKernel.CatchTarget[index + 1];
        System.arraycopy(this.catchStack, 0, activeCatches, 0, index + 1);
        return activeCatches;
    }

    private void pushFrameCopy() {
        int index = ++this.frameIndex;
        Frame[] stack = this.frameStack;
        Frame currentFrame = stack[index - 1];
        stack[index].updateFrame(currentFrame);
        if (index + 1 == stack.length) {
            this.expandFramesIfNecessary();
        }
    }

    private Frame pushFrame(Frame frame) {
        int index = ++this.frameIndex;
        Frame[] stack = this.frameStack;
        stack[index] = frame;
        if (index + 1 == stack.length) {
            this.expandFramesIfNecessary();
        }
        return frame;
    }

    private void pushCallFrame(RubyModule clazz, String name, IRubyObject self, Block block) {
        int index = ++this.frameIndex;
        Frame[] stack = this.frameStack;
        stack[index].updateFrame(clazz, self, name, block, this.file, this.line);
        if (index + 1 == stack.length) {
            this.expandFramesIfNecessary();
        }
    }

    private void pushEvalFrame(IRubyObject self) {
        int index = ++this.frameIndex;
        Frame[] stack = this.frameStack;
        stack[index].updateFrameForEval(self, this.file, this.line);
        if (index + 1 == stack.length) {
            this.expandFramesIfNecessary();
        }
    }

    private void pushBacktraceFrame(String name) {
        this.pushFrame(name);
    }

    private void pushFrame(String name) {
        int index = ++this.frameIndex;
        Frame[] stack = this.frameStack;
        stack[index].updateFrame(name, this.file, this.line);
        if (index + 1 == stack.length) {
            this.expandFramesIfNecessary();
        }
    }

    private void pushFrame() {
        int index = ++this.frameIndex;
        Frame[] stack = this.frameStack;
        stack[index].updateFrame(this.file, this.line);
        if (index + 1 == stack.length) {
            this.expandFramesIfNecessary();
        }
    }

    private void popFrame() {
        Frame frame = this.frameStack[this.frameIndex--];
        this.setFile(frame.getFile());
        this.setLine(frame.getLine());
        frame.clear();
    }

    private void popFrameReal(Frame oldFrame) {
        int index = this.frameIndex;
        Frame frame = this.frameStack[index];
        this.frameStack[index] = oldFrame;
        this.frameIndex = index - 1;
        this.setFile(frame.getFile());
        this.setLine(frame.getLine());
    }

    public Frame getCurrentFrame() {
        return this.frameStack[this.frameIndex];
    }

    public int getRubyFrameDelta() {
        return this.rubyFrameDelta;
    }

    public void setRubyFrameDelta(int newDelta) {
        this.rubyFrameDelta = newDelta;
    }

    public Frame getCurrentRubyFrame() {
        return this.frameStack[this.frameIndex - this.rubyFrameDelta];
    }

    public Frame getNextFrame() {
        int index = this.frameIndex;
        Frame[] stack = this.frameStack;
        if (index + 1 == stack.length) {
            this.expandFramesIfNecessary();
        }
        return stack[index + 1];
    }

    public Frame getPreviousFrame() {
        int index = this.frameIndex;
        return index < 1 ? null : this.frameStack[index - 1];
    }

    public int getFrameCount() {
        return this.frameIndex + 1;
    }

    public String getFrameName() {
        return this.getCurrentFrame().getName();
    }

    public IRubyObject getFrameSelf() {
        return this.getCurrentFrame().getSelf();
    }

    public JumpTarget getFrameJumpTarget() {
        return this.getCurrentFrame().getJumpTarget();
    }

    @Deprecated
    public void setFrameJumpTarget(JumpTarget target) {
    }

    public RubyModule getFrameKlazz() {
        return this.getCurrentFrame().getKlazz();
    }

    public Block getFrameBlock() {
        return this.getCurrentFrame().getBlock();
    }

    public String getFile() {
        return this.file;
    }

    public int getLine() {
        return this.line;
    }

    public void setFile(String file) {
        this.file = file;
    }

    public void setLine(int line) {
        this.line = line;
    }

    public void setFileAndLine(String file, int line) {
        this.file = file;
        this.line = line;
    }

    public Visibility getCurrentVisibility() {
        return this.getCurrentFrame().getVisibility();
    }

    public Visibility getPreviousVisibility() {
        return this.getPreviousFrame().getVisibility();
    }

    public void setCurrentVisibility(Visibility visibility) {
        this.getCurrentFrame().setVisibility(visibility);
    }

    public void pollThreadEvents() {
        this.getThread().pollThreadEvents(this);
    }

    public void callThreadPoll() {
        if ((this.calls++ & 0xFF) == 0) {
            this.pollThreadEvents();
        }
    }

    public void trace(RubyEvent event, String name, RubyModule implClass) {
        this.runtime.callEventHooks(this, event, this.file, this.line, name, implClass);
    }

    public void pushRubyClass(RubyModule currentModule) {
        int index = ++this.parentIndex;
        RubyModule[] stack = this.parentStack;
        stack[index] = currentModule;
        if (index + 1 == stack.length) {
            this.expandParentsIfNecessary();
        }
    }

    public RubyModule popRubyClass() {
        int index = this.parentIndex;
        RubyModule[] stack = this.parentStack;
        RubyModule ret = stack[index];
        stack[index] = null;
        this.parentIndex = index - 1;
        return ret;
    }

    public RubyModule getRubyClass() {
        assert (this.parentIndex != -1) : "Trying to get RubyClass from empty stack";
        RubyModule parentModule = this.parentStack[this.parentIndex];
        return parentModule.getNonIncludedClass();
    }

    public RubyModule getBindingRubyClass() {
        int index = this.parentIndex;
        RubyModule parentModule = null;
        parentModule = index == 0 ? this.parentStack[index] : this.parentStack[index - 1];
        return parentModule.getNonIncludedClass();
    }

    public boolean getConstantDefined(String internedName) {
        for (StaticScope scope = this.getCurrentScope().getStaticScope(); scope != null; scope = scope.getPreviousCRefScope()) {
            RubyModule module = scope.getModule();
            IRubyObject result = module.fastFetchConstant(internedName);
            if (result == null) continue;
            if (result != RubyObject.UNDEF) {
                return true;
            }
            return this.runtime.getLoadService().autoloadFor(module.getName() + "::" + internedName) != null;
        }
        return this.getCurrentScope().getStaticScope().getModule().fastIsConstantDefined(internedName);
    }

    public IRubyObject getConstant(String internedName) {
        return this.getCurrentScope().getStaticScope().getConstant(this.runtime, internedName, this.runtime.getObject());
    }

    public IRubyObject setConstantInCurrent(String internedName, IRubyObject result) {
        RubyModule module = this.getCurrentScope().getStaticScope().getModule();
        if (module != null) {
            module.fastSetConstant(internedName, result);
            return result;
        }
        throw this.runtime.newTypeError("no class/module to define constant");
    }

    public IRubyObject setConstantInModule(String internedName, IRubyObject target, IRubyObject result) {
        if (!(target instanceof RubyModule)) {
            throw this.runtime.newTypeError(target.toString() + " is not a class/module");
        }
        RubyModule module = (RubyModule)target;
        module.fastSetConstant(internedName, result);
        return result;
    }

    public IRubyObject setConstantInObject(String internedName, IRubyObject result) {
        this.runtime.getObject().fastSetConstant(internedName, result);
        return result;
    }

    @Deprecated
    private static void addBackTraceElement(RubyArray backtrace, StackTraceElement frame, StackTraceElement previousFrame) {
        ThreadContext.addBackTraceElement(backtrace.getRuntime(), backtrace, frame, previousFrame);
    }

    private static void addBackTraceElement(Ruby runtime, RubyArray backtrace, Frame frame, Frame previousFrame) {
        if (frame != previousFrame && frame.getLine() == previousFrame.getLine() && frame.getName() != null && frame.getName().equals(previousFrame.getName()) && frame.getFile().equals(previousFrame.getFile())) {
            return;
        }
        RubyString traceLine = previousFrame.getName() != null ? RubyString.newString(runtime, frame.getFile() + ':' + (frame.getLine() + 1) + ":in `" + previousFrame.getName() + '\'') : RubyString.newString(runtime, frame.getFile() + ':' + (frame.getLine() + 1));
        backtrace.append(traceLine);
    }

    private static void addBackTraceElement(Ruby runtime, RubyArray backtrace, StackTraceElement frame, StackTraceElement previousFrame) {
        if (frame != previousFrame && frame.getLineNumber() == previousFrame.getLineNumber() && frame.getMethodName() != null && frame.getMethodName().equals(previousFrame.getMethodName()) && frame.getFileName().equals(previousFrame.getFileName())) {
            return;
        }
        RubyString traceLine = previousFrame.getMethodName() == UNKNOWN_NAME ? RubyString.newString(runtime, frame.getFileName() + ':' + frame.getLineNumber()) : RubyString.newString(runtime, frame.getFileName() + ':' + frame.getLineNumber() + ":in `" + previousFrame.getMethodName() + '\'');
        backtrace.append(traceLine);
    }

    private static void addBackTraceElement(RubyArray backtrace, StackTraceElement frame, StackTraceElement previousFrame, FrameType frameType) {
        if (frame != previousFrame && frame.getMethodName() != null && frame.getMethodName().equals(previousFrame.getMethodName()) && frame.getFileName().equals(previousFrame.getFileName()) && frame.getLineNumber() == previousFrame.getLineNumber()) {
            return;
        }
        StringBuilder buf = new StringBuilder(60);
        buf.append(frame.getFileName()).append(':').append(frame.getLineNumber());
        if (previousFrame.getMethodName() != null) {
            switch (frameType) {
                case METHOD: {
                    buf.append(":in `");
                    buf.append(previousFrame.getMethodName());
                    buf.append('\'');
                    break;
                }
                case BLOCK: {
                    buf.append(":in `");
                    buf.append("block in " + previousFrame.getMethodName());
                    buf.append('\'');
                    break;
                }
                case EVAL: {
                    buf.append(":in `");
                    buf.append("eval in " + previousFrame.getMethodName());
                    buf.append('\'');
                    break;
                }
                case CLASS: {
                    buf.append(":in `");
                    buf.append("class in " + previousFrame.getMethodName());
                    buf.append('\'');
                    break;
                }
                case ROOT: {
                    buf.append(":in `<toplevel>'");
                }
            }
        }
        backtrace.append(backtrace.getRuntime().newString(buf.toString()));
    }

    public static IRubyObject createBacktraceFromFrames(Ruby runtime, StackTraceElement[] backtraceFrames) {
        return ThreadContext.createBacktraceFromFrames(runtime, backtraceFrames, true);
    }

    public IRubyObject createCallerBacktrace(Ruby runtime, int level) {
        int traceSize = this.frameIndex - level + 1;
        RubyArray backtrace = runtime.newArray(traceSize);
        for (int i = traceSize - 1; i > 0; --i) {
            ThreadContext.addBackTraceElement(runtime, backtrace, this.frameStack[i], this.frameStack[i - 1]);
        }
        return backtrace;
    }

    public static IRubyObject createBacktraceFromFrames(Ruby runtime, StackTraceElement[] backtraceFrames, boolean cropAtEval) {
        RubyArray backtrace = runtime.newArray();
        if (backtraceFrames == null || backtraceFrames.length <= 0) {
            return backtrace;
        }
        int traceSize = backtraceFrames.length;
        for (int i = 0; i < traceSize - 1; ++i) {
            StackTraceElement frame = backtraceFrames[i];
            ThreadContext.addBackTraceElement(runtime, backtrace, frame, backtraceFrames[i + 1]);
        }
        return backtrace;
    }

    public Frame[] createBacktrace(int level, boolean nativeException) {
        Frame[] traceFrames;
        int traceSize = this.frameIndex - level + 1;
        if (traceSize <= 0) {
            return null;
        }
        if (nativeException) {
            traceFrames = new Frame[traceSize + 1];
            traceFrames[traceSize] = this.frameStack[this.frameIndex];
        } else {
            traceFrames = new Frame[traceSize];
        }
        System.arraycopy(this.frameStack, 0, traceFrames, 0, traceSize);
        return traceFrames;
    }

    public StackTraceElement[] createBacktrace2(int level, boolean nativeException) {
        int traceSize = this.frameIndex - level + 1;
        if (traceSize <= 0) {
            return null;
        }
        int totalSize = traceSize;
        if (nativeException) {
            totalSize = traceSize + 1;
        }
        StackTraceElement[] newTrace = new StackTraceElement[totalSize];
        return this.buildTrace(newTrace);
    }

    private StackTraceElement[] buildTrace(StackTraceElement[] newTrace) {
        for (int i = 0; i < newTrace.length; ++i) {
            Frame current = this.frameStack[i];
            String klazzName = this.getClassNameFromFrame(current);
            String methodName = this.getMethodNameFromFrame(current);
            newTrace[newTrace.length - 1 - i] = new StackTraceElement(klazzName, methodName, current.getFile(), current.getLine() + 1);
        }
        return newTrace;
    }

    private String getClassNameFromFrame(Frame current) {
        String klazzName = current.getKlazz() == null ? UNKNOWN_NAME : current.getKlazz().getName();
        return klazzName;
    }

    private String getMethodNameFromFrame(Frame current) {
        String methodName = current.getName();
        if (current.getName() == null) {
            methodName = UNKNOWN_NAME;
        }
        return methodName;
    }

    private static String createRubyBacktraceString(StackTraceElement element) {
        return element.getClassName() + ":" + element.getLineNumber() + ":in `" + element.getMethodName() + "'";
    }

    public static String createRawBacktraceStringFromThrowable(Throwable t) {
        StackTraceElement[] stackTrace = t.getStackTrace();
        StringBuffer buffer = new StringBuffer();
        if (stackTrace != null && stackTrace.length > 0) {
            buffer.append(ThreadContext.createRubyBacktraceString(stackTrace[0])).append(": ").append(t.toString()).append("\n");
            for (int i = 1; i < stackTrace.length; ++i) {
                StackTraceElement element = stackTrace[i];
                buffer.append("\tfrom ").append(ThreadContext.createRubyBacktraceString(element));
                if (i + 1 >= stackTrace.length) continue;
                buffer.append("\n");
            }
        }
        return buffer.toString();
    }

    public static IRubyObject createRawBacktrace(Ruby runtime, StackTraceElement[] stackTrace, boolean filter) {
        RubyArray traceArray = RubyArray.newArray(runtime);
        for (int i = 17; i < stackTrace.length; ++i) {
            StackTraceElement element = stackTrace[i];
            if (filter && element.getClassName().startsWith("org.jruby.nb")) continue;
            RubyString str = RubyString.newString(runtime, ThreadContext.createRubyBacktraceString(element));
            traceArray.append(str);
        }
        return traceArray;
    }

    public static IRubyObject createRubyCompiledBacktrace(Ruby runtime, StackTraceElement[] stackTrace) {
        RubyArray traceArray = RubyArray.newArray(runtime);
        for (int i = 17; i < stackTrace.length; ++i) {
            StackTraceElement element = stackTrace[i];
            int index = element.getMethodName().indexOf("$RUBY$");
            if (index < 0) continue;
            String unmangledMethod = element.getMethodName().substring(index + 6);
            RubyString str = RubyString.newString(runtime, element.getFileName() + ":" + element.getLineNumber() + ":in `" + unmangledMethod + "'");
            traceArray.append(str);
        }
        return traceArray;
    }

    public static IRubyObject createRubyHybridBacktrace(Ruby runtime, StackTraceElement[] backtraceFrames, StackTraceElement[] stackTrace, boolean debug) {
        RubyArray traceArray = RubyArray.newArray(runtime);
        ThreadContext context = runtime.getCurrentContext();
        int rubyFrameIndex = backtraceFrames.length - 1;
        for (int i = 0; i < stackTrace.length; ++i) {
            RubyString str;
            String unmangledMethod;
            StackTraceElement element = stackTrace[i];
            int index = element.getMethodName().indexOf("$RUBY$");
            if (index >= 0) {
                unmangledMethod = element.getMethodName().substring(index + 6);
                RubyString str2 = RubyString.newString(runtime, element.getFileName() + ":" + element.getLineNumber() + ":in `" + unmangledMethod + "'");
                traceArray.append(str2);
                if (element.getMethodName().contains("__rescue__") || element.getMethodName().contains("__ensure__")) continue;
                --rubyFrameIndex;
                continue;
            }
            if (element.getMethodName().equals("__file__")) {
                RubyString str3 = RubyString.newString(runtime, element.getFileName() + ":" + element.getLineNumber() + ": `<toplevel>'");
                traceArray.append(str3);
                --rubyFrameIndex;
                continue;
            }
            index = element.getClassName().indexOf("$RUBYINVOKER$");
            if (index >= 0) {
                unmangledMethod = element.getClassName().substring(index + 13);
                Frame current = context.frameStack[rubyFrameIndex];
                str = RubyString.newString(runtime, current.getFile() + ":" + (current.getLine() + 1) + ":in `" + unmangledMethod + "'");
                traceArray.append(str);
                continue;
            }
            index = element.getClassName().indexOf("$RUBYFRAMEDINVOKER$");
            if (index >= 0) {
                ThreadContext.addBackTraceElement(traceArray, backtraceFrames[rubyFrameIndex], backtraceFrames[rubyFrameIndex - 1], FrameType.METHOD);
                --rubyFrameIndex;
                continue;
            }
            String classMethod = element.getClassName() + "." + element.getMethodName();
            FrameType frameType = INTERPRETED_FRAMES.get(classMethod);
            if (frameType != null) {
                if (rubyFrameIndex == 0) {
                    ThreadContext.addBackTraceElement(traceArray, backtraceFrames[rubyFrameIndex], backtraceFrames[rubyFrameIndex], frameType);
                    continue;
                }
                ThreadContext.addBackTraceElement(traceArray, backtraceFrames[rubyFrameIndex], backtraceFrames[rubyFrameIndex - 1], frameType);
                --rubyFrameIndex;
                continue;
            }
            if (!debug) continue;
            str = RubyString.newString(runtime, ThreadContext.createRubyBacktraceString(element));
            traceArray.append(str);
        }
        return traceArray;
    }

    public void preAdoptThread() {
        this.pushFrame();
        this.pushRubyClass(this.runtime.getObject());
        this.getCurrentFrame().setSelf(this.runtime.getTopSelf());
    }

    public void preCompiledClass(RubyModule type, String[] scopeNames) {
        this.pushRubyClass(type);
        this.pushFrameCopy();
        this.getCurrentFrame().setSelf(type);
        this.getCurrentFrame().setVisibility(Visibility.PUBLIC);
        LocalStaticScope staticScope = new LocalStaticScope(this.getCurrentScope().getStaticScope(), scopeNames);
        staticScope.setModule(type);
        this.pushScope(new ManyVarsDynamicScope(staticScope, null));
    }

    public void postCompiledClass() {
        this.popScope();
        this.popRubyClass();
        this.popFrame();
    }

    public void preScopeNode(StaticScope staticScope) {
        this.pushScope(DynamicScope.newDynamicScope(staticScope, this.getCurrentScope()));
    }

    public void postScopeNode() {
        this.popScope();
    }

    public void preClassEval(StaticScope staticScope, RubyModule type) {
        this.pushRubyClass(type);
        this.pushFrameCopy();
        this.getCurrentFrame().setSelf(type);
        this.getCurrentFrame().setVisibility(Visibility.PUBLIC);
        this.pushScope(DynamicScope.newDynamicScope(staticScope, null));
    }

    public void postClassEval() {
        this.popScope();
        this.popRubyClass();
        this.popFrame();
    }

    public void preBsfApply(String[] names) {
        LocalStaticScope staticScope = new LocalStaticScope(null);
        staticScope.setVariables(names);
        this.pushFrame();
    }

    public void postBsfApply() {
        this.popFrame();
    }

    public void preMethodFrameAndScope(RubyModule clazz, String name, IRubyObject self, Block block, StaticScope staticScope) {
        RubyModule implementationClass = staticScope.getModule();
        if (implementationClass == null) {
            implementationClass = clazz;
        }
        this.pushCallFrame(clazz, name, self, block);
        this.pushScope(DynamicScope.newDynamicScope(staticScope));
        this.pushRubyClass(implementationClass);
    }

    public void postMethodFrameAndScope() {
        this.popRubyClass();
        this.popScope();
        this.popFrame();
    }

    public void preMethodFrameOnly(RubyModule clazz, String name, IRubyObject self, Block block) {
        this.pushRubyClass(clazz);
        this.pushCallFrame(clazz, name, self, block);
    }

    public void postMethodFrameOnly() {
        this.popFrame();
        this.popRubyClass();
    }

    public void preMethodScopeOnly(RubyModule clazz, StaticScope staticScope) {
        RubyModule implementationClass = staticScope.getModule();
        if (implementationClass == null) {
            implementationClass = clazz;
        }
        this.pushScope(DynamicScope.newDynamicScope(staticScope));
        this.pushRubyClass(implementationClass);
    }

    public void postMethodScopeOnly() {
        this.popRubyClass();
        this.popScope();
    }

    public void preMethodBacktraceAndScope(String name, RubyModule clazz, StaticScope staticScope) {
        this.preMethodScopeOnly(clazz, staticScope);
        this.pushBacktraceFrame(name);
    }

    public void postMethodBacktraceAndScope() {
        this.postMethodScopeOnly();
        this.popFrame();
    }

    public void preMethodBacktraceOnly(String name) {
        this.pushBacktraceFrame(name);
    }

    public void postMethodBacktraceOnly() {
        this.popFrame();
    }

    public void prepareTopLevel(RubyClass objectClass, IRubyObject topSelf) {
        this.pushFrame();
        this.setCurrentVisibility(Visibility.PRIVATE);
        this.pushRubyClass(objectClass);
        Frame frame = this.getCurrentFrame();
        frame.setSelf(topSelf);
        this.getCurrentScope().getStaticScope().setModule(objectClass);
    }

    public void preNodeEval(RubyModule rubyClass, IRubyObject self, String name) {
        this.pushRubyClass(rubyClass);
        this.pushEvalFrame(self);
    }

    public void preNodeEval(RubyModule rubyClass, IRubyObject self) {
        this.pushRubyClass(rubyClass);
        this.pushEvalFrame(self);
    }

    public void postNodeEval() {
        this.popFrame();
        this.popRubyClass();
    }

    public void preExecuteUnder(RubyModule executeUnderClass, Block block) {
        Frame frame = this.getCurrentFrame();
        this.pushRubyClass(executeUnderClass);
        DynamicScope scope = this.getCurrentScope();
        BlockStaticScope sScope = new BlockStaticScope(scope.getStaticScope());
        sScope.setModule(executeUnderClass);
        this.pushScope(DynamicScope.newDynamicScope(sScope, scope));
        this.pushCallFrame(frame.getKlazz(), frame.getName(), frame.getSelf(), block);
        this.getCurrentFrame().setVisibility(this.getPreviousFrame().getVisibility());
    }

    public void postExecuteUnder() {
        this.popFrame();
        this.popScope();
        this.popRubyClass();
    }

    public void preMproc() {
        this.pushFrame();
    }

    public void postMproc() {
        this.popFrame();
    }

    public void preRunThread(Frame currentFrame) {
        this.pushFrame(currentFrame);
    }

    public void preTrace() {
        this.setWithinTrace(true);
        this.pushFrame();
    }

    public void postTrace() {
        this.popFrame();
        this.setWithinTrace(false);
    }

    public Frame preForBlock(Binding binding, RubyModule klass) {
        Frame lastFrame = this.getNextFrame();
        Frame f = binding.getFrame();
        f.setFile(this.file);
        f.setLine(this.line);
        this.pushFrame(f);
        this.getCurrentFrame().setVisibility(binding.getVisibility());
        this.pushScope(binding.getDynamicScope());
        this.pushRubyClass(klass != null ? klass : binding.getKlass());
        return lastFrame;
    }

    public Frame preYieldSpecificBlock(Binding binding, StaticScope scope, RubyModule klass) {
        Frame lastFrame = this.getNextFrame();
        Frame f = this.pushFrame(binding.getFrame());
        f.setFile(this.file);
        f.setLine(this.line);
        f.setVisibility(binding.getVisibility());
        this.pushScope(DynamicScope.newDynamicScope(scope, binding.getDynamicScope()));
        this.pushRubyClass(klass != null ? klass : binding.getKlass());
        return lastFrame;
    }

    public Frame preYieldLightBlock(Binding binding, DynamicScope emptyScope, RubyModule klass) {
        Frame lastFrame = this.getNextFrame();
        Frame f = this.pushFrame(binding.getFrame());
        f.setFile(this.file);
        f.setLine(this.line);
        f.setVisibility(binding.getVisibility());
        this.pushScope(emptyScope);
        this.pushRubyClass(klass != null ? klass : binding.getKlass());
        return lastFrame;
    }

    public Frame preYieldNoScope(Binding binding, RubyModule klass) {
        Frame lastFrame = this.getNextFrame();
        Frame f = this.pushFrame(binding.getFrame());
        f.setFile(this.file);
        f.setLine(this.line);
        f.setVisibility(binding.getVisibility());
        this.pushRubyClass(klass != null ? klass : binding.getKlass());
        return lastFrame;
    }

    public Frame preEvalWithBinding(Binding binding) {
        Frame lastFrame = this.getNextFrame();
        Frame frame = binding.getFrame();
        frame.setIsBindingFrame(true);
        this.pushFrame(frame);
        this.getCurrentFrame().setVisibility(binding.getVisibility());
        this.pushRubyClass(binding.getKlass());
        return lastFrame;
    }

    public void postEvalWithBinding(Binding binding, Frame lastFrame) {
        binding.getFrame().setIsBindingFrame(false);
        this.popFrameReal(lastFrame);
        this.popRubyClass();
    }

    public void postYield(Binding binding, Frame lastFrame) {
        this.popScope();
        this.popFrameReal(lastFrame);
        this.popRubyClass();
    }

    public void postYieldLight(Binding binding, Frame lastFrame) {
        this.popScope();
        this.popFrameReal(lastFrame);
        this.popRubyClass();
    }

    public void postYieldNoScope(Frame lastFrame) {
        this.popFrameReal(lastFrame);
        this.popRubyClass();
    }

    public void preScopedBody(DynamicScope scope) {
        this.pushScope(scope);
    }

    public void postScopedBody() {
        this.popScope();
    }

    public boolean isWithinTrace() {
        return this.isWithinTrace;
    }

    public void setWithinTrace(boolean isWithinTrace) {
        this.isWithinTrace = isWithinTrace;
    }

    public boolean isWithinDefined() {
        return this.isWithinDefined;
    }

    public void setWithinDefined(boolean isWithinDefined) {
        this.isWithinDefined = isWithinDefined;
    }

    static {
        INTERPRETED_FRAMES.put(DefaultMethod.class.getName() + ".interpretedCall", FrameType.METHOD);
        INTERPRETED_FRAMES.put(InterpretedBlock.class.getName() + ".evalBlockBody", FrameType.BLOCK);
        INTERPRETED_FRAMES.put(ASTInterpreter.class.getName() + ".evalWithBinding", FrameType.EVAL);
        INTERPRETED_FRAMES.put(ASTInterpreter.class.getName() + ".evalSimple", FrameType.EVAL);
        INTERPRETED_FRAMES.put(ASTInterpreter.class.getName() + ".evalClassDefinitionBody", FrameType.CLASS);
        INTERPRETED_FRAMES.put(Ruby.class.getName() + ".runInterpreter", FrameType.ROOT);
    }

    public static enum FrameType {
        METHOD,
        BLOCK,
        EVAL,
        CLASS,
        ROOT;

    }
}

