/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.nb.javasupport;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.ReentrantLock;
import org.jruby.nb.Ruby;
import org.jruby.nb.RubyArray;
import org.jruby.nb.RubyBoolean;
import org.jruby.nb.RubyClass;
import org.jruby.nb.RubyFixnum;
import org.jruby.nb.RubyInteger;
import org.jruby.nb.RubyModule;
import org.jruby.nb.RubyString;
import org.jruby.nb.anno.JRubyClass;
import org.jruby.nb.anno.JRubyMethod;
import org.jruby.nb.common.IRubyWarnings;
import org.jruby.nb.exceptions.RaiseException;
import org.jruby.nb.internal.runtime.methods.DynamicMethod;
import org.jruby.nb.java.addons.ArrayJavaAddons;
import org.jruby.nb.java.invokers.ConstructorInvoker;
import org.jruby.nb.java.invokers.InstanceFieldGetter;
import org.jruby.nb.java.invokers.InstanceFieldSetter;
import org.jruby.nb.java.invokers.InstanceMethodInvoker;
import org.jruby.nb.java.invokers.StaticFieldGetter;
import org.jruby.nb.java.invokers.StaticFieldSetter;
import org.jruby.nb.java.invokers.StaticMethodInvoker;
import org.jruby.nb.java.proxies.ArrayJavaProxy;
import org.jruby.nb.javasupport.Java;
import org.jruby.nb.javasupport.JavaArray;
import org.jruby.nb.javasupport.JavaCallable;
import org.jruby.nb.javasupport.JavaConstructor;
import org.jruby.nb.javasupport.JavaField;
import org.jruby.nb.javasupport.JavaMethod;
import org.jruby.nb.javasupport.JavaObject;
import org.jruby.nb.javasupport.JavaSupport;
import org.jruby.nb.javasupport.JavaUtil;
import org.jruby.nb.javasupport.util.RuntimeHelpers;
import org.jruby.nb.runtime.Arity;
import org.jruby.nb.runtime.Block;
import org.jruby.nb.runtime.CallType;
import org.jruby.nb.runtime.ObjectAllocator;
import org.jruby.nb.runtime.ThreadContext;
import org.jruby.nb.runtime.Visibility;
import org.jruby.nb.runtime.builtin.IRubyObject;
import org.jruby.nb.runtime.callback.Callback;
import org.jruby.nb.util.IdUtil;
import org.jruby.util.ByteList;

@JRubyClass(name={"Java::JavaClass"}, parent="Java::JavaObject")
public class JavaClass
extends JavaObject {
    private static final Class<?>[] EMPTY_CLASS_ARRAY = new Class[0];
    private static final Method[] EMPTY_METHOD_ARRAY = new Method[0];
    private static final Constructor[] EMPTY_CONSTRUCTOR_ARRAY = new Constructor[0];
    private static final Field[] EMPTY_FIELD_ARRAY = new Field[0];
    private static final Map<String, AssignedName> RESERVED_NAMES = new HashMap<String, AssignedName>();
    private static final Map<String, AssignedName> STATIC_RESERVED_NAMES;
    private static final Map<String, AssignedName> INSTANCE_RESERVED_NAMES;
    private final RubyModule JAVA_UTILITIES = this.getRuntime().getJavaSupport().getJavaUtilitiesModule();
    private Map<String, AssignedName> staticAssignedNames;
    private Map<String, AssignedName> instanceAssignedNames;
    private Map<String, NamedInstaller> staticInstallers;
    private Map<String, NamedInstaller> instanceInstallers;
    private ConstructorInvokerInstaller constructorInstaller;
    private List<ConstantField> constantFields;
    private volatile RubyArray constructors;
    private volatile ArrayList<IRubyObject> proxyExtenders;
    private volatile RubyModule proxyModule;
    private volatile RubyClass proxyClass;
    private RubyModule unfinishedProxyModule;
    private RubyClass unfinishedProxyClass;
    private final ReentrantLock proxyLock = new ReentrantLock();
    private static final Callback __jsend_method;

    public RubyModule getProxyModule() {
        RubyModule proxy = this.proxyModule;
        if (proxy != null) {
            return proxy;
        }
        if (this.proxyLock.isHeldByCurrentThread()) {
            return this.unfinishedProxyModule;
        }
        return null;
    }

    public RubyClass getProxyClass() {
        RubyClass proxy = this.proxyClass;
        if (proxy != null) {
            return proxy;
        }
        if (this.proxyLock.isHeldByCurrentThread()) {
            return this.unfinishedProxyClass;
        }
        return null;
    }

    public void lockProxy() {
        this.proxyLock.lock();
    }

    public void unlockProxy() {
        this.proxyLock.unlock();
    }

    protected Map<String, AssignedName> getStaticAssignedNames() {
        return this.staticAssignedNames;
    }

    protected Map<String, AssignedName> getInstanceAssignedNames() {
        return this.instanceAssignedNames;
    }

    private JavaClass(Ruby runtime, Class<?> javaClass) {
        super(runtime, runtime.getJavaSupport().getJavaClassClass(), javaClass);
        if (javaClass.isInterface()) {
            this.initializeInterface(javaClass);
        } else if (!javaClass.isArray() && !javaClass.isPrimitive()) {
            this.initializeClass(javaClass);
        }
    }

    @Override
    public boolean equals(Object other) {
        return other instanceof JavaClass && this.getValue() == ((JavaClass)other).getValue();
    }

    private void initializeInterface(Class<?> javaClass) {
        HashMap<String, AssignedName> staticNames = new HashMap<String, AssignedName>(STATIC_RESERVED_NAMES);
        ArrayList<ConstantField> constantFields = new ArrayList<ConstantField>();
        HashMap<String, NamedInstaller> staticCallbacks = new HashMap<String, NamedInstaller>();
        Field[] fields = EMPTY_FIELD_ARRAY;
        try {
            fields = javaClass.getDeclaredFields();
        }
        catch (SecurityException e) {
            try {
                fields = javaClass.getFields();
            }
            catch (SecurityException e2) {
                // empty catch block
            }
        }
        int i = fields.length;
        while (--i >= 0) {
            AssignedName assignedName;
            Field field = fields[i];
            if (javaClass != field.getDeclaringClass()) continue;
            if (ConstantField.isConstant(field)) {
                constantFields.add(new ConstantField(field));
            }
            String name = field.getName();
            int modifiers = field.getModifiers();
            if (!Modifier.isStatic(modifiers) || (assignedName = (AssignedName)staticNames.get(name)) != null && assignedName.type < 2) continue;
            staticNames.put(name, new AssignedName(name, 2));
            staticCallbacks.put(name, new StaticFieldGetterInstaller(name, field));
            if (Modifier.isFinal(modifiers)) continue;
            String setName = name + '=';
            staticCallbacks.put(setName, new StaticFieldSetterInstaller(setName, field));
        }
        this.staticAssignedNames = staticNames;
        this.staticInstallers = staticCallbacks;
        this.constantFields = constantFields;
    }

    private void initializeClass(Class<?> javaClass) {
        AssignedName assignedName;
        HashMap<Object, Object> instanceNames;
        HashMap<Object, Object> staticNames;
        Class<?> superclass = javaClass.getSuperclass();
        if (superclass == null) {
            staticNames = new HashMap<String, AssignedName>();
            instanceNames = new HashMap<String, AssignedName>();
        } else {
            JavaClass superJavaClass = JavaClass.get(this.getRuntime(), superclass);
            staticNames = new HashMap<String, AssignedName>(superJavaClass.getStaticAssignedNames());
            instanceNames = new HashMap<String, AssignedName>(superJavaClass.getInstanceAssignedNames());
        }
        staticNames.putAll(STATIC_RESERVED_NAMES);
        instanceNames.putAll(INSTANCE_RESERVED_NAMES);
        HashMap<String, NamedInstaller> staticCallbacks = new HashMap<String, NamedInstaller>();
        HashMap<String, NamedInstaller> instanceCallbacks = new HashMap<String, NamedInstaller>();
        ArrayList<ConstantField> constantFields = new ArrayList<ConstantField>();
        Field[] fields = EMPTY_FIELD_ARRAY;
        try {
            fields = javaClass.getFields();
        }
        catch (SecurityException e) {
            // empty catch block
        }
        int i = fields.length;
        while (--i >= 0) {
            String setName;
            Field field = fields[i];
            if (javaClass != field.getDeclaringClass()) continue;
            if (ConstantField.isConstant(field)) {
                constantFields.add(new ConstantField(field));
                continue;
            }
            String name = field.getName();
            int modifiers = field.getModifiers();
            if (Modifier.isStatic(modifiers)) {
                assignedName = (AssignedName)staticNames.get(name);
                if (assignedName != null && assignedName.type < 2) continue;
                staticNames.put(name, new AssignedName(name, 2));
                staticCallbacks.put(name, new StaticFieldGetterInstaller(name, field));
                if (Modifier.isFinal(modifiers)) continue;
                setName = name + '=';
                staticCallbacks.put(setName, new StaticFieldSetterInstaller(setName, field));
                continue;
            }
            assignedName = (AssignedName)instanceNames.get(name);
            if (assignedName != null && assignedName.type < 2) continue;
            instanceNames.put(name, new AssignedName(name, 2));
            instanceCallbacks.put(name, new InstanceFieldGetterInstaller(name, field));
            if (Modifier.isFinal(modifiers)) continue;
            setName = name + '=';
            instanceCallbacks.put(setName, new InstanceFieldSetterInstaller(setName, field));
        }
        Method[] methods = EMPTY_METHOD_ARRAY;
        for (Class<?> c = javaClass; c != null; c = c.getSuperclass()) {
            try {
                methods = javaClass.getMethods();
                break;
            }
            catch (SecurityException e) {
                continue;
            }
        }
        int i2 = methods.length;
        while (--i2 >= 0) {
            MethodInstaller invoker;
            Method method = methods[i2];
            String name = method.getName();
            if (Modifier.isStatic(method.getModifiers())) {
                assignedName = (AssignedName)staticNames.get(name);
                if (assignedName == null) {
                    staticNames.put(name, new AssignedName(name, 1));
                } else {
                    if (assignedName.type < 1) continue;
                    if (assignedName.type != 1) {
                        staticCallbacks.remove(name);
                        staticCallbacks.remove(name + '=');
                        staticNames.put(name, new AssignedName(name, 1));
                    }
                }
                invoker = (StaticMethodInvokerInstaller)staticCallbacks.get(name);
                if (invoker == null) {
                    invoker = new StaticMethodInvokerInstaller(name);
                    staticCallbacks.put(name, invoker);
                }
                invoker.addMethod(method, javaClass);
                continue;
            }
            assignedName = (AssignedName)instanceNames.get(name);
            if (assignedName == null) {
                instanceNames.put(name, new AssignedName(name, 1));
            } else {
                if (assignedName.type < 1) continue;
                if (assignedName.type != 1) {
                    instanceCallbacks.remove(name);
                    instanceCallbacks.remove(name + '=');
                    instanceNames.put(name, new AssignedName(name, 1));
                }
            }
            invoker = (InstanceMethodInvokerInstaller)instanceCallbacks.get(name);
            if (invoker == null) {
                invoker = new InstanceMethodInvokerInstaller(name);
                instanceCallbacks.put(name, invoker);
            }
            invoker.addMethod(method, javaClass);
        }
        Constructor[] constructors = EMPTY_CONSTRUCTOR_ARRAY;
        try {
            constructors = javaClass.getConstructors();
        }
        catch (SecurityException e) {
            // empty catch block
        }
        int i3 = constructors.length;
        while (--i3 >= 0) {
            Constructor ctor = constructors[i3];
            if (this.constructorInstaller == null) {
                this.constructorInstaller = new ConstructorInvokerInstaller("__jcreate!");
            }
            this.constructorInstaller.addConstructor(ctor, javaClass);
        }
        this.staticAssignedNames = staticNames;
        this.instanceAssignedNames = instanceNames;
        this.staticInstallers = staticCallbacks;
        this.instanceInstallers = instanceCallbacks;
        this.constantFields = constantFields;
    }

    public void setupProxy(RubyClass proxy) {
        assert (this.proxyLock.isHeldByCurrentThread());
        proxy.defineFastMethod("__jsend!", __jsend_method);
        Class javaClass = this.javaClass();
        if (javaClass.isInterface()) {
            this.setupInterfaceProxy(proxy);
            return;
        }
        assert (this.proxyClass == null);
        this.unfinishedProxyClass = proxy;
        if (javaClass.isArray() || javaClass.isPrimitive()) {
            this.proxyClass = proxy;
            this.proxyModule = proxy;
            return;
        }
        for (ConstantField field : this.constantFields) {
            field.install(proxy);
        }
        for (NamedInstaller installer : this.staticInstallers.values()) {
            if (installer.type == 2 && installer.hasLocalMethod()) {
                JavaClass.assignAliases((MethodInstaller)installer, this.staticAssignedNames);
            }
            installer.install(proxy);
        }
        for (NamedInstaller installer : this.instanceInstallers.values()) {
            if (installer.type == 4 && installer.hasLocalMethod()) {
                JavaClass.assignAliases((MethodInstaller)installer, this.instanceAssignedNames);
            }
            installer.install(proxy);
        }
        if (this.constructorInstaller != null) {
            this.constructorInstaller.install(proxy);
        }
        Class<?>[] classes = EMPTY_CLASS_ARRAY;
        try {
            classes = javaClass.getClasses();
        }
        catch (SecurityException e) {
            // empty catch block
        }
        int i = classes.length;
        while (--i >= 0) {
            Class<?> clazz;
            String simpleName;
            if (javaClass != classes[i].getDeclaringClass() || (simpleName = JavaClass.getSimpleName(clazz = classes[i])).length() == 0 || !IdUtil.isConstant(simpleName) || proxy.getConstantAt(simpleName) != null) continue;
            proxy.setConstant(simpleName, Java.get_proxy_class(this.JAVA_UTILITIES, JavaClass.get(this.getRuntime(), clazz)));
        }
        this.proxyClass = proxy;
        this.proxyModule = proxy;
        this.applyProxyExtenders();
    }

    private static void assignAliases(MethodInstaller installer, Map<String, AssignedName> assignedNames) {
        String name = installer.name;
        String rubyCasedName = JavaUtil.getRubyCasedName(name);
        JavaClass.addUnassignedAlias(rubyCasedName, assignedNames, installer);
        String javaPropertyName = JavaUtil.getJavaPropertyName(name);
        String rubyPropertyName = null;
        for (Method method : installer.methods) {
            Class<?>[] argTypes = method.getParameterTypes();
            Class<?> resultType = method.getReturnType();
            int argCount = argTypes.length;
            if (javaPropertyName != null) {
                if (rubyCasedName.startsWith("get_")) {
                    rubyPropertyName = rubyCasedName.substring(4);
                    if (argCount == 0 || argCount == 1 && argTypes[0] == Integer.TYPE) {
                        JavaClass.addUnassignedAlias(javaPropertyName, assignedNames, installer);
                        JavaClass.addUnassignedAlias(rubyPropertyName, assignedNames, installer);
                    }
                } else if (rubyCasedName.startsWith("set_")) {
                    rubyPropertyName = rubyCasedName.substring(4);
                    if (argCount == 1 && resultType == Void.TYPE) {
                        JavaClass.addUnassignedAlias(javaPropertyName + '=', assignedNames, installer);
                        JavaClass.addUnassignedAlias(rubyPropertyName + '=', assignedNames, installer);
                    }
                } else if (rubyCasedName.startsWith("is_")) {
                    rubyPropertyName = rubyCasedName.substring(3);
                    if (resultType == Boolean.TYPE) {
                        JavaClass.addUnassignedAlias(javaPropertyName, assignedNames, installer);
                        JavaClass.addUnassignedAlias(rubyPropertyName, assignedNames, installer);
                    }
                }
            }
            if (resultType != Boolean.TYPE) continue;
            JavaClass.addUnassignedAlias(rubyCasedName + '?', assignedNames, installer);
            if (rubyPropertyName == null) continue;
            JavaClass.addUnassignedAlias(rubyPropertyName + '?', assignedNames, installer);
        }
    }

    private static void addUnassignedAlias(String name, Map<String, AssignedName> assignedNames, MethodInstaller installer) {
        if (name != null) {
            AssignedName assignedName = assignedNames.get(name);
            if (assignedName == null) {
                installer.addAlias(name);
                assignedNames.put(name, new AssignedName(name, 5));
            } else if (assignedName.type == 5) {
                installer.addAlias(name);
            } else if (assignedName.type > 5) {
                installer.addAlias(name);
                assignedNames.put(name, new AssignedName(name, 5));
            }
        }
    }

    private void setupInterfaceProxy(RubyClass proxy) {
        assert (this.javaClass().isInterface());
        assert (this.proxyLock.isHeldByCurrentThread());
        assert (this.proxyClass == null);
        this.proxyClass = proxy;
    }

    public void setupInterfaceModule(RubyModule module) {
        assert (this.javaClass().isInterface());
        assert (this.proxyLock.isHeldByCurrentThread());
        assert (this.proxyModule == null);
        this.unfinishedProxyModule = module;
        Class javaClass = this.javaClass();
        for (ConstantField field : this.constantFields) {
            field.install(module);
        }
        for (NamedInstaller installer : this.staticInstallers.values()) {
            if (installer.type == 2 && installer.hasLocalMethod()) {
                JavaClass.assignAliases((MethodInstaller)installer, this.staticAssignedNames);
            }
            installer.install(module);
        }
        Class<?>[] classes = EMPTY_CLASS_ARRAY;
        try {
            classes = javaClass.getClasses();
        }
        catch (SecurityException e) {
            // empty catch block
        }
        int i = classes.length;
        while (--i >= 0) {
            Class<?> clazz;
            String simpleName;
            if (javaClass != classes[i].getDeclaringClass() || (simpleName = JavaClass.getSimpleName(clazz = classes[i])).length() == 0 || !IdUtil.isConstant(simpleName) || module.getConstantAt(simpleName) != null) continue;
            module.const_set(this.getRuntime().newString(simpleName), Java.get_proxy_class(this.JAVA_UTILITIES, JavaClass.get(this.getRuntime(), clazz)));
        }
        this.proxyModule = module;
        this.applyProxyExtenders();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addProxyExtender(IRubyObject extender) {
        this.lockProxy();
        try {
            if (!extender.respondsTo("extend_proxy")) {
                throw this.getRuntime().newTypeError("proxy extender must have an extend_proxy method");
            }
            if (this.proxyModule == null) {
                if (this.proxyExtenders == null) {
                    this.proxyExtenders = new ArrayList();
                }
                this.proxyExtenders.add(extender);
            } else {
                this.getRuntime().getWarnings().warn(IRubyWarnings.ID.PROXY_EXTENDED_LATE, " proxy extender added after proxy class created for " + this, new Object[0]);
                this.extendProxy(extender);
            }
        }
        finally {
            this.unlockProxy();
        }
    }

    private void applyProxyExtenders() {
        ArrayList<IRubyObject> extenders = this.proxyExtenders;
        if (extenders != null) {
            for (IRubyObject extender : extenders) {
                this.extendProxy(extender);
            }
            this.proxyExtenders = null;
        }
    }

    private void extendProxy(IRubyObject extender) {
        extender.callMethod(this.getRuntime().getCurrentContext(), "extend_proxy", this.proxyModule);
    }

    @JRubyMethod(required=1)
    public IRubyObject extend_proxy(IRubyObject extender) {
        this.addProxyExtender(extender);
        return this.getRuntime().getNil();
    }

    public static JavaClass get(Ruby runtime, Class<?> klass) {
        JavaClass javaClass = runtime.getJavaSupport().getJavaClassFromCache(klass);
        if (javaClass == null) {
            javaClass = JavaClass.createJavaClass(runtime, klass);
        }
        return javaClass;
    }

    public static RubyArray getRubyArray(Ruby runtime, Class<?>[] classes) {
        IRubyObject[] javaClasses = new IRubyObject[classes.length];
        int i = classes.length;
        while (--i >= 0) {
            javaClasses[i] = JavaClass.get(runtime, classes[i]);
        }
        return runtime.newArrayNoCopy(javaClasses);
    }

    private static synchronized JavaClass createJavaClass(Ruby runtime, Class<?> klass) {
        JavaClass javaClass = runtime.getJavaSupport().getJavaClassFromCache(klass);
        if (javaClass == null) {
            javaClass = new JavaClass(runtime, klass);
            runtime.getJavaSupport().putJavaClassIntoCache(javaClass);
        }
        return javaClass;
    }

    public static RubyClass createJavaClassClass(Ruby runtime, RubyModule javaModule) {
        RubyClass result = javaModule.defineClassUnder("JavaClass", javaModule.fastGetClass("JavaObject"), ObjectAllocator.NOT_ALLOCATABLE_ALLOCATOR);
        result.includeModule(runtime.fastGetModule("Comparable"));
        result.defineAnnotatedMethods(JavaClass.class);
        result.getMetaClass().undefineMethod("new");
        result.getMetaClass().undefineMethod("allocate");
        return result;
    }

    public static synchronized JavaClass forNameVerbose(Ruby runtime, String className) {
        Class klass = runtime.getJavaSupport().loadJavaClassVerbose(className);
        return JavaClass.get(runtime, klass);
    }

    public static synchronized JavaClass forNameQuiet(Ruby runtime, String className) {
        Class klass = runtime.getJavaSupport().loadJavaClassQuiet(className);
        return JavaClass.get(runtime, klass);
    }

    @JRubyMethod(name={"for_name"}, required=1, meta=true)
    public static JavaClass for_name(IRubyObject recv, IRubyObject name) {
        return JavaClass.forNameVerbose(recv.getRuntime(), name.asJavaString());
    }

    @JRubyMethod
    public RubyModule ruby_class() {
        return Java.getProxyClass(this.getRuntime(), this);
    }

    @JRubyMethod(name={"public?"})
    public RubyBoolean public_p() {
        return this.getRuntime().newBoolean(Modifier.isPublic(this.javaClass().getModifiers()));
    }

    @JRubyMethod(name={"protected?"})
    public RubyBoolean protected_p() {
        return this.getRuntime().newBoolean(Modifier.isProtected(this.javaClass().getModifiers()));
    }

    @JRubyMethod(name={"private?"})
    public RubyBoolean private_p() {
        return this.getRuntime().newBoolean(Modifier.isPrivate(this.javaClass().getModifiers()));
    }

    public Class javaClass() {
        return (Class)this.getValue();
    }

    @JRubyMethod(name={"final?"})
    public RubyBoolean final_p() {
        return this.getRuntime().newBoolean(Modifier.isFinal(this.javaClass().getModifiers()));
    }

    @JRubyMethod(name={"interface?"})
    public RubyBoolean interface_p() {
        return this.getRuntime().newBoolean(this.javaClass().isInterface());
    }

    @JRubyMethod(name={"array?"})
    public RubyBoolean array_p() {
        return this.getRuntime().newBoolean(this.javaClass().isArray());
    }

    @JRubyMethod(name={"enum?"})
    public RubyBoolean enum_p() {
        return this.getRuntime().newBoolean(this.javaClass().isEnum());
    }

    @JRubyMethod(name={"annotation?"})
    public RubyBoolean annotation_p() {
        return this.getRuntime().newBoolean(this.javaClass().isAnnotation());
    }

    @JRubyMethod(name={"anonymous_class?"})
    public RubyBoolean anonymous_class_p() {
        return this.getRuntime().newBoolean(this.javaClass().isAnonymousClass());
    }

    @JRubyMethod(name={"local_class?"})
    public RubyBoolean local_class_p() {
        return this.getRuntime().newBoolean(this.javaClass().isLocalClass());
    }

    @JRubyMethod(name={"member_class?"})
    public RubyBoolean member_class_p() {
        return this.getRuntime().newBoolean(this.javaClass().isMemberClass());
    }

    @JRubyMethod(name={"synthetic?"})
    public IRubyObject synthetic_p() {
        return this.getRuntime().newBoolean(this.javaClass().isSynthetic());
    }

    @JRubyMethod(name={"name", "to_s"})
    public RubyString name() {
        return this.getRuntime().newString(this.javaClass().getName());
    }

    @JRubyMethod
    public IRubyObject canonical_name() {
        String canonicalName = this.javaClass().getCanonicalName();
        if (canonicalName != null) {
            return this.getRuntime().newString(canonicalName);
        }
        return this.getRuntime().getNil();
    }

    @JRubyMethod(name={"package"})
    public IRubyObject get_package() {
        return Java.getInstance(this.getRuntime(), this.javaClass().getPackage());
    }

    @JRubyMethod
    public IRubyObject class_loader() {
        return Java.getInstance(this.getRuntime(), this.javaClass().getClassLoader());
    }

    @JRubyMethod
    public IRubyObject protection_domain() {
        return Java.getInstance(this.getRuntime(), this.javaClass().getProtectionDomain());
    }

    @JRubyMethod(required=1)
    public IRubyObject resource(IRubyObject name) {
        return Java.getInstance(this.getRuntime(), this.javaClass().getResource(name.asJavaString()));
    }

    @JRubyMethod(required=1)
    public IRubyObject resource_as_stream(IRubyObject name) {
        return Java.getInstance(this.getRuntime(), this.javaClass().getResourceAsStream(name.asJavaString()));
    }

    @JRubyMethod(required=1)
    public IRubyObject resource_as_string(IRubyObject name) {
        InputStream in = this.javaClass().getResourceAsStream(name.asJavaString());
        if (in == null) {
            return this.getRuntime().getNil();
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            int len;
            byte[] buf = new byte[4096];
            while ((len = in.read(buf)) >= 0) {
                out.write(buf, 0, len);
            }
        }
        catch (IOException e) {
            throw this.getRuntime().newIOErrorFromException(e);
        }
        return this.getRuntime().newString(new ByteList(out.toByteArray(), false));
    }

    @JRubyMethod(required=1)
    public IRubyObject annotation(IRubyObject annoClass) {
        if (!(annoClass instanceof JavaClass)) {
            throw this.getRuntime().newTypeError(annoClass, this.getRuntime().getJavaSupport().getJavaClassClass());
        }
        return Java.getInstance(this.getRuntime(), this.javaClass().getAnnotation(((JavaClass)annoClass).javaClass()));
    }

    @JRubyMethod
    public IRubyObject annotations() {
        return Java.getInstance(this.getRuntime(), this.javaClass().getAnnotations());
    }

    @JRubyMethod(name={"annotations?"})
    public RubyBoolean annotations_p() {
        return this.getRuntime().newBoolean(this.javaClass().getAnnotations().length > 0);
    }

    @JRubyMethod
    public IRubyObject declared_annotations() {
        return Java.getInstance(this.getRuntime(), this.javaClass().getDeclaredAnnotations());
    }

    @JRubyMethod(name={"declared_annotations?"})
    public RubyBoolean declared_annotations_p() {
        return this.getRuntime().newBoolean(this.javaClass().getDeclaredAnnotations().length > 0);
    }

    @JRubyMethod(name={"annotation_present?"}, required=1)
    public IRubyObject annotation_present_p(IRubyObject annoClass) {
        if (!(annoClass instanceof JavaClass)) {
            throw this.getRuntime().newTypeError(annoClass, this.getRuntime().getJavaSupport().getJavaClassClass());
        }
        return this.getRuntime().newBoolean(this.javaClass().isAnnotationPresent(((JavaClass)annoClass).javaClass()));
    }

    @JRubyMethod
    public IRubyObject modifiers() {
        return this.getRuntime().newFixnum(this.javaClass().getModifiers());
    }

    @JRubyMethod
    public IRubyObject declaring_class() {
        Class<?> clazz = this.javaClass().getDeclaringClass();
        if (clazz != null) {
            return JavaClass.get(this.getRuntime(), clazz);
        }
        return this.getRuntime().getNil();
    }

    @JRubyMethod
    public IRubyObject enclosing_class() {
        return Java.getInstance(this.getRuntime(), this.javaClass().getEnclosingClass());
    }

    @JRubyMethod
    public IRubyObject enclosing_constructor() {
        Constructor<?> ctor = this.javaClass().getEnclosingConstructor();
        if (ctor != null) {
            return new JavaConstructor(this.getRuntime(), ctor);
        }
        return this.getRuntime().getNil();
    }

    @JRubyMethod
    public IRubyObject enclosing_method() {
        Method meth = this.javaClass().getEnclosingMethod();
        if (meth != null) {
            return new JavaMethod(this.getRuntime(), meth);
        }
        return this.getRuntime().getNil();
    }

    @JRubyMethod
    public IRubyObject enum_constants() {
        return Java.getInstance(this.getRuntime(), this.javaClass().getEnumConstants());
    }

    @JRubyMethod
    public IRubyObject generic_interfaces() {
        return Java.getInstance(this.getRuntime(), this.javaClass().getGenericInterfaces());
    }

    @JRubyMethod
    public IRubyObject generic_superclass() {
        return Java.getInstance(this.getRuntime(), this.javaClass().getGenericSuperclass());
    }

    @JRubyMethod
    public IRubyObject type_parameters() {
        return Java.getInstance(this.getRuntime(), this.javaClass().getTypeParameters());
    }

    @JRubyMethod
    public IRubyObject signers() {
        return Java.getInstance(this.getRuntime(), this.javaClass().getSigners());
    }

    private static String getSimpleName(Class<?> clazz) {
        if (clazz.isArray()) {
            return JavaClass.getSimpleName(clazz.getComponentType()) + "[]";
        }
        String className = clazz.getName();
        int len = className.length();
        int i = className.lastIndexOf(36);
        if (i != -1) {
            while (++i < len && Character.isDigit(className.charAt(i))) {
            }
            return className.substring(i);
        }
        return className.substring(className.lastIndexOf(46) + 1);
    }

    @JRubyMethod
    public RubyString simple_name() {
        return this.getRuntime().newString(JavaClass.getSimpleName(this.javaClass()));
    }

    @JRubyMethod
    public IRubyObject superclass() {
        Class superclass = this.javaClass().getSuperclass();
        if (superclass == null) {
            return this.getRuntime().getNil();
        }
        return JavaClass.get(this.getRuntime(), superclass);
    }

    @JRubyMethod(name={"<=>"}, required=1)
    public RubyFixnum op_cmp(IRubyObject other) {
        if (!(other instanceof JavaClass)) {
            throw this.getRuntime().newTypeError("<=> requires JavaClass (" + other.getType() + " given)");
        }
        JavaClass otherClass = (JavaClass)other;
        if (this.javaClass() == otherClass.javaClass()) {
            return this.getRuntime().newFixnum(0);
        }
        if (otherClass.javaClass().isAssignableFrom(this.javaClass())) {
            return this.getRuntime().newFixnum(-1);
        }
        return this.getRuntime().newFixnum(1);
    }

    @JRubyMethod
    public RubyArray java_instance_methods() {
        return this.java_methods(this.javaClass().getMethods(), false);
    }

    @JRubyMethod
    public RubyArray declared_instance_methods() {
        return this.java_methods(this.javaClass().getDeclaredMethods(), false);
    }

    private RubyArray java_methods(Method[] methods, boolean isStatic) {
        RubyArray result = this.getRuntime().newArray(methods.length);
        for (int i = 0; i < methods.length; ++i) {
            Method method = methods[i];
            if (isStatic != Modifier.isStatic(method.getModifiers())) continue;
            result.append(JavaMethod.create(this.getRuntime(), method));
        }
        return result;
    }

    @JRubyMethod
    public RubyArray java_class_methods() {
        return this.java_methods(this.javaClass().getMethods(), true);
    }

    @JRubyMethod
    public RubyArray declared_class_methods() {
        return this.java_methods(this.javaClass().getDeclaredMethods(), true);
    }

    @JRubyMethod(required=1, rest=true)
    public JavaMethod java_method(IRubyObject[] args) throws ClassNotFoundException {
        String methodName = args[0].asJavaString();
        Class<?>[] argumentTypes = this.buildArgumentTypes(args);
        return JavaMethod.create(this.getRuntime(), this.javaClass(), methodName, argumentTypes);
    }

    @JRubyMethod(required=1, rest=true)
    public JavaMethod declared_method(IRubyObject[] args) throws ClassNotFoundException {
        String methodName = args[0].asJavaString();
        Class<?>[] argumentTypes = this.buildArgumentTypes(args);
        return JavaMethod.createDeclared(this.getRuntime(), this.javaClass(), methodName, argumentTypes);
    }

    @JRubyMethod(required=1, rest=true)
    public JavaCallable declared_method_smart(IRubyObject[] args) throws ClassNotFoundException {
        String methodName = args[0].asJavaString();
        Class<?>[] argumentTypes = this.buildArgumentTypes(args);
        JavaCallable callable = JavaClass.getMatchingCallable(this.getRuntime(), this.javaClass(), methodName, argumentTypes);
        if (callable != null) {
            return callable;
        }
        throw this.getRuntime().newNameError("undefined method '" + methodName + "' for class '" + this.javaClass().getName() + "'", methodName);
    }

    public static JavaCallable getMatchingCallable(Ruby runtime, Class<?> javaClass, String methodName, Class<?>[] argumentTypes) {
        if ("<init>".equals(methodName)) {
            return JavaConstructor.getMatchingConstructor(runtime, javaClass, argumentTypes);
        }
        return JavaMethod.getMatchingDeclaredMethod(runtime, javaClass, methodName, argumentTypes);
    }

    private Class<?>[] buildArgumentTypes(IRubyObject[] args) throws ClassNotFoundException {
        if (args.length < 1) {
            throw this.getRuntime().newArgumentError(args.length, 1);
        }
        Class[] argumentTypes = new Class[args.length - 1];
        for (int i = 1; i < args.length; ++i) {
            JavaClass type = args[i] instanceof JavaClass ? (JavaClass)args[i] : (args[i].respondsTo("java_class") ? (JavaClass)args[i].callMethod(this.getRuntime().getCurrentContext(), "java_class") : JavaClass.for_name(this, args[i]));
            argumentTypes[i - 1] = type.javaClass();
        }
        return argumentTypes;
    }

    @JRubyMethod
    public RubyArray constructors() {
        RubyArray ctors = this.constructors;
        if (ctors != null) {
            return ctors;
        }
        this.constructors = this.buildConstructors(this.javaClass().getConstructors());
        return this.constructors;
    }

    @JRubyMethod
    public RubyArray classes() {
        return JavaClass.getRubyArray(this.getRuntime(), this.javaClass().getClasses());
    }

    @JRubyMethod
    public RubyArray declared_classes() {
        Ruby runtime = this.getRuntime();
        RubyArray result = runtime.newArray();
        Class javaClass = this.javaClass();
        try {
            Class<?>[] classes = javaClass.getDeclaredClasses();
            for (int i = 0; i < classes.length; ++i) {
                if (!Modifier.isPublic(classes[i].getModifiers())) continue;
                result.append(JavaClass.get(runtime, classes[i]));
            }
        }
        catch (SecurityException e) {
            try {
                Class<?>[] classes = javaClass.getClasses();
                for (int i = 0; i < classes.length; ++i) {
                    if (javaClass != classes[i].getDeclaringClass()) continue;
                    result.append(JavaClass.get(runtime, classes[i]));
                }
            }
            catch (SecurityException e2) {
                // empty catch block
            }
        }
        return result;
    }

    @JRubyMethod
    public RubyArray declared_constructors() {
        return this.buildConstructors(this.javaClass().getDeclaredConstructors());
    }

    private RubyArray buildConstructors(Constructor<?>[] constructors) {
        RubyArray result = this.getRuntime().newArray(constructors.length);
        for (int i = 0; i < constructors.length; ++i) {
            result.append(new JavaConstructor(this.getRuntime(), constructors[i]));
        }
        return result;
    }

    @JRubyMethod(rest=true)
    public JavaConstructor constructor(IRubyObject[] args) {
        try {
            Class<?>[] parameterTypes = this.buildClassArgs(args);
            Constructor constructor = this.javaClass().getConstructor(parameterTypes);
            return new JavaConstructor(this.getRuntime(), constructor);
        }
        catch (NoSuchMethodException nsme) {
            throw this.getRuntime().newNameError("no matching java constructor", null);
        }
    }

    @JRubyMethod(rest=true)
    public JavaConstructor declared_constructor(IRubyObject[] args) {
        try {
            Class<?>[] parameterTypes = this.buildClassArgs(args);
            Constructor constructor = this.javaClass().getDeclaredConstructor(parameterTypes);
            return new JavaConstructor(this.getRuntime(), constructor);
        }
        catch (NoSuchMethodException nsme) {
            throw this.getRuntime().newNameError("no matching java constructor", null);
        }
    }

    private Class<?>[] buildClassArgs(IRubyObject[] args) {
        JavaSupport javaSupport = this.getRuntime().getJavaSupport();
        Class[] parameterTypes = new Class[args.length];
        int i = args.length;
        while (--i >= 0) {
            String name = args[i].asJavaString();
            parameterTypes[i] = javaSupport.loadJavaClassVerbose(name);
        }
        return parameterTypes;
    }

    @JRubyMethod
    public JavaClass array_class() {
        return JavaClass.get(this.getRuntime(), Array.newInstance(this.javaClass(), 0).getClass());
    }

    @JRubyMethod(required=1)
    public JavaObject new_array(IRubyObject lengthArgument) {
        if (lengthArgument instanceof RubyInteger) {
            int length = (int)((RubyInteger)lengthArgument).getLongValue();
            return new JavaArray(this.getRuntime(), Array.newInstance(this.javaClass(), length));
        }
        if (lengthArgument instanceof RubyArray) {
            List list = ((RubyArray)lengthArgument).getList();
            int length = list.size();
            if (length == 0) {
                throw this.getRuntime().newArgumentError("empty dimensions specifier for java array");
            }
            int[] dimensions = new int[length];
            int i = length;
            while (--i >= 0) {
                IRubyObject dimensionLength = (IRubyObject)list.get(i);
                if (!(dimensionLength instanceof RubyInteger)) {
                    throw this.getRuntime().newTypeError(dimensionLength, this.getRuntime().getInteger());
                }
                dimensions[i] = (int)((RubyInteger)dimensionLength).getLongValue();
            }
            return new JavaArray(this.getRuntime(), Array.newInstance(this.javaClass(), dimensions));
        }
        throw this.getRuntime().newArgumentError("invalid length or dimensions specifier for java array - must be Integer or Array of Integer");
    }

    public IRubyObject emptyJavaArray(ThreadContext context) {
        JavaArray javaArray = new JavaArray(this.getRuntime(), Array.newInstance(this.javaClass(), 0));
        RubyClass proxyClass = (RubyClass)Java.get_proxy_class(javaArray, this.array_class());
        ArrayJavaProxy proxy = new ArrayJavaProxy(context.getRuntime(), proxyClass);
        proxy.dataWrapStruct(javaArray);
        return proxy;
    }

    public IRubyObject javaArraySubarray(ThreadContext context, JavaArray fromArray, int index, int size) {
        int actualLength = Array.getLength(fromArray.getValue());
        if (index >= actualLength) {
            return context.getRuntime().getNil();
        }
        if (index + size > actualLength) {
            size = actualLength - index;
        }
        Object newArray = Array.newInstance(this.javaClass(), size);
        JavaArray javaArray = new JavaArray(this.getRuntime(), newArray);
        System.arraycopy(fromArray.getValue(), index, newArray, 0, size);
        RubyClass proxyClass = (RubyClass)Java.get_proxy_class(javaArray, this.array_class());
        ArrayJavaProxy proxy = new ArrayJavaProxy(context.getRuntime(), proxyClass);
        proxy.dataWrapStruct(javaArray);
        return proxy;
    }

    public IRubyObject concatArrays(ThreadContext context, JavaArray original, JavaArray additional) {
        int oldLength = (int)original.length().getLongValue();
        int addLength = (int)additional.length().getLongValue();
        Object newArray = Array.newInstance(this.javaClass(), oldLength + addLength);
        JavaArray javaArray = new JavaArray(this.getRuntime(), newArray);
        System.arraycopy(original.getValue(), 0, newArray, 0, oldLength);
        System.arraycopy(additional.getValue(), 0, newArray, oldLength, addLength);
        RubyClass proxyClass = (RubyClass)Java.get_proxy_class(javaArray, this.array_class());
        ArrayJavaProxy proxy = new ArrayJavaProxy(context.getRuntime(), proxyClass);
        proxy.dataWrapStruct(javaArray);
        return proxy;
    }

    public IRubyObject concatArrays(ThreadContext context, JavaArray original, IRubyObject additional) {
        int oldLength = (int)original.length().getLongValue();
        int addLength = (int)((RubyFixnum)RuntimeHelpers.invoke(context, additional, "length")).getLongValue();
        Object newArray = Array.newInstance(this.javaClass(), oldLength + addLength);
        JavaArray javaArray = new JavaArray(this.getRuntime(), newArray);
        System.arraycopy(original.getValue(), 0, newArray, 0, oldLength);
        RubyClass proxyClass = (RubyClass)Java.get_proxy_class(javaArray, this.array_class());
        ArrayJavaProxy proxy = new ArrayJavaProxy(context.getRuntime(), proxyClass);
        proxy.dataWrapStruct(javaArray);
        Ruby runtime = context.getRuntime();
        for (int i = 0; i < addLength; ++i) {
            RuntimeHelpers.invoke(context, (IRubyObject)proxy, "[]=", (IRubyObject)runtime.newFixnum(oldLength + i), RuntimeHelpers.invoke(context, additional, "[]", runtime.newFixnum(i)));
        }
        return proxy;
    }

    public IRubyObject javaArrayFromRubyArray(ThreadContext context, IRubyObject fromArray) {
        Ruby runtime = context.getRuntime();
        if (!(fromArray instanceof RubyArray)) {
            throw runtime.newTypeError(fromArray, runtime.getArray());
        }
        RubyArray rubyArray = (RubyArray)fromArray;
        JavaArray javaArray = new JavaArray(this.getRuntime(), Array.newInstance(this.javaClass(), rubyArray.size()));
        if (this.javaClass().isArray()) {
            for (int i = 0; i < rubyArray.size(); ++i) {
                JavaClass componentType = this.component_type();
                IRubyObject wrappedComponentArray = componentType.javaArrayFromRubyArray(context, rubyArray.eltInternal(i));
                javaArray.setWithExceptionHandling(i, JavaUtil.unwrapJavaObject(wrappedComponentArray));
            }
        } else {
            ArrayJavaAddons.copyDataToJavaArray(context, rubyArray, javaArray);
        }
        RubyClass proxyClass = (RubyClass)Java.get_proxy_class(javaArray, this.array_class());
        ArrayJavaProxy proxy = new ArrayJavaProxy(runtime, proxyClass);
        proxy.dataWrapStruct(javaArray);
        return proxy;
    }

    @JRubyMethod
    public RubyArray fields() {
        return this.buildFieldResults(this.javaClass().getFields());
    }

    @JRubyMethod
    public RubyArray declared_fields() {
        return this.buildFieldResults(this.javaClass().getDeclaredFields());
    }

    private RubyArray buildFieldResults(Field[] fields) {
        RubyArray result = this.getRuntime().newArray(fields.length);
        for (int i = 0; i < fields.length; ++i) {
            result.append(new JavaField(this.getRuntime(), fields[i]));
        }
        return result;
    }

    @JRubyMethod(required=1)
    public JavaField field(IRubyObject name) {
        String stringName = name.asJavaString();
        Field field = null;
        try {
            field = this.javaClass().getField(stringName);
            return new JavaField(this.getRuntime(), field);
        }
        catch (NoSuchFieldException nsfe) {
            String newName = JavaUtil.getJavaCasedName(stringName);
            if (newName != null) {
                try {
                    field = this.javaClass().getField(newName);
                    return new JavaField(this.getRuntime(), field);
                }
                catch (NoSuchFieldException nsfe2) {
                    // empty catch block
                }
            }
            throw this.undefinedFieldError(stringName);
        }
    }

    @JRubyMethod(required=1)
    public JavaField declared_field(IRubyObject name) {
        String stringName = name.asJavaString();
        Field field = null;
        try {
            field = this.javaClass().getDeclaredField(stringName);
            return new JavaField(this.getRuntime(), field);
        }
        catch (NoSuchFieldException nsfe) {
            String newName = JavaUtil.getJavaCasedName(stringName);
            if (newName != null) {
                try {
                    field = this.javaClass().getDeclaredField(newName);
                    return new JavaField(this.getRuntime(), field);
                }
                catch (NoSuchFieldException nsfe2) {
                    // empty catch block
                }
            }
            throw this.undefinedFieldError(stringName);
        }
    }

    private RaiseException undefinedFieldError(String name) {
        return this.getRuntime().newNameError("undefined field '" + name + "' for class '" + this.javaClass().getName() + "'", name);
    }

    @JRubyMethod
    public RubyArray interfaces() {
        return JavaClass.getRubyArray(this.getRuntime(), this.javaClass().getInterfaces());
    }

    @JRubyMethod(name={"primitive?"})
    public RubyBoolean primitive_p() {
        return this.getRuntime().newBoolean(this.isPrimitive());
    }

    @JRubyMethod(name={"assignable_from?"}, required=1)
    public RubyBoolean assignable_from_p(IRubyObject other) {
        if (!(other instanceof JavaClass)) {
            throw this.getRuntime().newTypeError("assignable_from requires JavaClass (" + other.getType() + " given)");
        }
        Class otherClass = ((JavaClass)other).javaClass();
        return JavaClass.assignable(this.javaClass(), otherClass) ? this.getRuntime().getTrue() : this.getRuntime().getFalse();
    }

    static boolean assignable(Class<?> thisClass, Class<?> otherClass) {
        if (!thisClass.isPrimitive() && otherClass == Void.TYPE || thisClass.isAssignableFrom(otherClass)) {
            return true;
        }
        otherClass = JavaUtil.primitiveToWrapper(otherClass);
        if ((thisClass = JavaUtil.primitiveToWrapper(thisClass)).isAssignableFrom(otherClass)) {
            return true;
        }
        if (Number.class.isAssignableFrom(thisClass)) {
            if (Number.class.isAssignableFrom(otherClass)) {
                return true;
            }
            if (otherClass.equals(Character.class)) {
                return true;
            }
        }
        return thisClass.equals(Character.class) && Number.class.isAssignableFrom(otherClass);
    }

    private boolean isPrimitive() {
        return this.javaClass().isPrimitive();
    }

    @JRubyMethod
    public JavaClass component_type() {
        if (!this.javaClass().isArray()) {
            throw this.getRuntime().newTypeError("not a java array-class");
        }
        return JavaClass.get(this.getRuntime(), this.javaClass().getComponentType());
    }

    static {
        RESERVED_NAMES.put("__id__", new AssignedName("__id__", 0));
        RESERVED_NAMES.put("__send__", new AssignedName("__send__", 0));
        RESERVED_NAMES.put("class", new AssignedName("class", 0));
        RESERVED_NAMES.put("initialize", new AssignedName("initialize", 0));
        RESERVED_NAMES.put("object_id", new AssignedName("object_id", 0));
        RESERVED_NAMES.put("private", new AssignedName("private", 0));
        RESERVED_NAMES.put("protected", new AssignedName("protected", 0));
        RESERVED_NAMES.put("public", new AssignedName("public", 0));
        RESERVED_NAMES.put("id", new AssignedName("id", 4));
        STATIC_RESERVED_NAMES = new HashMap<String, AssignedName>(RESERVED_NAMES);
        STATIC_RESERVED_NAMES.put("new", new AssignedName("new", 0));
        INSTANCE_RESERVED_NAMES = new HashMap<String, AssignedName>(RESERVED_NAMES);
        __jsend_method = new Callback(){

            @Override
            public IRubyObject execute(IRubyObject self, IRubyObject[] args, Block block) {
                String name = args[0].asJavaString();
                DynamicMethod method = self.getMetaClass().searchMethod(name);
                int v = method.getArity().getValue();
                IRubyObject[] newArgs = new IRubyObject[args.length - 1];
                System.arraycopy(args, 1, newArgs, 0, newArgs.length);
                if (v < 0 || v == newArgs.length) {
                    return RuntimeHelpers.invoke(self.getRuntime().getCurrentContext(), self, name, newArgs, block);
                }
                RubyClass superClass = self.getMetaClass().getSuperClass();
                return RuntimeHelpers.invokeAs(self.getRuntime().getCurrentContext(), superClass, self, name, newArgs, CallType.SUPER, block);
            }

            @Override
            public Arity getArity() {
                return Arity.optional();
            }
        };
    }

    private static class ConstantField {
        static final int CONSTANT = 25;
        final Field field;

        ConstantField(Field field) {
            this.field = field;
        }

        void install(RubyModule proxy) {
            if (proxy.fastGetConstantAt(this.field.getName()) == null) {
                if (!Ruby.isSecurityRestricted()) {
                    this.field.setAccessible(true);
                }
                try {
                    proxy.setConstant(this.field.getName(), JavaUtil.convertJavaToUsableRubyObject(proxy.getRuntime(), this.field.get(null)));
                }
                catch (IllegalAccessException iae) {
                    throw proxy.getRuntime().newTypeError("illegal access on setting variable: " + iae.getMessage());
                }
            }
        }

        static boolean isConstant(Field field) {
            return (field.getModifiers() & 0x19) == 25 && Character.isUpperCase(field.getName().charAt(0));
        }
    }

    private static class InstanceMethodInvokerInstaller
    extends MethodInstaller {
        InstanceMethodInvokerInstaller(String name) {
            super(name, 4);
        }

        @Override
        void install(RubyModule proxy) {
            if (this.hasLocalMethod()) {
                InstanceMethodInvoker method = new InstanceMethodInvoker(proxy, this.methods);
                proxy.addMethod(this.name, method);
                if (this.aliases != null && this.isPublic()) {
                    proxy.defineAliases(this.aliases, this.name);
                    this.aliases = null;
                }
            }
        }
    }

    private static class StaticMethodInvokerInstaller
    extends MethodInstaller {
        StaticMethodInvokerInstaller(String name) {
            super(name, 2);
        }

        @Override
        void install(RubyModule proxy) {
            if (this.hasLocalMethod()) {
                RubyClass singleton = proxy.getSingletonClass();
                StaticMethodInvoker method = new StaticMethodInvoker(singleton, (List<Method>)this.methods);
                singleton.addMethod(this.name, method);
                if (this.aliases != null && this.isPublic()) {
                    singleton.defineAliases(this.aliases, this.name);
                    this.aliases = null;
                }
            }
        }
    }

    private static class ConstructorInvokerInstaller
    extends MethodInstaller {
        private boolean haveLocalConstructor;
        protected List<Constructor> constructors;

        ConstructorInvokerInstaller(String name) {
            super(name, 2);
        }

        void addConstructor(Constructor ctor, Class<?> javaClass) {
            if (this.constructors == null) {
                this.constructors = new ArrayList<Constructor>();
            }
            if (!Ruby.isSecurityRestricted()) {
                ctor.setAccessible(true);
            }
            this.constructors.add(ctor);
            this.haveLocalConstructor |= javaClass == ctor.getDeclaringClass();
        }

        @Override
        void install(RubyModule proxy) {
            if (this.haveLocalConstructor) {
                ConstructorInvoker method = new ConstructorInvoker(proxy, this.constructors);
                proxy.addMethod(this.name, method);
            }
        }
    }

    private static abstract class MethodInstaller
    extends NamedInstaller {
        private boolean haveLocalMethod;
        protected List<Method> methods;
        protected List<String> aliases;

        MethodInstaller() {
        }

        MethodInstaller(String name, int type) {
            super(name, type);
        }

        void addMethod(Method method, Class<?> javaClass) {
            if (this.methods == null) {
                this.methods = new ArrayList<Method>();
            }
            if (!Ruby.isSecurityRestricted()) {
                method.setAccessible(true);
            }
            this.methods.add(method);
            this.haveLocalMethod |= javaClass == method.getDeclaringClass();
        }

        void addAlias(String alias) {
            if (this.aliases == null) {
                this.aliases = new ArrayList<String>();
            }
            if (!this.aliases.contains(alias)) {
                this.aliases.add(alias);
            }
        }

        @Override
        boolean hasLocalMethod() {
            return this.haveLocalMethod;
        }
    }

    private static class InstanceFieldSetterInstaller
    extends FieldInstaller {
        InstanceFieldSetterInstaller() {
        }

        InstanceFieldSetterInstaller(String name, Field field) {
            super(name, 3, field);
        }

        @Override
        void install(RubyModule proxy) {
            if (Modifier.isPublic(this.field.getModifiers())) {
                proxy.addMethod(this.name, new InstanceFieldSetter(this.name, proxy, this.field));
            }
        }
    }

    private static class InstanceFieldGetterInstaller
    extends FieldInstaller {
        InstanceFieldGetterInstaller() {
        }

        InstanceFieldGetterInstaller(String name, Field field) {
            super(name, 3, field);
        }

        @Override
        void install(RubyModule proxy) {
            if (Modifier.isPublic(this.field.getModifiers())) {
                proxy.addMethod(this.name, new InstanceFieldGetter(this.name, proxy, this.field));
            }
        }
    }

    private static class StaticFieldSetterInstaller
    extends FieldInstaller {
        StaticFieldSetterInstaller() {
        }

        StaticFieldSetterInstaller(String name, Field field) {
            super(name, 1, field);
        }

        @Override
        void install(RubyModule proxy) {
            if (Modifier.isPublic(this.field.getModifiers())) {
                proxy.getSingletonClass().addMethod(this.name, new StaticFieldSetter(this.name, proxy, this.field));
            }
        }
    }

    private static class StaticFieldGetterInstaller
    extends FieldInstaller {
        StaticFieldGetterInstaller() {
        }

        StaticFieldGetterInstaller(String name, Field field) {
            super(name, 1, field);
        }

        @Override
        void install(RubyModule proxy) {
            if (Modifier.isPublic(this.field.getModifiers())) {
                proxy.getSingletonClass().addMethod(this.name, new StaticFieldGetter(this.name, proxy, this.field));
            }
        }
    }

    private static abstract class FieldInstaller
    extends NamedInstaller {
        Field field;

        FieldInstaller() {
        }

        FieldInstaller(String name, int type, Field field) {
            super(name, type);
            this.field = field;
        }
    }

    private static abstract class NamedInstaller {
        static final int STATIC_FIELD = 1;
        static final int STATIC_METHOD = 2;
        static final int INSTANCE_FIELD = 3;
        static final int INSTANCE_METHOD = 4;
        static final int CONSTRUCTOR = 5;
        String name;
        int type;
        Visibility visibility = Visibility.PUBLIC;
        boolean isProtected;

        NamedInstaller() {
        }

        NamedInstaller(String name, int type) {
            this.name = name;
            this.type = type;
        }

        abstract void install(RubyModule var1);

        boolean hasLocalMethod() {
            return true;
        }

        boolean isPublic() {
            return this.visibility == Visibility.PUBLIC;
        }

        boolean isProtected() {
            return this.visibility == Visibility.PROTECTED;
        }
    }

    private static class AssignedName {
        static final int RESERVED = 0;
        static final int METHOD = 1;
        static final int FIELD = 2;
        static final int PROTECTED_METHOD = 3;
        static final int WEAKLY_RESERVED = 4;
        static final int ALIAS = 5;
        static final int PROTECTED_FIELD = 6;
        String name;
        int type;

        AssignedName() {
        }

        AssignedName(String name, int type) {
            this.name = name;
            this.type = type;
        }
    }
}

