/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.nb.ast;

import org.jruby.nb.Ruby;
import org.jruby.nb.RubyClass;
import org.jruby.nb.ast.CallNoArgBlockNode;
import org.jruby.nb.ast.CallNode;
import org.jruby.nb.ast.IterNode;
import org.jruby.nb.ast.Node;
import org.jruby.nb.exceptions.JumpException;
import org.jruby.nb.internal.runtime.methods.DynamicMethod;
import org.jruby.nb.lexer.yacc.ISourcePosition;
import org.jruby.nb.runtime.Block;
import org.jruby.nb.runtime.ThreadContext;
import org.jruby.nb.runtime.Visibility;
import org.jruby.nb.runtime.builtin.IRubyObject;

public final class CallNoArgNode
extends CallNode {
    public CallNoArgNode(ISourcePosition position, Node receiverNode, String name) {
        super(position, receiverNode, name, null, null);
    }

    public CallNoArgNode(ISourcePosition position, Node receiverNode, Node args, String name) {
        super(position, receiverNode, name, args, null);
    }

    @Override
    public IRubyObject interpret(Ruby runtime, ThreadContext context, IRubyObject self, Block aBlock) {
        return this.callAdapter.call(context, this.getReceiverNode().interpret(runtime, context, self, aBlock));
    }

    @Override
    public Node setIterNode(Node iterNode) {
        return new CallNoArgBlockNode(this.getPosition(), this.getReceiverNode(), this.getName(), this.getArgsNode(), (IterNode)iterNode);
    }

    @Override
    public String definition(Ruby runtime, ThreadContext context, IRubyObject self, Block aBlock) {
        if (this.getReceiverNode().definition(runtime, context, self, aBlock) != null) {
            try {
                IRubyObject receiver = this.getReceiverNode().interpret(runtime, context, self, aBlock);
                RubyClass metaClass = receiver.getMetaClass();
                DynamicMethod method = metaClass.searchMethod(this.getName());
                Visibility visibility = method.getVisibility();
                if (visibility != Visibility.PRIVATE && (visibility != Visibility.PROTECTED || metaClass.getRealClass().isInstance(self))) {
                    return !method.isUndefined() ? "method" : null;
                }
            }
            catch (JumpException excptn) {
                // empty catch block
            }
        }
        return null;
    }
}

