/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.apisupport.project.ui.wizard.options;

import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.netbeans.modules.apisupport.project.Util;
import org.netbeans.modules.apisupport.project.layers.LayerUtils;
import org.netbeans.modules.apisupport.project.ui.UIUtil;
import org.netbeans.modules.apisupport.project.ui.wizard.BasicWizardIterator;
import org.netbeans.modules.apisupport.project.ui.wizard.options.NewOptionsIterator;
import org.netbeans.modules.apisupport.project.universe.NbPlatform;
import org.openide.WizardDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

final class OptionsPanel0
extends BasicWizardIterator.Panel {
    private NewOptionsIterator.DataModel data;
    private DocumentListener fieldsDL;
    private JRadioButton advancedButton;
    private JCheckBox allowSecondaryPanelsCheckBox;
    private ButtonGroup buttonGroup1;
    private JTextField categoryNameField;
    private JLabel categoryNameLbl;
    private JLabel displayNameLbl1;
    private JPanel dummyPanel;
    private JButton iconButton;
    private JTextField iconField;
    private JLabel iconLbl;
    private JLabel keywordsLabel;
    private JRadioButton optionsCategoryButton;
    private JLabel primKeywordsLabel;
    private JTextField primaryKwField;
    private JComboBox primaryPanelCombo;
    private JLabel primaryPanelComboLbl;
    private JTextField secondaryKwField;
    private JTextField secondaryPanelTitle;

    public OptionsPanel0(WizardDescriptor setting, NewOptionsIterator.DataModel data) {
        super(setting);
        this.data = data;
        this.initComponents();
        this.initAccessibility();
        this.putClientProperty("NewFileWizard_Title", NbBundle.getMessage(OptionsPanel0.class, (String)"LBL_OptionsWizardTitle"));
    }

    private String[] getPrimaryIdsFromLayer() {
        ArrayList<String> primaryIds = new ArrayList<String>();
        try {
            FileSystem layerFS = LayerUtils.getEffectiveSystemFilesystem(this.data.getProject());
            FileObject optionsDialogFO = layerFS.findResource("OptionsDialog");
            if (optionsDialogFO != null) {
                FileObject[] children = optionsDialogFO.getChildren();
                for (int i = 0; i < children.length; ++i) {
                    FileObject child = children[i];
                    if (child.isFolder()) continue;
                    primaryIds.add(child.getName());
                }
                Collections.sort(primaryIds);
            }
        }
        catch (IOException x) {
            Logger.getLogger(OptionsPanel0.class.getName()).log(Level.INFO, null, x);
        }
        primaryIds.remove("Advanced");
        primaryIds.add(0, "Advanced");
        return primaryIds.toArray(new String[primaryIds.size()]);
    }

    private void addListeners() {
        if (this.fieldsDL == null) {
            this.fieldsDL = new UIUtil.DocumentAdapter(){

                @Override
                public void insertUpdate(DocumentEvent e) {
                    OptionsPanel0.this.updateData();
                }
            };
            this.categoryNameField.getDocument().addDocumentListener(this.fieldsDL);
            this.secondaryPanelTitle.getDocument().addDocumentListener(this.fieldsDL);
            this.iconField.getDocument().addDocumentListener(this.fieldsDL);
            this.primaryKwField.getDocument().addDocumentListener(this.fieldsDL);
            this.secondaryKwField.getDocument().addDocumentListener(this.fieldsDL);
            if (this.primaryPanelCombo.getEditor().getEditorComponent() instanceof JTextField) {
                ((JTextField)this.primaryPanelCombo.getEditor().getEditorComponent()).getDocument().addDocumentListener(this.fieldsDL);
            }
        }
    }

    private void removeListeners() {
        if (this.fieldsDL != null) {
            this.categoryNameField.getDocument().removeDocumentListener(this.fieldsDL);
            this.secondaryPanelTitle.getDocument().removeDocumentListener(this.fieldsDL);
            this.iconField.getDocument().removeDocumentListener(this.fieldsDL);
            this.fieldsDL = null;
        }
    }

    @Override
    protected void storeToDataModel() {
        this.removeListeners();
        this.updateData();
    }

    @Override
    protected void readFromDataModel() {
        this.addListeners();
    }

    private boolean smallerThan110(String version) {
        String[] ver = version.split("\\.");
        return Integer.parseInt(ver[0]) <= 1 && Integer.parseInt(ver[1]) < 10;
    }

    private void updateData() {
        NbPlatform platform = LayerUtils.getPlatformForProject(this.data.getProject());
        if (this.smallerThan110(platform.getModule("org.netbeans.modules.options.api").getSpecificationVersion())) {
            this.setError(NbBundle.getMessage(OptionsPanel0.class, (String)"MSG_INVALID_PLATFORM"));
            return;
        }
        int retCode = 0;
        if (this.advancedButton.isSelected()) {
            assert (!this.optionsCategoryButton.isSelected());
            retCode = this.data.setDataForSecondaryPanel(this.primaryPanelCombo.getEditor().getItem().toString(), this.secondaryPanelTitle.getText(), this.secondaryKwField.getText());
        } else {
            String iconRel;
            assert (this.optionsCategoryButton.isSelected());
            File icon = new File(this.iconField.getText());
            FileObject iconFO = icon.isFile() ? FileUtil.toFileObject((File)FileUtil.normalizeFile((File)icon)) : null;
            String string = iconRel = iconFO != null ? FileUtil.getRelativePath((FileObject)Util.getResourceDirectory(this.data.getProject()), (FileObject)iconFO) : null;
            if (iconRel == null) {
                iconRel = this.data.getPackageName().replace('.', '/') + "/" + icon.getName();
            }
            retCode = this.data.setDataForPrimaryPanel(this.categoryNameField.getText(), iconRel, icon, this.allowSecondaryPanelsCheckBox.isSelected(), this.primaryKwField.getText());
        }
        String msg = this.data.getMessage(retCode);
        if (NewOptionsIterator.DataModel.isSuccessCode(retCode)) {
            this.markValid();
        } else if (NewOptionsIterator.DataModel.isErrorCode(retCode)) {
            this.setError(msg);
        } else if (NewOptionsIterator.DataModel.isWarningCode(retCode)) {
            this.setWarning(msg);
        } else if (NewOptionsIterator.DataModel.isInfoCode(retCode)) {
            this.setInfo(msg, false);
        } else assert (false) : retCode;
    }

    @Override
    protected String getPanelName() {
        return NbBundle.getMessage(OptionsPanel0.class, (String)"LBL_OptionsPanel0_Title");
    }

    @Override
    protected HelpCtx getHelp() {
        return new HelpCtx(OptionsPanel0.class);
    }

    private static String getMessage(String key) {
        return NbBundle.getMessage(OptionsPanel0.class, (String)key);
    }

    private void initAccessibility() {
        this.getAccessibleContext().setAccessibleDescription(OptionsPanel0.getMessage("ACS_OptionsPanel0"));
        this.advancedButton.getAccessibleContext().setAccessibleDescription(OptionsPanel0.getMessage("ACS_LBL_Advanced"));
        this.optionsCategoryButton.getAccessibleContext().setAccessibleDescription(OptionsPanel0.getMessage("ACS_LBL_OptionsCategory"));
        this.secondaryPanelTitle.getAccessibleContext().setAccessibleDescription(OptionsPanel0.getMessage("ACS_CTL_DisplayName"));
        this.categoryNameField.getAccessibleContext().setAccessibleDescription(OptionsPanel0.getMessage("ACS_CTL_CategoryName"));
        this.iconField.getAccessibleContext().setAccessibleDescription(OptionsPanel0.getMessage("ACS_CTL_IconPath"));
        this.iconButton.getAccessibleContext().setAccessibleDescription(OptionsPanel0.getMessage("ACS_CTL_IconButton"));
        this.allowSecondaryPanelsCheckBox.getAccessibleContext().setAccessibleDescription(OptionsPanel0.getMessage("ACS_CTL_AllowSecondaryPanels"));
        this.primaryPanelCombo.getAccessibleContext().setAccessibleDescription(OptionsPanel0.getMessage("ACS_CTL_PrimaryPanelCombo"));
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this.addListeners();
        this.updateData();
    }

    @Override
    public void removeNotify() {
        super.removeNotify();
        this.removeListeners();
    }

    private void enableDisable() {
        boolean advancedEnabled = this.advancedButton.isSelected();
        assert (advancedEnabled != this.optionsCategoryButton.isSelected());
        this.categoryNameField.setEnabled(!advancedEnabled);
        this.categoryNameLbl.setEnabled(!advancedEnabled);
        this.iconButton.setEnabled(!advancedEnabled);
        this.iconField.setEnabled(!advancedEnabled);
        this.iconLbl.setEnabled(!advancedEnabled);
        this.primaryKwField.setEnabled(!advancedEnabled);
        this.primKeywordsLabel.setEnabled(!advancedEnabled);
        this.allowSecondaryPanelsCheckBox.setEnabled(!advancedEnabled);
        this.primaryPanelComboLbl.setEnabled(advancedEnabled);
        this.primaryPanelCombo.setEnabled(advancedEnabled);
        this.secondaryPanelTitle.setEnabled(advancedEnabled);
        this.secondaryKwField.setEditable(advancedEnabled);
        this.keywordsLabel.setEnabled(advancedEnabled);
        this.displayNameLbl1.setEnabled(advancedEnabled);
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        this.advancedButton = new JRadioButton();
        this.optionsCategoryButton = new JRadioButton();
        this.dummyPanel = new JPanel();
        this.categoryNameLbl = new JLabel();
        this.categoryNameField = new JTextField();
        this.displayNameLbl1 = new JLabel();
        this.secondaryPanelTitle = new JTextField();
        this.iconLbl = new JLabel();
        this.iconField = new JTextField();
        this.iconButton = new JButton();
        this.allowSecondaryPanelsCheckBox = new JCheckBox();
        this.primaryPanelComboLbl = new JLabel();
        this.primaryPanelCombo = new JComboBox();
        this.keywordsLabel = new JLabel();
        this.primKeywordsLabel = new JLabel();
        this.secondaryKwField = new JTextField();
        this.primaryKwField = new JTextField();
        this.buttonGroup1.add(this.advancedButton);
        this.advancedButton.setSelected(true);
        ResourceBundle bundle = ResourceBundle.getBundle("org/netbeans/modules/apisupport/project/ui/wizard/options/Bundle");
        Mnemonics.setLocalizedText((AbstractButton)this.advancedButton, (String)bundle.getString("LBL_Advanced"));
        this.advancedButton.setMargin(new Insets(0, 0, 0, 0));
        this.advancedButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                OptionsPanel0.this.advancedButtonActionPerformed(evt);
            }
        });
        this.buttonGroup1.add(this.optionsCategoryButton);
        Mnemonics.setLocalizedText((AbstractButton)this.optionsCategoryButton, (String)bundle.getString("LBL_OptionsCategory"));
        this.optionsCategoryButton.setMargin(new Insets(0, 0, 0, 0));
        this.optionsCategoryButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                OptionsPanel0.this.optionsCategoryButtonActionPerformed(evt);
            }
        });
        this.categoryNameLbl.setLabelFor(this.categoryNameField);
        Mnemonics.setLocalizedText((JLabel)this.categoryNameLbl, (String)bundle.getString("LBL_CategoryName"));
        this.categoryNameLbl.setEnabled(false);
        this.categoryNameField.setEnabled(false);
        this.displayNameLbl1.setLabelFor(this.secondaryPanelTitle);
        Mnemonics.setLocalizedText((JLabel)this.displayNameLbl1, (String)bundle.getString("LBL_DisplaName"));
        this.iconLbl.setLabelFor(this.iconField);
        Mnemonics.setLocalizedText((JLabel)this.iconLbl, (String)NbBundle.getMessage(OptionsPanel0.class, (String)"LBL_Icon"));
        this.iconLbl.setEnabled(false);
        this.iconField.setEditable(false);
        this.iconField.setText(NbBundle.getMessage(OptionsPanel0.class, (String)"CTL_None"));
        this.iconField.setEnabled(false);
        Mnemonics.setLocalizedText((AbstractButton)this.iconButton, (String)NbBundle.getMessage(OptionsPanel0.class, (String)"LBL_Icon_Browse"));
        this.iconButton.setEnabled(false);
        this.iconButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                OptionsPanel0.this.iconButtonActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.allowSecondaryPanelsCheckBox, (String)NbBundle.getMessage(OptionsPanel0.class, (String)"LBL_AllowSecondaryPanels"));
        this.allowSecondaryPanelsCheckBox.setEnabled(false);
        this.allowSecondaryPanelsCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                OptionsPanel0.this.allowSecondaryPanelsCheckBoxActionPerformed(evt);
            }
        });
        this.primaryPanelComboLbl.setLabelFor(this.primaryPanelCombo);
        Mnemonics.setLocalizedText((JLabel)this.primaryPanelComboLbl, (String)NbBundle.getMessage(OptionsPanel0.class, (String)"LBL_PrimaryPanelCombo"));
        this.primaryPanelCombo.setEditable(true);
        this.primaryPanelCombo.setModel(new DefaultComboBoxModel<String>(this.getPrimaryIdsFromLayer()));
        this.primaryPanelCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                OptionsPanel0.this.primaryPanelComboActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((JLabel)this.keywordsLabel, (String)NbBundle.getMessage(OptionsPanel0.class, (String)"LBL_Keywords"));
        Mnemonics.setLocalizedText((JLabel)this.primKeywordsLabel, (String)NbBundle.getMessage(OptionsPanel0.class, (String)"LBL_Keywords"));
        this.primKeywordsLabel.setEnabled(false);
        this.secondaryKwField.setText(NbBundle.getMessage(OptionsPanel0.class, (String)"OptionsPanel0.secondaryKwField.text"));
        this.primaryKwField.setText(NbBundle.getMessage(OptionsPanel0.class, (String)"OptionsPanel0.primaryKwField.text"));
        this.primaryKwField.setEnabled(false);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.advancedButton, -2, 400, -2).addGap(98, 98, 98)).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.displayNameLbl1).addComponent(this.primaryPanelComboLbl).addComponent(this.keywordsLabel)).addGap(22, 22, 22).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.secondaryKwField, -1, 420, Short.MAX_VALUE).addComponent(this.primaryPanelCombo, 0, 420, Short.MAX_VALUE).addComponent(this.secondaryPanelTitle, -1, 420, Short.MAX_VALUE)).addGap(10, 10, 10)).addGroup(layout.createSequentialGroup().addGap(235, 235, 235).addComponent(this.dummyPanel, -2, -1, -2))).addContainerGap()).addGroup(layout.createSequentialGroup().addComponent(this.optionsCategoryButton, -2, 400, -2).addContainerGap()).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.categoryNameLbl).addComponent(this.iconLbl)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.iconField, -1, 304, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.iconButton).addGap(18, 18, 18)).addGroup(layout.createSequentialGroup().addComponent(this.categoryNameField, -1, 418, Short.MAX_VALUE).addContainerGap()))).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.primKeywordsLabel).addGap(49, 49, 49).addComponent(this.primaryKwField, -1, 425, Short.MAX_VALUE).addContainerGap()).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.allowSecondaryPanelsCheckBox, -2, 215, -2).addContainerGap(350, Short.MAX_VALUE)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.advancedButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.primaryPanelComboLbl).addComponent(this.primaryPanelCombo, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.displayNameLbl1).addComponent(this.secondaryPanelTitle, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.keywordsLabel).addComponent(this.secondaryKwField, -2, -1, -2)).addGap(18, 18, 18).addComponent(this.optionsCategoryButton).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.categoryNameLbl).addComponent(this.categoryNameField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.iconLbl).addComponent(this.iconField, -2, -1, -2).addComponent(this.iconButton)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.primKeywordsLabel).addComponent(this.primaryKwField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.allowSecondaryPanelsCheckBox).addGap(68, 68, 68).addComponent(this.dummyPanel, -2, -1, -2)));
        this.advancedButton.getAccessibleContext().setAccessibleDescription(OptionsPanel0.getMessage("OptionsPanel0.advancedButton.AccessibleContext.accessibleDescription"));
        this.optionsCategoryButton.getAccessibleContext().setAccessibleDescription(OptionsPanel0.getMessage("OptionsPanel0.optionsCategoryButton.AccessibleContext.accessibleDescription"));
        this.dummyPanel.getAccessibleContext().setAccessibleName(OptionsPanel0.getMessage("OptionsPanel0.dummyPanel.AccessibleContext.accessibleName"));
        this.dummyPanel.getAccessibleContext().setAccessibleDescription(OptionsPanel0.getMessage("OptionsPanel0.dummyPanel.AccessibleContext.accessibleDescription"));
        this.categoryNameLbl.getAccessibleContext().setAccessibleDescription(OptionsPanel0.getMessage("OptionsPanel0.categoryNameLbl.AccessibleContext.accessibleDescription"));
        this.categoryNameField.getAccessibleContext().setAccessibleName(OptionsPanel0.getMessage("OptionsPanel0.categoryNameField.AccessibleContext.accessibleName"));
        this.categoryNameField.getAccessibleContext().setAccessibleDescription(OptionsPanel0.getMessage("OptionsPanel0.categoryNameField.AccessibleContext.accessibleDescription"));
        this.displayNameLbl1.getAccessibleContext().setAccessibleDescription(OptionsPanel0.getMessage("OptionsPanel0.displayNameLbl1.AccessibleContext.accessibleDescription"));
        this.secondaryPanelTitle.getAccessibleContext().setAccessibleName(OptionsPanel0.getMessage("OptionsPanel0.displayNameField1.AccessibleContext.accessibleName"));
        this.secondaryPanelTitle.getAccessibleContext().setAccessibleDescription(OptionsPanel0.getMessage("OptionsPanel0.displayNameField1.AccessibleContext.accessibleDescription"));
        this.iconLbl.getAccessibleContext().setAccessibleDescription(OptionsPanel0.getMessage("OptionsPanel0.iconLbl.AccessibleContext.accessibleDescription"));
        this.iconField.getAccessibleContext().setAccessibleName(OptionsPanel0.getMessage("OptionsPanel0.iconField.AccessibleContext.accessibleName"));
        this.iconField.getAccessibleContext().setAccessibleDescription(OptionsPanel0.getMessage("OptionsPanel0.iconField.AccessibleContext.accessibleDescription"));
        this.iconButton.getAccessibleContext().setAccessibleDescription(OptionsPanel0.getMessage("OptionsPanel0.iconButton.AccessibleContext.accessibleDescription"));
        this.allowSecondaryPanelsCheckBox.getAccessibleContext().setAccessibleDescription(OptionsPanel0.getMessage("OptionsPanel0.allowSecondaryPanelsCheckBox.AccessibleContext.accessibleDescription"));
        this.primaryPanelComboLbl.getAccessibleContext().setAccessibleDescription(OptionsPanel0.getMessage("OptionsPanel0.primaryPanelComboLbl.AccessibleContext.accessibleDescription"));
        this.primaryPanelCombo.getAccessibleContext().setAccessibleName(OptionsPanel0.getMessage("OptionsPanel0.primaryPanelCombo.AccessibleContext.accessibleName"));
        this.primaryPanelCombo.getAccessibleContext().setAccessibleDescription(OptionsPanel0.getMessage("OptionsPanel0.primaryPanelCombo.AccessibleContext.accessibleDescription"));
        this.getAccessibleContext().setAccessibleName(OptionsPanel0.getMessage("OptionsPanel0.AccessibleContext.accessibleName"));
        this.getAccessibleContext().setAccessibleDescription(OptionsPanel0.getMessage("OptionsPanel0.AccessibleContext.accessibleDescription"));
    }

    private void optionsCategoryButtonActionPerformed(ActionEvent evt) {
        this.enableDisable();
        this.updateData();
    }

    private void advancedButtonActionPerformed(ActionEvent evt) {
        this.enableDisable();
        this.updateData();
    }

    private void iconButtonActionPerformed(ActionEvent evt) {
        JFileChooser chooser = UIUtil.getIconFileChooser(this.iconField.getText());
        int ret = chooser.showDialog(this, OptionsPanel0.getMessage("LBL_Select"));
        if (ret == 0) {
            this.iconField.setText(chooser.getSelectedFile().getAbsolutePath());
            this.updateData();
        }
    }

    private void allowSecondaryPanelsCheckBoxActionPerformed(ActionEvent evt) {
        this.updateData();
    }

    private void primaryPanelComboActionPerformed(ActionEvent evt) {
        this.updateData();
    }
}

