/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.apisupport.project.ui.wizard;

import java.awt.Component;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ui.OpenProjects;
import org.netbeans.modules.apisupport.project.NbModuleProjectGenerator;
import org.netbeans.modules.apisupport.project.suite.SuiteProject;
import org.netbeans.modules.apisupport.project.suite.SuiteProjectGenerator;
import org.netbeans.modules.apisupport.project.ui.ModuleUISettings;
import org.netbeans.modules.apisupport.project.ui.UIUtil;
import org.netbeans.modules.apisupport.project.ui.customizer.SuiteUtils;
import org.netbeans.modules.apisupport.project.ui.wizard.BasicConfWizardPanel;
import org.netbeans.modules.apisupport.project.ui.wizard.BasicInfoWizardPanel;
import org.netbeans.modules.apisupport.project.ui.wizard.LibraryConfWizardPanel;
import org.netbeans.modules.apisupport.project.ui.wizard.LibraryStartVisualPanel;
import org.netbeans.modules.apisupport.project.ui.wizard.LibraryStartWizardPanel;
import org.netbeans.modules.apisupport.project.ui.wizard.NewModuleProjectData;
import org.netbeans.spi.project.ui.templates.support.Templates;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;

public class NewNbModuleWizardIterator
implements WizardDescriptor.AsynchronousInstantiatingIterator<WizardDescriptor> {
    static final String PREFERRED_SUITE_DIR = "preferredSuiteDir";
    static final String ONE_SUITE_DEDICATED_MODE = "oneSuiteDedicatedMode";
    private final NewModuleProjectData data;
    private int position;
    private List<WizardDescriptor.Panel<WizardDescriptor>> panels;
    private FileObject createdProjectFolder;
    private String preferredSuiteDir;
    private Boolean suiteDedicated = Boolean.FALSE;

    private NewNbModuleWizardIterator(Type type) {
        this.data = new NewModuleProjectData(type);
    }

    public static NewNbModuleWizardIterator createModuleIterator(Map m) {
        return new NewNbModuleWizardIterator(Type.MODULE);
    }

    public static NewNbModuleWizardIterator createSuiteComponentIterator(SuiteProject suite) {
        NewNbModuleWizardIterator iterator = new NewNbModuleWizardIterator(Type.SUITE_COMPONENT);
        iterator.preferredSuiteDir = suite.getProjectDirectoryFile().getAbsolutePath();
        iterator.suiteDedicated = Boolean.TRUE;
        return iterator;
    }

    public static NewNbModuleWizardIterator createSuiteIterator() {
        return new NewNbModuleWizardIterator(Type.SUITE);
    }

    public static NewNbModuleWizardIterator createApplicationIterator() {
        return new NewNbModuleWizardIterator(Type.APPLICATION);
    }

    public static NewNbModuleWizardIterator createLibraryModuleIterator(Project project) {
        NewNbModuleWizardIterator iterator = new NewNbModuleWizardIterator(Type.LIBRARY_MODULE);
        iterator.preferredSuiteDir = SuiteUtils.getSuiteDirectoryPath(project);
        assert (iterator.preferredSuiteDir != null) : project + " does not have a SuiteProvider in its lookup?";
        iterator.suiteDedicated = Boolean.TRUE;
        return iterator;
    }

    public static NewNbModuleWizardIterator createLibraryModuleIterator() {
        return new NewNbModuleWizardIterator(Type.LIBRARY_MODULE);
    }

    static boolean isSuiteWizard(Type type) {
        return type == Type.SUITE || type == Type.APPLICATION;
    }

    static boolean isSuiteComponentWizard(Type type) {
        return type == Type.SUITE_COMPONENT;
    }

    static boolean isLibraryWizard(Type type) {
        return type == Type.LIBRARY_MODULE;
    }

    public FileObject getCreateProjectFolder() {
        return this.createdProjectFolder;
    }

    public Set instantiate() throws IOException {
        File projectFolder = new File(this.data.getProjectFolder());
        ModuleUISettings.getDefault().setLastUsedPlatformID(this.data.getPlatformID());
        WizardDescriptor settings = this.data.getSettings();
        switch (this.data.getWizardType()) {
            case SUITE: {
                ModuleUISettings.getDefault().setNewSuiteCounter(this.data.getSuiteCounter());
                SuiteProjectGenerator.createSuiteProject(projectFolder, this.data.getPlatformID(), false);
                break;
            }
            case APPLICATION: {
                ModuleUISettings.getDefault().setNewSuiteCounter(this.data.getSuiteCounter());
                SuiteProjectGenerator.createSuiteProject(projectFolder, this.data.getPlatformID(), true);
                break;
            }
            case MODULE: 
            case SUITE_COMPONENT: {
                ModuleUISettings.getDefault().setNewModuleCounter(this.data.getModuleCounter());
                if (this.data.isNetBeansOrg()) {
                    NbModuleProjectGenerator.createNetBeansOrgModule(projectFolder, this.data.getCodeNameBase(), this.data.getProjectDisplayName(), this.data.getBundle(), this.data.getLayer(), this.data.isOSGi());
                    break;
                }
                if (this.data.isStandalone()) {
                    NbModuleProjectGenerator.createStandAloneModule(projectFolder, this.data.getCodeNameBase(), this.data.getProjectDisplayName(), this.data.getBundle(), this.data.getLayer(), this.data.getPlatformID(), this.data.isOSGi());
                    break;
                }
                NbModuleProjectGenerator.createSuiteComponentModule(projectFolder, this.data.getCodeNameBase(), this.data.getProjectDisplayName(), this.data.getBundle(), this.data.getLayer(), new File(this.data.getSuiteRoot()), this.data.isOSGi());
                break;
            }
            case LIBRARY_MODULE: {
                File[] jars = LibraryStartVisualPanel.convertStringToFiles((String)settings.getProperty("LIBRARY_PATH_VALUE"));
                File license = null;
                String licPath = (String)settings.getProperty("LICENSE_PATH_VALUE");
                if (licPath != null && licPath.length() > 0) {
                    license = new File(licPath);
                }
                NbModuleProjectGenerator.createSuiteLibraryModule(projectFolder, this.data.getCodeNameBase(), this.data.getProjectDisplayName(), this.data.getBundle(), new File(this.data.getSuiteRoot()), license, jars);
                break;
            }
            default: {
                throw new IllegalStateException("Uknown wizard type: " + (Object)((Object)this.data.getWizardType()));
            }
        }
        this.createdProjectFolder = FileUtil.toFileObject((File)FileUtil.normalizeFile((File)projectFolder));
        HashSet<FileObject> resultSet = new HashSet<FileObject>();
        resultSet.add(this.createdProjectFolder);
        if (!projectFolder.getParent().equals(this.data.getSuiteRoot())) {
            UIUtil.setProjectChooserDirParent(projectFolder);
        }
        Templates.setDefinesMainProject((WizardDescriptor)settings, (boolean)this.data.isMainProject());
        return resultSet;
    }

    public void initialize(WizardDescriptor wiz) {
        Project mainPrj;
        this.data.setSettings(wiz);
        if (this.preferredSuiteDir == null && (mainPrj = OpenProjects.getDefault().getMainProject()) != null) {
            this.preferredSuiteDir = SuiteUtils.getSuiteDirectoryPath(mainPrj);
        }
        if (this.preferredSuiteDir != null) {
            wiz.putProperty(PREFERRED_SUITE_DIR, (Object)this.preferredSuiteDir);
            wiz.putProperty(ONE_SUITE_DEDICATED_MODE, (Object)this.suiteDedicated);
        }
        this.position = 0;
        String[] steps = null;
        switch (this.data.getWizardType()) {
            case MODULE: 
            case SUITE_COMPONENT: {
                steps = this.initModuleWizard();
                break;
            }
            case SUITE: 
            case APPLICATION: {
                steps = this.initSuiteModuleWizard();
                break;
            }
            case LIBRARY_MODULE: {
                steps = this.initLibraryModuleWizard();
                break;
            }
            default: {
                assert (false) : "Should never get here. type: " + (Object)((Object)this.data.getWizardType());
                break;
            }
        }
        for (int i = 0; i < this.panels.size(); ++i) {
            Component c = this.panels.get(i).getComponent();
            if (!(c instanceof JComponent)) continue;
            JComponent jc = (JComponent)c;
            jc.putClientProperty("WizardPanel_contentSelectedIndex", new Integer(i));
            jc.putClientProperty("WizardPanel_contentData", steps);
            jc.putClientProperty("WizardPanel_autoWizardStyle", Boolean.TRUE);
            jc.putClientProperty("WizardPanel_contentDisplayed", Boolean.TRUE);
            jc.putClientProperty("WizardPanel_contentNumbered", Boolean.TRUE);
        }
    }

    public void uninitialize(WizardDescriptor wiz) {
        this.panels = null;
    }

    private String[] initModuleWizard() {
        this.panels = new ArrayList<WizardDescriptor.Panel<WizardDescriptor>>();
        this.panels.add(new BasicInfoWizardPanel(this.data));
        this.panels.add(new BasicConfWizardPanel(this.data));
        String[] steps = new String[]{NewNbModuleWizardIterator.getMessage("LBL_BasicInfoPanel_Title"), NewNbModuleWizardIterator.getMessage("LBL_BasicConfigPanel_Title")};
        return steps;
    }

    private String[] initSuiteModuleWizard() {
        this.panels = new ArrayList<WizardDescriptor.Panel<WizardDescriptor>>();
        this.panels.add(new BasicInfoWizardPanel(this.data));
        String[] steps = new String[]{NewNbModuleWizardIterator.getMessage("LBL_BasicInfoPanel_Title")};
        return steps;
    }

    private String[] initLibraryModuleWizard() {
        this.panels = new ArrayList<WizardDescriptor.Panel<WizardDescriptor>>();
        this.panels.add(new LibraryStartWizardPanel(this.data));
        this.panels.add(new BasicInfoWizardPanel(this.data));
        this.panels.add(new LibraryConfWizardPanel(this.data));
        String[] steps = new String[]{NewNbModuleWizardIterator.getMessage("LBL_LibraryStartPanel_Title"), NewNbModuleWizardIterator.getMessage("LBL_BasicInfoPanel_Title"), NewNbModuleWizardIterator.getMessage("LBL_PlatformSelectionPanel_Title")};
        return steps;
    }

    public String name() {
        return "";
    }

    public boolean hasNext() {
        return this.position < this.panels.size() - 1;
    }

    public boolean hasPrevious() {
        return this.position > 0;
    }

    public void nextPanel() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        ++this.position;
    }

    public void previousPanel() {
        if (!this.hasPrevious()) {
            throw new NoSuchElementException();
        }
        --this.position;
    }

    public WizardDescriptor.Panel<WizardDescriptor> current() {
        return this.panels.get(this.position);
    }

    static String getMessage(String key) {
        return NbBundle.getMessage(NewNbModuleWizardIterator.class, (String)key);
    }

    public final void addChangeListener(ChangeListener l) {
    }

    public final void removeChangeListener(ChangeListener l) {
    }

    static enum Type {
        MODULE,
        SUITE,
        APPLICATION,
        LIBRARY_MODULE,
        SUITE_COMPONENT;

    }
}

