/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.properties;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.WeakHashMap;
import javax.swing.SwingUtilities;
import org.netbeans.modules.vmd.api.io.ActiveViewSupport;
import org.netbeans.modules.vmd.api.io.DataEditorView;
import org.netbeans.modules.vmd.api.io.DataObjectContext;
import org.netbeans.modules.vmd.api.io.DesignDocumentAwareness;
import org.netbeans.modules.vmd.api.io.ProjectUtils;
import org.netbeans.modules.vmd.api.model.DesignComponent;
import org.netbeans.modules.vmd.api.model.DesignDocument;
import org.netbeans.modules.vmd.api.model.DesignEvent;
import org.netbeans.modules.vmd.api.model.DesignEventFilter;
import org.netbeans.modules.vmd.api.model.DesignListener;
import org.netbeans.modules.vmd.api.model.common.ActiveDocumentSupport;
import org.netbeans.modules.vmd.api.properties.DesignPropertyDescriptor;
import org.netbeans.modules.vmd.api.properties.DesignPropertyEditor;
import org.netbeans.modules.vmd.api.properties.GroupPropertyEditor;
import org.netbeans.modules.vmd.api.properties.PropertiesPresenter;
import org.netbeans.modules.vmd.properties.AdvancedPropertySupport;
import org.netbeans.modules.vmd.properties.DefaultPropertySupport;
import org.netbeans.modules.vmd.properties.PrimitivePropertySupport;
import org.netbeans.modules.vmd.properties.PropertiesNode;
import org.openide.nodes.Node;
import org.openide.nodes.Sheet;
import org.openide.util.WeakSet;
import org.openide.util.lookup.InstanceContent;

public final class PropertiesNodesManager
implements DesignDocumentAwareness,
DesignListener,
ActiveDocumentSupport.Listener,
ActiveViewSupport.Listener {
    private static final WeakHashMap<DataEditorView, PropertiesNodesManager> INSTANCES = new WeakHashMap();
    private static Comparator<DesignPropertyDescriptor> compareByDisplayName = new Comparator<DesignPropertyDescriptor>(){

        @Override
        public int compare(DesignPropertyDescriptor descriptor1, DesignPropertyDescriptor descriptor2) {
            return descriptor1.getPropertyDisplayName().compareTo(descriptor2.getPropertyDisplayName());
        }
    };
    private WeakHashMap<DataEditorView, InstanceContent> icMap;
    private Collection<InstanceContent> ics;
    private WeakHashMap<InstanceContent, WeakSet<Node>> nodesToRemoveMap;
    private DataEditorView view;
    private DesignDocument document;
    private WeakHashMap<DesignComponent, WeakSet<DefaultPropertySupport>> propertySupportMap;
    private WeakHashMap<DesignComponent, Sheet> sheetMap;
    private WeakHashMap<DesignComponent, PropertiesNode> nodesMap;

    public static synchronized PropertiesNodesManager getInstance(DataEditorView view) {
        assert (view != null);
        if (INSTANCES.get(view) == null) {
            PropertiesNodesManager manager = new PropertiesNodesManager(view);
            INSTANCES.put(view, manager);
        }
        return INSTANCES.get(view);
    }

    private PropertiesNodesManager(DataEditorView view) {
        view.getContext().addDesignDocumentAwareness((DesignDocumentAwareness)this);
        this.nodesToRemoveMap = new WeakHashMap();
        this.view = view;
        this.icMap = new WeakHashMap();
        this.ics = new HashSet<InstanceContent>();
        this.propertySupportMap = new WeakHashMap();
        this.sheetMap = new WeakHashMap();
        this.nodesMap = new WeakHashMap();
    }

    public void setDesignDocument(DesignDocument document) {
        if (document != null) {
            this.document = document;
            document.getListenerManager().addDesignListener((DesignListener)this, new DesignEventFilter(new DesignEventFilter[0]).setGlobal(true));
            ActiveDocumentSupport.getDefault().addActiveDocumentListener((ActiveDocumentSupport.Listener)this);
            ActiveViewSupport.getDefault().addActiveViewListener((ActiveViewSupport.Listener)this);
        } else if (this.document != null) {
            ActiveDocumentSupport.getDefault().removeActiveDocumentListener((ActiveDocumentSupport.Listener)this);
            ActiveViewSupport.getDefault().removeActiveViewListener((ActiveViewSupport.Listener)this);
            this.document.getListenerManager().removeDesignListener((DesignListener)this);
            this.document.getTransactionManager().readAccess(new Runnable(){

                @Override
                public void run() {
                    DesignComponent root = PropertiesNodesManager.this.document.getRootComponent();
                    for (DesignComponent c : root.getComponents()) {
                        PropertiesNodesManager.this.cleanUpAll(c);
                    }
                }
            });
            this.document = null;
            this.view = null;
            this.propertySupportMap = null;
            this.sheetMap = null;
            this.nodesMap = null;
        }
    }

    private void cleanUpAll(DesignComponent parent) {
        for (final DesignComponent c : parent.getComponents()) {
            Collection presenters = c.getPresenters(PropertiesPresenter.class);
            for (PropertiesPresenter p : presenters) {
                for (final DesignPropertyDescriptor pd : p.getDesignPropertyDescriptors()) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            pd.getPropertyEditor().cleanUp(c);
                        }
                    });
                }
            }
            this.cleanUpAll(c);
        }
    }

    public void designChanged(DesignEvent event) {
        WeakSet selectedComponents = new WeakSet(this.document.getSelectedComponents());
        if (event.isSelectionChanged()) {
            this.repaintPropertiesWindow((Collection<DesignComponent>)selectedComponents);
        }
        if (event.isStructureChanged()) {
            SwingUtilities.invokeLater(new Runnable((Collection)selectedComponents){
                final /* synthetic */ Collection val$selectedComponents;
                {
                    this.val$selectedComponents = collection;
                }

                @Override
                public void run() {
                    if (PropertiesNodesManager.this.document == null) {
                        return;
                    }
                    DataObjectContext context = ProjectUtils.getDataObjectContextForDocument((DesignDocument)PropertiesNodesManager.this.document);
                    if (context == null) {
                        return;
                    }
                    PropertiesNodesManager.this.updatePropertyEditorsValues(this.val$selectedComponents);
                    PropertiesNodesManager.this.updateSheet(this.val$selectedComponents);
                }
            });
        }
    }

    public void activeDocumentChanged(DesignDocument deactivatedDocument, DesignDocument activatedDocument) {
        if (this.document == null) {
            return;
        }
        if (activatedDocument == null) {
            this.document.getTransactionManager().readAccess(new Runnable(){

                @Override
                public void run() {
                    PropertiesNodesManager.this.repaintPropertiesWindow(Collections.EMPTY_LIST);
                }
            });
        }
        if (this.document != activatedDocument) {
            return;
        }
        this.document.getTransactionManager().readAccess(new Runnable(){

            @Override
            public void run() {
                PropertiesNodesManager.this.repaintPropertiesWindow(PropertiesNodesManager.this.document.getSelectedComponents());
            }
        });
    }

    public void activeComponentsChanged(Collection<DesignComponent> activeComponents) {
    }

    public void activeViewChanged(DataEditorView deactivatedView, DataEditorView activatedView) {
        if (this.document == null) {
            return;
        }
        if (activatedView != null && this.view.getContext() == activatedView.getContext() && activatedView.getKind() == DataEditorView.Kind.MODEL) {
            this.document.getTransactionManager().readAccess(new Runnable(){

                @Override
                public void run() {
                    PropertiesNodesManager.this.repaintPropertiesWindow(PropertiesNodesManager.this.document.getSelectedComponents());
                }
            });
        } else if (deactivatedView != null && deactivatedView.getKind() == DataEditorView.Kind.MODEL) {
            this.document.getTransactionManager().readAccess(new Runnable(){

                @Override
                public void run() {
                    PropertiesNodesManager.this.repaintPropertiesWindow(Collections.EMPTY_SET);
                }
            });
        }
    }

    public void add(InstanceContent ic) {
        assert (ic != null);
        this.ics.add(ic);
    }

    public void add(DataEditorView view, InstanceContent ic) {
        assert (ic != null);
        this.icMap.put(view, ic);
    }

    private void changeLookup(Collection<DesignComponent> components) {
        Object nodesToRemove;
        if (components == null) {
            return;
        }
        HashSet<InstanceContent> tempIcs = new HashSet<InstanceContent>();
        tempIcs.addAll(this.ics);
        if (this.icMap.get(this.view) != null) {
            tempIcs.add(this.icMap.get(this.view));
        }
        for (InstanceContent ic : tempIcs) {
            nodesToRemove = this.nodesToRemoveMap.get(ic);
            if (nodesToRemove == null) {
                nodesToRemove = new WeakSet();
                this.nodesToRemoveMap.put(ic, (WeakSet<Node>)nodesToRemove);
            }
            ic.set((Collection)Collections.EMPTY_SET, (InstanceContent.Convertor)new PropertiesNodeConverter());
            nodesToRemove.clear();
        }
        if (components.isEmpty()) {
            for (InstanceContent ic : tempIcs) {
                ic.set(Collections.singleton(Node.EMPTY), (InstanceContent.Convertor)new PropertiesNodeConverter());
            }
        }
        for (InstanceContent ic : tempIcs) {
            nodesToRemove = (Set)this.nodesToRemoveMap.get(ic);
            for (DesignComponent component : components) {
                PropertiesNode node = this.nodesMap.get(component);
                if (node == null) {
                    node = new PropertiesNode(this.view, component);
                    this.nodesMap.put(component, node);
                }
                nodesToRemove.add(node);
            }
            if (nodesToRemove == null || nodesToRemove.isEmpty()) continue;
            ic.set((Collection)nodesToRemove, (InstanceContent.Convertor)new PropertiesNodeConverter());
        }
    }

    public synchronized Sheet getSheet(DesignComponent component) {
        assert (component != null);
        if (this.sheetMap == null) {
            return null;
        }
        if (this.sheetMap.get(component) == null) {
            this.sheetMap.put(component, this.createSheet(component));
        }
        return this.sheetMap.get(component);
    }

    public Sheet createSheet(final DesignComponent component) {
        final Sheet sheet = new Sheet();
        component.getDocument().getTransactionManager().readAccess(new Runnable(){

            @Override
            public void run() {
                ArrayList<DesignPropertyDescriptor> designerPropertyDescriptors = new ArrayList<DesignPropertyDescriptor>();
                ArrayList<String> categories = new ArrayList<String>();
                for (PropertiesPresenter propertiesPresenter : component.getPresenters(PropertiesPresenter.class)) {
                    designerPropertyDescriptors.addAll(propertiesPresenter.getDesignPropertyDescriptors());
                    categories.addAll(propertiesPresenter.getPropertiesCategories());
                }
                if (designerPropertyDescriptors != null) {
                    Collections.sort(designerPropertyDescriptors, compareByDisplayName);
                }
                PropertiesNodesManager.this.createCategoriesSet(sheet, categories);
                for (DesignPropertyDescriptor designerPropertyDescriptor : designerPropertyDescriptors) {
                    DefaultPropertySupport property;
                    DesignPropertyEditor propertyEditor = designerPropertyDescriptor.getPropertyEditor();
                    if (propertyEditor instanceof GroupPropertyEditor && designerPropertyDescriptor.getPropertyNames().size() == 0) {
                        throw new IllegalStateException("To use AdvancedPropertyEditorSupport you need to specific at least one propertyName");
                    }
                    if (propertyEditor instanceof GroupPropertyEditor) {
                        property = new AdvancedPropertySupport(designerPropertyDescriptor, designerPropertyDescriptor.getPropertyEditorType());
                        PropertiesNodesManager.this.addPropertySupport(component, property);
                    } else if (designerPropertyDescriptor.getPropertyNames().size() <= 1) {
                        property = new PrimitivePropertySupport(designerPropertyDescriptor, designerPropertyDescriptor.getPropertyEditorType());
                        PropertiesNodesManager.this.addPropertySupport(component, property);
                    } else {
                        throw new IllegalArgumentException();
                    }
                    if (propertyEditor != null && propertyEditor.canEditAsText() != null) {
                        property.setValue("canEditAsText", propertyEditor.canEditAsText());
                    }
                    property.setValue("changeImmediate", false);
                    sheet.get(designerPropertyDescriptor.getPropertyCategory()).put((Node.Property)property);
                }
            }
        });
        return sheet;
    }

    public void updateSheet(Collection<DesignComponent> components) {
        if (components == null || components.isEmpty()) {
            return;
        }
        for (DesignComponent component : components) {
            Sheet sheet = this.sheetMap.get(component);
            if (sheet == null) continue;
            for (Node.PropertySet set : sheet.toArray()) {
                for (Node.Property property : set.getProperties()) {
                    if (!(property instanceof DefaultPropertySupport)) continue;
                    ((DefaultPropertySupport)property).update();
                }
            }
        }
    }

    private void addPropertySupport(DesignComponent component, DefaultPropertySupport propertySupport) {
        WeakSet propertySupports = this.propertySupportMap.get(component);
        if (propertySupports == null) {
            propertySupports = new WeakSet();
            this.propertySupportMap.put(component, (WeakSet<DefaultPropertySupport>)propertySupports);
        }
        propertySupports.add((Object)propertySupport);
    }

    private void updatePropertyEditorsValues(Collection<DesignComponent> components) {
        if (components == null) {
            return;
        }
        HashSet<InstanceContent> tempIcs = new HashSet<InstanceContent>();
        tempIcs.addAll(this.ics);
        if (this.icMap.get(this.view) != null) {
            tempIcs.add(this.icMap.get(this.view));
        }
        for (InstanceContent ic : tempIcs) {
            WeakSet<Node> nodesToRemove = this.nodesToRemoveMap.get(ic);
            if (nodesToRemove == null) continue;
            for (Node node : nodesToRemove) {
                PropertiesNode pn = (PropertiesNode)node;
                pn.updateNode(this.getSheet(pn.getComponent()));
            }
        }
    }

    private void repaintPropertiesWindow(final Collection<DesignComponent> selectedComponents) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (PropertiesNodesManager.this.view != null) {
                    PropertiesNodesManager.this.changeLookup(selectedComponents);
                    PropertiesNodesManager.this.updateSheet(selectedComponents);
                }
            }
        });
    }

    private synchronized void createCategoriesSet(Sheet sheet, List<String> categories) {
        for (String propertyCategory : categories) {
            sheet.put(this.createPropertiesSet(propertyCategory));
        }
    }

    private synchronized Sheet.Set createPropertiesSet(String categoryName) {
        Sheet.Set setSheet = new Sheet.Set();
        setSheet.setName(categoryName);
        setSheet.setDisplayName(categoryName);
        return setSheet;
    }

    private class PropertiesNodeConverter
    implements InstanceContent.Convertor {
        private PropertiesNodeConverter() {
        }

        public Object convert(Object object) {
            return object;
        }

        public Class type(Object object) {
            return object.getClass();
        }

        public String id(Object object) {
            return object.toString();
        }

        public String displayName(Object object) {
            return object.toString();
        }
    }
}

