/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.hibernate.refactoring;

import com.sun.source.tree.Tree;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.TypeElement;
import org.netbeans.api.fileinfo.NonRecursiveFolder;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.ElementUtilities;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.java.source.TreePathHandle;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.hibernate.refactoring.HibernateMappingRenameTransaction;
import org.netbeans.modules.hibernate.refactoring.HibernateRefactoringUtil;
import org.netbeans.modules.hibernate.refactoring.HibernateRenameRefactoringElement;
import org.netbeans.modules.hibernate.refactoring.JavaClassRenameTransaction;
import org.netbeans.modules.hibernate.refactoring.JavaFieldRenameTransaction;
import org.netbeans.modules.hibernate.refactoring.JavaPackageRenameTransaction;
import org.netbeans.modules.hibernate.service.api.HibernateEnvironment;
import org.netbeans.modules.refactoring.api.AbstractRefactoring;
import org.netbeans.modules.refactoring.api.Problem;
import org.netbeans.modules.refactoring.api.RenameRefactoring;
import org.netbeans.modules.refactoring.spi.RefactoringElementImplementation;
import org.netbeans.modules.refactoring.spi.RefactoringElementsBag;
import org.netbeans.modules.refactoring.spi.RefactoringPlugin;
import org.netbeans.modules.refactoring.spi.Transaction;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;

public class HibernateRenamePlugin
implements RefactoringPlugin {
    private RenameRefactoring refactoring;
    private List<FileObject> mFileObjs;

    public HibernateRenamePlugin(RenameRefactoring renameRefactoring) {
        this.refactoring = renameRefactoring;
    }

    public Problem preCheck() {
        return null;
    }

    public Problem checkParameters() {
        return null;
    }

    public Problem fastCheckParameters() {
        return null;
    }

    public void cancelRequest() {
    }

    public Problem prepare(RefactoringElementsBag refactoringElementsBag) {
        Project project;
        TreePathHandle treePathHandle = (TreePathHandle)this.refactoring.getRefactoringSource().lookup(TreePathHandle.class);
        FileObject fileObject = null;
        if (treePathHandle != null && (treePathHandle.getKind() == Tree.Kind.CLASS || treePathHandle.getKind() == Tree.Kind.VARIABLE || treePathHandle.getKind() == Tree.Kind.MEMBER_SELECT || treePathHandle.getKind() == Tree.Kind.IDENTIFIER)) {
            fileObject = treePathHandle.getFileObject();
        }
        if (fileObject == null) {
            fileObject = (FileObject)this.refactoring.getRefactoringSource().lookup(FileObject.class);
        }
        boolean bl = true;
        if (fileObject == null && (project = (NonRecursiveFolder)this.refactoring.getRefactoringSource().lookup(NonRecursiveFolder.class)) != null) {
            bl = false;
            fileObject = project.getFolder();
        }
        if (fileObject == null) {
            return null;
        }
        project = FileOwnerQuery.getOwner((FileObject)fileObject);
        HibernateEnvironment hibernateEnvironment = (HibernateEnvironment)project.getLookup().lookup(HibernateEnvironment.class);
        if (hibernateEnvironment == null) {
            return null;
        }
        this.mFileObjs = hibernateEnvironment.getAllHibernateMappingFileObjects();
        if (this.mFileObjs == null || this.mFileObjs.size() == 0) {
            return null;
        }
        try {
            if (treePathHandle != null) {
                if (treePathHandle.getKind() == Tree.Kind.CLASS) {
                    this.renameJavaClass(refactoringElementsBag, treePathHandle, fileObject);
                } else if (treePathHandle.getKind() == Tree.Kind.VARIABLE || treePathHandle.getKind() == Tree.Kind.MEMBER_SELECT || treePathHandle.getKind() == Tree.Kind.IDENTIFIER) {
                    this.renameJavaField(refactoringElementsBag, treePathHandle, fileObject);
                }
            } else if (fileObject.isFolder()) {
                this.renameJavaPackage(refactoringElementsBag, treePathHandle, fileObject, bl);
            }
        }
        catch (IOException iOException) {
            ErrorManager.getDefault().notify(1, (Throwable)iOException);
        }
        return null;
    }

    private void renameJavaClass(RefactoringElementsBag refactoringElementsBag, TreePathHandle treePathHandle, FileObject fileObject) throws IOException {
        HibernateRefactoringUtil.RenamedClassName renamedClassName = null;
        JavaSource javaSource = JavaSource.forFileObject((FileObject)fileObject);
        if (javaSource != null) {
            renamedClassName = HibernateRefactoringUtil.getRenamedClassName(treePathHandle, javaSource, this.refactoring.getNewName());
        }
        if (renamedClassName != null) {
            String string = renamedClassName.getOldBinaryName();
            String string2 = renamedClassName.getNewBinaryName();
            if (string != null && string2 != null) {
                Map<FileObject, List<HibernateRefactoringUtil.OccurrenceItem>> map = HibernateRefactoringUtil.getJavaClassOccurrences(this.mFileObjs, string);
                for (FileObject fileObject2 : map.keySet()) {
                    List<HibernateRefactoringUtil.OccurrenceItem> list = map.get(fileObject2);
                    for (HibernateRefactoringUtil.OccurrenceItem occurrenceItem : list) {
                        HibernateRenameRefactoringElement hibernateRenameRefactoringElement = new HibernateRenameRefactoringElement(fileObject2, string, string2, occurrenceItem.getLocation(), occurrenceItem.getText());
                        refactoringElementsBag.add((AbstractRefactoring)this.refactoring, (RefactoringElementImplementation)hibernateRenameRefactoringElement);
                    }
                }
                refactoringElementsBag.registerTransaction((Transaction)new JavaClassRenameTransaction(map.keySet(), string, string2));
            }
        }
    }

    private void renameJavaField(RefactoringElementsBag refactoringElementsBag, final TreePathHandle treePathHandle, FileObject fileObject) throws IOException {
        final String[] stringArray = new String[]{null, null};
        JavaSource javaSource = JavaSource.forFileObject((FileObject)fileObject);
        if (javaSource == null) {
            return;
        }
        javaSource.runUserActionTask((Task)new Task<CompilationController>(){

            public void run(CompilationController compilationController) throws IOException {
                compilationController.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
                Element element = treePathHandle.resolveElement((CompilationInfo)compilationController);
                if (element == null || element.getKind() != ElementKind.FIELD) {
                    return;
                }
                stringArray[0] = ElementUtilities.getBinaryName((TypeElement)((TypeElement)element.getEnclosingElement()));
                stringArray[1] = element.getSimpleName().toString();
            }
        }, true);
        String string = stringArray[0];
        String string2 = stringArray[1];
        String string3 = this.refactoring.getNewName();
        if (string2 != null && string3 != null) {
            Map<FileObject, List<HibernateRefactoringUtil.OccurrenceItem>> map = HibernateRefactoringUtil.getJavaFieldOccurrences(this.mFileObjs, string, string2);
            for (FileObject fileObject2 : map.keySet()) {
                List<HibernateRefactoringUtil.OccurrenceItem> list = map.get(fileObject2);
                for (HibernateRefactoringUtil.OccurrenceItem occurrenceItem : list) {
                    HibernateRenameRefactoringElement hibernateRenameRefactoringElement = new HibernateRenameRefactoringElement(fileObject2, string2, string3, occurrenceItem.getLocation(), occurrenceItem.getText());
                    refactoringElementsBag.add((AbstractRefactoring)this.refactoring, (RefactoringElementImplementation)hibernateRenameRefactoringElement);
                }
            }
            refactoringElementsBag.registerTransaction((Transaction)new JavaFieldRenameTransaction(map.keySet(), string, string2, string3));
        }
    }

    private void renameJavaPackage(RefactoringElementsBag refactoringElementsBag, TreePathHandle treePathHandle, FileObject fileObject, boolean bl) throws IOException {
        Object object;
        List<FileObject> list;
        Object object2;
        Project project2;
        Object object3;
        String string;
        String string2 = HibernateRefactoringUtil.getPackageName(fileObject);
        String string3 = string = bl ? HibernateRefactoringUtil.getRenamedPackageName(fileObject, this.refactoring.getNewName()) : this.refactoring.getNewName();
        if (string2 != null && string != null) {
            object3 = HibernateRefactoringUtil.getJavaPackageOccurrences(this.mFileObjs, string2);
            for (Project project2 : object3.keySet()) {
                object2 = (List)object3.get(project2);
                list = object2.iterator();
                while (list.hasNext()) {
                    object = (HibernateRefactoringUtil.OccurrenceItem)list.next();
                    Object object4 = new HibernateRenameRefactoringElement((FileObject)project2, string2, string, ((HibernateRefactoringUtil.OccurrenceItem)object).getLocation(), ((HibernateRefactoringUtil.OccurrenceItem)object).getText());
                    refactoringElementsBag.add((AbstractRefactoring)this.refactoring, object4);
                }
            }
            refactoringElementsBag.registerTransaction((Transaction)new JavaPackageRenameTransaction(object3.keySet(), string2, string));
        }
        object3 = string2.replace('.', '/');
        String string4 = string.replace('.', '/');
        project2 = FileOwnerQuery.getOwner((FileObject)fileObject);
        object2 = (HibernateEnvironment)project2.getLookup().lookup(HibernateEnvironment.class);
        if (object2 == null) {
            return;
        }
        list = object2.getAllHibernateConfigFileObjects();
        if (list.isEmpty()) {
            return;
        }
        object = HibernateRefactoringUtil.getMappingResourceOccurrences(list, (String)object3, true);
        for (FileObject fileObject2 : object.keySet()) {
            List list2 = (List)object.get(fileObject2);
            for (HibernateRefactoringUtil.OccurrenceItem occurrenceItem : list2) {
                HibernateRenameRefactoringElement hibernateRenameRefactoringElement = new HibernateRenameRefactoringElement(fileObject2, (String)object3, string4, occurrenceItem.getLocation(), occurrenceItem.getText());
                refactoringElementsBag.add((AbstractRefactoring)this.refactoring, (RefactoringElementImplementation)hibernateRenameRefactoringElement);
            }
        }
        refactoringElementsBag.registerTransaction((Transaction)new HibernateMappingRenameTransaction(object.keySet(), (String)object3, string4, true));
    }
}

