/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.navigation.macroview.impl.services;

import javax.swing.SwingUtilities;
import javax.swing.text.Document;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmOffsetable;
import org.netbeans.modules.cnd.api.model.CsmScope;
import org.netbeans.modules.cnd.api.model.services.CsmMacroExpansion;
import org.netbeans.modules.cnd.api.model.util.CsmKindUtilities;
import org.netbeans.modules.cnd.modelutil.CsmUtilities;
import org.netbeans.modules.cnd.navigation.hierarchy.ContextUtils;
import org.netbeans.modules.cnd.navigation.macroview.MacroExpansionTopComponent;
import org.netbeans.modules.cnd.navigation.macroview.MacroExpansionViewUtils;
import org.netbeans.modules.cnd.spi.model.services.CsmMacroExpansionViewProvider;
import org.openide.util.NbBundle;

public class MacroExpansionViewProviderImpl
implements CsmMacroExpansionViewProvider {
    public void showMacroExpansionView(Document doc, int offset) {
        Document expandedContextDoc;
        CsmScope scope;
        final Document mainDoc = doc;
        if (mainDoc == null) {
            return;
        }
        CsmFile csmFile = CsmUtilities.getCsmFile((Document)mainDoc, (boolean)true, (boolean)false);
        if (csmFile == null) {
            return;
        }
        int startOffset = 0;
        int endOffset = mainDoc.getLength();
        if (MacroExpansionTopComponent.isLocalContext() && CsmKindUtilities.isOffsetable((Object)(scope = ContextUtils.findInnerFileScope(csmFile, offset)))) {
            startOffset = ((CsmOffsetable)scope).getStartOffset();
            endOffset = ((CsmOffsetable)scope).getEndOffset();
        }
        if ((expandedContextDoc = MacroExpansionViewUtils.createExpandedContextDocument(mainDoc, csmFile)) == null) {
            return;
        }
        final int expansionsNumber = CsmMacroExpansion.expand((Document)mainDoc, (int)startOffset, (int)endOffset, (Document)expandedContextDoc);
        MacroExpansionViewUtils.setOffset(expandedContextDoc, startOffset, endOffset);
        MacroExpansionViewUtils.saveDocumentAndMarkAsReadOnly(expandedContextDoc);
        Runnable openView = new Runnable(){

            @Override
            public void run() {
                MacroExpansionTopComponent view = MacroExpansionTopComponent.findInstance();
                if (!view.isOpened()) {
                    view.open();
                }
                view.setDocuments(expandedContextDoc);
                view.requestActive();
                view.setDisplayName(NbBundle.getMessage(MacroExpansionTopComponent.class, (String)"CTL_MacroExpansionViewTitle", (Object)CsmUtilities.getFile((Document)mainDoc).getName()));
                view.setStatusBarText(NbBundle.getMessage(MacroExpansionTopComponent.class, (String)"CTL_MacroExpansionStatusBarLine", (Object)expansionsNumber));
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            openView.run();
        } else {
            SwingUtilities.invokeLater(openView);
        }
    }
}

