/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.samples;

import java.awt.Component;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.LinkedHashSet;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.Stack;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.swing.JComponent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.modules.php.samples.PHPSamplesWizardPanel;
import org.netbeans.spi.project.ui.support.ProjectChooser;
import org.netbeans.spi.project.ui.templates.support.Templates;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileAlreadyLockedException;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.xml.XMLUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class PHPSamplesWizardIterator
implements WizardDescriptor.InstantiatingIterator {
    private static final boolean DO_NOT_OPEN_README_HTML = Boolean.getBoolean("org.netbeans.modules.php.samples.donotopenreadmehtml");
    private int index;
    private WizardDescriptor.Panel[] panels;
    private WizardDescriptor wiz;

    public static PHPSamplesWizardIterator createIterator() {
        return new PHPSamplesWizardIterator();
    }

    private WizardDescriptor.Panel[] createPanels() {
        return new WizardDescriptor.Panel[]{new PHPSamplesWizardPanel()};
    }

    private String[] createSteps() {
        return new String[]{NbBundle.getMessage(PHPSamplesWizardIterator.class, (String)"LBL_CreateProjectStep")};
    }

    public Set instantiate() throws IOException {
        LinkedHashSet<FileObject> resultSet = new LinkedHashSet<FileObject>();
        File dirF = FileUtil.normalizeFile((File)((File)this.wiz.getProperty("projdir")));
        PHPSamplesWizardIterator.createFolder(dirF);
        FileObject template = Templates.getTemplate((WizardDescriptor)this.wiz);
        FileObject dir = FileUtil.toFileObject((File)dirF);
        PHPSamplesWizardIterator.unZipFile(template.getInputStream(), dir);
        ProjectManager.getDefault().clearNonProjectCache();
        resultSet.add(dir);
        Enumeration e = dir.getFolders(true);
        while (e.hasMoreElements()) {
            FileObject subfolder = (FileObject)e.nextElement();
            if (!ProjectManager.getDefault().isProject(subfolder)) continue;
            resultSet.add(subfolder);
        }
        File parent = dirF.getParentFile();
        if (parent != null && parent.exists()) {
            ProjectChooser.setProjectsFolder((File)parent);
        }
        if (!DO_NOT_OPEN_README_HTML) {
            File urlTempF = File.createTempFile("phpSamplesReadme", ".url");
            urlTempF.deleteOnExit();
            FileObject readmeURL = FileUtil.toFileObject((File)FileUtil.normalizeFile((File)urlTempF));
            PHPSamplesWizardIterator.writeLines(readmeURL, dir.getFileObject("readme.html").getURL().toString());
            resultSet.add(readmeURL);
        }
        return resultSet;
    }

    private static void writeLines(FileObject readme, String ... lines) throws FileAlreadyLockedException, IOException {
        PrintWriter readmeW = new PrintWriter(readme.getOutputStream());
        for (String line : lines) {
            readmeW.println(line);
        }
        readmeW.close();
    }

    public void initialize(WizardDescriptor wiz) {
        this.wiz = wiz;
        this.index = 0;
        this.panels = this.createPanels();
        String[] steps = this.createSteps();
        for (int i = 0; i < this.panels.length; ++i) {
            Component c = this.panels[i].getComponent();
            if (steps[i] == null) {
                steps[i] = c.getName();
            }
            if (!(c instanceof JComponent)) continue;
            JComponent jc = (JComponent)c;
            jc.putClientProperty("WizardPanel_contentSelectedIndex", new Integer(i));
            jc.putClientProperty("WizardPanel_contentData", steps);
        }
        FileObject template = Templates.getTemplate((WizardDescriptor)wiz);
        wiz.putProperty("name", (Object)template.getName());
    }

    public void uninitialize(WizardDescriptor wiz) {
        this.wiz.putProperty("projdir", null);
        this.wiz.putProperty("name", null);
        this.wiz = null;
        this.panels = null;
    }

    public String name() {
        return MessageFormat.format("{0} of {1}", new Integer(this.index + 1), new Integer(this.panels.length));
    }

    public boolean hasNext() {
        return this.index < this.panels.length - 1;
    }

    public boolean hasPrevious() {
        return this.index > 0;
    }

    public void nextPanel() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        ++this.index;
    }

    public void previousPanel() {
        if (!this.hasPrevious()) {
            throw new NoSuchElementException();
        }
        --this.index;
    }

    public WizardDescriptor.Panel current() {
        return this.panels[this.index];
    }

    public final void addChangeListener(ChangeListener l) {
    }

    public final void removeChangeListener(ChangeListener l) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void unZipFile(InputStream source, FileObject projectRoot) throws IOException {
        try {
            ZipEntry entry;
            ZipInputStream str = new ZipInputStream(source);
            while ((entry = str.getNextEntry()) != null) {
                if (entry.isDirectory()) {
                    FileUtil.createFolder((FileObject)projectRoot, (String)entry.getName());
                    continue;
                }
                FileObject fo = FileUtil.createData((FileObject)projectRoot, (String)entry.getName());
                if ("nbproject/project.xml".equals(entry.getName())) {
                    PHPSamplesWizardIterator.filterProjectXML(fo, str, projectRoot.getName());
                    continue;
                }
                PHPSamplesWizardIterator.writeFile(str, fo);
            }
        }
        finally {
            source.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeFile(ZipInputStream str, FileObject fo) throws IOException {
        OutputStream out = fo.getOutputStream();
        try {
            FileUtil.copy((InputStream)str, (OutputStream)out);
        }
        finally {
            out.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void filterProjectXML(FileObject fo, ZipInputStream str, String name) throws IOException {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            FileUtil.copy((InputStream)str, (OutputStream)baos);
            Document doc = XMLUtil.parse((InputSource)new InputSource(new ByteArrayInputStream(baos.toByteArray())), (boolean)false, (boolean)false, null, null);
            NodeList nl = doc.getDocumentElement().getElementsByTagName("name");
            if (nl != null) {
                for (int i = 0; i < nl.getLength(); ++i) {
                    Element el = (Element)nl.item(i);
                    if (el.getParentNode() == null || !"data".equals(el.getParentNode().getNodeName())) continue;
                    NodeList nl2 = el.getChildNodes();
                    if (nl2.getLength() <= 0) break;
                    nl2.item(0).setNodeValue(name);
                    break;
                }
            }
            OutputStream out = fo.getOutputStream();
            try {
                XMLUtil.write((Document)doc, (OutputStream)out, (String)"UTF-8");
            }
            finally {
                out.close();
            }
        }
        catch (Exception ex) {
            Exceptions.printStackTrace((Throwable)ex);
            PHPSamplesWizardIterator.writeFile(str, fo);
        }
    }

    private static FileObject createFolder(File dir) throws IOException {
        Stack<String> stack = new Stack<String>();
        while (!dir.exists()) {
            stack.push(dir.getName());
            dir = dir.getParentFile();
        }
        FileObject dirFO = FileUtil.toFileObject((File)dir);
        if (dirFO == null) {
            PHPSamplesWizardIterator.refreshFileSystem(dir);
            dirFO = FileUtil.toFileObject((File)dir);
        }
        assert (dirFO != null);
        while (!stack.isEmpty()) {
            dirFO = dirFO.createFolder((String)stack.pop());
        }
        return dirFO;
    }

    private static void refreshFileSystem(File dir) throws FileStateInvalidException {
        File rootF = dir;
        while (rootF.getParentFile() != null) {
            rootF = rootF.getParentFile();
        }
        FileObject dirFO = FileUtil.toFileObject((File)rootF);
        assert (dirFO != null) : "At least disk roots must be mounted! " + rootF;
        dirFO.getFileSystem().refresh(false);
    }
}

