/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.modelimpl.cache.impl;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import org.netbeans.modules.cnd.antlr.collections.AST;

public class CacheUtil {
    private static final int CHILD = 1;
    private static final int SIBLING = 2;
    private static final int END_AST = 3;

    public static String mangleName(CharSequence charSequence, char c) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < charSequence.length(); ++i) {
            char c2 = charSequence.charAt(i);
            if (c2 == '\\' || c2 == '/' || c2 == ':' || c2 == ' ') {
                c2 = c;
            }
            if (i <= 0 && c2 == c) continue;
            stringBuilder.append(c2);
        }
        return stringBuilder.toString();
    }

    public static void writeAST(ObjectOutputStream objectOutputStream, AST aST) throws IOException {
        objectOutputStream.writeObject(aST);
        if (aST != null) {
            CacheUtil.writeTree(objectOutputStream, aST);
        }
    }

    public static AST readAST(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        AST aST = (AST)objectInputStream.readObject();
        if (aST != null) {
            CacheUtil.readTree(objectInputStream, aST);
        }
        return aST;
    }

    private static void writeTree(ObjectOutputStream objectOutputStream, AST aST) throws IOException {
        assert (aST != null) : "there must be something to write";
        AST aST2 = aST;
        do {
            AST aST3;
            if ((aST3 = aST2.getFirstChild()) != null) {
                objectOutputStream.writeInt(1);
                CacheUtil.writeAST(objectOutputStream, aST3);
            }
            if ((aST2 = aST2.getNextSibling()) == null) continue;
            objectOutputStream.writeInt(2);
            objectOutputStream.writeObject(aST2);
        } while (aST2 != null);
        objectOutputStream.writeInt(3);
    }

    private static void readTree(ObjectInputStream objectInputStream, AST aST) throws IOException, ClassNotFoundException {
        assert (aST != null) : "there must be something to read";
        AST aST2 = aST;
        do {
            int n = objectInputStream.readInt();
            switch (n) {
                case 3: {
                    return;
                }
                case 1: {
                    aST2.setFirstChild(CacheUtil.readAST(objectInputStream));
                    break;
                }
                case 2: {
                    AST aST3 = (AST)objectInputStream.readObject();
                    aST2.setNextSibling(aST3);
                    aST2 = aST3;
                    break;
                }
                default: {
                    assert (false);
                    {
                        break;
                    }
                }
            }
        } while (aST2 != null);
    }
}

