/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.selector.java.nodes;

import com.sun.source.tree.ClassTree;
import com.sun.source.util.TreePathScanner;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import javax.swing.Icon;
import org.netbeans.api.java.source.CancellableTask;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.ElementUtilities;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.SourceUtils;
import org.netbeans.api.java.source.Task;
import org.netbeans.lib.profiler.client.ClientUtils;
import org.netbeans.modules.profiler.selector.java.nodes.JavaConstructorNode;
import org.netbeans.modules.profiler.selector.java.nodes.JavaMethodNode;
import org.netbeans.modules.profiler.selector.spi.nodes.ClassNode;
import org.netbeans.modules.profiler.selector.spi.nodes.ConstructorsNode;
import org.netbeans.modules.profiler.selector.spi.nodes.ContainerNode;
import org.netbeans.modules.profiler.selector.spi.nodes.InnerClassesNode;
import org.netbeans.modules.profiler.selector.spi.nodes.MethodNode;
import org.netbeans.modules.profiler.selector.spi.nodes.MethodsNode;
import org.netbeans.modules.profiler.selector.spi.nodes.SelectorNode;
import org.openide.filesystems.FileObject;

public class JavaClassNode
extends ClassNode {
    private ClasspathInfo cpInfo;
    private ElementHandle<TypeElement> typeHandle;
    private ClientUtils.SourceCodeSelection signature;

    public JavaClassNode(ClasspathInfo classpathInfo, String string, boolean bl, TypeElement typeElement, ContainerNode containerNode) {
        super(ElementUtilities.getBinaryName((TypeElement)typeElement), string, bl, containerNode);
        this.cpInfo = classpathInfo;
        this.typeHandle = ElementHandle.create((Element)typeElement);
        this.signature = new ClientUtils.SourceCodeSelection(ElementUtilities.getBinaryName((TypeElement)typeElement), "*", "");
    }

    public JavaClassNode(ClasspathInfo classpathInfo, boolean bl, TypeElement typeElement, ContainerNode containerNode) {
        this(classpathInfo, JavaClassNode.getSimpleName(ElementUtilities.getBinaryName((TypeElement)typeElement)), bl, typeElement, containerNode);
    }

    public JavaClassNode(ClasspathInfo classpathInfo, TypeElement typeElement, ContainerNode containerNode) {
        this(classpathInfo, false, typeElement, containerNode);
    }

    public JavaClassNode(ClasspathInfo classpathInfo, String string, Icon icon, boolean bl, TypeElement typeElement, ContainerNode containerNode) {
        super(ElementUtilities.getBinaryName((TypeElement)typeElement), string, icon, bl, containerNode);
        this.cpInfo = classpathInfo;
        this.typeHandle = ElementHandle.create((Element)typeElement);
        this.signature = new ClientUtils.SourceCodeSelection(ElementUtilities.getBinaryName((TypeElement)typeElement), "*", "");
    }

    public JavaClassNode(ClasspathInfo classpathInfo, Icon icon, boolean bl, TypeElement typeElement, ContainerNode containerNode) {
        this(classpathInfo, typeElement.getSimpleName().toString(), icon, bl, typeElement, containerNode);
        this.cpInfo = classpathInfo;
        this.typeHandle = ElementHandle.create((Element)typeElement);
        this.signature = new ClientUtils.SourceCodeSelection(ElementUtilities.getBinaryName((TypeElement)typeElement), "*", "");
    }

    public JavaClassNode(ClasspathInfo classpathInfo, Icon icon, TypeElement typeElement, ContainerNode containerNode) {
        this(classpathInfo, icon, false, typeElement, containerNode);
    }

    public ClientUtils.SourceCodeSelection getSignature() {
        return this.signature;
    }

    protected ConstructorsNode getConstructorsNode() {
        return new ConstructorsNode(this){

            protected List<SelectorNode> getConstructorNodes(final ConstructorsNode constructorsNode) {
                final ArrayList<SelectorNode> arrayList = new ArrayList<SelectorNode>();
                try {
                    JavaSource javaSource = JavaSource.create((ClasspathInfo)JavaClassNode.this.cpInfo, (FileObject[])new FileObject[0]);
                    javaSource.runUserActionTask((Task)new CancellableTask<CompilationController>(){

                        public void cancel() {
                        }

                        public void run(CompilationController compilationController) throws Exception {
                            compilationController.toPhase(JavaSource.Phase.RESOLVED);
                            TypeElement typeElement = (TypeElement)JavaClassNode.this.typeHandle.resolve((CompilationInfo)compilationController);
                            List<ExecutableElement> list = ElementFilter.constructorsIn(typeElement.getEnclosedElements());
                            for (ExecutableElement executableElement : list) {
                                arrayList.add(new JavaConstructorNode(JavaClassNode.this.cpInfo, executableElement, executableElement.getSimpleName().toString(), constructorsNode));
                            }
                        }
                    }, true);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    illegalArgumentException.printStackTrace();
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
                return arrayList;
            }
        };
    }

    protected InnerClassesNode getInnerClassesNode() {
        return new InnerClassesNode(this){

            private String getInterfaceNames(TypeElement typeElement, CompilationInfo compilationInfo) {
                String string = null;
                List<? extends TypeMirror> list = typeElement.getInterfaces();
                if (list != null) {
                    StringBuilder stringBuilder = new StringBuilder();
                    boolean bl = true;
                    for (TypeMirror typeMirror : list) {
                        Element element = compilationInfo.getTypes().asElement(typeMirror);
                        if (element == null || element.getKind() != ElementKind.INTERFACE) continue;
                        if (!bl) {
                            stringBuilder.append(", ");
                        }
                        stringBuilder.append(ElementUtilities.getBinaryName((TypeElement)((TypeElement)element)));
                    }
                    string = stringBuilder.toString();
                }
                return string;
            }

            private String getSuperTypeClassName(TypeElement typeElement, CompilationInfo compilationInfo) {
                String string;
                Element element;
                String string2 = null;
                TypeMirror typeMirror = typeElement.getSuperclass();
                if (typeMirror != null && (element = compilationInfo.getTypes().asElement(typeMirror)) != null && element.getKind() == ElementKind.CLASS && !(string = ElementUtilities.getBinaryName((TypeElement)((TypeElement)element))).equals("java.lang.Object")) {
                    string2 = string;
                }
                return string2;
            }

            private void addAnonymousInnerClasses(final CompilationController compilationController, final InnerClassesNode innerClassesNode, final Set<ClassNode> set) throws IOException {
                final Pattern pattern = Pattern.compile("\\$[0-9]*");
                final int n = JavaClassNode.this.typeHandle.getBinaryName().length();
                FileObject fileObject = SourceUtils.getFile((ElementHandle)JavaClassNode.this.typeHandle, (ClasspathInfo)compilationController.getClasspathInfo());
                JavaSource.forFileObject((FileObject)fileObject).runUserActionTask((Task)new CancellableTask<CompilationController>(){

                    public void cancel() {
                    }

                    public void run(final CompilationController compilationController2) throws Exception {
                        compilationController2.toPhase(JavaSource.Phase.RESOLVED);
                        TreePathScanner<Void, Void> treePathScanner = new TreePathScanner<Void, Void>(){

                            @Override
                            public Void visitClass(ClassTree classTree, Void void_) {
                                TypeElement typeElement;
                                String string;
                                Element element = compilationController.getTrees().getElement(this.getCurrentPath());
                                if (element != null && element.getKind() == ElementKind.CLASS && pattern.matcher(string = (string = ElementUtilities.getBinaryName((TypeElement)(typeElement = (TypeElement)element))).length() <= n ? "" : string.substring(n)).matches()) {
                                    String string2 = this.getSuperTypeClassName(typeElement, (CompilationInfo)compilationController2);
                                    if (string2 == null) {
                                        string2 = this.getInterfaceNames(typeElement, (CompilationInfo)compilationController2);
                                    }
                                    if (string2 != null) {
                                        StringBuilder stringBuilder = new StringBuilder();
                                        stringBuilder.append(string).append("[").append(string2).append("]");
                                        string = stringBuilder.toString();
                                        set.add(new JavaClassNode(JavaClassNode.this.cpInfo, true, typeElement, (ContainerNode)innerClassesNode));
                                    }
                                }
                                super.visitClass(classTree, void_);
                                return null;
                            }
                        };
                        treePathScanner.scan(compilationController2.getCompilationUnit(), null);
                    }
                }, false);
            }

            protected Set<ClassNode> getInnerClassNodes(final InnerClassesNode innerClassesNode) {
                final HashSet<ClassNode> hashSet = new HashSet<ClassNode>();
                try {
                    JavaSource javaSource = JavaSource.create((ClasspathInfo)JavaClassNode.this.cpInfo, (FileObject[])new FileObject[0]);
                    javaSource.runUserActionTask((Task)new CancellableTask<CompilationController>(){

                        public void cancel() {
                        }

                        public void run(CompilationController compilationController) throws Exception {
                            if (compilationController.toPhase(JavaSource.Phase.RESOLVED) != JavaSource.Phase.RESOLVED) {
                                return;
                            }
                            TypeElement typeElement = (TypeElement)JavaClassNode.this.typeHandle.resolve((CompilationInfo)compilationController);
                            List<TypeElement> list = ElementFilter.typesIn(typeElement.getEnclosedElements());
                            for (TypeElement typeElement2 : list) {
                                hashSet.add(new JavaClassNode(JavaClassNode.this.cpInfo, false, typeElement2, (ContainerNode)innerClassesNode));
                            }
                            this.addAnonymousInnerClasses(compilationController, innerClassesNode, hashSet);
                        }
                    }, true);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    illegalArgumentException.printStackTrace();
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                return hashSet;
            }
        };
    }

    protected MethodsNode getMethodsNode() {
        return new MethodsNode(this){

            protected List<MethodNode> getMethodNodes(final MethodsNode methodsNode) {
                final ArrayList<MethodNode> arrayList = new ArrayList<MethodNode>();
                try {
                    JavaSource javaSource = JavaSource.create((ClasspathInfo)JavaClassNode.this.cpInfo, (FileObject[])new FileObject[0]);
                    javaSource.runUserActionTask((Task)new CancellableTask<CompilationController>(){

                        public void cancel() {
                        }

                        public void run(CompilationController compilationController) throws Exception {
                            compilationController.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
                            TypeElement typeElement = (TypeElement)JavaClassNode.this.typeHandle.resolve((CompilationInfo)compilationController);
                            List<ExecutableElement> list = ElementFilter.methodsIn(typeElement.getEnclosedElements());
                            for (ExecutableElement executableElement : list) {
                                JavaMethodNode javaMethodNode = new JavaMethodNode(JavaClassNode.this.cpInfo, executableElement, methodsNode);
                                if (javaMethodNode.getSignature() == null) continue;
                                arrayList.add(javaMethodNode);
                            }
                        }
                    }, true);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    illegalArgumentException.printStackTrace();
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
                return arrayList;
            }
        };
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != object.getClass()) {
            return false;
        }
        JavaClassNode javaClassNode = (JavaClassNode)((Object)object);
        return this.typeHandle == javaClassNode.typeHandle || this.typeHandle != null && this.typeHandle.equals(javaClassNode.typeHandle);
    }

    public int hashCode() {
        int n = 7;
        n = 53 * n + (this.typeHandle != null ? this.typeHandle.hashCode() : 0);
        return n;
    }

    private static String getSimpleName(String string) {
        int n = string.lastIndexOf(".");
        if (n > -1) {
            return string.substring(n + 1);
        }
        return string;
    }
}

