/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.makeproject.ui.options;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.netbeans.modules.cnd.makeproject.MakeOptions;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class ProjectOptionsPanel
extends JPanel {
    private boolean changed;
    private boolean listen = false;
    private ArrayList<PropertyChangeListener> propertyChangeListeners = new ArrayList();
    private DocumentListener documentListener;
    private JCheckBox dependencyCheckingCheckBox;
    private JLabel filePathLabel;
    private JTextArea filePathTxt;
    private JComboBox filePathcomboBox;
    private JCheckBox fullFileIndexer;
    private JSeparator jSeparator1;
    private JLabel makeOptionsLabel;
    private JTextField makeOptionsTextField;
    private JLabel makeOptionsTxt;
    private JCheckBox rebuildPropsChangedCheckBox;
    private JCheckBox reuseCheckBox;
    private JCheckBox saveCheckBox;
    private JCheckBox showConfigurationWarningCheckBox;
    private JCheckBox showProfilerCheckBox;
    private JCheckBox viewBinaryFilesCheckBox;

    public ProjectOptionsPanel() {
        this.initComponents();
        this.reuseCheckBox.getAccessibleContext().setAccessibleDescription(ProjectOptionsPanel.getString("REUSE_CHECKBOX_AD"));
        this.saveCheckBox.getAccessibleContext().setAccessibleDescription(ProjectOptionsPanel.getString("SAVE_CHECKBOX_AD"));
        this.dependencyCheckingCheckBox.getAccessibleContext().setAccessibleDescription(ProjectOptionsPanel.getString("DEPENDENCY_CHECKBOX_AD"));
        this.rebuildPropsChangedCheckBox.getAccessibleContext().setAccessibleDescription(ProjectOptionsPanel.getString("REBUILD_PROP_CHANGED_AD"));
        this.filePathcomboBox.getAccessibleContext().setAccessibleDescription(ProjectOptionsPanel.getString("FILE_PATH_AD"));
        this.makeOptionsTextField.getAccessibleContext().setAccessibleDescription(ProjectOptionsPanel.getString("MAKE_OPTIONS_AD"));
        this.filePathTxt.getAccessibleContext().setAccessibleDescription(ProjectOptionsPanel.getString("FILE_PATH_TXT_AD"));
        this.filePathTxt.getAccessibleContext().setAccessibleName(ProjectOptionsPanel.getString("FILE_PATH_TXT_AN"));
        this.documentListener = new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                ProjectOptionsPanel.this.validateFields();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                ProjectOptionsPanel.this.validateFields();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                ProjectOptionsPanel.this.validateFields();
            }
        };
        this.makeOptionsTextField.getDocument().addDocumentListener(this.documentListener);
        this.setName("TAB_ProjectsTab");
        if ("Windows".equals(UIManager.getLookAndFeel().getID())) {
            this.setOpaque(false);
        } else {
            Color c = this.getBackground();
            Color cc = new Color(c.getRed(), c.getGreen(), c.getBlue());
            this.filePathTxt.setBackground(cc);
        }
    }

    public void update() {
        this.listen = false;
        MakeOptions makeOptions = MakeOptions.getInstance();
        this.dependencyCheckingCheckBox.setSelected(makeOptions.getDepencyChecking());
        this.rebuildPropsChangedCheckBox.setSelected(makeOptions.getRebuildPropChanged());
        this.makeOptionsTextField.setText(makeOptions.getMakeOptions());
        this.filePathcomboBox.removeAllItems();
        for (int i = 0; i < MakeOptions.PathModeNames.length; ++i) {
            this.filePathcomboBox.addItem(MakeOptions.PathModeNames[i]);
        }
        this.filePathcomboBox.setSelectedIndex(makeOptions.getPathMode());
        this.saveCheckBox.setSelected(makeOptions.getSave());
        this.reuseCheckBox.setSelected(makeOptions.getReuse());
        this.viewBinaryFilesCheckBox.setSelected(makeOptions.getViewBinaryFiles());
        this.showProfilerCheckBox.setSelected(makeOptions.getShowProfiling());
        this.showConfigurationWarningCheckBox.setSelected(makeOptions.getShowConfigurationWarning());
        this.fullFileIndexer.setSelected(makeOptions.isFullFileIndexer());
        this.listen = true;
        this.changed = false;
    }

    public void applyChanges() {
        MakeOptions makeOptions = MakeOptions.getInstance();
        makeOptions.setDepencyChecking(this.dependencyCheckingCheckBox.isSelected());
        makeOptions.setRebuildPropChanged(this.rebuildPropsChangedCheckBox.isSelected());
        makeOptions.setMakeOptions(this.makeOptionsTextField.getText());
        makeOptions.setPathMode(this.filePathcomboBox.getSelectedIndex());
        makeOptions.setSave(this.saveCheckBox.isSelected());
        makeOptions.setReuse(this.reuseCheckBox.isSelected());
        makeOptions.setViewBinaryFiles(this.viewBinaryFilesCheckBox.isSelected());
        makeOptions.setShowProfiling(this.showProfilerCheckBox.isSelected());
        makeOptions.setShowConfigurationWarning(this.showConfigurationWarningCheckBox.isSelected());
        makeOptions.setFullFileIndexer(this.fullFileIndexer.isSelected());
        this.changed = false;
    }

    public void cancel() {
        this.changed = false;
    }

    public boolean dataValid() {
        return true;
    }

    public boolean isChanged() {
        return this.changed;
    }

    private void validateFields() {
        PropertyChangeEvent pce = new PropertyChangeEvent(this, "valid", this, this);
        this.firePropertyChange(pce);
    }

    public void firePropertyChange(PropertyChangeEvent evt) {
        ArrayList<PropertyChangeListener> newList = new ArrayList<PropertyChangeListener>();
        newList.addAll(this.propertyChangeListeners);
        for (PropertyChangeListener listener : newList) {
            listener.propertyChange(evt);
        }
    }

    private static String getString(String key) {
        return NbBundle.getMessage(ProjectOptionsPanel.class, (String)key);
    }

    private void initComponents() {
        this.makeOptionsLabel = new JLabel();
        this.makeOptionsTextField = new JTextField();
        this.makeOptionsTxt = new JLabel();
        this.filePathLabel = new JLabel();
        this.filePathcomboBox = new JComboBox();
        this.filePathTxt = new JTextArea();
        this.saveCheckBox = new JCheckBox();
        this.reuseCheckBox = new JCheckBox();
        this.dependencyCheckingCheckBox = new JCheckBox();
        this.viewBinaryFilesCheckBox = new JCheckBox();
        this.jSeparator1 = new JSeparator();
        this.showProfilerCheckBox = new JCheckBox();
        this.showConfigurationWarningCheckBox = new JCheckBox();
        this.fullFileIndexer = new JCheckBox();
        this.rebuildPropsChangedCheckBox = new JCheckBox();
        this.setLayout(new GridBagLayout());
        this.makeOptionsLabel.setDisplayedMnemonic(ResourceBundle.getBundle("org/netbeans/modules/cnd/makeproject/ui/options/Bundle").getString("MAKE_OPTIONS_MN").charAt(0));
        this.makeOptionsLabel.setLabelFor(this.makeOptionsTextField);
        ResourceBundle bundle = ResourceBundle.getBundle("org/netbeans/modules/cnd/makeproject/ui/options/Bundle");
        this.makeOptionsLabel.setText(bundle.getString("MAKE_OPTIONS"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 6, 0, 0);
        this.add((Component)this.makeOptionsLabel, gridBagConstraints);
        this.makeOptionsTextField.setColumns(45);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 4, 0, 6);
        this.add((Component)this.makeOptionsTextField, gridBagConstraints);
        this.makeOptionsTxt.setText(bundle.getString("MAKE_OPTIONS_TXT"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 6, 0, 12);
        this.add((Component)this.makeOptionsTxt, gridBagConstraints);
        this.filePathLabel.setDisplayedMnemonic(ResourceBundle.getBundle("org/netbeans/modules/cnd/makeproject/ui/options/Bundle").getString("FILE_PATH_MN").charAt(0));
        this.filePathLabel.setLabelFor(this.filePathcomboBox);
        this.filePathLabel.setText(bundle.getString("FILE_PATH"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 6, 0, 0);
        this.add((Component)this.filePathLabel, gridBagConstraints);
        this.filePathcomboBox.setMinimumSize(new Dimension(75, 18));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(12, 4, 0, 6);
        this.add((Component)this.filePathcomboBox, gridBagConstraints);
        this.filePathTxt.setEditable(false);
        this.filePathTxt.setLineWrap(true);
        this.filePathTxt.setText(bundle.getString("FILE_PATH_MODE_TXT"));
        this.filePathTxt.setWrapStyleWord(true);
        this.filePathTxt.setBorder(null);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 10.0;
        gridBagConstraints.insets = new Insets(6, 6, 0, 6);
        this.add((Component)this.filePathTxt, gridBagConstraints);
        this.saveCheckBox.setMnemonic(ResourceBundle.getBundle("org/netbeans/modules/cnd/makeproject/ui/options/Bundle").getString("SAVE_CHECKBOX_MN").charAt(0));
        this.saveCheckBox.setText(NbBundle.getMessage(ProjectOptionsPanel.class, (String)"SAVE_CHECKBOX_TXT"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(12, 6, 6, 6);
        this.add((Component)this.saveCheckBox, gridBagConstraints);
        this.reuseCheckBox.setMnemonic(ResourceBundle.getBundle("org/netbeans/modules/cnd/makeproject/ui/options/Bundle").getString("REUSE_CHECKBOX_MN").charAt(0));
        this.reuseCheckBox.setText(bundle.getString("REUSE_CHECKBOX_TXT"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 6, 6, 6);
        this.add((Component)this.reuseCheckBox, gridBagConstraints);
        this.dependencyCheckingCheckBox.setMnemonic(ResourceBundle.getBundle("org/netbeans/modules/cnd/makeproject/ui/options/Bundle").getString("DEPENDENCY_CHECKING_MN").charAt(0));
        this.dependencyCheckingCheckBox.setText(bundle.getString("DEPENDENCY_CHECKING_TXT"));
        this.dependencyCheckingCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ProjectOptionsPanel.this.dependencyCheckingCheckBoxActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 6, 6, 6);
        this.add((Component)this.dependencyCheckingCheckBox, gridBagConstraints);
        this.viewBinaryFilesCheckBox.setMnemonic(ResourceBundle.getBundle("org/netbeans/modules/cnd/makeproject/ui/options/Bundle").getString("DISPLAY_BINARY_FILES_MN").charAt(0));
        this.viewBinaryFilesCheckBox.setText(NbBundle.getMessage(ProjectOptionsPanel.class, (String)"DISPLAY_BINARY_FILES_TXT"));
        this.viewBinaryFilesCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ProjectOptionsPanel.this.viewBinaryFilesCheckBoxActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 6, 6, 6);
        this.add((Component)this.viewBinaryFilesCheckBox, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 14;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.jSeparator1, gridBagConstraints);
        this.showProfilerCheckBox.setMnemonic('j');
        this.showProfilerCheckBox.setText(NbBundle.getMessage(ProjectOptionsPanel.class, (String)"SHOW_PROFILER_CHECKBOX_TXT"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 6, 6, 6);
        this.add((Component)this.showProfilerCheckBox, gridBagConstraints);
        this.showConfigurationWarningCheckBox.setMnemonic(ResourceBundle.getBundle("org/netbeans/modules/cnd/makeproject/ui/options/Bundle").getString("SHOW_WARNING_ABOUT_MISMATCHED_CONFIGURATIONS.MN").charAt(0));
        this.showConfigurationWarningCheckBox.setText(NbBundle.getMessage(ProjectOptionsPanel.class, (String)"SHOW_WARNING_ABOUT_MISMATCHED_CONFIGURATIONS.TXT"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 11;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 6, 6, 6);
        this.add((Component)this.showConfigurationWarningCheckBox, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.fullFileIndexer, (String)NbBundle.getMessage(ProjectOptionsPanel.class, (String)"FullFileIndexerName"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 12;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 6, 6, 6);
        this.add((Component)this.fullFileIndexer, gridBagConstraints);
        this.rebuildPropsChangedCheckBox.setMnemonic(ResourceBundle.getBundle("org/netbeans/modules/cnd/makeproject/ui/options/Bundle").getString("REBUILD_PROP_CHANGED_MN").charAt(0));
        this.rebuildPropsChangedCheckBox.setText(NbBundle.getMessage(ProjectOptionsPanel.class, (String)"REBUILD_PROP_CHANGED_TXT"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 13;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 6, 6, 6);
        this.add((Component)this.rebuildPropsChangedCheckBox, gridBagConstraints);
    }

    private void dependencyCheckingCheckBoxActionPerformed(ActionEvent evt) {
        PropertyChangeEvent pce = new PropertyChangeEvent(this, "valid", this, this);
        this.firePropertyChange(pce);
    }

    private void viewBinaryFilesCheckBoxActionPerformed(ActionEvent evt) {
        PropertyChangeEvent pce = new PropertyChangeEvent(this, "valid", this, this);
        this.firePropertyChange(pce);
    }
}

