/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bugtracking.ui.nodes;

import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import javax.swing.AbstractAction;
import javax.swing.Action;
import org.netbeans.modules.bugtracking.BugtrackingManager;
import org.netbeans.modules.bugtracking.spi.BugtrackingConnector;
import org.netbeans.modules.bugtracking.spi.Repository;
import org.netbeans.modules.bugtracking.ui.nodes.WaitNode;
import org.netbeans.modules.bugtracking.util.BugtrackingUtil;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class BugtrackingRootNode
extends AbstractNode {
    private static final String ICON_BASE = "org/netbeans/modules/bugtracking/ui/resources/bugtracking.png";
    private static final Object LOCK_INIT = new Object();
    private static BugtrackingRootNode defaultInstance;

    private BugtrackingRootNode() {
        super((Children)new RootNodeChildren());
        this.setName("bugtracking");
        this.setDisplayName(NbBundle.getMessage(BugtrackingRootNode.class, (String)"LBL_BugtrackingNode"));
        this.setIconBaseWithExtension(ICON_BASE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BugtrackingRootNode getDefault() {
        Object object = LOCK_INIT;
        synchronized (object) {
            if (defaultInstance == null) {
                defaultInstance = new BugtrackingRootNode();
            }
            return defaultInstance;
        }
    }

    public Action[] getActions(boolean context) {
        return new Action[]{new AbstractAction(NbBundle.getMessage(BugtrackingRootNode.class, (String)"LBL_CreateRepository")){

            @Override
            public void actionPerformed(ActionEvent e) {
                BugtrackingUtil.createRepository();
            }
        }};
    }

    private static class RepositoryComparator
    implements Comparator<Repository> {
        private RepositoryComparator() {
        }

        @Override
        public int compare(Repository r1, Repository r2) {
            if (r1 == null && r2 == null) {
                return 0;
            }
            if (r1 == null) {
                return -1;
            }
            if (r2 == null) {
                return 1;
            }
            return r1.getDisplayName().compareTo(r2.getDisplayName());
        }
    }

    private static class RootNodeChildren
    extends Children.Keys
    implements PropertyChangeListener {
        public RootNodeChildren() {
            BugtrackingConnector[] connectors;
            for (BugtrackingConnector c : connectors = BugtrackingManager.getInstance().getConnectors()) {
                c.addPropertyChangeListener(this);
            }
        }

        protected Node[] createNodes(Object key) {
            if (key instanceof WaitNode) {
                return new Node[]{(Node)key};
            }
            assert (key instanceof Repository);
            return new Node[]{((Repository)key).getNode()};
        }

        protected void addNotify() {
            super.addNotify();
            this.refreshKeys();
        }

        protected void removeNotify() {
            this.setKeys(Collections.emptySet());
            super.removeNotify();
        }

        private void refreshKeys() {
            WaitNode waitNode = new WaitNode(NbBundle.getMessage(BugtrackingRootNode.class, (String)"LBL_Wait"));
            this.setKeys(Collections.singleton(waitNode));
            RequestProcessor.getDefault().post(new Runnable(){

                @Override
                public void run() {
                    ArrayList<Repository> l = new ArrayList<Repository>();
                    l.addAll(Arrays.asList(BugtrackingManager.getInstance().getRepositories()));
                    Collections.sort(l, new RepositoryComparator());
                    RootNodeChildren.this.setKeys(l);
                }
            });
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (evt.getPropertyName().equals("bugtracking.repositories.changed")) {
                this.refreshKeys();
            }
        }
    }
}

