/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.dataview.output;

import java.awt.Dimension;
import java.awt.Toolkit;
import org.netbeans.modules.db.dataview.output.DataView;
import org.netbeans.modules.db.dataview.output.DataViewPageContext;
import org.netbeans.modules.db.dataview.output.DataViewTableUI;
import org.netbeans.modules.db.dataview.output.DataViewUI;
import org.netbeans.modules.db.dataview.output.InsertRecordDialog;
import org.netbeans.modules.db.dataview.output.SQLExecutionHelper;
import org.netbeans.modules.db.dataview.output.UpdatedRowContext;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.NbBundle;
import org.openide.windows.WindowManager;

class DataViewActionHandler {
    private final DataViewPageContext dataPage;
    private final SQLExecutionHelper execHelper;
    private final DataViewUI dataViewUI;
    private final DataView dataView;

    DataViewActionHandler(DataViewUI dataViewUI, DataView dataView) {
        this.dataView = dataView;
        this.dataViewUI = dataViewUI;
        this.dataPage = dataView.getDataViewPageContext();
        this.execHelper = dataView.getSQLExecutionHelper();
    }

    private boolean rejectModifications() {
        String msg;
        boolean doCalculation = true;
        if (this.dataViewUI.isCommitEnabled() && DataViewActionHandler.showYesAllDialog(msg = NbBundle.getMessage(DataViewActionHandler.class, (String)"MSG_confirm_commit_changes"), NbBundle.getMessage(DataViewActionHandler.class, (String)"MSG_confirm_navigation")).equals(NotifyDescriptor.NO_OPTION)) {
            doCalculation = false;
        }
        return doCalculation;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void cancelEditPerformed(boolean selectedOnly) {
        DataView dataView = this.dataView;
        synchronized (dataView) {
            if (selectedOnly) {
                DataViewTableUI rsTable = this.dataViewUI.getDataViewTableUI();
                UpdatedRowContext updatedRowCtx = this.dataView.getUpdatedRowContext();
                int[] rows = rsTable.getSelectedRows();
                for (int i = 0; i < rows.length; ++i) {
                    int row = rows[i];
                    int CNT = rsTable.getColumnCount();
                    for (int col = 0; col < CNT; ++col) {
                        this.dataViewUI.resetValueAt(row, col);
                    }
                    updatedRowCtx.removeUpdateForSelectedRow(row);
                }
                if (updatedRowCtx.getUpdateKeys().isEmpty()) {
                    this.dataViewUI.setCancelEnabled(false);
                    this.dataViewUI.setCommitEnabled(false);
                }
            } else {
                this.dataView.getUpdatedRowContext().removeAllUpdates();
                this.dataView.setRowsInTableModel();
                this.dataViewUI.setCancelEnabled(false);
                this.dataViewUI.setCommitEnabled(false);
            }
        }
    }

    void setMaxActionPerformed() {
        if (this.rejectModifications()) {
            int pageSize = this.dataViewUI.getPageSize();
            this.dataPage.setPageSize(pageSize);
            this.dataPage.first();
            this.dataPage.setTotalRows(-1);
            this.execHelper.executeQuery();
        }
    }

    void firstActionPerformed() {
        if (this.rejectModifications()) {
            this.dataPage.first();
            this.execHelper.executeQuery();
        }
    }

    void previousActionPerformed() {
        if (this.rejectModifications()) {
            this.dataPage.previous();
            this.execHelper.executeQuery();
        }
    }

    void nextActionPerformed() {
        if (this.rejectModifications()) {
            this.dataPage.next();
            this.execHelper.executeQuery();
        }
    }

    void lastActionPerformed() {
        if (this.rejectModifications()) {
            this.dataPage.last();
            this.execHelper.executeQuery();
        }
    }

    void commitActionPerformed(boolean selectedOnly) {
        if (this.dataViewUI.isDirty()) {
            this.execHelper.executeUpdateRow(this.dataViewUI.getDataViewTableUI(), selectedOnly);
        }
    }

    void insertActionPerformed() {
        InsertRecordDialog dialog = new InsertRecordDialog(this.dataView);
        dialog.setLocationRelativeTo(WindowManager.getDefault().getMainWindow());
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        dialog.setMinimumSize(new Dimension((screenSize.width - 50) / 2, (screenSize.height - 50) / 2));
        dialog.setVisible(true);
    }

    void truncateActionPerformed() {
        String confirmMsg = NbBundle.getMessage(DataViewActionHandler.class, (String)"MSG_confirm_truncate_table") + this.dataView.getDataViewDBTable().geTable(0).getDisplayName();
        if (DataViewActionHandler.showYesAllDialog(confirmMsg, confirmMsg).equals(NotifyDescriptor.YES_OPTION)) {
            this.execHelper.executeTruncate();
        }
    }

    void deleteRecordActionPerformed() {
        DataViewTableUI rsTable = this.dataViewUI.getDataViewTableUI();
        if (rsTable.getSelectedRowCount() == 0) {
            String msg = NbBundle.getMessage(DataViewActionHandler.class, (String)"MSG_select_delete_rows");
            this.dataView.setInfoStatusText(msg);
        } else {
            String msg = NbBundle.getMessage(DataViewActionHandler.class, (String)"MSG_confirm_permanent_delete");
            if (DataViewActionHandler.showYesAllDialog(msg, NbBundle.getMessage(DataViewActionHandler.class, (String)"MSG_confirm_delete")).equals(NotifyDescriptor.YES_OPTION)) {
                this.execHelper.executeDeleteRow(rsTable);
            }
        }
    }

    void refreshActionPerformed() {
        this.dataPage.setTotalRows(-1);
        this.execHelper.executeQuery();
    }

    private static Object showYesAllDialog(Object msg, String title) {
        NotifyDescriptor nd = new NotifyDescriptor(msg, title, 0, 3, null, NotifyDescriptor.NO_OPTION);
        DialogDisplayer.getDefault().notify(nd);
        return nd.getValue();
    }
}

