/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.wsitconf.ui.service.subpanels;

import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Vector;
import javax.swing.AbstractCellEditor;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellEditor;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.modules.websvc.wsitconf.ui.security.listmodels.MessageAttachments;
import org.netbeans.modules.websvc.wsitconf.ui.security.listmodels.MessageBody;
import org.netbeans.modules.websvc.wsitconf.ui.security.listmodels.MessageElement;
import org.netbeans.modules.websvc.wsitconf.ui.security.listmodels.MessageHeader;
import org.netbeans.modules.websvc.wsitconf.ui.security.listmodels.TargetElement;
import org.netbeans.modules.websvc.wsitconf.ui.service.subpanels.AddHeaderPanel;
import org.netbeans.modules.websvc.wsitconf.wsdlmodelext.PolicyModelHelper;
import org.netbeans.modules.websvc.wsitconf.wsdlmodelext.SecurityPolicyModelHelper;
import org.netbeans.modules.xml.wsdl.model.Binding;
import org.netbeans.modules.xml.wsdl.model.WSDLComponent;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public class TargetsPanel
extends JPanel {
    private WSDLComponent comp;
    private Binding binding;
    private Vector<Vector> targetsModel;
    private MessagePartsModel targetsTableDataModel;
    private Vector<String> columnNames = new Vector();
    private AddHeaderPanel addHeaderPanel;
    boolean inSync = false;
    private JButton addAttachButton;
    private JButton addBodyButton;
    private JButton addHeaderButton;
    private JButton addPartButton;
    private JScrollPane jScrollPane2;
    private JTable jTable1;
    private JButton removeButton;

    public TargetsPanel(WSDLComponent c) {
        WSDLComponent b;
        this.comp = c;
        for (b = c; !(b instanceof Binding) && b != null; b = (WSDLComponent)b.getParent()) {
        }
        if (b != null && b instanceof Binding) {
            this.binding = (Binding)b;
        }
        this.initComponents();
        this.columnNames.add(NbBundle.getMessage(TargetsPanel.class, (String)"LBL_Targets_MessagePart"));
        this.columnNames.add(NbBundle.getMessage(TargetsPanel.class, (String)"LBL_Targets_Sign"));
        this.columnNames.add(NbBundle.getMessage(TargetsPanel.class, (String)"LBL_Targets_Encrypt"));
        this.columnNames.add(NbBundle.getMessage(TargetsPanel.class, (String)"LBL_Targets_Require"));
        this.sync();
    }

    private void sync() {
        this.inSync = true;
        this.targetsModel = SecurityPolicyModelHelper.getTargets(this.comp);
        this.targetsTableDataModel = new MessagePartsModel(this.getTargetsModel(), this.columnNames);
        this.jTable1.setModel(this.targetsTableDataModel);
        this.jTable1.doLayout();
        this.jTable1.setDefaultEditor(MessageElement.class, new XPathTableCellEditor());
        this.jTable1.getColumnModel().getColumn(0).setCellEditor(new XPathTableCellEditor());
        this.enableDisable();
        this.inSync = false;
    }

    private AddHeaderPanel getAddHeaderPanel() {
        return new AddHeaderPanel(this.binding);
    }

    private void saveTargetsModel() {
        if (!this.inSync) {
            SecurityPolicyModelHelper.getInstance(PolicyModelHelper.getConfigVersion(this.comp)).setTargets(this.comp, this.getTargetsModel());
            this.jTable1.setModel(new MessagePartsModel(this.getTargetsModel(), this.columnNames));
        }
    }

    private void enableDisable() {
    }

    private void initComponents() {
        this.addHeaderButton = new JButton();
        this.removeButton = new JButton();
        this.addPartButton = new JButton();
        this.addBodyButton = new JButton();
        this.jScrollPane2 = new JScrollPane();
        this.jTable1 = new JTable();
        this.addAttachButton = new JButton();
        this.addHeaderButton.setText(NbBundle.getMessage(TargetsPanel.class, (String)"LBL_AddHeader"));
        this.addHeaderButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TargetsPanel.this.addHeaderButtonActionPerformed(evt);
            }
        });
        this.removeButton.setText(NbBundle.getMessage(TargetsPanel.class, (String)"LBL_Remove"));
        this.removeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TargetsPanel.this.removeButtonActionPerformed(evt);
            }
        });
        this.addPartButton.setText(NbBundle.getMessage(TargetsPanel.class, (String)"LBL_AddXPath"));
        this.addPartButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TargetsPanel.this.addPartButtonActionPerformed(evt);
            }
        });
        this.addBodyButton.setText(NbBundle.getMessage(TargetsPanel.class, (String)"LBL_AddBody"));
        this.addBodyButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TargetsPanel.this.addBodyButtonActionPerformed(evt);
            }
        });
        this.jTable1.setModel(new DefaultTableModel(new Object[][]{{null, null, null, null}, {null, null, null, null}, {null, null, null, null}, {null, null, null, null}}, new String[]{"Title 1", "Title 2", "Title 3", "Title 4"}));
        this.jTable1.setShowVerticalLines(false);
        this.jTable1.setVerifyInputWhenFocusTarget(false);
        this.jScrollPane2.setViewportView(this.jTable1);
        this.addAttachButton.setText(NbBundle.getMessage(TargetsPanel.class, (String)"LBL_AddAttachment"));
        this.addAttachButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TargetsPanel.this.addAttachButtonActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((Component)this.jScrollPane2, -1, 358, Short.MAX_VALUE).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createParallelGroup(1, false).add((Component)this.addBodyButton, -1, -1, Short.MAX_VALUE).add((Component)this.addPartButton, -1, -1, Short.MAX_VALUE).add((Component)this.addHeaderButton, -1, -1, Short.MAX_VALUE).add((Component)this.removeButton, -1, -1, Short.MAX_VALUE)).add((Component)this.addAttachButton, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        layout.linkSize(new Component[]{this.addAttachButton, this.addBodyButton, this.addHeaderButton, this.addPartButton, this.removeButton}, 1);
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.addBodyButton).addPreferredGap(0).add((Component)this.addHeaderButton).addPreferredGap(0).add((Component)this.addPartButton).addPreferredGap(0).add((Component)this.addAttachButton).add(7, 7, 7).add((Component)this.removeButton)).add((Component)this.jScrollPane2, -1, 183, Short.MAX_VALUE)).addContainerGap()));
    }

    private void addBodyButtonActionPerformed(ActionEvent evt) {
        MessageBody body = new MessageBody();
        if (SecurityPolicyModelHelper.targetExists(this.getTargetsModel(), body) == null) {
            Vector<Object> row = new Vector<Object>();
            row.add(0, body);
            row.add(1, Boolean.TRUE);
            row.add(2, Boolean.FALSE);
            row.add(3, Boolean.FALSE);
            this.getTargetsModel().add(row);
            this.saveTargetsModel();
        }
    }

    private void removeButtonActionPerformed(ActionEvent evt) {
        int[] rows = this.jTable1.getSelectedRows();
        ArrayList<Vector> rowsToRemove = new ArrayList<Vector>();
        for (int i = 0; i < rows.length; ++i) {
            rowsToRemove.add(this.getTargetsModel().get(rows[i]));
        }
        for (Object e : rowsToRemove) {
            this.getTargetsModel().remove(e);
        }
        this.saveTargetsModel();
    }

    private void addPartButtonActionPerformed(ActionEvent evt) {
        Object button = DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Confirmation((Object)NbBundle.getMessage(TargetsPanel.class, (String)"WARNING_DISABLE_OPTIMSECURITY")));
        if (NotifyDescriptor.OK_OPTION.equals(button)) {
            MessageElement e = new MessageElement(NbBundle.getMessage(TargetsPanel.class, (String)"TXT_EditHere"));
            Vector<Object> row = new Vector<Object>();
            row.add(0, e);
            row.add(1, Boolean.FALSE);
            row.add(2, Boolean.FALSE);
            row.add(3, Boolean.TRUE);
            this.getTargetsModel().add(row);
            this.jTable1.updateUI();
        }
    }

    private void addHeaderButtonActionPerformed(ActionEvent evt) {
        this.addHeaderPanel = this.getAddHeaderPanel();
        DialogDescriptor dd = new DialogDescriptor((Object)this.addHeaderPanel, NbBundle.getMessage(TargetsPanel.class, (String)"LBL_SignEncryptChooser_AddHeaderTitle"), true, 2, DialogDescriptor.CANCEL_OPTION, 0, new HelpCtx(TargetsPanel.class), null);
        if (DialogDisplayer.getDefault().notify((NotifyDescriptor)dd).equals(DialogDescriptor.OK_OPTION) && this.addHeaderPanel != null) {
            if (this.addHeaderPanel.isAllHeaders()) {
                Vector<Object> row;
                MessageHeader h;
                for (String s : MessageHeader.ADDRESSING_HEADERS) {
                    h = new MessageHeader(s);
                    if (SecurityPolicyModelHelper.targetExists(this.getTargetsModel(), h) != null) continue;
                    row = new Vector<Object>();
                    row.add(0, h);
                    row.add(1, Boolean.TRUE);
                    row.add(2, Boolean.FALSE);
                    row.add(3, Boolean.FALSE);
                    this.getTargetsModel().add(row);
                }
                for (String s : MessageHeader.RM_HEADERS) {
                    h = new MessageHeader(s);
                    if (SecurityPolicyModelHelper.targetExists(this.getTargetsModel(), h) != null) continue;
                    row = new Vector();
                    row.add(0, h);
                    row.add(1, Boolean.TRUE);
                    row.add(2, Boolean.FALSE);
                    row.add(3, Boolean.FALSE);
                    this.getTargetsModel().add(row);
                }
            } else {
                String header = this.addHeaderPanel.getHeader();
                MessageHeader h = new MessageHeader(header);
                if (SecurityPolicyModelHelper.targetExists(this.getTargetsModel(), h) == null) {
                    Vector<Object> row = new Vector<Object>();
                    row.add(0, h);
                    row.add(1, Boolean.TRUE);
                    row.add(2, Boolean.FALSE);
                    row.add(3, Boolean.FALSE);
                    this.getTargetsModel().add(row);
                }
            }
            this.saveTargetsModel();
        }
    }

    private void addAttachButtonActionPerformed(ActionEvent evt) {
        MessageAttachments attch = new MessageAttachments();
        if (SecurityPolicyModelHelper.targetExists(this.getTargetsModel(), attch) == null) {
            Vector<Object> row = new Vector<Object>();
            row.add(0, attch);
            row.add(1, Boolean.TRUE);
            row.add(2, Boolean.FALSE);
            row.add(3, Boolean.FALSE);
            this.getTargetsModel().add(row);
            this.saveTargetsModel();
        }
    }

    public Vector<Vector> getTargetsModel() {
        return this.targetsModel;
    }

    private class MessagePartsModel
    extends DefaultTableModel {
        public MessagePartsModel(Vector<Vector> data, Vector columnNames) {
            super(data, columnNames);
        }

        @Override
        public boolean isCellEditable(int row, int column) {
            Vector rowVector = TargetsPanel.this.getTargetsModel().get(row);
            if (column == 0) {
                return rowVector.get(0) instanceof MessageElement;
            }
            if (column == 1 || column == 2) {
                return true;
            }
            if (column == 3) {
                return rowVector.get(0) instanceof MessageElement;
            }
            return false;
        }

        public Class getColumnClass(int columnIndex) {
            if (columnIndex == 0) {
                return TargetElement.class;
            }
            return Boolean.class;
        }
    }

    public static class XPathTableCellEditor
    extends AbstractCellEditor
    implements TableCellEditor {
        JTextField component = new JTextField();

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int rowIndex, int vColIndex) {
            if (isSelected) {
                this.component.setText(((MessageElement)value).getElement());
                return this.component;
            }
            return null;
        }

        @Override
        public Object getCellEditorValue() {
            return new MessageElement(this.component.getText());
        }
    }
}

