/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.dlight.api.execution;

import java.util.Collection;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import org.netbeans.modules.dlight.api.execution.DLightSessionConfiguration;
import org.netbeans.modules.dlight.api.execution.DLightTarget;
import org.netbeans.modules.dlight.api.impl.DLightSessionHandlerAccessor;
import org.netbeans.modules.dlight.api.impl.DLightSessionInternalReference;
import org.netbeans.modules.dlight.api.impl.DLightToolkitManager;
import org.netbeans.modules.dlight.api.tool.DLightConfiguration;
import org.netbeans.modules.dlight.util.DLightExecutorService;
import org.openide.util.Lookup;

public final class DLightToolkitManagement {
    private static final DLightToolkitManagement instance;
    private static final DLightToolkitManager toolkitManager;

    private DLightToolkitManagement() {
        assert (toolkitManager != null);
    }

    public static final DLightToolkitManagement getInstance() {
        return instance;
    }

    @Deprecated
    public Future<DLightSessionHandler> createSession(DLightTarget target, String configurationName) {
        return this.createSession(target, configurationName, null);
    }

    @Deprecated
    public Future<DLightSessionHandler> createSession(DLightTarget target, String configurationName, String sessionName) {
        final DLightSessionConfiguration sessionConfiguration = new DLightSessionConfiguration();
        sessionConfiguration.setDLightConfigurationName(configurationName);
        sessionConfiguration.setDLightTarget(target);
        sessionConfiguration.setSessionName(sessionName);
        return DLightExecutorService.submit((Callable)new Callable<DLightSessionHandler>(){

            @Override
            public DLightSessionHandler call() throws Exception {
                return toolkitManager.createSession(sessionConfiguration);
            }
        }, (String)("DLight [" + configurationName + "] Session Creation for " + target));
    }

    @Deprecated
    public Future<DLightSessionHandler> createSession(DLightTarget target, DLightConfiguration configuration) {
        return this.createSession(target, configuration, null);
    }

    @Deprecated
    public Future<DLightSessionHandler> createSession(DLightTarget target, DLightConfiguration configuration, String sessionName) {
        final DLightSessionConfiguration sessionConfiguration = new DLightSessionConfiguration();
        sessionConfiguration.setDLightConfiguration(configuration);
        sessionConfiguration.setDLightTarget(target);
        sessionConfiguration.setSessionName(sessionName);
        return DLightExecutorService.submit((Callable)new Callable<DLightSessionHandler>(){

            @Override
            public DLightSessionHandler call() throws Exception {
                return toolkitManager.createSession(sessionConfiguration);
            }
        }, (String)("DLight [" + configuration.getConfigurationName() + "] Session Creation for " + target));
    }

    public Future<DLightSessionHandler> createSession(final DLightSessionConfiguration sessionConfiguration) {
        return DLightExecutorService.submit((Callable)new Callable<DLightSessionHandler>(){

            @Override
            public DLightSessionHandler call() throws Exception {
                return toolkitManager.createSession(sessionConfiguration);
            }
        }, (String)(sessionConfiguration + ""));
    }

    public void startSession(DLightSessionHandler sessionHandler) {
        toolkitManager.startSession(sessionHandler);
    }

    public void stopSession(DLightSessionHandler sessionHandler) {
        toolkitManager.stopSession(sessionHandler);
    }

    private DLightSessionHandler create(DLightSessionInternalReference ref) {
        return new DLightSessionHandler(ref);
    }

    static {
        DLightSessionHandlerAccessor.setDefault(new DLightSessionHandlerAccessorImpl());
        Collection allManagers = Lookup.getDefault().lookupAll(DLightToolkitManager.class);
        toolkitManager = !allManagers.isEmpty() ? (DLightToolkitManager)allManagers.iterator().next() : null;
        instance = new DLightToolkitManagement();
    }

    private static final class DLightSessionHandlerAccessorImpl
    extends DLightSessionHandlerAccessor {
        private DLightSessionHandlerAccessorImpl() {
        }

        @Override
        public DLightSessionHandler create(DLightSessionInternalReference ref) {
            return DLightToolkitManagement.getInstance().create(ref);
        }

        @Override
        public DLightSessionInternalReference getSessionReferenceImpl(DLightSessionHandler handler) {
            return handler.getSessionReferenceImpl();
        }
    }

    public static final class DLightSessionHandler {
        private DLightSessionInternalReference ref;

        private DLightSessionHandler(DLightSessionInternalReference ref) {
            this.ref = ref;
        }

        DLightSessionInternalReference getSessionReferenceImpl() {
            return this.ref;
        }
    }
}

