/*
 * Decompiled with CFR 0.152.
 */
package org.easymock.internal;

import java.util.ArrayList;
import java.util.List;
import junit.framework.AssertionFailedError;
import org.easymock.internal.AbstractBehavior;
import org.easymock.internal.AssertionFailedErrorWrapper;
import org.easymock.internal.ExpectedMethodCall;
import org.easymock.internal.MethodCall;
import org.easymock.internal.Range;
import org.easymock.internal.Result;
import org.easymock.internal.ResultList;

public class OrderedBehavior
extends AbstractBehavior {
    private List methodCalls = new ArrayList();
    private List resultLists = new ArrayList();
    private int position = 0;

    public void addExpected(MethodCall methodCall, Result result, Range range) {
        ExpectedMethodCall matchableMethodCall = new ExpectedMethodCall(methodCall.getMethod(), methodCall.getArguments(), this.getMatcher(methodCall.getMethod()));
        if (!this.lastMethodCallEqualTo(matchableMethodCall)) {
            this.methodCalls.add(matchableMethodCall);
            this.resultLists.add(new ResultList());
        }
        ResultList resultList = (ResultList)this.resultLists.get(this.resultLists.size() - 1);
        resultList.add(result, range);
    }

    private boolean lastMethodCallEqualTo(ExpectedMethodCall matchableMethodCall) {
        if (this.methodCalls.isEmpty()) {
            return false;
        }
        ExpectedMethodCall lastMethodCall = (ExpectedMethodCall)this.methodCalls.get(this.methodCalls.size() - 1);
        return lastMethodCall.equals(matchableMethodCall);
    }

    public Result doAddActual(MethodCall methodCall) {
        Result defaultBehavior;
        ArrayList<ExpectedMethodCall> matchedCalls = new ArrayList<ExpectedMethodCall>();
        ArrayList<ResultList> matchedResultLists = new ArrayList<ResultList>();
        int tooManyCallsPosition = -1;
        while (this.position < this.methodCalls.size()) {
            ExpectedMethodCall expectedCall = (ExpectedMethodCall)this.methodCalls.get(this.position);
            ResultList resultList = (ResultList)this.resultLists.get(this.position);
            if (expectedCall.matches(methodCall)) {
                Result result = resultList.next();
                if (result != null) {
                    return result;
                }
                matchedCalls.add(expectedCall);
                matchedResultLists.add(resultList);
                tooManyCallsPosition = matchedCalls.size() - 1;
            } else if (!resultList.hasValidCallCount()) {
                matchedCalls.add(expectedCall);
                matchedResultLists.add(resultList);
                break;
            }
            ++this.position;
        }
        if ((defaultBehavior = this.getDefaultResult(methodCall.getMethod())) != null) {
            return defaultBehavior;
        }
        throw new AssertionFailedErrorWrapper(new AssertionFailedError(this.createFailureMessage(methodCall, matchedCalls, matchedResultLists, tooManyCallsPosition)));
    }

    private String createFailureMessage(MethodCall methodCall, List matchedCalls, List matchedResultLists, int tooManyCallsPosition) {
        String failureMessage = "";
        if (tooManyCallsPosition == -1) {
            failureMessage = failureMessage + "\n    " + methodCall.toString(this.getMatcher(methodCall.getMethod())) + ": " + new Range(2).expectedAndActual(1).replace('2', '0');
        }
        for (int i = 0; i < matchedCalls.size(); ++i) {
            ExpectedMethodCall call = (ExpectedMethodCall)matchedCalls.get(i);
            ResultList list = (ResultList)matchedResultLists.get(i);
            failureMessage = failureMessage + "\n    " + call.toString() + ": ";
            int count = list.getCallCount() + (i == tooManyCallsPosition ? 1 : 0);
            failureMessage = failureMessage + list.getMessage(count);
        }
        return failureMessage;
    }

    public void doVerify() {
        String failureMessage = "";
        boolean verifyFailed = false;
        for (int i = this.position; i < this.methodCalls.size(); ++i) {
            ExpectedMethodCall call = (ExpectedMethodCall)this.methodCalls.get(i);
            ResultList list = (ResultList)this.resultLists.get(i);
            failureMessage = failureMessage + "\n    " + call.toString() + ": " + list.getMessage();
            if (list.hasValidCallCount()) continue;
            verifyFailed = true;
        }
        if (verifyFailed) {
            throw new AssertionFailedErrorWrapper(new AssertionFailedError(failureMessage));
        }
    }
}

