/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.extension;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.maven.artifact.ArtifactUtils;
import org.apache.maven.errors.ExtensionErrorReporterAspect;
import org.apache.maven.execution.MavenExecutionRequest;
import org.apache.maven.extension.BuildExtensionScanner;
import org.apache.maven.extension.ExtensionManager;
import org.apache.maven.extension.ExtensionManagerException;
import org.apache.maven.extension.ExtensionScanningException;
import org.apache.maven.model.Build;
import org.apache.maven.model.Extension;
import org.apache.maven.model.Model;
import org.apache.maven.model.Parent;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.PluginManagement;
import org.apache.maven.profiles.ProfileManager;
import org.apache.maven.profiles.activation.DefaultProfileActivationContext;
import org.apache.maven.profiles.activation.ProfileActivationContext;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectBuilder;
import org.apache.maven.project.ProjectBuilderConfiguration;
import org.apache.maven.project.ProjectBuildingException;
import org.apache.maven.project.build.model.ModelLineage;
import org.apache.maven.project.build.model.ModelLineageBuilder;
import org.apache.maven.project.build.model.ModelLineageIterator;
import org.apache.maven.project.interpolation.ModelInterpolationException;
import org.apache.maven.project.interpolation.ModelInterpolator;
import org.apache.maven.reactor.MissingModuleException;
import org.codehaus.plexus.logging.LogEnabled;
import org.codehaus.plexus.logging.Logger;
import org.codehaus.plexus.logging.console.ConsoleLogger;

public class DefaultBuildExtensionScanner
implements BuildExtensionScanner,
LogEnabled {
    private Logger logger;
    private ExtensionManager extensionManager;
    private MavenProjectBuilder projectBuilder;
    private ModelLineageBuilder modelLineageBuilder;
    private ModelInterpolator modelInterpolator;
    private MavenProject basicSuperProject;

    public DefaultBuildExtensionScanner() {
    }

    protected DefaultBuildExtensionScanner(ExtensionManager extensionManager, MavenProjectBuilder projectBuilder, ModelLineageBuilder modelLineageBuilder, ModelInterpolator modelInterpolator, Logger logger) {
        this.extensionManager = extensionManager;
        this.projectBuilder = projectBuilder;
        this.modelLineageBuilder = modelLineageBuilder;
        this.modelInterpolator = modelInterpolator;
        this.logger = logger;
    }

    public void scanForBuildExtensions(List files, MavenExecutionRequest request, boolean ignoreMissingModules) throws ExtensionScanningException, MissingModuleException {
        ArrayList visited = new ArrayList();
        ArrayList internalFiles = new ArrayList();
        internalFiles.addAll(files);
        for (File pom : files) {
            this.scanInternal(pom, request, visited, internalFiles, ignoreMissingModules);
        }
    }

    public void scanForBuildExtensions(File pom, MavenExecutionRequest request, boolean ignoreMissingModules) throws ExtensionScanningException, MissingModuleException {
        ArrayList<File> internalFiles = new ArrayList<File>();
        internalFiles.add(pom);
        this.scanInternal(pom, request, new ArrayList(), internalFiles, ignoreMissingModules);
    }

    /*
     * WARNING - void declaration
     */
    private void scanInternal(File file, MavenExecutionRequest mavenExecutionRequest, List list, List list2, boolean bl) throws ExtensionScanningException, MissingModuleException {
        File file2 = file;
        MavenExecutionRequest mavenExecutionRequest2 = mavenExecutionRequest;
        List list3 = list;
        List list4 = list2;
        boolean bl2 = bl;
        Object[] objectArray = new Object[]{file2, mavenExecutionRequest2};
        ExtensionErrorReporterAspect.ajc$cflowStack$0.push(objectArray);
        try {
            void pom;
            try {
                void request;
                List originalRemoteRepositories = this.getInitialRemoteRepositories(request.getProjectBuildingConfiguration());
                this.getLogger().debug("Pre-scanning POM lineage of: " + pom + " for build extensions.");
                ModelLineage lineage = this.buildModelLineage((File)pom, request.getProjectBuildingConfiguration(), originalRemoteRepositories);
                HashMap<Object, Object> inheritedInterpolationValues = new HashMap<Object, Object>();
                ArrayList inheritedRemoteRepositories = new ArrayList();
                inheritedRemoteRepositories.addAll(originalRemoteRepositories);
                HashMap managedPluginsWithExtensionsFlag = new HashMap();
                HashMap managedPlugins = new HashMap();
                ModelLineageIterator lineageIterator = lineage.reversedLineageIterator();
                while (lineageIterator.hasNext()) {
                    void ignoreMissingModules;
                    void reactorFiles;
                    void visitedModelIds;
                    Model model;
                    Model model2 = (Model)lineageIterator.next();
                    File modelPom = lineageIterator.getPOMFile();
                    List remoteRepos = lineageIterator.getArtifactRepositories();
                    if (remoteRepos != null && !remoteRepos.isEmpty()) {
                        inheritedRemoteRepositories.addAll(remoteRepos);
                    }
                    String key = this.createKey(model2);
                    if (inheritedInterpolationValues == null) {
                        inheritedInterpolationValues = new HashMap();
                    }
                    boolean bl3 = false;
                    Properties properties = request.getUserProperties();
                    HashMap<Object, Object> hashMap = inheritedInterpolationValues;
                    Model model3 = model2;
                    try {
                        model = this.modelInterpolator.interpolate(model3, hashMap, properties, bl3);
                    }
                    catch (ModelInterpolationException modelInterpolationException) {
                        if (ExtensionErrorReporterAspect.ajc$cflowStack$0.isValid()) {
                            ExtensionErrorReporterAspect.aspectOf().ajc$afterThrowing$org_apache_maven_errors_ExtensionErrorReporterAspect$2$ec37f9c7((File)ExtensionErrorReporterAspect.ajc$cflowStack$0.get(0), (MavenExecutionRequest)ExtensionErrorReporterAspect.ajc$cflowStack$0.get(1), model3, hashMap, modelInterpolationException);
                        }
                        throw modelInterpolationException;
                    }
                    model2 = model;
                    this.grabManagedPluginsWithExtensionsFlagTurnedOn(model2, managedPluginsWithExtensionsFlag, managedPlugins);
                    Properties modelProps = model2.getProperties();
                    if (modelProps != null) {
                        inheritedInterpolationValues.putAll(modelProps);
                    }
                    if (model2.getVersion() != null) {
                        inheritedInterpolationValues.put("project.version", model2.getVersion());
                    }
                    if (model2.getArtifactId() != null) {
                        inheritedInterpolationValues.put("project.artifactId", model2.getArtifactId());
                    }
                    if (model2.getGroupId() != null) {
                        inheritedInterpolationValues.put("project.groupId", model2.getGroupId());
                    }
                    if (visitedModelIds.contains(key)) {
                        this.getLogger().debug("Already visited: " + key + "; continuing.");
                        continue;
                    }
                    visitedModelIds.add(key);
                    this.getLogger().debug("Checking: " + model2.getId() + " for extensions. (It has " + model2.getModules().size() + " modules.)");
                    this.checkModelBuildForExtensions(model2, (MavenExecutionRequest)request, inheritedRemoteRepositories, managedPluginsWithExtensionsFlag, managedPlugins);
                    if (!reactorFiles.contains(modelPom)) {
                        this.getLogger().debug("POM: " + modelPom + " is not in the current reactor. Its modules will not be scanned.");
                        continue;
                    }
                    if (!request.isRecursive()) continue;
                    this.checkModulesForExtensions(modelPom, model2, (MavenExecutionRequest)request, originalRemoteRepositories, (List)visitedModelIds, (List)reactorFiles, (boolean)ignoreMissingModules);
                }
            }
            catch (ModelInterpolationException e) {
                throw new ExtensionScanningException("Failed to interpolate model from: " + pom + " prior to scanning for extensions.", (File)pom, e);
            }
        }
        finally {
            ExtensionErrorReporterAspect.ajc$cflowStack$0.pop();
        }
    }

    private void grabManagedPluginsWithExtensionsFlagTurnedOn(Model model, Map managedPluginsWithExtensionsFlag, Map managedPlugins) {
        List plugins;
        PluginManagement pluginManagement;
        Build build = model.getBuild();
        if (build != null && (pluginManagement = build.getPluginManagement()) != null && (plugins = pluginManagement.getPlugins()) != null && !plugins.isEmpty()) {
            for (Plugin plugin : plugins) {
                if (plugin.isExtensions()) {
                    managedPluginsWithExtensionsFlag.put(plugin.getKey(), plugin);
                }
                managedPlugins.put(plugin.getKey(), plugin);
            }
        }
    }

    private String createKey(Model model) {
        Parent parent = model.getParent();
        String groupId = model.getGroupId();
        if (groupId == null) {
            groupId = parent.getGroupId();
        }
        String artifactId = model.getArtifactId();
        return String.valueOf(groupId) + ":" + artifactId;
    }

    private void checkModulesForExtensions(File containingPom, Model model, MavenExecutionRequest request, List originalRemoteRepositories, List visitedModelIds, List reactorFiles, boolean ignoreMissingModules) throws ExtensionScanningException, MissingModuleException {
        List modules = model.getModules();
        if (modules != null) {
            File basedir = containingPom.getParentFile();
            this.getLogger().debug("Basedir is: " + basedir);
            for (String moduleSubpath : modules) {
                File modulePomDirectory;
                this.getLogger().debug("Scanning module: " + moduleSubpath);
                try {
                    modulePomDirectory = new File(basedir, moduleSubpath).getCanonicalFile();
                    if (modulePomDirectory.equals(basedir.getCanonicalFile())) {
                        break;
                    }
                }
                catch (IOException e) {
                    throw new ExtensionScanningException("Error getting canonical path for modulePomDirectory.", containingPom, moduleSubpath, e);
                }
                if (modulePomDirectory.isDirectory()) {
                    this.getLogger().debug("Assuming POM file 'pom.xml' in module: " + moduleSubpath + " under basedir: " + basedir);
                    modulePomDirectory = new File(modulePomDirectory, "pom.xml");
                }
                if (!modulePomDirectory.exists()) {
                    if (ignoreMissingModules) continue;
                    throw new MissingModuleException(moduleSubpath, modulePomDirectory, containingPom);
                }
                reactorFiles.add(modulePomDirectory);
                this.scanInternal(modulePomDirectory, request, visitedModelIds, reactorFiles, ignoreMissingModules);
            }
        }
    }

    private void checkModelBuildForExtensions(Model model, MavenExecutionRequest request, List remoteRepositories, Map managedPluginsWithExtensionsFlag, Map managedPlugins) throws ExtensionScanningException {
        this.getLogger().debug("Checking " + model.getId() + " for extensions.");
        Build build = model.getBuild();
        if (build != null) {
            List plugins;
            List extensions = build.getExtensions();
            if (extensions != null && !extensions.isEmpty()) {
                for (Extension extension : extensions) {
                    this.getLogger().debug("Adding extension: " + ArtifactUtils.versionlessKey(extension.getGroupId(), extension.getArtifactId()) + " from model: " + model.getId());
                    try {
                        this.extensionManager.addExtension(extension, model, remoteRepositories, request);
                    }
                    catch (ExtensionManagerException e) {
                        throw new ExtensionScanningException("Cannot resolve pre-scanned extension artifact: " + extension.getGroupId() + ":" + extension.getArtifactId() + ": " + e.getMessage(), model, extension, e);
                    }
                }
            }
            if ((plugins = build.getPlugins()) != null && !plugins.isEmpty()) {
                for (Plugin plugin : plugins) {
                    if (!plugin.isExtensions() && !managedPluginsWithExtensionsFlag.containsKey(plugin.getKey())) continue;
                    this.getLogger().debug("Adding plugin: " + plugin.getKey() + " as an extension(from model: " + model.getId() + ")");
                    Plugin manPlugin = (Plugin)managedPlugins.get(plugin.getKey());
                    if (plugin.getVersion() == null && manPlugin != null) {
                        plugin.setVersion(manPlugin.getVersion());
                    }
                    try {
                        this.extensionManager.addPluginAsExtension(plugin, model, remoteRepositories, request);
                    }
                    catch (ExtensionManagerException e) {
                        throw new ExtensionScanningException("Cannot resolve pre-scanned plugin artifact (for use as an extension): " + plugin.getKey() + ": " + e.getMessage(), model, plugin, e);
                    }
                }
            }
        }
    }

    private ModelLineage buildModelLineage(File pom, ProjectBuilderConfiguration config, List originalRemoteRepositories) throws ExtensionScanningException {
        ModelLineage lineage;
        ProfileManager profileManager = config.getGlobalProfileManager();
        ProfileActivationContext profileActivationContext = profileManager == null ? new DefaultProfileActivationContext(config.getExecutionProperties(), false) : profileManager.getProfileActivationContext();
        boolean suppressActivatorFailure = profileActivationContext.isCustomActivatorFailureSuppressed();
        try {
            try {
                this.getLogger().debug("Building model-lineage for: " + pom + " to pre-scan for extensions.");
                profileActivationContext.setCustomActivatorFailureSuppressed(true);
                lineage = this.modelLineageBuilder.buildModelLineage(pom, config, originalRemoteRepositories, false, true);
            }
            catch (ProjectBuildingException e) {
                throw new ExtensionScanningException("Error building model lineage in order to pre-scan for extensions: " + e.getMessage(), pom, e);
            }
        }
        finally {
            profileActivationContext.setCustomActivatorFailureSuppressed(suppressActivatorFailure);
        }
        return lineage;
    }

    private List getInitialRemoteRepositories(ProjectBuilderConfiguration config) throws ExtensionScanningException {
        if (this.basicSuperProject == null) {
            try {
                this.basicSuperProject = this.projectBuilder.buildStandaloneSuperProject(config);
            }
            catch (ProjectBuildingException e) {
                throw new ExtensionScanningException("Error building super-POM for retrieving the default remote repository list: " + e.getMessage(), e);
            }
        }
        return this.basicSuperProject.getRemoteArtifactRepositories();
    }

    protected Logger getLogger() {
        if (this.logger == null) {
            this.logger = new ConsoleLogger(0, "DefaultBuildExtensionScanner:internal");
        }
        return this.logger;
    }

    public void enableLogging(Logger logger) {
        this.logger = logger;
    }
}

