/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.windows;

import java.util.MissingResourceException;
import org.openide.util.NbBundle;
import org.openide.windows.TopComponent;

public final class Switches {
    public static boolean isTopComponentDragAndDropEnabled() {
        return Switches.getSwitchValue("TopComponent.DragAndDrop.Enabled", true);
    }

    public static boolean isDraggingEnabled(TopComponent tc) {
        return !Boolean.TRUE.equals(tc.getClientProperty((Object)"netbeans.winsys.tc.dragging_disabled"));
    }

    public static boolean isTopComponentUndockingEnabled() {
        return Switches.getSwitchValue("TopComponent.Undocking.Enabled", true);
    }

    public static boolean isUndockingEnabled(TopComponent tc) {
        return !Boolean.TRUE.equals(tc.getClientProperty((Object)"netbeans.winsys.tc.undocking_disabled"));
    }

    public static boolean isTopComponentSlidingEnabled() {
        return Switches.getSwitchValue("TopComponent.Sliding.Enabled", true);
    }

    public static boolean isSlidingEnabled(TopComponent tc) {
        return !Boolean.TRUE.equals(tc.getClientProperty((Object)"netbeans.winsys.tc.sliding_disabled"));
    }

    public static boolean isTopComponentResizingEnabled() {
        return Switches.getSwitchValue("TopComponent.Resizing.Enabled", true);
    }

    public static boolean isViewTopComponentClosingEnabled() {
        return Switches.getSwitchValue("View.TopComponent.Closing.Enabled", true);
    }

    public static boolean isEditorTopComponentClosingEnabled() {
        return Switches.getSwitchValue("Editor.TopComponent.Closing.Enabled", true);
    }

    public static boolean isClosingEnabled(TopComponent tc) {
        return !Boolean.TRUE.equals(tc.getClientProperty((Object)"netbeans.winsys.tc.closing_disabled"));
    }

    public static boolean isTopComponentMaximizationEnabled() {
        return Switches.getSwitchValue("TopComponent.Maximization.Enabled", true);
    }

    public static boolean isMaximizationEnabled(TopComponent tc) {
        return !Boolean.TRUE.equals(tc.getClientProperty((Object)"netbeans.winsys.tc.maximization_disabled"));
    }

    public static boolean isSplitterRespectMinimumSizeEnabled() {
        return Switches.getSwitchValue("Splitter.Respect.MinimumSize.Enabled", true);
    }

    private static boolean getSwitchValue(String switchName, boolean defaultValue) {
        boolean result = defaultValue;
        try {
            String resValue = NbBundle.getMessage(Switches.class, (String)switchName);
            result = "true".equals(resValue.toLowerCase());
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
        return result;
    }

    private Switches() {
    }
}

