/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.css.gsf;

import java.util.ArrayList;
import java.util.List;
import javax.swing.SwingUtilities;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.text.Position;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.Utilities;
import org.netbeans.modules.csl.api.KeystrokeHandler;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.csl.spi.ParserResult;
import org.netbeans.modules.css.editor.LexerUtils;
import org.netbeans.modules.css.gsf.api.CssParserResult;
import org.netbeans.modules.css.lexer.api.CssTokenId;
import org.netbeans.modules.css.parser.SimpleNode;
import org.netbeans.modules.css.parser.SimpleNodeUtil;
import org.netbeans.modules.editor.indent.api.Indent;
import org.netbeans.modules.parsing.api.Snapshot;

public class CssBracketCompleter
implements KeystrokeHandler {
    private static final char[][] PAIRS = new char[][]{{'{', '}'}, {'\"', '\"'}, {'\'', '\''}};
    private char justAddedPair;
    private int justAddedPairOffset = -1;

    private int pairIndex(char ch) {
        for (int i = 0; i < PAIRS.length; ++i) {
            char pair = PAIRS[i][0];
            if (pair != ch) continue;
            return i;
        }
        return -1;
    }

    public boolean beforeCharInserted(Document doc, int dot, JTextComponent target, char ch) throws BadLocationException {
        TokenSequence<CssTokenId> ts;
        int pairIdx;
        TokenSequence<CssTokenId> ts2;
        Caret caret = target.getCaret();
        if (this.justAddedPair == ch && this.justAddedPairOffset == dot) {
            this.justAddedPair = '\u0000';
            this.justAddedPairOffset = -1;
            caret.setDot(dot + 1);
            return true;
        }
        this.justAddedPair = '\u0000';
        this.justAddedPairOffset = -1;
        if (ch == '}' && (ts2 = LexerUtils.getCssTokenSequence(doc, dot)) != null) {
            ts2.move(dot);
            if (ts2.moveNext() && ts2.token().id() == CssTokenId.RBRACE) {
                caret.setDot(dot + 1);
                return true;
            }
        }
        if ((pairIdx = this.pairIndex(ch)) == -1) {
            return false;
        }
        if (target.getSelectionStart() != dot) {
            return false;
        }
        if ((ch == '\'' || ch == '\"') && (ts = LexerUtils.getCssTokenSequence(doc, dot)) != null) {
            Token t;
            int diff = ts.move(dot);
            if (ts.moveNext() && (t = ts.token()).id() == CssTokenId.STRING) {
                char front = t.text().charAt(diff);
                if (front == ch) {
                    caret.setDot(dot + 1);
                    return true;
                }
                return false;
            }
            ts.move(dot);
            while (ts.movePrevious()) {
                t = ts.token();
                if (t.text().charAt(0) == ch) {
                    if (t.id() == CssTokenId.STRING || t.id() == CssTokenId.STRING1 || t.id() == CssTokenId.STRING2) break;
                    return false;
                }
                if (t.id() != CssTokenId.LBRACE && t.id() != CssTokenId.RBRACE && t.id() != CssTokenId.SEMICOLON) continue;
                break;
            }
        }
        this.justAddedPair = PAIRS[pairIdx][1];
        this.justAddedPairOffset = dot + 1;
        doc.insertString(dot, String.valueOf(PAIRS[pairIdx][0]), null);
        doc.insertString(dot + 1, String.valueOf(this.justAddedPair), null);
        caret.setDot(dot + 1);
        return true;
    }

    public boolean afterCharInserted(Document doc, int caretOffset, JTextComponent target, char ch) throws BadLocationException {
        if ('}' != ch) {
            return false;
        }
        int lineStart = Utilities.getRowFirstNonWhite((BaseDocument)((BaseDocument)doc), (int)caretOffset);
        if (lineStart != caretOffset) {
            return false;
        }
        this.reindentLater((BaseDocument)doc, caretOffset);
        return false;
    }

    public boolean charBackspaced(Document doc, int dot, JTextComponent target, char ch) throws BadLocationException {
        if (this.justAddedPairOffset - 1 == dot) {
            doc.remove(dot, 1);
        }
        this.justAddedPair = '\u0000';
        this.justAddedPairOffset = -1;
        return false;
    }

    public int beforeBreak(Document doc, int dot, JTextComponent jtc) throws BadLocationException {
        if (dot == 0 || dot == doc.getLength()) {
            return -1;
        }
        String context = doc.getText(dot - 1, 2);
        if ("{}".equals(context)) {
            BaseDocument bdoc = (BaseDocument)doc;
            doc.insertString(dot, "\n", null);
            jtc.getCaret().setDot(dot);
            this.reindentLater(bdoc, dot);
        }
        return -1;
    }

    public OffsetRange findMatching(Document doc, int caretOffset) {
        return OffsetRange.NONE;
    }

    public List<OffsetRange> findLogicalRanges(ParserResult info, int caretOffset) {
        SimpleNode node;
        ArrayList<OffsetRange> ranges = new ArrayList<OffsetRange>(2);
        SimpleNode root = ((CssParserResult)info).root();
        Snapshot snapshot = info.getSnapshot();
        if (root != null && (node = SimpleNodeUtil.findDescendant(root, snapshot.getEmbeddedOffset(caretOffset))) != null) {
            do {
                OffsetRange last;
                int from = snapshot.getOriginalOffset(node.startOffset());
                int to = snapshot.getOriginalOffset(node.endOffset());
                if (from == -1 || to == -1) continue;
                OffsetRange offsetRange = last = ranges.isEmpty() ? null : ranges.get(ranges.size() - 1);
                if (last != null && last.getEnd() - last.getStart() >= to - from) continue;
                ranges.add(new OffsetRange(from, to));
            } while ((node = (SimpleNode)node.jjtGetParent()) != null);
        }
        return ranges;
    }

    public int getNextWordOffset(Document doc, int caretOffset, boolean reverse) {
        return -1;
    }

    private void reindentLater(final BaseDocument doc, int dotPos) throws BadLocationException {
        final Position from = doc.createPosition(Utilities.getRowStart((BaseDocument)doc, (int)dotPos));
        final Position to = doc.createPosition(Utilities.getRowEnd((BaseDocument)doc, (int)dotPos));
        SwingUtilities.invokeLater(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                final Indent indent = Indent.get((Document)doc);
                indent.lock();
                try {
                    doc.runAtomic(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                indent.reindent(from.getOffset(), to.getOffset());
                                System.out.println("formatted");
                            }
                            catch (BadLocationException badLocationException) {
                                // empty catch block
                            }
                        }
                    });
                }
                finally {
                    indent.unlock();
                }
            }
        });
    }
}

