/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.css.editor.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.css.editor.model.CssRule;
import org.netbeans.modules.css.editor.model.CssRuleItem;
import org.netbeans.modules.css.gsf.api.CssParserResult;
import org.netbeans.modules.css.parser.NodeVisitor;
import org.netbeans.modules.css.parser.SimpleNode;
import org.netbeans.modules.css.parser.SimpleNodeUtil;
import org.netbeans.modules.css.parser.Token;
import org.netbeans.modules.parsing.api.ParserManager;
import org.netbeans.modules.parsing.api.ResultIterator;
import org.netbeans.modules.parsing.api.Snapshot;
import org.netbeans.modules.parsing.api.Source;
import org.netbeans.modules.parsing.api.UserTask;
import org.netbeans.modules.parsing.spi.ParseException;
import org.netbeans.modules.web.common.api.WebUtils;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;

public final class CssModel {
    private static final Logger LOGGER = Logger.getLogger(CssModel.class.getName());
    private static final boolean LOG = LOGGER.isLoggable(Level.FINE);
    private final List<CssRule> rules = new ArrayList<CssRule>(10);
    private final Collection<String> imported_files = new ArrayList<String>();
    private Snapshot snapshot;
    private FileObject fileObject;

    public static CssModel create(CssParserResult result) {
        return new CssModel(result.getSnapshot(), result.root());
    }

    private CssModel(Snapshot snapshot, SimpleNode root) {
        this.snapshot = snapshot;
        this.fileObject = snapshot.getSource().getFileObject();
        if (root != null) {
            this.updateModel(snapshot, root);
        }
    }

    public Snapshot getSnapshot() {
        return this.snapshot;
    }

    public List<CssRule> rules() {
        return this.rules;
    }

    public Collection<String> getImportedFileNames() {
        return this.imported_files;
    }

    public Collection<FileObject> getImportedFiles() {
        FileObject baseFolder = this.snapshot.getSource().getFileObject().getParent();
        ArrayList<FileObject> files = new ArrayList<FileObject>();
        for (String fileNamePath : this.getImportedFileNames()) {
            FileObject file = baseFolder.getFileObject(fileNamePath);
            if (file == null) continue;
            files.add(file);
        }
        return files;
    }

    public Collection<CssModel> getImportedFileModels() {
        HashSet<CssModel> models = new HashSet<CssModel>();
        this.processModels(models, this);
        return models;
    }

    private void processModels(Collection<CssModel> models, CssModel model) {
        for (FileObject importedFile : model.getImportedFiles()) {
            CssModel created;
            final AtomicReference ref = new AtomicReference();
            if (importedFile.isValid() && importedFile.getMIMEType().equals("text/x-css")) {
                try {
                    Source source = Source.create((FileObject)importedFile);
                    ParserManager.parse(Collections.singleton(source), (UserTask)new UserTask(){

                        public void run(ResultIterator resultIterator) throws Exception {
                            CssParserResult result = (CssParserResult)resultIterator.getParserResult();
                            ref.set(CssModel.create(result));
                        }
                    });
                }
                catch (ParseException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
            if ((created = (CssModel)ref.get()) == null || !models.add(created)) continue;
            this.processModels(models, created);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CssRule ruleForOffset(int offset) {
        List<CssRule> list = this.rules;
        synchronized (list) {
            if (this.rules != null) {
                for (CssRule rule : this.rules()) {
                    if (rule.getRuleNameOffset() > offset || rule.getRuleCloseBracketOffset() < offset) continue;
                    return rule;
                }
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void updateModel(final Snapshot snapshot, SimpleNode root) {
        List<CssRule> list = this.rules;
        synchronized (list) {
            NodeVisitor styleRuleVisitor = new NodeVisitor(){

                @Override
                public void visit(SimpleNode node) {
                    Token importedFile;
                    if (node.kind() == 19) {
                        Token t = node.jjtGetFirstToken();
                        Token last = node.jjtGetLastToken();
                        int openCurlyBracketOffset = -1;
                        int closeCurlyBracketOffset = -1;
                        ArrayList<Integer> semicolons = new ArrayList<Integer>();
                        ArrayList<Integer> colons = new ArrayList<Integer>();
                        while (t != null && t.offset <= last.offset) {
                            if (t.kind == 8) {
                                openCurlyBracketOffset = t.offset;
                            } else if (t.kind == 9) {
                                closeCurlyBracketOffset = t.offset;
                            } else if (t.kind == 12) {
                                semicolons.add(t.offset);
                            } else if (t.kind == 13) {
                                colons.add(t.offset);
                            }
                            t = t.next;
                        }
                        SimpleNode selectortList = SimpleNodeUtil.getChildByType(node, 20);
                        SimpleNode[] declarations = SimpleNodeUtil.getChildrenByType(node, 29);
                        ArrayList<CssRuleItem> ruleItems = new ArrayList<CssRuleItem>(declarations.length);
                        for (int i = 0; i < declarations.length; ++i) {
                            SimpleNode declaration = declarations[i];
                            SimpleNode property = SimpleNodeUtil.getChildByType(declaration, 18);
                            SimpleNode value = SimpleNodeUtil.getChildByType(declaration, 31);
                            if (property == null || value == null) {
                                return;
                            }
                            int semicolonOffset = i < semicolons.size() ? (Integer)semicolons.get(i) : -1;
                            int colonOffset = i < colons.size() ? (Integer)colons.get(i) : -1;
                            CssRuleItem ruleItem = new CssRuleItem(property.image().trim(), property.startOffset(), value.image().trim(), value.startOffset(), colonOffset, semicolonOffset);
                            ruleItems.add(ruleItem);
                        }
                        String ruleName = selectortList.image().trim();
                        CssRule rule = new CssRule(snapshot, ruleName, selectortList.startOffset(), openCurlyBracketOffset, closeCurlyBracketOffset, ruleItems);
                        CssModel.this.rules.add(rule);
                    } else if (node.kind() == 6 && (importedFile = SimpleNodeUtil.getNodeToken(node, 23)) != null) {
                        CssModel.this.imported_files.add(WebUtils.unquotedValue((CharSequence)importedFile.image));
                    }
                }
            };
            SimpleNodeUtil.visitChildren(root, styleRuleVisitor);
            if (LOG) {
                LOGGER.fine("CssModel parse tree:");
                LOGGER.fine(root.dump());
                LOGGER.fine("CssModel structure:");
                for (CssRule rule : this.rules) {
                    LOGGER.fine(rule.toString());
                }
            }
        }
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CssModel other = (CssModel)obj;
        return this.fileObject == other.fileObject || this.fileObject != null && this.fileObject.equals(other.fileObject);
    }

    public int hashCode() {
        int hash = 7;
        hash = 61 * hash + (this.fileObject != null ? this.fileObject.hashCode() : 0);
        return hash;
    }
}

