/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.identity.profile.api.configurator.impl.dynamic;

import java.io.File;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.netbeans.modules.identity.profile.api.configurator.ConfiguratorException;
import org.netbeans.modules.identity.profile.api.configurator.ServerProperties;
import org.openide.util.NbBundle;

class ClassLoaderManager {
    private static final String AM_SYSTEM_PROPERTIES_CLASS = "com.iplanet.am.util.SystemProperties";
    private static final String AM_INITIALIZE_PROPERTIES_METHOD = "initializeProperties";
    private static String[] dependentJars = new String[]{"/addons/accessmanager/amclientsdk.jar", "/lib/javaee.jar", "/lib/webservices-rt.jar"};
    private static ClassLoaderManager instance;
    private Map<String, AMClientSDKClassLoader> classLoaderCache = new HashMap<String, AMClientSDKClassLoader>();

    private ClassLoaderManager() {
    }

    public static ClassLoaderManager getDefault() {
        if (instance == null) {
            instance = new ClassLoaderManager();
        }
        return instance;
    }

    public ClassLoader getClassLoader(ServerProperties properties) {
        String key = properties.getProperty("org.netbeans.modules.identity.profile.api.configurator.id");
        AMClientSDKClassLoader classLoader = this.classLoaderCache.get(key);
        if (classLoader != null && !properties.equals(classLoader.getProperties())) {
            classLoader = null;
        }
        if (classLoader == null) {
            classLoader = this.createClassLoader(properties);
            this.classLoaderCache.put(key, classLoader);
        }
        return classLoader;
    }

    public void removeClassLoader(ServerProperties properties) {
        this.classLoaderCache.remove(properties.getProperty("org.netbeans.modules.identity.profile.api.configurator.id"));
    }

    private AMClientSDKClassLoader createClassLoader(ServerProperties properties) {
        String asRoot = properties.getProperty("org.netbeans.modules.identity.profile.api.configurator.asroot");
        if (asRoot != null) {
            URL[] urls = new URL[dependentJars.length];
            for (int i = 0; i < dependentJars.length; ++i) {
                File jarFile = new File(asRoot + dependentJars[i]);
                try {
                    URL url;
                    urls[i] = url = jarFile.toURL();
                    continue;
                }
                catch (MalformedURLException ex) {
                    // empty catch block
                }
            }
            return new AMClientSDKClassLoader(urls, properties);
        }
        return new AMClientSDKClassLoader(new URL[0], ClassLoaderManager.class.getClassLoader(), properties);
    }

    private static class AMClientSDKClassLoader
    extends URLClassLoader {
        private ServerProperties properties;

        public AMClientSDKClassLoader(URL[] urls, ServerProperties properties) {
            super(urls);
            this.init(properties);
        }

        public AMClientSDKClassLoader(URL[] urls, ClassLoader parent, ServerProperties properties) {
            super(urls, parent);
            this.init(properties);
        }

        private void init(ServerProperties properties) {
            this.properties = (ServerProperties)properties.clone();
            try {
                Class<?> systemPropClazz = this.loadClass(ClassLoaderManager.AM_SYSTEM_PROPERTIES_CLASS);
                Method method = systemPropClazz.getMethod(ClassLoaderManager.AM_INITIALIZE_PROPERTIES_METHOD, Properties.class);
                method.invoke(null, properties);
            }
            catch (ClassNotFoundException ex) {
                throw new ConfiguratorException(NbBundle.getMessage(ClassLoaderManager.class, (String)"TXT_FailedToLoadAMClientSDK"));
            }
            catch (Exception ex) {
                throw ConfiguratorException.create(ex);
            }
        }

        public ServerProperties getProperties() {
            return this.properties;
        }
    }
}

