/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.glassfish.javaee;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.glassfish.javaee.Hk2DeploymentManager;
import org.netbeans.modules.glassfish.javaee.ResourceModifier;
import org.netbeans.modules.glassfish.javaee.SunMessageDestination;
import org.netbeans.modules.glassfish.spi.GlassfishModule;
import org.netbeans.modules.glassfish.spi.TreeParser;
import org.netbeans.modules.j2ee.deployment.common.api.ConfigurationException;
import org.netbeans.modules.j2ee.deployment.common.api.MessageDestination;
import org.netbeans.modules.j2ee.deployment.plugins.spi.MessageDestinationDeployment;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class Hk2MessageDestinationManager
implements MessageDestinationDeployment {
    private Hk2DeploymentManager dm;
    private static final String DOMAIN_XML_PATH = "config/domain.xml";
    public static final String JMS_PREFIX = "jms/";
    public static final String QUEUE = "javax.jms.Queue";
    public static final String TOPIC = "javax.jms.Topic";
    public static final String QUEUE_PROP = "PhysicalQueue";
    public static final String TOPIC_PROP = "PhysicalTopic";
    public static final String QUEUE_CNTN_FACTORY = "javax.jms.QueueConnectionFactory";
    public static final String TOPIC_CNTN_FACTORY = "javax.jms.TopicConnectionFactory";
    private static final String ATTR_JNDINAME = "jndi-name";
    private static final String ATTR_POOLNAME = "pool-name";
    private static final String ATTR_POOL_NAME = "name";
    private static final String AO_TAG_1 = "    <admin-object-resource enabled=\"true\" ";
    private static final String ATTR_RESTYPE = " res-type";
    private static final String AO_TAG_2 = " res-adapter=\"jmsra\">\n";
    private static final String PROP_NAME = "Name";
    private static final String AO_TAG_3 = "    </admin-object-resource>\n";
    private static final String CONNECTOR_POOL_TAG_1 = "    <connector-connection-pool ";
    private static final String ATTR_CONN_DEFINITION = " connection-definition-name";
    private static final String CONNECTOR_POOL_TAG_2 = " resource-adapter-name=\"jmsra\"/>\n";
    private static final String CONNECTOR_TAG_1 = "    <connector-resource enabled=\"true\" ";
    private static final String CONNECTOR_TAG_2 = " />\n";

    public Hk2MessageDestinationManager(Hk2DeploymentManager hk2DeploymentManager) {
        this.dm = hk2DeploymentManager;
    }

    public Set<MessageDestination> getMessageDestinations() throws ConfigurationException {
        GlassfishModule glassfishModule = this.dm.getCommonServerSupport();
        String string = (String)glassfishModule.getInstanceProperties().get("domainsfolder");
        String string2 = (String)glassfishModule.getInstanceProperties().get("domainname");
        if (null != string) {
            File file = new File(string, string2 + File.separatorChar + DOMAIN_XML_PATH);
            return Hk2MessageDestinationManager.readMessageDestinations(file, "/domain/", null);
        }
        return Collections.EMPTY_SET;
    }

    public void deployMessageDestinations(Set<MessageDestination> set) throws ConfigurationException {
    }

    public static Set<MessageDestination> getMessageDestinations(File file) {
        File file2 = new File(file, "sun-resources.xml");
        return Hk2MessageDestinationManager.readMessageDestinations(file2, "/", file);
    }

    private static Set<MessageDestination> readMessageDestinations(File file, String string, File file2) {
        HashSet<MessageDestination> hashSet = new HashSet<MessageDestination>();
        if (file.exists()) {
            HashMap<String, AdminObjectResource> hashMap = new HashMap<String, AdminObjectResource>();
            ArrayList<TreeParser.Path> arrayList = new ArrayList<TreeParser.Path>();
            arrayList.add(new TreeParser.Path(string + "resources/admin-object-resource", (TreeParser.NodeReader)new AdminObjectReader(hashMap)));
            try {
                TreeParser.readXml((File)file, arrayList);
            }
            catch (IllegalStateException illegalStateException) {
                Logger.getLogger("glassfish-javaee").log(Level.INFO, illegalStateException.getLocalizedMessage(), illegalStateException);
            }
            for (AdminObjectResource adminObjectResource : hashMap.values()) {
                String string2 = adminObjectResource.getResType();
                if (string2.equals(QUEUE)) {
                    hashSet.add(new SunMessageDestination(adminObjectResource.getJndiName(), MessageDestination.Type.QUEUE, file2));
                    continue;
                }
                hashSet.add(new SunMessageDestination(adminObjectResource.getJndiName(), MessageDestination.Type.TOPIC, file2));
            }
        }
        return hashSet;
    }

    public static MessageDestination createMessageDestination(String string, MessageDestination.Type type, File file) throws ConfigurationException {
        Object object;
        if (!string.startsWith(JMS_PREFIX)) {
            string = JMS_PREFIX + string;
        }
        DuplicateAOFinder duplicateAOFinder = new DuplicateAOFinder(string);
        DuplicateConnectorFinder duplicateConnectorFinder = new DuplicateConnectorFinder(string);
        ConnectorPoolFinder connectorPoolFinder = new ConnectorPoolFinder();
        File file2 = new File(file, "sun-resources.xml");
        if (file2.exists()) {
            object = new ArrayList<TreeParser.Path>();
            object.add(new TreeParser.Path("/resources/admin-object-resource", (TreeParser.NodeReader)duplicateAOFinder));
            object.add(new TreeParser.Path("/resources/connector-resource", (TreeParser.NodeReader)duplicateConnectorFinder));
            object.add(new TreeParser.Path("/resources/connector-connection-pool", (TreeParser.NodeReader)connectorPoolFinder));
            TreeParser.readXml((File)file2, (List)object);
            if (duplicateConnectorFinder.isDuplicate()) {
                throw new ConfigurationException("Resource already exists");
            }
        }
        object = string + "Factory";
        String string2 = string + "FactoryPool";
        try {
            Hk2MessageDestinationManager.createAdminObject(file2, string, type);
            Hk2MessageDestinationManager.createConnectorConnectionPool(file2, string2, type);
            Hk2MessageDestinationManager.createConnector(file2, (String)object, string2);
        }
        catch (IOException iOException) {
            Logger.getLogger("glassfish-javaee").log(Level.WARNING, iOException.getLocalizedMessage(), iOException);
            throw new ConfigurationException(iOException.getLocalizedMessage(), (Throwable)iOException);
        }
        SunMessageDestination sunMessageDestination = new SunMessageDestination(string, type, file);
        return sunMessageDestination;
    }

    public static void createAdminObject(File file, String string, MessageDestination.Type type) throws IOException {
        StringBuilder stringBuilder = new StringBuilder(500);
        stringBuilder.append(AO_TAG_1);
        ResourceModifier.appendAttr(stringBuilder, ATTR_JNDINAME, string, false);
        if (MessageDestination.Type.QUEUE.equals((Object)type)) {
            ResourceModifier.appendAttr(stringBuilder, ATTR_RESTYPE, QUEUE, true);
            stringBuilder.append(AO_TAG_2);
            ResourceModifier.appendProperty(stringBuilder, PROP_NAME, QUEUE_PROP, true);
        } else if (MessageDestination.Type.TOPIC.equals((Object)type)) {
            ResourceModifier.appendAttr(stringBuilder, ATTR_RESTYPE, TOPIC, true);
            stringBuilder.append(AO_TAG_2);
            ResourceModifier.appendProperty(stringBuilder, PROP_NAME, TOPIC_PROP, true);
        }
        stringBuilder.append(AO_TAG_3);
        String string2 = stringBuilder.toString();
        Logger.getLogger("glassfish-javaee").log(Level.FINER, "New Connector resource:\n" + string2);
        ResourceModifier.appendResource(file, string2);
    }

    public static void createConnectorConnectionPool(File file, String string, MessageDestination.Type type) throws IOException {
        StringBuilder stringBuilder = new StringBuilder(500);
        stringBuilder.append(CONNECTOR_POOL_TAG_1);
        ResourceModifier.appendAttr(stringBuilder, ATTR_POOL_NAME, string, true);
        if (type.equals((Object)MessageDestination.Type.QUEUE)) {
            ResourceModifier.appendAttr(stringBuilder, ATTR_CONN_DEFINITION, QUEUE_CNTN_FACTORY, true);
        } else if (type.equals((Object)MessageDestination.Type.TOPIC)) {
            ResourceModifier.appendAttr(stringBuilder, ATTR_CONN_DEFINITION, TOPIC_CNTN_FACTORY, true);
        }
        stringBuilder.append(CONNECTOR_POOL_TAG_2);
        String string2 = stringBuilder.toString();
        Logger.getLogger("glassfish-javaee").log(Level.FINER, "New Connector Connection Pool resource:\n" + string2);
        ResourceModifier.appendResource(file, string2);
    }

    public static void createConnector(File file, String string, String string2) throws IOException {
        StringBuilder stringBuilder = new StringBuilder(500);
        stringBuilder.append(CONNECTOR_TAG_1);
        ResourceModifier.appendAttr(stringBuilder, ATTR_JNDINAME, string, true);
        ResourceModifier.appendAttr(stringBuilder, ATTR_POOLNAME, string2, true);
        stringBuilder.append(CONNECTOR_TAG_2);
        String string3 = stringBuilder.toString();
        Logger.getLogger("glassfish-javaee").log(Level.FINER, "New Connector resource:\n" + string3);
        ResourceModifier.appendResource(file, string3);
    }

    private static class ConnectorPool {
        private final String poolName;
        private final String raName;
        private final String conndefName;

        public ConnectorPool(String string, String string2, String string3) {
            this.poolName = string;
            this.raName = string2;
            this.conndefName = string3;
        }

        public String getPoolName() {
            return this.poolName;
        }

        public String getRaName() {
            return this.raName;
        }

        public String getConndefName() {
            return this.conndefName;
        }
    }

    private static class ConnectorPoolFinder
    extends TreeParser.NodeReader {
        private Map<String, String> properties = null;
        private Map<String, ConnectorPool> pools = new HashMap<String, ConnectorPool>();

        private ConnectorPoolFinder() {
        }

        public void readAttributes(String string, Attributes attributes) throws SAXException {
            this.properties = new HashMap<String, String>();
            String string2 = attributes.getValue(Hk2MessageDestinationManager.ATTR_POOL_NAME);
            if (string2 != null && string2.length() > 0) {
                if (!this.pools.containsKey(string2)) {
                    this.properties.put(Hk2MessageDestinationManager.ATTR_POOL_NAME, string2);
                    this.properties.put("raname", attributes.getValue("resource-adapter-name"));
                    this.properties.put("conndefname", attributes.getValue("connection-definition-name"));
                } else {
                    Logger.getLogger("glassfish-javaee").log(Level.WARNING, "Duplicate pool-names defined for Resource Adapter Pools: " + string2);
                }
            }
        }

        public void readChildren(String string, Attributes attributes) throws SAXException {
            String string2;
            if (null != attributes && null != this.properties && (string2 = attributes.getValue(Hk2MessageDestinationManager.ATTR_POOL_NAME)) != null && string2.length() > 0) {
                this.properties.put(string2.toLowerCase(Locale.ENGLISH), attributes.getValue("value"));
            }
        }

        public void endNode(String string) throws SAXException {
            String string2 = this.properties.get(Hk2MessageDestinationManager.ATTR_POOL_NAME);
            ConnectorPool connectorPool = new ConnectorPool(string2, this.properties.get("raname"), this.properties.get("conndefname"));
            this.pools.put(string2, connectorPool);
        }

        public List<String> getPoolNames() {
            return new ArrayList<String>(this.pools.keySet());
        }

        public Map<String, ConnectorPool> getPoolData() {
            return Collections.unmodifiableMap(this.pools);
        }
    }

    private static class DuplicateConnectorFinder
    extends TreeParser.NodeReader {
        private final String targetJndiName;
        private boolean duplicate;
        private String poolName;

        public DuplicateConnectorFinder(String string) {
            this.targetJndiName = string;
            this.duplicate = false;
            this.poolName = null;
        }

        public void readAttributes(String string, Attributes attributes) throws SAXException {
            String string2 = attributes.getValue(Hk2MessageDestinationManager.ATTR_JNDINAME);
            if (this.targetJndiName.equals(string2)) {
                if (this.duplicate) {
                    Logger.getLogger("glassfish-javaee").log(Level.WARNING, "Duplicate jndi-names defined for Connector resources.");
                }
                this.duplicate = true;
                this.poolName = attributes.getValue(Hk2MessageDestinationManager.ATTR_POOLNAME);
            }
        }

        public boolean isDuplicate() {
            return this.duplicate;
        }

        public String getPoolName() {
            return this.poolName;
        }
    }

    private static class DuplicateAOFinder
    extends TreeParser.NodeReader {
        private final String targetJndiName;
        private boolean duplicate;
        private String resType;

        public DuplicateAOFinder(String string) {
            this.targetJndiName = string;
            this.duplicate = false;
            this.resType = null;
        }

        public void readAttributes(String string, Attributes attributes) throws SAXException {
            String string2 = attributes.getValue(Hk2MessageDestinationManager.ATTR_JNDINAME);
            if (this.targetJndiName.equals(string2)) {
                if (this.duplicate) {
                    Logger.getLogger("glassfish-javaee").log(Level.WARNING, "Duplicate jndi-names defined for Admin Object resources.");
                }
                this.duplicate = true;
                this.resType = attributes.getValue("res-type");
            }
        }

        public boolean isDuplicate() {
            return this.duplicate;
        }

        public String getResType() {
            return this.resType;
        }
    }

    private static class AdminObjectResource {
        private final String jndiName;
        private final String resType;
        private final String resAdapter;

        public AdminObjectResource(String string, String string2, String string3) {
            this.jndiName = string;
            this.resType = string2;
            this.resAdapter = string3;
        }

        public String getJndiName() {
            return this.jndiName;
        }

        public String getResType() {
            return this.resType;
        }

        public String getResAdapter() {
            return this.resAdapter;
        }
    }

    private static class AdminObjectReader
    extends TreeParser.NodeReader {
        private final Map<String, AdminObjectResource> resourceMap;

        public AdminObjectReader(Map<String, AdminObjectResource> map) {
            this.resourceMap = map;
        }

        public void readAttributes(String string, Attributes attributes) throws SAXException {
            String string2 = attributes.getValue("object-type");
            if (string2 != null && string2.startsWith("system-")) {
                return;
            }
            String string3 = attributes.getValue(Hk2MessageDestinationManager.ATTR_JNDINAME);
            String string4 = attributes.getValue("res-type");
            String string5 = attributes.getValue("res-adapter");
            if (string3 != null && string3.length() > 0 && string4 != null && string4.length() > 0) {
                this.resourceMap.put(string3, new AdminObjectResource(string3, string4, string5));
            }
        }
    }
}

