/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.favorites.templates;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.SwingUtilities;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.actions.CopyAction;
import org.openide.actions.CutAction;
import org.openide.actions.DeleteAction;
import org.openide.actions.PasteAction;
import org.openide.actions.PropertiesAction;
import org.openide.actions.RenameAction;
import org.openide.awt.Mnemonics;
import org.openide.explorer.ExplorerManager;
import org.openide.explorer.ExplorerUtils;
import org.openide.explorer.view.BeanTreeView;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataFilter;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.nodes.Children;
import org.openide.nodes.FilterNode;
import org.openide.nodes.Index;
import org.openide.nodes.Node;
import org.openide.nodes.NodeMemberEvent;
import org.openide.nodes.NodeReorderEvent;
import org.openide.nodes.PropertySupport;
import org.openide.nodes.Sheet;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.actions.NodeAction;
import org.openide.util.actions.SystemAction;
import org.openide.util.lookup.AbstractLookup;
import org.openide.util.lookup.InstanceContent;
import org.openide.util.lookup.ProxyLookup;
import org.openide.windows.TopComponent;

public class TemplatesPanel
extends TopComponent
implements ExplorerManager.Provider {
    private static ExplorerManager manager;
    private static TemplateTreeView view;
    private static FileObject templatesRoot;
    private static Node templatesRootNode;
    private static final String TEMPLATE_DISPLAY_NAME_ATTRIBUTE = "displayName";
    private static final String TEMPLATE_LOCALIZING_BUNDLE_ATTRIBUTE = "SystemFileSystem.localizingBundle";
    private static final String TEMPLATE_SCRIPT_ENGINE_ATTRIBUTE = "javax.script.ScriptEngine";
    private static final String TEMPLATE_CATEGORY_ATTRIBUTE = "templateCategory";
    private JButton addButton;
    private JPanel buttonsPanel;
    private JButton deleteButton;
    private JButton duplicateButton;
    private JSeparator jSeparator1;
    private JSeparator jSeparator2;
    private JSeparator jSeparator3;
    private JButton moveDownButton;
    private JButton moveUpButton;
    private JButton newFolderButton;
    private JButton renameButton;
    private JLabel templatesLabel;
    private JPanel treePanel;

    public TemplatesPanel() {
        ActionMap map = this.getActionMap();
        map.put("copy-to-clipboard", ExplorerUtils.actionCopy((ExplorerManager)this.getExplorerManager()));
        map.put("cut-to-clipboard", ExplorerUtils.actionCut((ExplorerManager)this.getExplorerManager()));
        map.put("paste-from-clipboard", ExplorerUtils.actionPaste((ExplorerManager)this.getExplorerManager()));
        map.put("delete", ExplorerUtils.actionDelete((ExplorerManager)this.getExplorerManager(), (boolean)true));
        this.initComponents();
        this.createTemplateView();
        this.treePanel.add((Component)((Object)view), "Center");
        this.associateLookup(ExplorerUtils.createLookup((ExplorerManager)this.getExplorerManager(), (ActionMap)map));
        this.initialize();
    }

    public ExplorerManager getExplorerManager() {
        if (manager == null) {
            manager = new ExplorerManager();
        }
        return manager;
    }

    private void createTemplateView() {
        if (view == null) {
            view = new TemplateTreeView();
        }
        view.setRootVisible(false);
        view.setPopupAllowed(true);
        view.setDefaultActionAllowed(false);
    }

    private void initialize() {
        this.getExplorerManager().setRootContext(TemplatesPanel.getTemplateRootNode());
        this.getExplorerManager().addPropertyChangeListener((PropertyChangeListener)new SelectionListener());
        this.deleteButton.setEnabled(false);
        this.renameButton.setEnabled(false);
        this.duplicateButton.setEnabled(false);
        this.moveUpButton.setEnabled(false);
        this.moveDownButton.setEnabled(false);
        this.addButton.setEnabled(false);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                Node firstNode = templatesRootNode.getChildren().getNodeAt(0);
                try {
                    manager.setSelectedNodes(new Node[]{firstNode});
                }
                catch (PropertyVetoException ex) {
                    Logger.getLogger(TemplatesPanel.class.getName()).log(Level.FINE, ex.getLocalizedMessage(), ex);
                }
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        view.requestFocus();
                    }
                });
            }
        });
    }

    static Node getTemplateRootNode() {
        if (templatesRootNode == null) {
            DataFolder df = DataFolder.findFolder((FileObject)TemplatesPanel.getTemplatesRoot());
            templatesRootNode = new TemplateNode((Node)new FilterNode(df.getNodeDelegate(), df.createNodeChildren((DataFilter)new TemplateFilter())));
        }
        return templatesRootNode;
    }

    private void initComponents() {
        this.templatesLabel = new JLabel();
        this.treePanel = new JPanel();
        this.buttonsPanel = new JPanel();
        this.addButton = new JButton();
        this.newFolderButton = new JButton();
        this.jSeparator1 = new JSeparator();
        this.duplicateButton = new JButton();
        this.renameButton = new JButton();
        this.jSeparator2 = new JSeparator();
        this.moveUpButton = new JButton();
        this.moveDownButton = new JButton();
        this.jSeparator3 = new JSeparator();
        this.deleteButton = new JButton();
        this.setPreferredSize(new Dimension(500, 300));
        this.setLayout(new GridBagLayout());
        Mnemonics.setLocalizedText((JLabel)this.templatesLabel, (String)NbBundle.getBundle(TemplatesPanel.class).getString("LBL_TemplatesPanel_TemplatesLabel"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(12, 12, 0, 0);
        this.add(this.templatesLabel, gridBagConstraints);
        this.treePanel.setBorder(BorderFactory.createEtchedBorder());
        this.treePanel.setLayout(new BorderLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 12, 11, 0);
        this.add(this.treePanel, gridBagConstraints);
        this.buttonsPanel.setLayout(new GridBagLayout());
        Mnemonics.setLocalizedText((AbstractButton)this.addButton, (String)NbBundle.getBundle(TemplatesPanel.class).getString("BTN_TemplatesPanel_Add"));
        this.addButton.setToolTipText(NbBundle.getMessage(TemplatesPanel.class, (String)"TT_TemplatesPanel_Add"));
        this.addButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TemplatesPanel.this.addButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 8, 3, 0);
        this.buttonsPanel.add((Component)this.addButton, gridBagConstraints);
        this.addButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(TemplatesPanel.class, (String)"ACD_TemplatesPanel_Add"));
        Mnemonics.setLocalizedText((AbstractButton)this.newFolderButton, (String)NbBundle.getBundle(TemplatesPanel.class).getString("BTN_TemplatesPanel_NewFolder"));
        this.newFolderButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TemplatesPanel.this.newFolderButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 8, 3, 0);
        this.buttonsPanel.add((Component)this.newFolderButton, gridBagConstraints);
        this.newFolderButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(TemplatesPanel.class, (String)"ACD_TemplatesPanel_New"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = new Insets(4, 8, 4, 0);
        this.buttonsPanel.add((Component)this.jSeparator1, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.duplicateButton, (String)NbBundle.getBundle(TemplatesPanel.class).getString("BTN_TemplatesPanel_DuplicateButton"));
        this.duplicateButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TemplatesPanel.this.duplicateButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 8, 3, 0);
        this.buttonsPanel.add((Component)this.duplicateButton, gridBagConstraints);
        this.duplicateButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(TemplatesPanel.class, (String)"ACD_TemplatesPanel_Duplicate"));
        Mnemonics.setLocalizedText((AbstractButton)this.renameButton, (String)NbBundle.getBundle(TemplatesPanel.class).getString("BTN_TemplatesPanel_RenameButton"));
        this.renameButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TemplatesPanel.this.renameButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 8, 3, 0);
        this.buttonsPanel.add((Component)this.renameButton, gridBagConstraints);
        this.renameButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(TemplatesPanel.class, (String)"ACD_TemplatesPanel_Rename"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.insets = new Insets(4, 8, 4, 0);
        this.buttonsPanel.add((Component)this.jSeparator2, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.moveUpButton, (String)NbBundle.getBundle(TemplatesPanel.class).getString("BTN_TemplatesPanel_MoveUp"));
        this.moveUpButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TemplatesPanel.this.moveUpButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 8, 3, 0);
        this.buttonsPanel.add((Component)this.moveUpButton, gridBagConstraints);
        this.moveUpButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(TemplatesPanel.class, (String)"ACD_TemplatesPanel_MoveUp"));
        Mnemonics.setLocalizedText((AbstractButton)this.moveDownButton, (String)NbBundle.getBundle(TemplatesPanel.class).getString("BTN_TemplatesPanel_MoveDown"));
        this.moveDownButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TemplatesPanel.this.moveDownButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 8, 3, 0);
        this.buttonsPanel.add((Component)this.moveDownButton, gridBagConstraints);
        this.moveDownButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(TemplatesPanel.class, (String)"ACD_TemplatesPanel_MoveDown"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.insets = new Insets(4, 8, 4, 0);
        this.buttonsPanel.add((Component)this.jSeparator3, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.deleteButton, (String)NbBundle.getBundle(TemplatesPanel.class).getString("BTN_TemplatesPanel_Delete"));
        this.deleteButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TemplatesPanel.this.deleteButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 8, 3, 0);
        this.buttonsPanel.add((Component)this.deleteButton, gridBagConstraints);
        this.deleteButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(TemplatesPanel.class, (String)"ACD_TemplatesPanel_Delete"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.insets = new Insets(0, 11, 11, 8);
        this.add(this.buttonsPanel, gridBagConstraints);
    }

    private void moveDownButtonActionPerformed(ActionEvent evt) {
        this.moveDown(manager.getSelectedNodes());
    }

    private void moveUpButtonActionPerformed(ActionEvent evt) {
        this.moveUp(manager.getSelectedNodes());
    }

    private void newFolderButtonActionPerformed(ActionEvent evt) {
        DataFolder df = TemplatesPanel.doNewFolder(manager.getSelectedNodes());
        assert (df != null) : "New DataFolder has been created.";
        try {
            Node[] nodes = manager.getSelectedNodes();
            Node targerNode = null;
            targerNode = nodes == null || nodes.length == 0 ? manager.getRootContext() : (nodes[0].isLeaf() ? nodes[0].getParentNode() : nodes[0]);
            targerNode.getChildren().getNodes(true);
            Node newSubfolder = targerNode.getChildren().findChild(df.getName());
            assert (newSubfolder != null) : "Node for subfolder found in nodes: " + Arrays.asList(targerNode.getChildren().getNodes());
            manager.setSelectedNodes(new Node[]{newSubfolder});
            TemplatesPanel.view.invokeInplaceEditing();
        }
        catch (PropertyVetoException pve) {
            Logger.getLogger(TemplatesPanel.class.getName()).log(Level.WARNING, null, pve);
        }
    }

    private void deleteButtonActionPerformed(ActionEvent evt) {
        Node[] nodes = manager.getSelectedNodes();
        for (int i = 0; i < nodes.length; ++i) {
            try {
                nodes[i].destroy();
                continue;
            }
            catch (IOException ioe) {
                Logger.getLogger(TemplatesPanel.class.getName()).log(Level.WARNING, null, ioe);
            }
        }
    }

    private void duplicateButtonActionPerformed(ActionEvent evt) {
        Node[] nodes = manager.getSelectedNodes();
        assert (nodes != null) : "Selected Nodes cannot be null.";
        assert (nodes.length == 1) : "One one node can be selected, but was " + Arrays.asList(nodes);
        TemplatesPanel.createDuplicateFromNode(nodes[0]);
    }

    private void renameButtonActionPerformed(ActionEvent evt) {
        Node[] nodes = manager.getSelectedNodes();
        assert (nodes != null) : "Selected Nodes cannot be null.";
        assert (nodes.length == 1) : "One one node can be selected, but was " + Arrays.asList(nodes);
        TemplatesPanel.view.invokeInplaceEditing();
    }

    private void addButtonActionPerformed(ActionEvent evt) {
        TemplatesPanel.doAdd(manager.getSelectedNodes());
    }

    private static Sheet.Set createTemplateProperties(final TemplateNode templateNode) {
        Sheet.Set properties = Sheet.createPropertiesSet();
        properties.put((Node.Property)new PropertySupport.ReadWrite<String>("name", String.class, NbBundle.getMessage(TemplatesPanel.class, (String)"TemplatesPanel_TemplateNode_DisplayName"), NbBundle.getMessage(TemplatesPanel.class, (String)"TemplatesPanel_TemplateNode_DisplayName_Desc")){

            public String getValue() throws IllegalAccessException, InvocationTargetException {
                return templateNode.getDisplayName();
            }

            public void setValue(String val) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
                templateNode.setName(val);
            }
        });
        properties.put((Node.Property)new PropertySupport.ReadWrite<String>("primaryFile", String.class, NbBundle.getMessage(TemplatesPanel.class, (String)"TemplatesPanel_TemplateNode_FileName"), NbBundle.getMessage(TemplatesPanel.class, (String)"TemplatesPanel_TemplateNode_FileName_Desc")){

            public String getValue() throws IllegalAccessException, InvocationTargetException {
                return templateNode.getFileName();
            }

            public void setValue(String val) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
                templateNode.setFileName(val);
            }
        });
        properties.put((Node.Property)new PropertySupport.ReadWrite<String>(TEMPLATE_SCRIPT_ENGINE_ATTRIBUTE, String.class, NbBundle.getMessage(TemplatesPanel.class, (String)"TemplatesPanel_TemplateNode_ScriptEngine"), NbBundle.getMessage(TemplatesPanel.class, (String)"TemplatesPanel_TemplateNode_ScriptEngine_Desc")){

            public String getValue() throws IllegalAccessException, InvocationTargetException {
                DataObject dobj = TemplatesPanel.getDOFromNode((Node)templateNode);
                Object o = dobj.getPrimaryFile().getAttribute(TemplatesPanel.TEMPLATE_SCRIPT_ENGINE_ATTRIBUTE);
                return o == null ? "" : o.toString();
            }

            public void setValue(String val) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
                DataObject dobj = TemplatesPanel.getDOFromNode((Node)templateNode);
                try {
                    dobj.getPrimaryFile().setAttribute(TemplatesPanel.TEMPLATE_SCRIPT_ENGINE_ATTRIBUTE, (Object)val);
                }
                catch (IOException ex) {
                    Logger.getLogger(TemplatesPanel.class.getName()).log(Level.INFO, ex.getLocalizedMessage(), ex);
                }
            }
        });
        properties.put((Node.Property)new PropertySupport.ReadWrite<String[]>(TEMPLATE_CATEGORY_ATTRIBUTE, String[].class, NbBundle.getMessage(TemplatesPanel.class, (String)"TemplatesPanel_TemplateNode_TemplateCategories"), NbBundle.getMessage(TemplatesPanel.class, (String)"TemplatesPanel_TemplateNode_TemplateCategories_Desc")){

            public String[] getValue() throws IllegalAccessException, InvocationTargetException {
                DataObject dobj = TemplatesPanel.getDOFromNode((Node)templateNode);
                Object o = dobj.getPrimaryFile().getAttribute(TemplatesPanel.TEMPLATE_CATEGORY_ATTRIBUTE);
                if (o != null) {
                    ArrayList<String> list = new ArrayList<String>();
                    StringTokenizer tokenizer = new StringTokenizer(o.toString(), ",");
                    while (tokenizer.hasMoreTokens()) {
                        String token = tokenizer.nextToken();
                        list.add(token.trim());
                    }
                    return list.toArray(new String[0]);
                }
                return null;
            }

            public void setValue(String[] val) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
                DataObject dobj = TemplatesPanel.getDOFromNode((Node)templateNode);
                try {
                    if (val == null) {
                        dobj.getPrimaryFile().setAttribute(TemplatesPanel.TEMPLATE_CATEGORY_ATTRIBUTE, null);
                    } else {
                        dobj.getPrimaryFile().setAttribute(TemplatesPanel.TEMPLATE_CATEGORY_ATTRIBUTE, (Object)Arrays.asList(val).toString());
                    }
                }
                catch (IOException ex) {
                    Logger.getLogger(TemplatesPanel.class.getName()).log(Level.INFO, ex.getLocalizedMessage(), ex);
                }
            }
        });
        return properties;
    }

    private static DataObject getDOFromNode(Node n) {
        DataObject dobj = (DataObject)n.getLookup().lookup(DataObject.class);
        assert (dobj != null) : "DataObject for node " + n;
        return dobj;
    }

    private static DataFolder getTargetFolder(Node[] nodes) {
        DataFolder folder = null;
        if (nodes == null || nodes.length == 0) {
            folder = DataFolder.findFolder((FileObject)TemplatesPanel.getTemplatesRoot());
        } else {
            folder = (DataFolder)nodes[0].getLookup().lookup(DataFolder.class);
            if (folder == null && nodes[0].isLeaf()) {
                Node parent = nodes[0].getParentNode();
                folder = (DataFolder)parent.getLookup().lookup(DataFolder.class);
            }
        }
        return folder;
    }

    static DataObject createTemplateFromFile(File file, DataFolder preferred) {
        if (file == null) {
            throw new IllegalArgumentException("Argument file cannot be null!");
        }
        FileObject sourceFO = FileUtil.toFileObject((File)FileUtil.normalizeFile((File)file));
        assert (sourceFO != null) : "FileObject found for file " + file;
        DataObject sourceDO = null;
        try {
            sourceDO = DataObject.find((FileObject)sourceFO);
        }
        catch (DataObjectNotFoundException donfe) {
            Logger.getLogger(TemplatesPanel.class.getName()).log(Level.WARNING, null, donfe);
        }
        assert (sourceDO != null) : "DataObject found for FileObject " + sourceFO;
        DataFolder folder = preferred == null ? DataFolder.findFolder((FileObject)TemplatesPanel.getTemplatesRoot()) : preferred;
        DataObject template = null;
        try {
            template = sourceDO.copy(folder);
            DataObject templateSample = null;
            for (DataObject d : folder.getChildren()) {
                if (!d.isTemplate()) continue;
                templateSample = d;
                break;
            }
            template.setTemplate(true);
            if (templateSample == null) {
                template.getPrimaryFile().setAttribute(TEMPLATE_SCRIPT_ENGINE_ATTRIBUTE, (Object)"freemarker");
            } else {
                TemplatesPanel.setTemplateAttributes(template.getPrimaryFile(), TemplatesPanel.getAttributes(templateSample.getPrimaryFile()));
            }
        }
        catch (IOException ioe) {
            Logger.getLogger(TemplatesPanel.class.getName()).log(Level.WARNING, null, ioe);
        }
        return template;
    }

    private static void doAdd(Node[] nodes) {
        JFileChooser chooser = new JFileChooser();
        chooser.setDialogTitle(NbBundle.getBundle(TemplatesPanel.class).getString("LBL_TemplatesPanel_JFileChooser_Title"));
        chooser.setApproveButtonText(NbBundle.getBundle(TemplatesPanel.class).getString("BTN_TemplatesPanel_JFileChooser_AddButtonName"));
        chooser.setFileHidingEnabled(false);
        chooser.setMultiSelectionEnabled(false);
        int result = chooser.showOpenDialog(null);
        if (0 == result) {
            File f = chooser.getSelectedFile();
            assert (f != null);
            if (!f.isFile()) {
                NotifyDescriptor.Message msg = new NotifyDescriptor.Message((Object)NbBundle.getMessage(TemplatesPanel.class, (String)"MSG_TemplatesPanel_Nonexistent_File", (Object)f.toString()));
                DialogDisplayer.getDefault().notify((NotifyDescriptor)msg);
            } else {
                TemplatesPanel.createTemplateFromFile(f, TemplatesPanel.getTargetFolder(nodes));
            }
        }
    }

    private static DataFolder doNewFolder(Node[] nodes) {
        String baseName;
        DataFolder df = null;
        DataFolder pref = TemplatesPanel.getTargetFolder(nodes);
        if (pref == null) {
            pref = DataFolder.findFolder((FileObject)TemplatesPanel.getTemplatesRoot());
            assert (pref != null) : "DataFolder found for FO " + TemplatesPanel.getTemplatesRoot();
        }
        String name = baseName = NbBundle.getBundle(TemplatesPanel.class).getString("TXT_TemplatesPanel_NewFolderName");
        DataObject[] arr = pref.getChildren();
        boolean exists = true;
        int counter = 0;
        block2: while (exists) {
            exists = false;
            for (int i = 0; i < arr.length; ++i) {
                if (!name.equals(arr[i].getName())) continue;
                name = baseName + " " + ++counter;
                exists = true;
                continue block2;
            }
        }
        try {
            df = DataFolder.create((DataFolder)pref, (String)name);
            assert (df != null) : "New subfolder found in folder " + pref;
        }
        catch (IOException ioe) {
            Logger.getLogger(TemplatesPanel.class.getName()).log(Level.WARNING, null, ioe);
        }
        return df;
    }

    static DataObject createDuplicateFromNode(Node n) {
        DataObject source = TemplatesPanel.getDOFromNode(n);
        try {
            Node parent = n.getParentNode();
            DataObject target = source.copy(source.getFolder());
            FileObject srcFo = source.getPrimaryFile();
            FileObject targetFo = target.getPrimaryFile();
            TemplatesPanel.setTemplateAttributes(targetFo, TemplatesPanel.getAttributes(srcFo));
            if (parent != null) {
                Node duplicateNode = null;
                for (Node k : parent.getChildren().getNodes(true)) {
                    if (!k.getName().startsWith(targetFo.getName())) continue;
                    duplicateNode = k;
                    break;
                }
                if (duplicateNode != null) {
                    final Node finalNode = duplicateNode;
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                manager.setSelectedNodes(new Node[]{finalNode});
                                view.invokeInplaceEditing();
                            }
                            catch (PropertyVetoException ex) {
                                Logger.getLogger(TemplatesPanel.class.getName()).log(Level.INFO, ex.getLocalizedMessage(), ex);
                            }
                        }
                    });
                }
            }
            return target;
        }
        catch (IOException ioe) {
            Logger.getLogger(TemplatesPanel.class.getName()).log(Level.WARNING, null, ioe);
            return null;
        }
    }

    private static HashMap<String, Object> getAttributes(FileObject fo) {
        HashMap<String, Object> attributes = new HashMap<String, Object>();
        Enumeration attributeNames = fo.getAttributes();
        while (attributeNames.hasMoreElements()) {
            Object attrValue;
            String attrName = (String)attributeNames.nextElement();
            if (attrName == null || (attrValue = fo.getAttribute(attrName)) == null) continue;
            attributes.put(attrName, attrValue);
        }
        return attributes;
    }

    private static void setTemplateAttributes(FileObject fo, HashMap<String, Object> attributes) throws IOException {
        for (Map.Entry<String, Object> entry : attributes.entrySet()) {
            if (TEMPLATE_LOCALIZING_BUNDLE_ATTRIBUTE.equals(entry.getKey())) continue;
            fo.setAttribute(entry.getKey(), entry.getValue());
        }
    }

    static FileObject getTemplatesRoot() {
        if (templatesRoot == null) {
            templatesRoot = FileUtil.getConfigFile((String)"Templates");
        }
        return templatesRoot;
    }

    private boolean isMoveUpEnabled(Node[] nodes) {
        if (nodes == null || nodes.length != 1 || !nodes[0].isLeaf()) {
            return false;
        }
        int pos = this.getNodePosition(nodes[0]);
        return pos != -1 && pos > 0;
    }

    private boolean isMoveDownEnabled(Node[] nodes) {
        if (nodes == null || nodes.length != 1 || !nodes[0].isLeaf()) {
            return false;
        }
        int count = nodes[0].getParentNode().getChildren().getNodesCount();
        int pos = this.getNodePosition(nodes[0]);
        return pos != -1 && pos < count - 1;
    }

    private int getNodePosition(Node n) {
        Index supp = this.getIndexSupport(n);
        DataFolder df = (DataFolder)n.getParentNode().getLookup().lookup(DataFolder.class);
        df.getNodeDelegate().getChildren().getNodes(true);
        int pos = supp.indexOf(n);
        return pos;
    }

    private Index getIndexSupport(Node n) {
        Node parent = n.getParentNode();
        assert (parent != null) : "Node " + n + " has a parent.";
        Index index = (Index)parent.getLookup().lookup(Index.class);
        assert (index != null) : "Node " + parent + " has Index cookie.";
        return index;
    }

    private void moveUp(Node[] nodes) {
        assert (nodes != null) : "Nodes to moveUp cannot be null.";
        assert (nodes.length == 1) : "Only one node can be moveUp, not " + Arrays.asList(nodes);
        assert (nodes[0].isLeaf()) : "Only leaf node can be moveUp, not " + nodes[0];
        Node n = nodes[0];
        Index supp = this.getIndexSupport(n);
        int origPos = this.getNodePosition(n);
        if (origPos == -1) {
            return;
        }
        supp.moveUp(origPos);
        assert (origPos - 1 == this.getNodePosition(n)) : "Node " + n + " has been moved from " + origPos + " to pos " + this.getNodePosition(n);
    }

    private void moveDown(Node[] nodes) {
        assert (nodes != null) : "Nodes to moveDown cannot be null.";
        assert (nodes.length == 1) : "Only one node can be moveDown, not " + Arrays.asList(nodes);
        assert (nodes[0].isLeaf()) : "Only leaf node can be moveDown, not " + nodes[0];
        Node n = nodes[0];
        Index supp = this.getIndexSupport(n);
        int origPos = this.getNodePosition(n);
        if (origPos == -1) {
            return;
        }
        supp.moveDown(origPos);
        assert (origPos + 1 == this.getNodePosition(n)) : "Node " + n + " has been moved from " + origPos + " to pos " + this.getNodePosition(n);
    }

    static {
        templatesRootNode = null;
    }

    private static class NewFolderAction
    extends NodeAction {
        private NewFolderAction() {
        }

        protected void performAction(Node[] activatedNodes) {
            TemplatesPanel.doNewFolder(activatedNodes);
        }

        protected boolean enable(Node[] activatedNodes) {
            return activatedNodes != null && activatedNodes.length == 1;
        }

        public String getName() {
            return NbBundle.getBundle(TemplatesPanel.class).getString("BTN_TemplatesPanel_NewFolder");
        }

        public HelpCtx getHelpCtx() {
            return null;
        }

        protected boolean asynchronous() {
            return true;
        }
    }

    private static class AddAction
    extends NodeAction {
        private AddAction() {
        }

        protected void performAction(Node[] activatedNodes) {
            TemplatesPanel.doAdd(activatedNodes);
        }

        protected boolean enable(Node[] activatedNodes) {
            return activatedNodes != null && activatedNodes.length == 1;
        }

        public String getName() {
            return NbBundle.getBundle(TemplatesPanel.class).getString("BTN_TemplatesPanel_Add");
        }

        public HelpCtx getHelpCtx() {
            return null;
        }

        protected boolean asynchronous() {
            return false;
        }
    }

    private static class DataFolderFilterChildren
    extends FilterNode.Children {
        public DataFolderFilterChildren(Node n) {
            super(n);
        }

        protected Node[] createNodes(Node key) {
            Node[] orig = super.createNodes(key);
            Node[] filtered = new Node[orig.length];
            for (int i = 0; i < orig.length; ++i) {
                DataObject dobj = TemplatesPanel.getDOFromNode(orig[i]);
                filtered[i] = dobj.isTemplate() ? new TemplateNode(orig[i], Children.LEAF) : new TemplateNode(orig[i]);
            }
            return filtered;
        }

        protected void addNotify() {
            super.addNotify();
            if (TemplatesPanel.getTemplateRootNode().equals((Object)this.getNode())) {
                this.sortNodes();
            }
        }

        protected void filterChildrenAdded(NodeMemberEvent ev) {
            super.filterChildrenAdded(ev);
            if (TemplatesPanel.getTemplateRootNode().equals((Object)this.getNode())) {
                this.sortNodes();
            }
        }

        protected void filterChildrenRemoved(NodeMemberEvent ev) {
            super.filterChildrenRemoved(ev);
            if (TemplatesPanel.getTemplateRootNode().equals((Object)this.getNode())) {
                this.sortNodes();
            }
        }

        protected void filterChildrenReordered(NodeReorderEvent ev) {
            super.filterChildrenReordered(ev);
            if (TemplatesPanel.getTemplateRootNode().equals((Object)this.getNode())) {
                this.sortNodes();
            }
        }

        private void sortNodes() {
            Node[] originalNodes = this.original.getChildren().getNodes();
            TreeSet<Node> sortedNodes = new TreeSet<Node>(new TemplateCategotyComparator());
            for (Node n : originalNodes) {
                sortedNodes.add(n);
            }
            this.setKeys(sortedNodes.toArray(new Node[0]));
        }

        private static final class TemplateCategotyComparator
        implements Comparator<Node> {
            private TemplateCategotyComparator() {
            }

            @Override
            public int compare(Node o1, Node o2) {
                return o1.getDisplayName().compareToIgnoreCase(o2.getDisplayName());
            }
        }
    }

    private static class TemplateNode
    extends FilterNode {
        private static Action[] ACTIONS_ON_LEAF = new Action[]{SystemAction.get(CutAction.class), SystemAction.get(CopyAction.class), SystemAction.get(PasteAction.class), null, SystemAction.get(DeleteAction.class), SystemAction.get(RenameAction.class), null, SystemAction.get(PropertiesAction.class)};
        private static Action[] ACTIONS_ON_FOLDER = new Action[]{SystemAction.get(AddAction.class), SystemAction.get(NewFolderAction.class), null, SystemAction.get(CutAction.class), SystemAction.get(CopyAction.class), SystemAction.get(PasteAction.class), null, SystemAction.get(DeleteAction.class), SystemAction.get(RenameAction.class)};

        public TemplateNode(Node n) {
            this(n, (Children)new DataFolderFilterChildren(n), new InstanceContent());
        }

        private TemplateNode(Node n, Children ch) {
            this(n, ch, new InstanceContent());
        }

        private TemplateNode(Node originalNode, Children ch, InstanceContent content) {
            super(originalNode, ch, (Lookup)new ProxyLookup(new Lookup[]{new AbstractLookup((AbstractLookup.Content)content), originalNode.getLookup()}));
            DataObject dobj = TemplatesPanel.getDOFromNode(originalNode);
            if (dobj.isValid()) {
                DataFolder folder = null;
                if (dobj instanceof DataFolder) {
                    folder = (DataFolder)dobj;
                } else if (dobj.getPrimaryFile().getParent() != null && dobj.getPrimaryFile().getParent().isValid()) {
                    folder = dobj.getFolder();
                }
                if (folder != null) {
                    content.add((Object)new DataFolder.Index(folder, (Node)this));
                }
            }
            content.add((Object)this);
        }

        public Action[] getActions(boolean context) {
            return this.isLeaf() ? ACTIONS_ON_LEAF : ACTIONS_ON_FOLDER;
        }

        public Action getPreferredAction() {
            return null;
        }

        public String getName() {
            return super.getDisplayName();
        }

        public void setName(String name) {
            FileObject fo = (FileObject)this.getLookup().lookup(FileObject.class);
            try {
                fo.setAttribute(TemplatesPanel.TEMPLATE_DISPLAY_NAME_ATTRIBUTE, (Object)name);
                fo.setAttribute(TemplatesPanel.TEMPLATE_LOCALIZING_BUNDLE_ATTRIBUTE, null);
            }
            catch (IOException ex) {
                Logger.getLogger(TemplatesPanel.class.getName()).log(Level.WARNING, null, ex);
            }
            this.setDisplayName(name);
        }

        public Node.PropertySet[] getPropertySets() {
            return new Node.PropertySet[]{TemplatesPanel.createTemplateProperties(this)};
        }

        public String getFileName() {
            return super.getName();
        }

        public void setFileName(String name) {
            String origDisplayName = this.getDisplayName();
            super.setName(name);
            FileObject fo = (FileObject)this.getLookup().lookup(FileObject.class);
            try {
                fo.setAttribute(TemplatesPanel.TEMPLATE_DISPLAY_NAME_ATTRIBUTE, (Object)origDisplayName);
                fo.setAttribute(TemplatesPanel.TEMPLATE_LOCALIZING_BUNDLE_ATTRIBUTE, null);
            }
            catch (IOException ex) {
                Logger.getLogger(TemplatesPanel.class.getName()).log(Level.WARNING, null, ex);
            }
            this.setDisplayName(origDisplayName);
        }
    }

    private static final class TemplateFilter
    implements DataFilter {
        private TemplateFilter() {
        }

        public boolean acceptDataObject(DataObject obj) {
            return this.acceptTemplate(obj);
        }

        private boolean acceptTemplate(DataObject d) {
            if (d.isTemplate() || d instanceof DataFolder) {
                Object o = d.getPrimaryFile().getAttribute("simple");
                return o == null || Boolean.TRUE.equals(o);
            }
            return false;
        }
    }

    private class SelectionListener
    implements PropertyChangeListener {
        private SelectionListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if ("selectedNodes".equals(evt.getPropertyName())) {
                final Node[] nodes = (Node[])evt.getNewValue();
                TemplatesPanel.this.deleteButton.setEnabled(nodes != null && nodes.length > 0);
                TemplatesPanel.this.renameButton.setEnabled(nodes != null && nodes.length == 1);
                TemplatesPanel.this.addButton.setEnabled(nodes != null && nodes.length == 1);
                TemplatesPanel.this.duplicateButton.setEnabled(nodes != null && nodes.length == 1 && nodes[0].isLeaf());
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        TemplatesPanel.this.moveUpButton.setEnabled(TemplatesPanel.this.isMoveUpEnabled(nodes));
                        TemplatesPanel.this.moveDownButton.setEnabled(TemplatesPanel.this.isMoveDownEnabled(nodes));
                    }
                });
            }
        }
    }

    private static class TemplateTreeView
    extends BeanTreeView {
        private Action startEditing;

        private TemplateTreeView() {
        }

        private void invokeInplaceEditing() {
            Action o;
            if (this.startEditing == null && (o = this.tree.getActionMap().get("startEditing")) != null && o instanceof Action) {
                this.startEditing = o;
            }
            assert (this.startEditing != null) : "startEditing is on tree ActionMap " + Arrays.asList(this.tree.getActionMap().keys());
            this.startEditing.actionPerformed(new ActionEvent(this.tree, 0, "startEditing"));
        }
    }
}

