/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.sun.ide.runtime.actions;

import org.netbeans.modules.j2ee.sun.bridge.apis.AppserverMgmtNode;
import org.netbeans.modules.j2ee.sun.bridge.apis.RefreshCookie;
import org.netbeans.modules.j2ee.sun.bridge.apis.Removable;
import org.netbeans.modules.j2ee.sun.ide.runtime.nodes.ConnectionPoolNode;
import org.netbeans.modules.j2ee.sun.util.GUIUtils;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.actions.NodeAction;

public class DeleteResourceAction
extends NodeAction {
    protected void performAction(Node[] activatedNodes) {
        if (activatedNodes == null) {
            return;
        }
        for (int i = 0; i < activatedNodes.length; ++i) {
            Node node = activatedNodes[i];
            Lookup lookup = node.getLookup();
            Object obj2 = lookup.lookup(AppserverMgmtNode.class);
            String nodeType = null;
            if (obj2 instanceof AppserverMgmtNode) {
                AppserverMgmtNode appMgmtNode = (AppserverMgmtNode)((Object)obj2);
                nodeType = appMgmtNode.getNodeType();
            }
            try {
                if ("CONNECTION_POOL".equals(nodeType)) {
                    Object proceed = GUIUtils.showWarning(DeleteResourceAction.getLocalizedString("dependent_resources_notify"));
                    if (proceed == NotifyDescriptor.OK_OPTION) {
                        this.deleteDependentResources(node);
                        this.removeResource(node);
                    }
                } else {
                    this.removeResource(node);
                }
                Node parentNode = node.getParentNode();
                RefreshCookie refreshAction = (RefreshCookie)parentNode.getCookie(RefreshCookie.class);
                if (refreshAction == null) continue;
                refreshAction.refresh();
                continue;
            }
            catch (RuntimeException rex) {
                ErrorManager.getDefault().notify(1, (Throwable)rex);
            }
        }
    }

    private void removeResource(Node node) {
        Lookup lookup = node.getLookup();
        Object obj = lookup.lookup(Removable.class);
        if (obj instanceof Removable) {
            Removable removeableObj = (Removable)obj;
            removeableObj.remove();
        }
    }

    private void deleteDependentResources(Node node) {
        Lookup lookup = node.getLookup();
        Object obj = lookup.lookup(ConnectionPoolNode.class);
        if (obj instanceof ConnectionPoolNode) {
            ConnectionPoolNode connPoolNode = (ConnectionPoolNode)obj;
            connPoolNode.removeDependentJDBCResources();
        }
        this.refreshJDBCResourcesFolder(node);
    }

    private void refreshJDBCResourcesFolder(Node node) {
        try {
            Node jdbcMgmtNode;
            RefreshCookie refreshAction;
            Node parentNode = node.getParentNode();
            Children ch = parentNode.getParentNode().getChildren();
            Node[] resourceNodes = ch.getNodes(true);
            if (resourceNodes.length > 0 && (refreshAction = (RefreshCookie)(jdbcMgmtNode = resourceNodes[0]).getCookie(RefreshCookie.class)) != null) {
                refreshAction.refresh();
            }
        }
        catch (Exception ex) {
            ErrorManager.getDefault().notify(1, (Throwable)ex);
        }
    }

    protected boolean enable(Node[] nodes) {
        return nodes != null && nodes.length >= 1;
    }

    protected boolean asynchronous() {
        return false;
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    public String getName() {
        return NbBundle.getMessage(DeleteResourceAction.class, (String)"LBL_DeleteResourceAction");
    }

    private static String getLocalizedString(String bundleStrProp) {
        return NbBundle.getMessage(DeleteResourceAction.class, (String)bundleStrProp);
    }
}

