/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.project.ui.actions;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.util.Collection;
import java.util.EventListener;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.plaf.UIResource;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.modules.project.ui.OpenProjectList;
import org.netbeans.modules.project.ui.actions.ActionsUtil;
import org.netbeans.modules.project.ui.actions.LookupSensitiveAction;
import org.netbeans.spi.project.ProjectConfiguration;
import org.netbeans.spi.project.ProjectConfigurationProvider;
import org.openide.awt.Actions;
import org.openide.awt.DynamicMenuContent;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.MultiFileSystem;
import org.openide.loaders.DataObject;
import org.openide.util.ContextAwareAction;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.Mutex;
import org.openide.util.MutexException;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.WeakListeners;
import org.openide.util.actions.CallableSystemAction;
import org.openide.util.actions.Presenter;

public class ActiveConfigAction
extends CallableSystemAction
implements LookupListener,
PropertyChangeListener,
ContextAwareAction {
    private static final Logger LOGGER = Logger.getLogger(ActiveConfigAction.class.getName());
    private static final RequestProcessor RP = new RequestProcessor(ActiveConfigAction.class);
    private static final DefaultComboBoxModel EMPTY_MODEL = new DefaultComboBoxModel();
    private static final Object CUSTOMIZE_ENTRY = new Object();
    private final PropertyChangeListener lst;
    private final LookupListener looklst;
    private JComboBox configListCombo;
    private boolean listeningToCombo = true;
    private Project currentProject;
    private ProjectConfigurationProvider<?> pcp;
    private Lookup.Result<ProjectConfigurationProvider> currentResult;
    private final Lookup lookup;

    private void initConfigListCombo() {
        assert (EventQueue.isDispatchThread());
        if (this.configListCombo != null) {
            return;
        }
        LOGGER.finest("initConfigListCombo");
        this.configListCombo = new JComboBox();
        this.configListCombo.addPopupMenuListener(new PopupMenuListener(){
            private Component prevFocusOwner = null;

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
                this.prevFocusOwner = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
                ActiveConfigAction.this.configListCombo.setFocusable(true);
                ActiveConfigAction.this.configListCombo.requestFocusInWindow();
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
                if (this.prevFocusOwner != null) {
                    this.prevFocusOwner.requestFocusInWindow();
                }
                this.prevFocusOwner = null;
                ActiveConfigAction.this.configListCombo.setFocusable(false);
            }

            @Override
            public void popupMenuCanceled(PopupMenuEvent e) {
            }
        });
        this.configListCombo.setRenderer(new ConfigCellRenderer());
        this.configListCombo.setToolTipText(Actions.cutAmpersand((String)this.getName()));
        this.configListCombo.setFocusable(false);
        this.configurationsListChanged(this.pcp == null ? null : ActiveConfigAction.getConfigurations(this.pcp));
        this.configListCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!ActiveConfigAction.this.listeningToCombo) {
                    return;
                }
                Object o = ActiveConfigAction.this.configListCombo.getSelectedItem();
                if (o == CUSTOMIZE_ENTRY) {
                    ActiveConfigAction.this.activeConfigurationChanged(ActiveConfigAction.this.pcp != null ? ActiveConfigAction.getActiveConfiguration(ActiveConfigAction.this.pcp) : null);
                    ActiveConfigAction.this.pcp.customize();
                } else if (o != null) {
                    ActiveConfigAction.this.activeConfigurationSelected((ProjectConfiguration)o, null);
                }
            }
        });
    }

    public ActiveConfigAction() {
        this.putValue("noIconInMenu", true);
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                ActiveConfigAction.this.initConfigListCombo();
            }
        });
        this.lst = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if ("configurations".equals(evt.getPropertyName())) {
                    ActiveConfigAction.this.configurationsListChanged(ActiveConfigAction.getConfigurations(ActiveConfigAction.this.pcp));
                } else if ("activeConfiguration".equals(evt.getPropertyName())) {
                    ActiveConfigAction.this.activeConfigurationChanged(ActiveConfigAction.getActiveConfiguration(ActiveConfigAction.this.pcp));
                }
            }
        };
        this.looklst = new LookupListener(){

            public void resultChanged(LookupEvent ev) {
                ActiveConfigAction.this.activeProjectProviderChanged();
            }
        };
        OpenProjectList.getDefault().addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)OpenProjectList.getDefault()));
        this.lookup = LookupSensitiveAction.LastActivatedWindowLookup.INSTANCE;
        Lookup.Result resultPrj = this.lookup.lookupResult(Project.class);
        Lookup.Result resultDO = this.lookup.lookupResult(DataObject.class);
        resultPrj.addLookupListener((LookupListener)WeakListeners.create(LookupListener.class, (EventListener)this, (Object)resultPrj));
        resultDO.addLookupListener((LookupListener)WeakListeners.create(LookupListener.class, (EventListener)this, (Object)resultDO));
        DynLayer.INSTANCE.setEnabled(true);
        this.refreshView(this.lookup);
    }

    private synchronized void configurationsListChanged(Collection<? extends ProjectConfiguration> configs) {
        LOGGER.log(Level.FINER, "configurationsListChanged: {0}", configs);
        if (configs == null) {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ActiveConfigAction.this.configListCombo.setModel(EMPTY_MODEL);
                    ActiveConfigAction.this.configListCombo.setEnabled(false);
                }
            });
        } else {
            final DefaultComboBoxModel<Object> model = new DefaultComboBoxModel<Object>(configs.toArray());
            if (this.pcp != null && this.pcp.hasCustomizer()) {
                model.addElement(CUSTOMIZE_ENTRY);
            }
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ActiveConfigAction.this.configListCombo.setModel(model);
                    ActiveConfigAction.this.configListCombo.setEnabled(true);
                }
            });
        }
        if (this.pcp != null) {
            this.activeConfigurationChanged(ActiveConfigAction.getActiveConfiguration(this.pcp));
        }
    }

    private synchronized void activeConfigurationChanged(final ProjectConfiguration config) {
        LOGGER.log(Level.FINER, "activeConfigurationChanged: {0}", config);
        EventQueue.invokeLater(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                block4: {
                    ActiveConfigAction.this.listeningToCombo = false;
                    try {
                        ActiveConfigAction.this.configListCombo.setSelectedIndex(-1);
                        if (config == null) break block4;
                        ComboBoxModel m = ActiveConfigAction.this.configListCombo.getModel();
                        for (int i = 0; i < m.getSize(); ++i) {
                            if (!config.equals(m.getElementAt(i))) continue;
                            ActiveConfigAction.this.configListCombo.setSelectedIndex(i);
                            break;
                        }
                    }
                    finally {
                        ActiveConfigAction.this.listeningToCombo = true;
                    }
                }
            }
        });
    }

    private synchronized void activeConfigurationSelected(ProjectConfiguration cfg, ProjectConfigurationProvider<?> ppcp) {
        ProjectConfigurationProvider<?> lpcp = this.pcp;
        if (ppcp != null) {
            lpcp = ppcp;
        }
        LOGGER.log(Level.FINER, "activeConfigurationSelected: {0}", cfg);
        if (lpcp != null && cfg != null && !cfg.equals(ActiveConfigAction.getActiveConfiguration(lpcp))) {
            try {
                ActiveConfigAction.setActiveConfiguration(lpcp, cfg);
            }
            catch (IOException x) {
                LOGGER.log(Level.WARNING, null, x);
            }
        }
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(ActiveConfigAction.class);
    }

    public String getName() {
        return NbBundle.getMessage(ActiveConfigAction.class, (String)"ActiveConfigAction.label");
    }

    public void performAction() {
        Toolkit.getDefaultToolkit().beep();
    }

    public Component getToolbarPresenter() {
        JPanel toolbarPanel = new JPanel(new GridBagLayout());
        toolbarPanel.setOpaque(false);
        toolbarPanel.setMaximumSize(new Dimension(150, 80));
        toolbarPanel.setMinimumSize(new Dimension(150, 0));
        toolbarPanel.setPreferredSize(new Dimension(150, 23));
        this.initConfigListCombo();
        toolbarPanel.add((Component)this.configListCombo, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 2, new Insets(1, 6, 1, 5), 0, 0));
        return toolbarPanel;
    }

    public JMenuItem getMenuPresenter() {
        return new ConfigMenu(null);
    }

    private synchronized void activeProjectChanged(Project p) {
        LOGGER.log(Level.FINER, "activeProjectChanged: {0} -> {1}", new Object[]{this.currentProject, p});
        if (this.currentResult != null) {
            this.currentResult.removeLookupListener(this.looklst);
        }
        this.currentResult = null;
        if (this.currentProject != p) {
            if (this.pcp != null) {
                this.pcp.removePropertyChangeListener(this.lst);
            }
            this.currentProject = p;
            if (this.currentProject != null) {
                this.currentResult = this.currentProject.getLookup().lookupResult(ProjectConfigurationProvider.class);
                this.pcp = this.currentResult.allInstances().isEmpty() ? null : (ProjectConfigurationProvider)this.currentResult.allInstances().iterator().next();
                this.currentResult.addLookupListener(this.looklst);
                if (this.pcp != null) {
                    this.pcp.addPropertyChangeListener(this.lst);
                } else {
                    LOGGER.log(Level.FINEST, "currentResult on {0} is empty", this.currentProject);
                }
            } else {
                LOGGER.finest("currentProject is null");
                this.pcp = null;
            }
            this.configurationsListChanged(this.pcp == null ? null : ActiveConfigAction.getConfigurations(this.pcp));
        }
    }

    private synchronized void activeProjectProviderChanged() {
        if (this.currentResult != null) {
            Collection all;
            if (this.pcp != null) {
                this.pcp.removePropertyChangeListener(this.lst);
            }
            ProjectConfigurationProvider<?> projectConfigurationProvider = this.pcp = (all = this.currentResult.allInstances()).isEmpty() ? null : (ProjectConfigurationProvider<?>)all.iterator().next();
            if (this.pcp != null) {
                this.pcp.addPropertyChangeListener(this.lst);
            } else {
                LOGGER.finest("currentResult is empty");
            }
            this.configurationsListChanged(this.pcp == null ? null : ActiveConfigAction.getConfigurations(this.pcp));
        }
    }

    public Action createContextAwareInstance(final Lookup actionContext) {
        class A
        extends AbstractAction
        implements Presenter.Popup {
            A() {
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                assert (false);
            }

            public JMenuItem getPopupPresenter() {
                return new ConfigMenu(actionContext);
            }
        }
        return new A();
    }

    private static Collection<? extends ProjectConfiguration> getConfigurations(final ProjectConfigurationProvider<?> pcp) {
        return (Collection)ProjectManager.mutex().readAccess((Mutex.Action)new Mutex.Action<Collection<? extends ProjectConfiguration>>(){

            public Collection<? extends ProjectConfiguration> run() {
                Collection configs = pcp.getConfigurations();
                assert (configs != null) : pcp;
                return configs;
            }
        });
    }

    private static ProjectConfiguration getActiveConfiguration(final ProjectConfigurationProvider<?> pcp) {
        return (ProjectConfiguration)ProjectManager.mutex().readAccess((Mutex.Action)new Mutex.Action<ProjectConfiguration>(){

            public ProjectConfiguration run() {
                return pcp.getActiveConfiguration();
            }
        });
    }

    private static void setActiveConfiguration(ProjectConfigurationProvider<?> pcp, final ProjectConfiguration pc) throws IOException {
        final ProjectConfigurationProvider<?> _pcp = pcp;
        try {
            ProjectManager.mutex().writeAccess((Mutex.ExceptionAction)new Mutex.ExceptionAction<Void>(){

                public Void run() throws IOException {
                    _pcp.setActiveConfiguration(pc);
                    return null;
                }
            });
        }
        catch (MutexException e) {
            throw (IOException)e.getException();
        }
    }

    private void refreshView(Lookup context) {
        Project p = OpenProjectList.getDefault().getMainProject();
        if (p != null) {
            this.activeProjectChanged(p);
        } else {
            Project[] selected = ActionsUtil.getProjectsFromLookup(context, null);
            if (selected.length == 1) {
                this.activeProjectChanged(selected[0]);
            } else {
                Project[] open = OpenProjectList.getDefault().getOpenProjects();
                if (open.length == 1) {
                    this.activeProjectChanged(open[0]);
                } else {
                    this.activeProjectChanged(null);
                }
            }
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals("MainProject") || evt.getPropertyName().equals("OpenProjects")) {
            this.refreshViewLater();
        }
    }

    public void resultChanged(LookupEvent ev) {
        this.refreshViewLater();
    }

    private void refreshViewLater() {
        RP.post(new Runnable(){

            @Override
            public void run() {
                ActiveConfigAction.this.refreshView(ActiveConfigAction.this.lookup);
            }
        });
    }

    private static class ConfigCellRenderer
    extends JLabel
    implements ListCellRenderer,
    UIResource {
        private Border defaultBorder = this.getBorder();

        public ConfigCellRenderer() {
            this.setOpaque(true);
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            this.setName("ComboBox.listRenderer");
            String label = null;
            if (value instanceof ProjectConfiguration) {
                label = ((ProjectConfiguration)value).getDisplayName();
                this.setBorder(this.defaultBorder);
            } else if (value == CUSTOMIZE_ENTRY) {
                label = Actions.cutAmpersand((String)NbBundle.getMessage(ActiveConfigAction.class, (String)"ActiveConfigAction.customize"));
                this.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(1, 0, 0, 0, UIManager.getColor("controlDkShadow")), this.defaultBorder));
            } else {
                assert (value == null);
                label = null;
                this.setBorder(this.defaultBorder);
            }
            this.setText(label);
            this.setIcon(null);
            if (isSelected) {
                this.setBackground(list.getSelectionBackground());
                this.setForeground(list.getSelectionForeground());
            } else {
                this.setBackground(list.getBackground());
                this.setForeground(list.getForeground());
            }
            return this;
        }

        @Override
        public String getName() {
            String name = super.getName();
            return name == null ? "ComboBox.renderer" : name;
        }
    }

    class ConfigMenu
    extends JMenu
    implements DynamicMenuContent,
    ActionListener {
        private final Lookup context;

        public ConfigMenu(Lookup context) {
            this.context = context;
            if (context != null) {
                Mnemonics.setLocalizedText((AbstractButton)this, (String)NbBundle.getMessage(ActiveConfigAction.class, (String)"ActiveConfigAction.context.label"));
            } else {
                Mnemonics.setLocalizedText((AbstractButton)this, (String)ActiveConfigAction.this.getName());
            }
        }

        private ProjectConfigurationProvider<?> findPCP() {
            if (this.context != null) {
                Collection projects = this.context.lookupAll(Project.class);
                if (projects.size() == 1) {
                    return (ProjectConfigurationProvider)((Project)projects.iterator().next()).getLookup().lookup(ProjectConfigurationProvider.class);
                }
                return null;
            }
            return ActiveConfigAction.this.pcp;
        }

        public JComponent[] getMenuPresenters() {
            this.removeAll();
            ProjectConfigurationProvider<?> pcp = this.findPCP();
            if (pcp != null) {
                boolean something = false;
                ProjectConfiguration activeConfig = ActiveConfigAction.getActiveConfiguration(pcp);
                for (final ProjectConfiguration config : ActiveConfigAction.getConfigurations(pcp)) {
                    JRadioButtonMenuItem jmi = new JRadioButtonMenuItem(config.getDisplayName(), config.equals(activeConfig));
                    jmi.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            ActiveConfigAction.this.activeConfigurationSelected(config, ConfigMenu.this.findPCP());
                        }
                    });
                    this.add(jmi);
                    something = true;
                }
                if (pcp.hasCustomizer()) {
                    if (something) {
                        this.addSeparator();
                    }
                    something = true;
                    JMenuItem customize = new JMenuItem();
                    Mnemonics.setLocalizedText((AbstractButton)customize, (String)NbBundle.getMessage(ActiveConfigAction.class, (String)"ActiveConfigAction.customize"));
                    customize.addActionListener(this);
                    this.add(customize);
                }
                this.setEnabled(something);
            } else {
                this.setEnabled(false);
            }
            return new JComponent[]{this};
        }

        public JComponent[] synchMenuPresenters(JComponent[] items) {
            return this.getMenuPresenters();
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ProjectConfigurationProvider<?> pcp = this.findPCP();
            if (pcp != null) {
                pcp.customize();
            }
        }
    }

    public static final class DynLayer
    extends MultiFileSystem {
        static DynLayer INSTANCE;
        private final FileSystem fragment;

        public DynLayer() {
            INSTANCE = this;
            this.fragment = FileUtil.createMemoryFileSystem();
            try {
                FileObject f = FileUtil.createData((FileObject)this.fragment.getRoot(), (String)"Toolbars/Build/org-netbeans-modules-project-ui-actions-ActiveConfigAction.shadow");
                f.setAttribute("originalFile", (Object)"Actions/Project/org-netbeans-modules-project-ui-actions-ActiveConfigAction.instance");
                f.setAttribute("position", (Object)80);
            }
            catch (IOException e) {
                throw new AssertionError((Object)e);
            }
        }

        void setEnabled(boolean enabled) {
            if (enabled) {
                this.setDelegates(new FileSystem[]{this.fragment});
            } else {
                this.setDelegates(new FileSystem[0]);
            }
        }
    }
}

