/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.rpc.processor.generator;

import java.util.HashSet;
import java.util.Set;

public final class SimpleToBoxedUtil {
    static Set primitiveSet = null;

    public static String getBoxedExpressionOfType(String s, String c) {
        if (SimpleToBoxedUtil.isPrimitive(c)) {
            StringBuffer sb = new StringBuffer();
            sb.append("new ");
            sb.append(SimpleToBoxedUtil.getBoxedClassName(c));
            sb.append('(');
            sb.append(s);
            sb.append(')');
            return sb.toString();
        }
        return s;
    }

    public static String getUnboxedExpressionOfType(String s, String c) {
        if (SimpleToBoxedUtil.isPrimitive(c)) {
            StringBuffer sb = new StringBuffer();
            sb.append('(');
            sb.append(s);
            sb.append(").");
            sb.append(c);
            sb.append("Value()");
            return sb.toString();
        }
        return s;
    }

    public static String convertExpressionFromTypeToType(String s, String from, String to) throws Exception {
        if (from.equals(to)) {
            return s;
        }
        if (!SimpleToBoxedUtil.isPrimitive(to) && SimpleToBoxedUtil.isPrimitive(from)) {
            return SimpleToBoxedUtil.getBoxedExpressionOfType(s, from);
        }
        if (SimpleToBoxedUtil.isPrimitive(to) && SimpleToBoxedUtil.isPrimitive(from)) {
            return SimpleToBoxedUtil.getUnboxedExpressionOfType(s, to);
        }
        return s;
    }

    public static String getBoxedClassName(String className) {
        if (SimpleToBoxedUtil.isPrimitive(className)) {
            StringBuffer sb = new StringBuffer();
            if (className.equals(Integer.TYPE.getName())) {
                sb.append("java.lang.Integer");
            } else if (className.equals(Character.TYPE.getName())) {
                sb.append("java.lang.Character");
            } else {
                sb.append(Character.toUpperCase(className.charAt(0)));
                sb.append(className.substring(1));
            }
            return sb.toString();
        }
        return className;
    }

    public static boolean isPrimitive(String className) {
        return primitiveSet.contains(className);
    }

    static {
        primitiveSet = new HashSet();
        primitiveSet.add("boolean");
        primitiveSet.add("byte");
        primitiveSet.add("double");
        primitiveSet.add("float");
        primitiveSet.add("int");
        primitiveSet.add("long");
        primitiveSet.add("short");
    }
}

