/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.heapwalk;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.regex.PatternSyntaxException;
import javax.swing.AbstractButton;
import javax.swing.JPanel;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.netbeans.api.project.Project;
import org.netbeans.lib.profiler.heap.Heap;
import org.netbeans.lib.profiler.heap.JavaClass;
import org.netbeans.modules.profiler.heapwalk.AbstractController;
import org.netbeans.modules.profiler.heapwalk.ClassesController;
import org.netbeans.modules.profiler.heapwalk.HeapFragmentWalker;
import org.netbeans.modules.profiler.heapwalk.ui.ClassesListControllerUI;
import org.netbeans.modules.profiler.projectsupport.utilities.SourceUtils;
import org.openide.util.NbBundle;

public class ClassesListController
extends AbstractController {
    private static final String ANALYZING_CLASSES_MSG = NbBundle.getMessage(ClassesListController.class, (String)"ClassesListController_AnalyzingClassesMsg");
    public static final int FILTER_SUBCLASS = 1001;
    private ClassesController classesController;
    private JavaClass selectedClass;

    public ClassesListController(ClassesController classesController) {
        this.classesController = classesController;
    }

    public ClassesController getClassesController() {
        return this.classesController;
    }

    public void setColumnVisibility(int n, boolean bl) {
        ((ClassesListControllerUI)((Object)this.getPanel())).setColumnVisibility(n, bl);
    }

    public List getFilteredSortedClasses(String[] stringArray, int n, boolean bl, boolean bl2, int n2, boolean bl3) {
        HeapFragmentWalker heapFragmentWalker = this.classesController.getHeapFragmentWalker();
        Heap heap = heapFragmentWalker.getHeapFragment();
        List list = n == 1001 && stringArray != null && !stringArray[0].equals("") ? ClassesListController.getFilteredClasses(ClassesListController.getSubclasses(heap, stringArray, heapFragmentWalker.getHeapDumpProject()), null, 0, bl, bl2) : ClassesListController.getFilteredClasses(heap.getAllClasses(), stringArray, n, bl, bl2);
        return ClassesListController.getSortedClasses(list, n2, bl3);
    }

    public JavaClass getSelectedClass() {
        return this.selectedClass;
    }

    public void classSelected(JavaClass javaClass) {
        if (this.selectedClass == javaClass) {
            return;
        }
        this.selectedClass = javaClass;
        this.classesController.classSelected();
    }

    public static boolean matchesFilter(JavaClass javaClass, String[] stringArray, int n, boolean bl, boolean bl2) {
        int n2 = javaClass.getInstancesCount();
        int n3 = javaClass.getInstanceSize();
        if (!bl && n2 == 0) {
            return false;
        }
        if (!(bl2 || n2 != 0 && n3 != 0)) {
            return false;
        }
        if (n == 0 || stringArray == null || stringArray[0].equals("")) {
            return true;
        }
        return ClassesListController.passesFilters(javaClass.getName(), stringArray, n);
    }

    public void selectClass(JavaClass javaClass) {
        ((ClassesListControllerUI)((Object)this.getPanel())).ensureWillBeVisible(javaClass);
        ((ClassesListControllerUI)((Object)this.getPanel())).selectClass(javaClass);
    }

    public void updateData() {
        ((ClassesListControllerUI)((Object)this.getPanel())).updateData();
    }

    @Override
    protected AbstractButton createControllerPresenter() {
        return ((ClassesListControllerUI)((Object)this.getPanel())).getPresenter();
    }

    @Override
    protected JPanel createControllerUI() {
        return new ClassesListControllerUI(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Collection getContextSubclasses(Heap heap, String string, Project project) {
        ProgressHandle progressHandle = null;
        try {
            progressHandle = ProgressHandleFactory.createHandle((String)ANALYZING_CLASSES_MSG);
            progressHandle.setInitialDelay(0);
            progressHandle.start();
            HashSet<JavaClass> hashSet = new HashSet<JavaClass>();
            String[] stringArray = SourceUtils.getSubclassesNames((String)string, (Project)project);
            for (int i = 0; i < stringArray.length; ++i) {
                JavaClass javaClass = heap.getJavaClassByName(stringArray[i]);
                if (javaClass == null || !hashSet.add(javaClass)) continue;
                hashSet.addAll(javaClass.getSubClasses());
            }
            HashSet<JavaClass> hashSet2 = hashSet;
            return hashSet2;
        }
        finally {
            if (progressHandle != null) {
                progressHandle.finish();
            }
        }
    }

    private static List getFilteredClasses(List list, String[] stringArray, int n, boolean bl, boolean bl2) {
        ArrayList<JavaClass> arrayList = new ArrayList<JavaClass>();
        for (JavaClass javaClass : list) {
            if (!ClassesListController.matchesFilter(javaClass, stringArray, n, bl, bl2)) continue;
            arrayList.add(javaClass);
        }
        return arrayList;
    }

    private static List getSortedClasses(List list, int n, boolean bl) {
        Collections.sort(list, new ClassesComparator(n, bl));
        return list;
    }

    private static List getSubclasses(Heap heap, String[] stringArray, Project project) {
        HashSet<JavaClass> hashSet = new HashSet<JavaClass>();
        for (int i = 0; i < stringArray.length; ++i) {
            JavaClass javaClass = heap.getJavaClassByName(stringArray[i]);
            if (javaClass == null) continue;
            Collection collection = javaClass.getSubClasses();
            hashSet.add(javaClass);
            if (collection.size() > 0) {
                hashSet.addAll(collection);
                continue;
            }
            if (project == null) continue;
            hashSet.addAll(ClassesListController.getContextSubclasses(heap, stringArray[i], project));
        }
        return new ArrayList(hashSet);
    }

    private static boolean passesFilter(String string, String string2, int n) {
        switch (n) {
            case 10: {
                return string.regionMatches(true, 0, string2, 0, string2.length());
            }
            case 20: {
                return string.toLowerCase().indexOf(string2.toLowerCase()) != -1;
            }
            case 30: {
                return string.regionMatches(true, string.length() - string2.length(), string2, 0, string2.length());
            }
            case 40: {
                return string.equalsIgnoreCase(string2);
            }
            case 50: {
                try {
                    return string.matches(string2);
                }
                catch (PatternSyntaxException patternSyntaxException) {
                    return false;
                }
            }
        }
        return false;
    }

    private static boolean passesFilters(String string, String[] stringArray, int n) {
        for (int i = 0; i < stringArray.length; ++i) {
            if (!ClassesListController.passesFilter(string, stringArray[i], n)) continue;
            return true;
        }
        return false;
    }

    private static class ClassesComparator
    implements Comparator {
        private boolean sortingOrder;
        private int sortingColumn;

        public ClassesComparator(int n, boolean bl) {
            this.sortingColumn = n;
            this.sortingOrder = bl;
        }

        public int compare(Object object, Object object2) {
            JavaClass javaClass = this.sortingOrder ? (JavaClass)object : (JavaClass)object2;
            JavaClass javaClass2 = this.sortingOrder ? (JavaClass)object2 : (JavaClass)object;
            switch (this.sortingColumn) {
                case 0: {
                    return javaClass.getName().compareTo(javaClass2.getName());
                }
                case 1: 
                case 2: {
                    return new Integer(javaClass.getInstancesCount()).compareTo(new Integer(javaClass2.getInstancesCount()));
                }
                case 3: {
                    return new Long(javaClass.getAllInstancesSize()).compareTo(javaClass2.getAllInstancesSize());
                }
            }
            throw new RuntimeException("Unsupported compare operation for " + object + ", " + object2);
        }
    }
}

