/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.settings;

import java.util.Collections;
import java.util.EventListener;
import java.util.Set;
import java.util.logging.Logger;
import org.openide.filesystems.FileAttributeEvent;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileRenameEvent;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.FolderLookup;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.WeakListeners;
import org.openide.util.lookup.Lookups;
import org.openide.util.lookup.ProxyLookup;
import org.openide.util.lookup.implspi.NamedServicesProvider;

public final class RecognizeInstanceObjects
extends NamedServicesProvider {
    private static final Logger LOG = Logger.getLogger(RecognizeInstanceObjects.class.getName());

    public Lookup create(String path) {
        return new OverObjects(path);
    }

    private static final class OverObjects
    extends ProxyLookup
    implements LookupListener,
    FileChangeListener {
        private static Lookup.Result<ClassLoader> CL = Lookup.getDefault().lookupResult(ClassLoader.class);
        private final String path;

        public OverObjects(String path) {
            block2: {
                super(OverObjects.delegates(path));
                this.path = path;
                CL.addLookupListener((LookupListener)WeakListeners.create(LookupListener.class, (EventListener)((Object)this), CL));
                try {
                    FileSystem sfs = FileUtil.getConfigRoot().getFileSystem();
                    sfs.addFileChangeListener(FileUtil.weakFileChangeListener((FileChangeListener)this, (Object)sfs));
                }
                catch (FileStateInvalidException x) {
                    if ($assertionsDisabled) break block2;
                    throw new AssertionError((Object)x);
                }
            }
        }

        private static Lookup[] delegates(String path) {
            Set<ClassLoader> allCL = CL.allInstances();
            ClassLoader ccl = Thread.currentThread().getContextClassLoader();
            if (ccl != null) {
                allCL = Collections.singleton(ccl);
            } else if (allCL.isEmpty()) {
                allCL = Collections.singleton(RecognizeInstanceObjects.class.getClassLoader());
            }
            Lookup base = Lookups.metaInfServices((ClassLoader)((ClassLoader)allCL.iterator().next()), (String)("META-INF/namedservices/" + path));
            FileObject fo = FileUtil.getConfigFile((String)path);
            if (fo == null) {
                return new Lookup[]{base};
            }
            String s = path.endsWith("/") ? path.substring(0, path.length() - 1) : path;
            return new Lookup[]{new FolderLookup((DataObject.Container)DataFolder.findFolder((FileObject)fo), s).getLookup(), base};
        }

        public void resultChanged(LookupEvent ev) {
            this.setLookups(OverObjects.delegates(this.path));
        }

        public void fileFolderCreated(FileEvent fe) {
            this.ch(fe);
        }

        public void fileDataCreated(FileEvent fe) {
            this.ch(fe);
        }

        public void fileChanged(FileEvent fe) {
            this.ch(fe);
        }

        public void fileDeleted(FileEvent fe) {
            this.ch(fe);
        }

        public void fileRenamed(FileRenameEvent fe) {
            this.ch((FileEvent)fe);
        }

        public void fileAttributeChanged(FileAttributeEvent fe) {
            this.ch((FileEvent)fe);
        }

        private void ch(FileEvent e) {
            if ((e.getFile().getPath() + "/").startsWith(this.path)) {
                this.setLookups(OverObjects.delegates(this.path));
            }
        }
    }
}

