/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby.railsprojects.ui.wizards;

import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.List;
import java.util.logging.Logger;
import javax.swing.AbstractListModel;
import javax.swing.ComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.api.ruby.platform.RubyPlatform;
import org.netbeans.modules.ruby.railsprojects.database.ConfigurableRailsAdapter;
import org.netbeans.modules.ruby.railsprojects.database.RailsAdapterFactory;
import org.netbeans.modules.ruby.railsprojects.database.RailsDatabaseConfiguration;
import org.netbeans.modules.ruby.railsprojects.ui.wizards.DatabaseConfigPanelVisual;
import org.netbeans.modules.ruby.railsprojects.ui.wizards.SettingsPanel;
import org.openide.WizardDescriptor;
import org.openide.WizardValidationException;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

class RailsAdaptersPanel
extends SettingsPanel {
    private static final Logger LOGGER = Logger.getLogger(RailsAdaptersPanel.class.getName());
    private String projectName;
    private boolean manuallyEdited;
    private DocumentListener databaseNameListener;
    private final DatabaseConfigPanelVisual parent;
    private boolean useJdbcOriginallySelected;
    private boolean useJdbcOriginallyEnabled;
    private JTextField databaseNameField;
    private JLabel databaseNameLabel;
    private JComboBox developmentComboBox;
    private JLabel developmentLabel;
    private JPasswordField passwordField;
    private JLabel passwordLabel;
    private JTextField userNameField;
    private JLabel userNameLabel;

    public RailsAdaptersPanel(DatabaseConfigPanelVisual parent) {
        this.initComponents();
        this.parent = parent;
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        if (!enabled) {
            this.resetUseJdbc();
        } else {
            this.initJdbcCheckBox();
        }
    }

    private void resetUseJdbc() {
        this.parent.getUseJdbc().setSelected(this.useJdbcOriginallySelected);
        this.parent.getUseJdbc().setEnabled(this.useJdbcOriginallyEnabled);
    }

    private void initDatabaseNameField() {
        if (this.manuallyEdited) {
            return;
        }
        RailsDatabaseConfiguration configuration = (RailsDatabaseConfiguration)this.developmentComboBox.getSelectedItem();
        this.databaseNameField.getDocument().removeDocumentListener(this.databaseNameListener);
        if (configuration != null) {
            this.databaseNameField.setText(configuration.getDatabaseName(this.projectName));
        }
        this.databaseNameField.getDocument().addDocumentListener(this.databaseNameListener);
    }

    private void initComponents() {
        this.developmentLabel = new JLabel();
        this.developmentComboBox = new JComboBox();
        this.databaseNameLabel = new JLabel();
        this.databaseNameField = new JTextField();
        this.userNameLabel = new JLabel();
        this.userNameField = new JTextField();
        this.passwordLabel = new JLabel();
        this.passwordField = new JPasswordField();
        this.developmentLabel.setLabelFor(this.developmentComboBox);
        Mnemonics.setLocalizedText((JLabel)this.developmentLabel, (String)NbBundle.getMessage(RailsAdaptersPanel.class, (String)"LBL_DatabaseAdapter"));
        this.databaseNameLabel.setLabelFor(this.databaseNameField);
        Mnemonics.setLocalizedText((JLabel)this.databaseNameLabel, (String)NbBundle.getMessage(RailsAdaptersPanel.class, (String)"LBL_DatabaseName"));
        this.userNameLabel.setLabelFor(this.userNameField);
        Mnemonics.setLocalizedText((JLabel)this.userNameLabel, (String)NbBundle.getMessage(RailsAdaptersPanel.class, (String)"LBL_UserName"));
        this.userNameField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RailsAdaptersPanel.this.userNameFieldActionPerformed(evt);
            }
        });
        this.passwordLabel.setLabelFor(this.passwordField);
        Mnemonics.setLocalizedText((JLabel)this.passwordLabel, (String)NbBundle.getMessage(RailsAdaptersPanel.class, (String)"LBL_Password"));
        GroupLayout layout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.developmentLabel).add((Component)this.databaseNameLabel).add((Component)this.userNameLabel).add((Component)this.passwordLabel)).add((GroupLayout.Group)layout.createParallelGroup(2).add((GroupLayout.Group)layout.createSequentialGroup().addPreferredGap(0).add((Component)this.developmentComboBox, 0, 374, Short.MAX_VALUE)).add(1, (GroupLayout.Group)layout.createSequentialGroup().addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(1).add(2, (Component)this.passwordField, -1, 374, Short.MAX_VALUE).add(2, (Component)this.userNameField, -1, 374, Short.MAX_VALUE).add((Component)this.databaseNameField, -1, 374, Short.MAX_VALUE))))));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.developmentLabel).add((Component)this.developmentComboBox, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.databaseNameLabel).add((Component)this.databaseNameField, -2, 22, -2)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.userNameLabel).add((Component)this.userNameField, -2, 21, -2)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.passwordLabel).add((Component)this.passwordField, -2, 22, -2)).addContainerGap(23, Short.MAX_VALUE)));
        this.developmentLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(RailsAdaptersPanel.class, (String)"ACSD_DatabaseAdapter"));
        this.databaseNameLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(RailsAdaptersPanel.class, (String)"ASCD_DatabaseName"));
        this.userNameLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(RailsAdaptersPanel.class, (String)"ASCD_UserName"));
        this.passwordLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(RailsAdaptersPanel.class, (String)"ASCD_Password"));
        this.getAccessibleContext().setAccessibleName(NbBundle.getMessage(RailsAdaptersPanel.class, (String)"ASCN_RailsAdapterPanel"));
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(RailsAdaptersPanel.class, (String)"ASCD_RailsAdapterPanel"));
        this.getAccessibleContext().setAccessibleParent(this);
    }

    private void userNameFieldActionPerformed(ActionEvent evt) {
    }

    @Override
    void store(WizardDescriptor settings) {
        boolean jdbc = settings.getProperty("useJdbc") != null ? (Boolean)settings.getProperty("useJdbc") : false;
        RailsDatabaseConfiguration databaseConfiguration = (RailsDatabaseConfiguration)this.developmentComboBox.getSelectedItem();
        databaseConfiguration = new ConfigurableRailsAdapter((RailsDatabaseConfiguration)this.developmentComboBox.getSelectedItem(), this.userNameField.getText(), String.valueOf(this.passwordField.getPassword()), this.databaseNameField.getText(), jdbc);
        settings.putProperty("railsDatabase.development", (Object)databaseConfiguration);
    }

    void initJdbcCheckBox() {
        RailsDatabaseConfiguration selected = (RailsDatabaseConfiguration)this.developmentComboBox.getSelectedItem();
        if (selected != null && selected.requiresJdbc()) {
            this.parent.getUseJdbc().setSelected(true);
            this.parent.getUseJdbc().setEnabled(false);
        } else {
            this.resetUseJdbc();
        }
    }

    @Override
    void read(WizardDescriptor settings) {
        RubyPlatform platform = (RubyPlatform)settings.getProperty("platform");
        List<RailsDatabaseConfiguration> adapters = RailsAdapterFactory.getAdapters(platform);
        this.useJdbcOriginallyEnabled = this.parent.getUseJdbc().isEnabled();
        this.useJdbcOriginallySelected = this.parent.getUseJdbc().isSelected();
        this.developmentComboBox.setModel(new AdapterListModel(adapters));
        this.developmentComboBox.setRenderer(new AdapterListCellRendered());
        this.developmentComboBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                RailsAdaptersPanel.this.initDatabaseNameField();
                RailsAdaptersPanel.this.initJdbcCheckBox();
            }
        });
        this.databaseNameListener = new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                RailsAdaptersPanel.this.manuallyEdited = true;
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                RailsAdaptersPanel.this.manuallyEdited = true;
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                RailsAdaptersPanel.this.manuallyEdited = true;
            }
        };
        String name = (String)settings.getProperty("name");
        if (!name.equals(this.projectName)) {
            this.projectName = name;
            this.initDatabaseNameField();
        }
        this.initJdbcCheckBox();
    }

    @Override
    boolean valid(WizardDescriptor settings) {
        return true;
    }

    @Override
    void validate(WizardDescriptor settings) throws WizardValidationException {
    }

    private static class AdapterListCellRendered
    extends JLabel
    implements ListCellRenderer {
        public AdapterListCellRendered() {
            this.setOpaque(true);
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            if (value == null) {
                return this;
            }
            RailsDatabaseConfiguration dbConf = (RailsDatabaseConfiguration)value;
            this.setText(dbConf.getDisplayName());
            this.setForeground(isSelected ? list.getSelectionForeground() : list.getForeground());
            this.setBackground(isSelected ? list.getSelectionBackground() : list.getBackground());
            return this;
        }
    }

    private static class AdapterListModel
    extends AbstractListModel
    implements ComboBoxModel {
        private final List<? extends RailsDatabaseConfiguration> adapters;
        private Object selected;

        public AdapterListModel(List<? extends RailsDatabaseConfiguration> adapters) {
            this.adapters = adapters;
            this.selected = adapters.get(0);
        }

        @Override
        public int getSize() {
            return this.adapters.size();
        }

        @Override
        public Object getElementAt(int index) {
            return this.adapters.get(index);
        }

        @Override
        public void setSelectedItem(Object adapter) {
            if (this.selected != adapter) {
                this.selected = adapter;
                this.fireContentsChanged(this, -1, -1);
            }
        }

        @Override
        public Object getSelectedItem() {
            return this.selected;
        }
    }
}

