/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.nbtasks;

import com.sun.javacard.AID;
import com.sun.javacard.filemodels.DeploymentXmlAppletEntry;
import com.sun.javacard.filemodels.DeploymentXmlInstanceEntry;
import com.sun.javacard.filemodels.DeploymentXmlModel;
import com.sun.javacard.nbtasks.JCInstallerTask;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import org.apache.tools.ant.BuildException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CreateTask
extends JCInstallerTask {
    private String bundleName;
    private String instanceID;
    private File instancesFile;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute() throws BuildException {
        this.validateBundleName();
        if (this.isWebApplication()) {
            this.validateInstanceID();
        } else {
            this.validateInstancesFile();
        }
        if (this.isWebApplication()) {
            this.createArg().setValue("create");
            this.createArg().setValue("--name");
            this.createArg().setValue(this.bundleName);
            if (this.instanceID != null) {
                this.createArg().setValue("--instance");
                this.createArg().setValue(this.instanceID);
            }
            super.execute();
        } else {
            try {
                DeploymentXmlModel deploymentXmlModel;
                BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(this.instancesFile));
                try {
                    deploymentXmlModel = new DeploymentXmlModel((InputStream)bufferedInputStream);
                }
                finally {
                    bufferedInputStream.close();
                }
                for (DeploymentXmlAppletEntry deploymentXmlAppletEntry : deploymentXmlModel.getData()) {
                    AID aID = deploymentXmlAppletEntry.getAppletAid();
                    this.instantiateForOneApplet(aID, deploymentXmlAppletEntry.getData());
                }
            }
            catch (IOException iOException) {
                throw new BuildException((Throwable)iOException);
            }
        }
    }

    private void instantiateForOneApplet(AID aID, List<? extends DeploymentXmlInstanceEntry> list) throws BuildException {
        for (DeploymentXmlInstanceEntry deploymentXmlInstanceEntry : list) {
            String string = deploymentXmlInstanceEntry.getDeploymentParams();
            AID aID2 = deploymentXmlInstanceEntry.getInstanceAID();
            this.instantiateOneInstanceForOneApplet(aID, aID2, string);
        }
    }

    private void instantiateOneInstanceForOneApplet(AID aID, AID aID2, String string) throws BuildException {
        String string2 = aID.toString();
        String string3 = aID2.toString();
        String string4 = string.trim();
        if (string4.length() <= 0) {
            string4 = null;
        }
        super.clearArgs();
        this.createArg().setValue("create");
        this.createArg().setValue("--name");
        this.createArg().setValue(this.bundleName);
        if (string2 != null) {
            this.createArg().setValue("--applet");
            this.createArg().setValue(string2);
        }
        if (string3 != null) {
            this.createArg().setValue("--instance");
            this.createArg().setValue(string3);
        }
        if (string4 != null) {
            this.createArg().setValue("--data");
            this.createArg().setValue(string4);
        }
        super.execute();
    }

    private void validateBundleName() throws BuildException {
        if (this.bundleName == null) {
            this.bundleName = this.getProject().getProperty("display.name");
        }
        if (this.bundleName == null) {
            throw new BuildException("BundleName value not specified");
        }
        this.bundleName = this.bundleName.trim();
        if (this.bundleName.length() <= 0) {
            throw new BuildException("Empty value for BundleName");
        }
    }

    private void validateInstanceID() throws BuildException {
        if (this.instanceID == null) {
            this.instanceID = this.getProject().getProperty("webcontextpath");
        }
        if (this.instanceID == null) {
            this.instanceID = this.getProject().getProperty("webcontextpath");
        }
        if (this.instanceID != null) {
            this.instanceID = this.instanceID.trim();
            if (this.instanceID.length() <= 0) {
                this.instanceID = null;
            }
        }
    }

    private void validateInstancesFile() {
        if (this.instancesFile == null) {
            this.instancesFile = new File(this.getProject().getBaseDir(), "nbproject/deployment.xml");
        }
        if (this.instancesFile == null) {
            throw new BuildException("Instances File Not Set / Missing.");
        }
        if (!this.instancesFile.exists()) {
            throw new BuildException(this.instancesFile.getPath() + " does not exist");
        }
        if (!this.instancesFile.isFile()) {
            throw new BuildException(this.instancesFile.getPath() + " is not a regular file");
        }
    }

    public String getBundleName() {
        return this.bundleName;
    }

    public void setBundleName(String string) {
        this.bundleName = string;
    }

    public String getInstanceID() {
        return this.instanceID;
    }

    public void setInstanceID(String string) {
        this.instanceID = string;
    }

    public File getInstancesFile() {
        return this.instancesFile;
    }

    public void setInstancesFile(File file) {
        this.instancesFile = file;
    }
}

