/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.ui.threads;

import java.awt.Component;
import javax.swing.JTable;
import org.netbeans.lib.profiler.results.threads.ThreadData;
import org.netbeans.lib.profiler.ui.components.table.LabelTableCellRenderer;
import org.netbeans.lib.profiler.ui.threads.ThreadStateIcon;
import org.netbeans.lib.profiler.ui.threads.ThreadsPanel;

public class ThreadNameCellRenderer
extends LabelTableCellRenderer {
    private static final int THREAD_ICON_SIZE = 9;
    private static ThreadStateIcon noneIcon = new ThreadStateIcon(-100, 9, 9);
    private static ThreadStateIcon unknownIcon = new ThreadStateIcon(-1, 9, 9);
    private static ThreadStateIcon zombieIcon = new ThreadStateIcon(0, 9, 9);
    private static ThreadStateIcon runningIcon = new ThreadStateIcon(1, 9, 9);
    private static ThreadStateIcon sleepingIcon = new ThreadStateIcon(2, 9, 9);
    private static ThreadStateIcon monitorIcon = new ThreadStateIcon(3, 9, 9);
    private static ThreadStateIcon waitIcon = new ThreadStateIcon(4, 9, 9);
    private ThreadsPanel viewManager;

    public ThreadNameCellRenderer(ThreadsPanel viewManager) {
        this.viewManager = viewManager;
    }

    @Override
    public Component getTableCellRendererComponentPersistent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        return new ThreadNameCellRenderer(this.viewManager).getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
    }

    @Override
    protected void setValue(JTable table, Object value, int row, int column) {
        super.setValue(table, value, row, column);
        if (value == null) {
            this.label.setText("");
            this.label.setIcon(zombieIcon);
        } else {
            int index = (Integer)value;
            ThreadData threadData = this.viewManager.getThreadData(index);
            this.label.setText(this.viewManager.getThreadName(index));
            if (threadData.size() > 0) {
                byte state = threadData.getLastState();
                switch (state) {
                    case -1: {
                        this.label.setIcon(unknownIcon);
                        break;
                    }
                    case 0: {
                        this.label.setIcon(zombieIcon);
                        break;
                    }
                    case 1: {
                        this.label.setIcon(runningIcon);
                        break;
                    }
                    case 2: {
                        if (this.viewManager.supportsSleepingState()) {
                            this.label.setIcon(sleepingIcon);
                            break;
                        }
                        this.label.setIcon(runningIcon);
                        break;
                    }
                    case 3: {
                        this.label.setIcon(monitorIcon);
                        break;
                    }
                    case 4: {
                        this.label.setIcon(waitIcon);
                    }
                }
            } else {
                this.label.setIcon(zombieIcon);
            }
        }
    }
}

