// This file is generated by TableGen. Do not edit.

#ifndef LLVM_CLANG_ATTR_CLASSES_INC
#define LLVM_CLANG_ATTR_CLASSES_INC

class AcquiredAfterAttr : public InheritableAttr {
  unsigned argsSize;
  Expr * *args;


 public:
  AcquiredAfterAttr(SourceRange R, ASTContext &Ctx
              , Expr * *Args, unsigned ArgsSize
             )
    : InheritableAttr(attr::AcquiredAfter, R)
              , argsSize(ArgsSize), args(new (Ctx, 16) Expr *[argsSize])
  {
    std::memcpy(args, Args, argsSize * sizeof(Expr *));

  }

  virtual AcquiredAfterAttr *clone (ASTContext &C) const;
  virtual void printPretty(llvm::raw_ostream &OS,                           const PrintingPolicy &Policy) const;
  typedef Expr ** args_iterator;
  args_iterator args_begin() const {
    return args;
  }
  args_iterator args_end() const {
    return args + argsSize;
  }
  unsigned args_size() const {
    return argsSize;
  }



  static bool classof(const Attr *A) { return A->getKind() == attr::AcquiredAfter; }
  virtual bool isLateParsed() const { return 1; }
};

class AcquiredBeforeAttr : public InheritableAttr {
  unsigned argsSize;
  Expr * *args;


 public:
  AcquiredBeforeAttr(SourceRange R, ASTContext &Ctx
              , Expr * *Args, unsigned ArgsSize
             )
    : InheritableAttr(attr::AcquiredBefore, R)
              , argsSize(ArgsSize), args(new (Ctx, 16) Expr *[argsSize])
  {
    std::memcpy(args, Args, argsSize * sizeof(Expr *));

  }

  virtual AcquiredBeforeAttr *clone (ASTContext &C) const;
  virtual void printPretty(llvm::raw_ostream &OS,                           const PrintingPolicy &Policy) const;
  typedef Expr ** args_iterator;
  args_iterator args_begin() const {
    return args;
  }
  args_iterator args_end() const {
    return args + argsSize;
  }
  unsigned args_size() const {
    return argsSize;
  }



  static bool classof(const Attr *A) { return A->getKind() == attr::AcquiredBefore; }
  virtual bool isLateParsed() const { return 1; }
};

class AliasAttr : public InheritableAttr {
unsigned aliaseeLength;
char *aliasee;


 public:
  AliasAttr(SourceRange R, ASTContext &Ctx
              , llvm::StringRef Aliasee
             )
    : InheritableAttr(attr::Alias, R)
              , aliaseeLength(Aliasee.size()),aliasee(new (Ctx, 1) char[aliaseeLength])
  {
      std::memcpy(aliasee, Aliasee.data(), aliaseeLength);
  }

  virtual AliasAttr *clone (ASTContext &C) const;
  virtual void printPretty(llvm::raw_ostream &OS,                           const PrintingPolicy &Policy) const;
  llvm::StringRef getAliasee() const {
    return llvm::StringRef(aliasee, aliaseeLength);
  }
  unsigned getAliaseeLength() const {
    return aliaseeLength;
  }
  void setAliasee(ASTContext &C, llvm::StringRef S) {
    aliaseeLength = S.size();
    this->aliasee = new (C, 1) char [aliaseeLength];
    std::memcpy(this->aliasee, S.data(), aliaseeLength);
  }



  static bool classof(const Attr *A) { return A->getKind() == attr::Alias; }
  virtual bool isLateParsed() const { return 0; }
};

class AlignMac68kAttr : public InheritableAttr {

 public:
  AlignMac68kAttr(SourceRange R, ASTContext &Ctx
             )
    : InheritableAttr(attr::AlignMac68k, R)
  {
  }

  virtual AlignMac68kAttr *clone (ASTContext &C) const;
  virtual void printPretty(llvm::raw_ostream &OS,                           const PrintingPolicy &Policy) const;


  static bool classof(const Attr *A) { return A->getKind() == attr::AlignMac68k; }
  virtual bool isLateParsed() const { return 0; }
};

class AlignedAttr : public InheritableAttr {
bool isalignmentExpr;
union {
Expr *alignmentExpr;
TypeSourceInfo *alignmentType;
};

bool isMSDeclSpec;


 public:
  AlignedAttr(SourceRange R, ASTContext &Ctx
              , bool IsAlignmentExpr, void *Alignment
              , bool IsMSDeclSpec
             )
    : InheritableAttr(attr::Aligned, R)
              , isalignmentExpr(IsAlignmentExpr)
              , isMSDeclSpec(IsMSDeclSpec)
  {
    if (isalignmentExpr)
       alignmentExpr = reinterpret_cast<Expr *>(Alignment);
    else
       alignmentType = reinterpret_cast<TypeSourceInfo *>(Alignment);

  }

  virtual AlignedAttr *clone (ASTContext &C) const;
  virtual void printPretty(llvm::raw_ostream &OS,                           const PrintingPolicy &Policy) const;
  bool isAlignmentDependent() const;
  unsigned getAlignment(ASTContext &Ctx) const;
  bool isAlignmentExpr() const {
    return isalignmentExpr;
  }
  Expr *getAlignmentExpr() const {
    assert(isalignmentExpr);
    return alignmentExpr;
  }
  TypeSourceInfo *getAlignmentType() const {
    assert(!isalignmentExpr);
    return alignmentType;
  }

  bool getIsMSDeclSpec() const {
    return isMSDeclSpec;
  }



  static bool classof(const Attr *A) { return A->getKind() == attr::Aligned; }
  virtual bool isLateParsed() const { return 0; }
};

class AllocSizeAttr : public Attr {
  unsigned argsSize;
  unsigned *args;


 public:
  AllocSizeAttr(SourceRange R, ASTContext &Ctx
              , unsigned *Args, unsigned ArgsSize
             )
    : Attr(attr::AllocSize, R)
              , argsSize(ArgsSize), args(new (Ctx, 16) unsigned[argsSize])
  {
    std::memcpy(args, Args, argsSize * sizeof(unsigned));

  }

  virtual AllocSizeAttr *clone (ASTContext &C) const;
  virtual void printPretty(llvm::raw_ostream &OS,                           const PrintingPolicy &Policy) const;
  typedef unsigned* args_iterator;
  args_iterator args_begin() const {
    return args;
  }
  args_iterator args_end() const {
    return args + argsSize;
  }
  unsigned args_size() const {
    return argsSize;
  }



  static bool classof(const Attr *A) { return A->getKind() == attr::AllocSize; }
  virtual bool isLateParsed() const { return 0; }
};

class AlwaysInlineAttr : public InheritableAttr {

 public:
  AlwaysInlineAttr(SourceRange R, ASTContext &Ctx
             )
    : InheritableAttr(attr::AlwaysInline, R)
  {
  }

  virtual AlwaysInlineAttr *clone (ASTContext &C) const;
  virtual void printPretty(llvm::raw_ostream &OS,                           const PrintingPolicy &Policy) const;


  static bool classof(const Attr *A) { return A->getKind() == attr::AlwaysInline; }
  virtual bool isLateParsed() const { return 0; }
};

class AnalyzerNoReturnAttr : public InheritableAttr {

 public:
  AnalyzerNoReturnAttr(SourceRange R, ASTContext &Ctx
             )
    : InheritableAttr(attr::AnalyzerNoReturn, R)
  {
  }

  virtual AnalyzerNoReturnAttr *clone (ASTContext &C) const;
  virtual void printPretty(llvm::raw_ostream &OS,                           const PrintingPolicy &Policy) const;


  static bool classof(const Attr *A) { return A->getKind() == attr::AnalyzerNoReturn; }
  virtual bool isLateParsed() const { return 0; }
};

class AnnotateAttr : public InheritableParamAttr {
unsigned annotationLength;
char *annotation;


 public:
  AnnotateAttr(SourceRange R, ASTContext &Ctx
              , llvm::StringRef Annotation
             )
    : InheritableParamAttr(attr::Annotate, R)
              , annotationLength(Annotation.size()),annotation(new (Ctx, 1) char[annotationLength])
  {
      std::memcpy(annotation, Annotation.data(), annotationLength);
  }

  virtual AnnotateAttr *clone (ASTContext &C) const;
  virtual void printPretty(llvm::raw_ostream &OS,                           const PrintingPolicy &Policy) const;
  llvm::StringRef getAnnotation() const {
    return llvm::StringRef(annotation, annotationLength);
  }
  unsigned getAnnotationLength() const {
    return annotationLength;
  }
  void setAnnotation(ASTContext &C, llvm::StringRef S) {
    annotationLength = S.size();
    this->annotation = new (C, 1) char [annotationLength];
    std::memcpy(this->annotation, S.data(), annotationLength);
  }



  static bool classof(const Attr *A) { return A->getKind() == attr::Annotate; }
  virtual bool isLateParsed() const { return 0; }
};

class ArcWeakrefUnavailableAttr : public InheritableAttr {

 public:
  ArcWeakrefUnavailableAttr(SourceRange R, ASTContext &Ctx
             )
    : InheritableAttr(attr::ArcWeakrefUnavailable, R)
  {
  }

  virtual ArcWeakrefUnavailableAttr *clone (ASTContext &C) const;
  virtual void printPretty(llvm::raw_ostream &OS,                           const PrintingPolicy &Policy) const;


  static bool classof(const Attr *A) { return A->getKind() == attr::ArcWeakrefUnavailable; }
  virtual bool isLateParsed() const { return 0; }
};

class ArgumentWithTypeTagAttr : public InheritableAttr {
IdentifierInfo * argumentKind;

unsigned argumentIdx;

unsigned typeTagIdx;

bool isPointer;


 public:
  ArgumentWithTypeTagAttr(SourceRange R, ASTContext &Ctx
              , IdentifierInfo * ArgumentKind
              , unsigned ArgumentIdx
              , unsigned TypeTagIdx
              , bool IsPointer
             )
    : InheritableAttr(attr::ArgumentWithTypeTag, R)
              , argumentKind(ArgumentKind)
              , argumentIdx(ArgumentIdx)
              , typeTagIdx(TypeTagIdx)
              , isPointer(IsPointer)
  {




  }

  virtual ArgumentWithTypeTagAttr *clone (ASTContext &C) const;
  virtual void printPretty(llvm::raw_ostream &OS,                           const PrintingPolicy &Policy) const;
  IdentifierInfo * getArgumentKind() const {
    return argumentKind;
  }

  unsigned getArgumentIdx() const {
    return argumentIdx;
  }

  unsigned getTypeTagIdx() const {
    return typeTagIdx;
  }

  bool getIsPointer() const {
    return isPointer;
  }



  static bool classof(const Attr *A) { return A->getKind() == attr::ArgumentWithTypeTag; }
  virtual bool isLateParsed() const { return 0; }
};

class AsmLabelAttr : public InheritableAttr {
unsigned labelLength;
char *label;


 public:
  AsmLabelAttr(SourceRange R, ASTContext &Ctx
              , llvm::StringRef Label
             )
    : InheritableAttr(attr::AsmLabel, R)
              , labelLength(Label.size()),label(new (Ctx, 1) char[labelLength])
  {
      std::memcpy(label, Label.data(), labelLength);
  }

  virtual AsmLabelAttr *clone (ASTContext &C) const;
  virtual void printPretty(llvm::raw_ostream &OS,                           const PrintingPolicy &Policy) const;
  llvm::StringRef getLabel() const {
    return llvm::StringRef(label, labelLength);
  }
  unsigned getLabelLength() const {
    return labelLength;
  }
  void setLabel(ASTContext &C, llvm::StringRef S) {
    labelLength = S.size();
    this->label = new (C, 1) char [labelLength];
    std::memcpy(this->label, S.data(), labelLength);
  }



  static bool classof(const Attr *A) { return A->getKind() == attr::AsmLabel; }
  virtual bool isLateParsed() const { return 0; }
};

class AvailabilityAttr : public InheritableAttr {
IdentifierInfo * platform;

VersionTuple introduced;


VersionTuple deprecated;


VersionTuple obsoleted;


bool unavailable;

unsigned messageLength;
char *message;


 public:
  AvailabilityAttr(SourceRange R, ASTContext &Ctx
              , IdentifierInfo * Platform
              , VersionTuple Introduced
              , VersionTuple Deprecated
              , VersionTuple Obsoleted
              , bool Unavailable
              , llvm::StringRef Message
             )
    : InheritableAttr(attr::Availability, R)
              , platform(Platform)
              , introduced(Introduced)
              , deprecated(Deprecated)
              , obsoleted(Obsoleted)
              , unavailable(Unavailable)
              , messageLength(Message.size()),message(new (Ctx, 1) char[messageLength])
  {





      std::memcpy(message, Message.data(), messageLength);
  }

  virtual AvailabilityAttr *clone (ASTContext &C) const;
  virtual void printPretty(llvm::raw_ostream &OS,                           const PrintingPolicy &Policy) const;
  IdentifierInfo * getPlatform() const {
    return platform;
  }

  VersionTuple getIntroduced() const {
    return introduced;
  }
  void setIntroduced(ASTContext &C, VersionTuple V) {
    introduced = V;
  }

  VersionTuple getDeprecated() const {
    return deprecated;
  }
  void setDeprecated(ASTContext &C, VersionTuple V) {
    deprecated = V;
  }

  VersionTuple getObsoleted() const {
    return obsoleted;
  }
  void setObsoleted(ASTContext &C, VersionTuple V) {
    obsoleted = V;
  }

  bool getUnavailable() const {
    return unavailable;
  }

  llvm::StringRef getMessage() const {
    return llvm::StringRef(message, messageLength);
  }
  unsigned getMessageLength() const {
    return messageLength;
  }
  void setMessage(ASTContext &C, llvm::StringRef S) {
    messageLength = S.size();
    this->message = new (C, 1) char [messageLength];
    std::memcpy(this->message, S.data(), messageLength);
  }

static llvm::StringRef getPrettyPlatformName(llvm::StringRef Platform) {
    return llvm::StringSwitch<llvm::StringRef>(Platform)
             .Case("ios", "iOS")
             .Case("macosx", "OS X")
             .Default(llvm::StringRef());
} 

  static bool classof(const Attr *A) { return A->getKind() == attr::Availability; }
  virtual bool isLateParsed() const { return 0; }
};

class BlocksAttr : public InheritableAttr {
public:
  enum BlockType {
    ByRef
  };
private:
  BlockType type;


 public:
  BlocksAttr(SourceRange R, ASTContext &Ctx
              , BlockType Type
             )
    : InheritableAttr(attr::Blocks, R)
              , type(Type)
  {

  }

  virtual BlocksAttr *clone (ASTContext &C) const;
  virtual void printPretty(llvm::raw_ostream &OS,                           const PrintingPolicy &Policy) const;
  BlockType getType() const {
    return type;
  }



  static bool classof(const Attr *A) { return A->getKind() == attr::Blocks; }
  virtual bool isLateParsed() const { return 0; }
};

class CDeclAttr : public InheritableAttr {

 public:
  CDeclAttr(SourceRange R, ASTContext &Ctx
             )
    : InheritableAttr(attr::CDecl, R)
  {
  }

  virtual CDeclAttr *clone (ASTContext &C) const;
  virtual void printPretty(llvm::raw_ostream &OS,                           const PrintingPolicy &Policy) const;


  static bool classof(const Attr *A) { return A->getKind() == attr::CDecl; }
  virtual bool isLateParsed() const { return 0; }
};

class CFAuditedTransferAttr : public InheritableAttr {

 public:
  CFAuditedTransferAttr(SourceRange R, ASTContext &Ctx
             )
    : InheritableAttr(attr::CFAuditedTransfer, R)
  {
  }

  virtual CFAuditedTransferAttr *clone (ASTContext &C) const;
  virtual void printPretty(llvm::raw_ostream &OS,                           const PrintingPolicy &Policy) const;


  static bool classof(const Attr *A) { return A->getKind() == attr::CFAuditedTransfer; }
  virtual bool isLateParsed() const { return 0; }
};

class CFConsumedAttr : public InheritableParamAttr {

 public:
  CFConsumedAttr(SourceRange R, ASTContext &Ctx
             )
    : InheritableParamAttr(attr::CFConsumed, R)
  {
  }

  virtual CFConsumedAttr *clone (ASTContext &C) const;
  virtual void printPretty(llvm::raw_ostream &OS,                           const PrintingPolicy &Policy) const;


  static bool classof(const Attr *A) { return A->getKind() == attr::CFConsumed; }
  virtual bool isLateParsed() const { return 0; }
};

class CFReturnsNotRetainedAttr : public InheritableAttr {

 public:
  CFReturnsNotRetainedAttr(SourceRange R, ASTContext &Ctx
             )
    : InheritableAttr(attr::CFReturnsNotRetained, R)
  {
  }

  virtual CFReturnsNotRetainedAttr *clone (ASTContext &C) const;
  virtual void printPretty(llvm::raw_ostream &OS,                           const PrintingPolicy &Policy) const;


  static bool classof(const Attr *A) { return A->getKind() == attr::CFReturnsNotRetained; }
  virtual bool isLateParsed() const { return 0; }
};

class CFReturnsRetainedAttr : public InheritableAttr {

 public:
  CFReturnsRetainedAttr(SourceRange R, ASTContext &Ctx
             )
    : InheritableAttr(attr::CFReturnsRetained, R)
  {
  }

  virtual CFReturnsRetainedAttr *clone (ASTContext &C) const;
  virtual void printPretty(llvm::raw_ostream &OS,                           const PrintingPolicy &Policy) const;


  static bool classof(const Attr *A) { return A->getKind() == attr::CFReturnsRetained; }
  virtual bool isLateParsed() const { return 0; }
};

class CFUnknownTransferAttr : public InheritableAttr {

 public:
  CFUnknownTransferAttr(SourceRange R, ASTContext &Ctx
             )
    : InheritableAttr(attr::CFUnknownTransfer, R)
  {
  }

  virtual CFUnknownTransferAttr *clone (ASTContext &C) const;
  virtual void printPretty(llvm::raw_ostream &OS,                           const PrintingPolicy &Policy) const;


  static bool classof(const Attr *A) { return A->getKind() == attr::CFUnknownTransfer; }
  virtual bool isLateParsed() const { return 0; }
};

class CUDAConstantAttr : public InheritableAttr {

 public:
  CUDAConstantAttr(SourceRange R, ASTContext &Ctx
             )
    : InheritableAttr(attr::CUDAConstant, R)
  {
  }

  virtual CUDAConstantAttr *clone (ASTContext &C) const;
  virtual void printPretty(llvm::raw_ostream &OS,                           const PrintingPolicy &Policy) const;


  static bool classof(const Attr *A) { return A->getKind() == attr::CUDAConstant; }
  virtual bool isLateParsed() const { return 0; }
};

class CUDADeviceAttr : public InheritableAttr {

 public:
  CUDADeviceAttr(SourceRange R, ASTContext &Ctx
             )
    : InheritableAttr(attr::CUDADevice, R)
  {
  }

  virtual CUDADeviceAttr *clone (ASTContext &C) const;
  virtual void printPretty(llvm::raw_ostream &OS,                           const PrintingPolicy &Policy) const;


  static bool classof(const Attr *A) { return A->getKind() == attr::CUDADevice; }
  virtual bool isLateParsed() const { return 0; }
};

class CUDAGlobalAttr : public InheritableAttr {

 public:
  CUDAGlobalAttr(SourceRange R, ASTContext &Ctx
             )
    : InheritableAttr(attr::CUDAGlobal, R)
  {
  }

  virtual CUDAGlobalAttr *clone (ASTContext &C) const;
  virtual void printPretty(llvm::raw_ostream &OS,                           const PrintingPolicy &Policy) const;


  static bool classof(const Attr *A) { return A->getKind() == attr::CUDAGlobal; }
  virtual bool isLateParsed() const { return 0; }
};

class CUDAHostAttr : public InheritableAttr {

 public:
  CUDAHostAttr(SourceRange R, ASTContext &Ctx
             )
    : InheritableAttr(attr::CUDAHost, R)
  {
  }

  virtual CUDAHostAttr *clone (ASTContext &C) const;
  virtual void printPretty(llvm::raw_ostream &OS,                           const PrintingPolicy &Policy) const;


  static bool classof(const Attr *A) { return A->getKind() == attr::CUDAHost; }
  virtual bool isLateParsed() const { return 0; }
};

class CUDALaunchBoundsAttr : public InheritableAttr {
int maxThreads;

int minBlocks;


 public:
  CUDALaunchBoundsAttr(SourceRange R, ASTContext &Ctx
              , int MaxThreads
              , int MinBlocks
             )
    : InheritableAttr(attr::CUDALaunchBounds, R)
              , maxThreads(MaxThreads)
              , minBlocks(MinBlocks)
  {


  }

  virtual CUDALaunchBoundsAttr *clone (ASTContext &C) const;
  virtual void printPretty(llvm::raw_ostream &OS,                           const PrintingPolicy &Policy) const;
  int getMaxThreads() const {
    return maxThreads;
  }

  int getMinBlocks() const {
    return minBlocks;
  }



  static bool classof(const Attr *A) { return A->getKind() == attr::CUDALaunchBounds; }
  virtual bool isLateParsed() const { return 0; }
};

class CUDASharedAttr : public InheritableAttr {

 public:
  CUDASharedAttr(SourceRange R, ASTContext &Ctx
             )
    : InheritableAttr(attr::CUDAShared, R)
  {
  }

  virtual CUDASharedAttr *clone (ASTContext &C) const;
  virtual void printPretty(llvm::raw_ostream &OS,                           const PrintingPolicy &Policy) const;


  static bool classof(const Attr *A) { return A->getKind() == attr::CUDAShared; }
  virtual bool isLateParsed() const { return 0; }
};

class CarriesDependencyAttr : public InheritableParamAttr {

 public:
  CarriesDependencyAttr(SourceRange R, ASTContext &Ctx
             )
    : InheritableParamAttr(attr::CarriesDependency, R)
  {
  }

  virtual CarriesDependencyAttr *clone (ASTContext &C) const;
  virtual void printPretty(llvm::raw_ostream &OS,                           const PrintingPolicy &Policy) const;


  static bool classof(const Attr *A) { return A->getKind() == attr::CarriesDependency; }
  virtual bool isLateParsed() const { return 0; }
};

class CleanupAttr : public InheritableAttr {
FunctionDecl * functionDecl;


 public:
  CleanupAttr(SourceRange R, ASTContext &Ctx
              , FunctionDecl * FunctionDecl
             )
    : InheritableAttr(attr::Cleanup, R)
              , functionDecl(FunctionDecl)
  {

  }

  virtual CleanupAttr *clone (ASTContext &C) const;
  virtual void printPretty(llvm::raw_ostream &OS,                           const PrintingPolicy &Policy) const;
  FunctionDecl * getFunctionDecl() const {
    return functionDecl;
  }



  static bool classof(const Attr *A) { return A->getKind() == attr::Cleanup; }
  virtual bool isLateParsed() const { return 0; }
};

class ColdAttr : public InheritableAttr {

 public:
  ColdAttr(SourceRange R, ASTContext &Ctx
             )
    : InheritableAttr(attr::Cold, R)
  {
  }

  virtual ColdAttr *clone (ASTContext &C) const;
  virtual void printPretty(llvm::raw_ostream &OS,                           const PrintingPolicy &Policy) const;


  static bool classof(const Attr *A) { return A->getKind() == attr::Cold; }
  virtual bool isLateParsed() const { return 0; }
};

class CommonAttr : public InheritableAttr {

 public:
  CommonAttr(SourceRange R, ASTContext &Ctx
             )
    : InheritableAttr(attr::Common, R)
  {
  }

  virtual CommonAttr *clone (ASTContext &C) const;
  virtual void printPretty(llvm::raw_ostream &OS,                           const PrintingPolicy &Policy) const;


  static bool classof(const Attr *A) { return A->getKind() == attr::Common; }
  virtual bool isLateParsed() const { return 0; }
};

class ConstAttr : public InheritableAttr {

 public:
  ConstAttr(SourceRange R, ASTContext &Ctx
             )
    : InheritableAttr(attr::Const, R)
  {
  }

  virtual ConstAttr *clone (ASTContext &C) const;
  virtual void printPretty(llvm::raw_ostream &OS,                           const PrintingPolicy &Policy) const;


  static bool classof(const Attr *A) { return A->getKind() == attr::Const; }
  virtual bool isLateParsed() const { return 0; }
};

class ConstructorAttr : public InheritableAttr {
int priority;


 public:
  ConstructorAttr(SourceRange R, ASTContext &Ctx
              , int Priority
             )
    : InheritableAttr(attr::Constructor, R)
              , priority(Priority)
  {

  }

  virtual ConstructorAttr *clone (ASTContext &C) const;
  virtual void printPretty(llvm::raw_ostream &OS,                           const PrintingPolicy &Policy) const;
  int getPriority() const {
    return priority;
  }



  static bool classof(const Attr *A) { return A->getKind() == attr::Constructor; }
  virtual bool isLateParsed() const { return 0; }
};

class DLLExportAttr : public InheritableAttr {

 public:
  DLLExportAttr(SourceRange R, ASTContext &Ctx
             )
    : InheritableAttr(attr::DLLExport, R)
  {
  }

  virtual DLLExportAttr *clone (ASTContext &C) const;
  virtual void printPretty(llvm::raw_ostream &OS,                           const PrintingPolicy &Policy) const;


  static bool classof(const Attr *A) { return A->getKind() == attr::DLLExport; }
  virtual bool isLateParsed() const { return 0; }
};

class DLLImportAttr : public InheritableAttr {

 public:
  DLLImportAttr(SourceRange R, ASTContext &Ctx
             )
    : InheritableAttr(attr::DLLImport, R)
  {
  }

  virtual DLLImportAttr *clone (ASTContext &C) const;
  virtual void printPretty(llvm::raw_ostream &OS,                           const PrintingPolicy &Policy) const;


  static bool classof(const Attr *A) { return A->getKind() == attr::DLLImport; }
  virtual bool isLateParsed() const { return 0; }
};

class DeprecatedAttr : public InheritableAttr {
unsigned messageLength;
char *message;


 public:
  DeprecatedAttr(SourceRange R, ASTContext &Ctx
              , llvm::StringRef Message
             )
    : InheritableAttr(attr::Deprecated, R)
              , messageLength(Message.size()),message(new (Ctx, 1) char[messageLength])
  {
      std::memcpy(message, Message.data(), messageLength);
  }

  virtual DeprecatedAttr *clone (ASTContext &C) const;
  virtual void printPretty(llvm::raw_ostream &OS,                           const PrintingPolicy &Policy) const;
  llvm::StringRef getMessage() const {
    return llvm::StringRef(message, messageLength);
  }
  unsigned getMessageLength() const {
    return messageLength;
  }
  void setMessage(ASTContext &C, llvm::StringRef S) {
    messageLength = S.size();
    this->message = new (C, 1) char [messageLength];
    std::memcpy(this->message, S.data(), messageLength);
  }



  static bool classof(const Attr *A) { return A->getKind() == attr::Deprecated; }
  virtual bool isLateParsed() const { return 0; }
};

class DestructorAttr : public InheritableAttr {
int priority;


 public:
  DestructorAttr(SourceRange R, ASTContext &Ctx
              , int Priority
             )
    : InheritableAttr(attr::Destructor, R)
              , priority(Priority)
  {

  }

  virtual DestructorAttr *clone (ASTContext &C) const;
  virtual void printPretty(llvm::raw_ostream &OS,                           const PrintingPolicy &Policy) const;
  int getPriority() const {
    return priority;
  }



  static bool classof(const Attr *A) { return A->getKind() == attr::Destructor; }
  virtual bool isLateParsed() const { return 0; }
};

class ExclusiveLockFunctionAttr : public InheritableAttr {
  unsigned argsSize;
  Expr * *args;


 public:
  ExclusiveLockFunctionAttr(SourceRange R, ASTContext &Ctx
              , Expr * *Args, unsigned ArgsSize
             )
    : InheritableAttr(attr::ExclusiveLockFunction, R)
              , argsSize(ArgsSize), args(new (Ctx, 16) Expr *[argsSize])
  {
    std::memcpy(args, Args, argsSize * sizeof(Expr *));

  }

  virtual ExclusiveLockFunctionAttr *clone (ASTContext &C) const;
  virtual void printPretty(llvm::raw_ostream &OS,                           const PrintingPolicy &Policy) const;
  typedef Expr ** args_iterator;
  args_iterator args_begin() const {
    return args;
  }
  args_iterator args_end() const {
    return args + argsSize;
  }
  unsigned args_size() const {
    return argsSize;
  }



  static bool classof(const Attr *A) { return A->getKind() == attr::ExclusiveLockFunction; }
  virtual bool isLateParsed() const { return 1; }
};

class ExclusiveLocksRequiredAttr : public InheritableAttr {
  unsigned argsSize;
  Expr * *args;


 public:
  ExclusiveLocksRequiredAttr(SourceRange R, ASTContext &Ctx
              , Expr * *Args, unsigned ArgsSize
             )
    : InheritableAttr(attr::ExclusiveLocksRequired, R)
              , argsSize(ArgsSize), args(new (Ctx, 16) Expr *[argsSize])
  {
    std::memcpy(args, Args, argsSize * sizeof(Expr *));

  }

  virtual ExclusiveLocksRequiredAttr *clone (ASTContext &C) const;
  virtual void printPretty(llvm::raw_ostream &OS,                           const PrintingPolicy &Policy) const;
  typedef Expr ** args_iterator;
  args_iterator args_begin() const {
    return args;
  }
  args_iterator args_end() const {
    return args + argsSize;
  }
  unsigned args_size() const {
    return argsSize;
  }



  static bool classof(const Attr *A) { return A->getKind() == attr::ExclusiveLocksRequired; }
  virtual bool isLateParsed() const { return 1; }
};

class ExclusiveTrylockFunctionAttr : public InheritableAttr {
Expr * successValue;

  unsigned argsSize;
  Expr * *args;


 public:
  ExclusiveTrylockFunctionAttr(SourceRange R, ASTContext &Ctx
              , Expr * SuccessValue
              , Expr * *Args, unsigned ArgsSize
             )
    : InheritableAttr(attr::ExclusiveTrylockFunction, R)
              , successValue(SuccessValue)
              , argsSize(ArgsSize), args(new (Ctx, 16) Expr *[argsSize])
  {

    std::memcpy(args, Args, argsSize * sizeof(Expr *));

  }

  virtual ExclusiveTrylockFunctionAttr *clone (ASTContext &C) const;
  virtual void printPretty(llvm::raw_ostream &OS,                           const PrintingPolicy &Policy) const;
  Expr * getSuccessValue() const {
    return successValue;
  }

  typedef Expr ** args_iterator;
  args_iterator args_begin() const {
    return args;
  }
  args_iterator args_end() const {
    return args + argsSize;
  }
  unsigned args_size() const {
    return argsSize;
  }



  static bool classof(const Attr *A) { return A->getKind() == attr::ExclusiveTrylockFunction; }
  virtual bool isLateParsed() const { return 1; }
};

class FallThroughAttr : public Attr {

 public:
  FallThroughAttr(SourceRange R, ASTContext &Ctx
             )
    : Attr(attr::FallThrough, R)
  {
  }

  virtual FallThroughAttr *clone (ASTContext &C) const;
  virtual void printPretty(llvm::raw_ostream &OS,                           const PrintingPolicy &Policy) const;


  static bool classof(const Attr *A) { return A->getKind() == attr::FallThrough; }
  virtual bool isLateParsed() const { return 0; }
};

class FastCallAttr : public InheritableAttr {

 public:
  FastCallAttr(SourceRange R, ASTContext &Ctx
             )
    : InheritableAttr(attr::FastCall, R)
  {
  }

  virtual FastCallAttr *clone (ASTContext &C) const;
  virtual void printPretty(llvm::raw_ostream &OS,                           const PrintingPolicy &Policy) const;


  static bool classof(const Attr *A) { return A->getKind() == attr::FastCall; }
  virtual bool isLateParsed() const { return 0; }
};

class FinalAttr : public InheritableAttr {

 public:
  FinalAttr(SourceRange R, ASTContext &Ctx
             )
    : InheritableAttr(attr::Final, R)
  {
  }

  virtual FinalAttr *clone (ASTContext &C) const;
  virtual void printPretty(llvm::raw_ostream &OS,                           const PrintingPolicy &Policy) const;


  static bool classof(const Attr *A) { return A->getKind() == attr::Final; }
  virtual bool isLateParsed() const { return 0; }
};

class ForceInlineAttr : public InheritableAttr {

 public:
  ForceInlineAttr(SourceRange R, ASTContext &Ctx
             )
    : InheritableAttr(attr::ForceInline, R)
  {
  }

  virtual ForceInlineAttr *clone (ASTContext &C) const;
  virtual void printPretty(llvm::raw_ostream &OS,                           const PrintingPolicy &Policy) const;


  static bool classof(const Attr *A) { return A->getKind() == attr::ForceInline; }
  virtual bool isLateParsed() const { return 0; }
};

class FormatAttr : public InheritableAttr {
unsigned typeLength;
char *type;

int formatIdx;

int firstArg;


 public:
  FormatAttr(SourceRange R, ASTContext &Ctx
              , llvm::StringRef Type
              , int FormatIdx
              , int FirstArg
             )
    : InheritableAttr(attr::Format, R)
              , typeLength(Type.size()),type(new (Ctx, 1) char[typeLength])
              , formatIdx(FormatIdx)
              , firstArg(FirstArg)
  {
      std::memcpy(type, Type.data(), typeLength);


  }

  virtual FormatAttr *clone (ASTContext &C) const;
  virtual void printPretty(llvm::raw_ostream &OS,                           const PrintingPolicy &Policy) const;
  llvm::StringRef getType() const {
    return llvm::StringRef(type, typeLength);
  }
  unsigned getTypeLength() const {
    return typeLength;
  }
  void setType(ASTContext &C, llvm::StringRef S) {
    typeLength = S.size();
    this->type = new (C, 1) char [typeLength];
    std::memcpy(this->type, S.data(), typeLength);
  }

  int getFormatIdx() const {
    return formatIdx;
  }

  int getFirstArg() const {
    return firstArg;
  }



  static bool classof(const Attr *A) { return A->getKind() == attr::Format; }
  virtual bool isLateParsed() const { return 0; }
};

class FormatArgAttr : public InheritableAttr {
int formatIdx;


 public:
  FormatArgAttr(SourceRange R, ASTContext &Ctx
              , int FormatIdx
             )
    : InheritableAttr(attr::FormatArg, R)
              , formatIdx(FormatIdx)
  {

  }

  virtual FormatArgAttr *clone (ASTContext &C) const;
  virtual void printPretty(llvm::raw_ostream &OS,                           const PrintingPolicy &Policy) const;
  int getFormatIdx() const {
    return formatIdx;
  }



  static bool classof(const Attr *A) { return A->getKind() == attr::FormatArg; }
  virtual bool isLateParsed() const { return 0; }
};

class GNUInlineAttr : public InheritableAttr {

 public:
  GNUInlineAttr(SourceRange R, ASTContext &Ctx
             )
    : InheritableAttr(attr::GNUInline, R)
  {
  }

  virtual GNUInlineAttr *clone (ASTContext &C) const;
  virtual void printPretty(llvm::raw_ostream &OS,                           const PrintingPolicy &Policy) const;


  static bool classof(const Attr *A) { return A->getKind() == attr::GNUInline; }
  virtual bool isLateParsed() const { return 0; }
};

class GuardedByAttr : public InheritableAttr {
Expr * arg;


 public:
  GuardedByAttr(SourceRange R, ASTContext &Ctx
              , Expr * Arg
             )
    : InheritableAttr(attr::GuardedBy, R)
              , arg(Arg)
  {

  }

  virtual GuardedByAttr *clone (ASTContext &C) const;
  virtual void printPretty(llvm::raw_ostream &OS,                           const PrintingPolicy &Policy) const;
  Expr * getArg() const {
    return arg;
  }



  static bool classof(const Attr *A) { return A->getKind() == attr::GuardedBy; }
  virtual bool isLateParsed() const { return 1; }
};

class GuardedVarAttr : public InheritableAttr {

 public:
  GuardedVarAttr(SourceRange R, ASTContext &Ctx
             )
    : InheritableAttr(attr::GuardedVar, R)
  {
  }

  virtual GuardedVarAttr *clone (ASTContext &C) const;
  virtual void printPretty(llvm::raw_ostream &OS,                           const PrintingPolicy &Policy) const;


  static bool classof(const Attr *A) { return A->getKind() == attr::GuardedVar; }
  virtual bool isLateParsed() const { return 0; }
};

class HotAttr : public InheritableAttr {

 public:
  HotAttr(SourceRange R, ASTContext &Ctx
             )
    : InheritableAttr(attr::Hot, R)
  {
  }

  virtual HotAttr *clone (ASTContext &C) const;
  virtual void printPretty(llvm::raw_ostream &OS,                           const PrintingPolicy &Policy) const;


  static bool classof(const Attr *A) { return A->getKind() == attr::Hot; }
  virtual bool isLateParsed() const { return 0; }
};

class IBActionAttr : public InheritableAttr {

 public:
  IBActionAttr(SourceRange R, ASTContext &Ctx
             )
    : InheritableAttr(attr::IBAction, R)
  {
  }

  virtual IBActionAttr *clone (ASTContext &C) const;
  virtual void printPretty(llvm::raw_ostream &OS,                           const PrintingPolicy &Policy) const;


  static bool classof(const Attr *A) { return A->getKind() == attr::IBAction; }
  virtual bool isLateParsed() const { return 0; }
};

class IBOutletAttr : public InheritableAttr {

 public:
  IBOutletAttr(SourceRange R, ASTContext &Ctx
             )
    : InheritableAttr(attr::IBOutlet, R)
  {
  }

  virtual IBOutletAttr *clone (ASTContext &C) const;
  virtual void printPretty(llvm::raw_ostream &OS,                           const PrintingPolicy &Policy) const;


  static bool classof(const Attr *A) { return A->getKind() == attr::IBOutlet; }
  virtual bool isLateParsed() const { return 0; }
};

class IBOutletCollectionAttr : public InheritableAttr {
QualType interface;

SourceLocation interfaceLoc;


 public:
  IBOutletCollectionAttr(SourceRange R, ASTContext &Ctx
              , QualType Interface
              , SourceLocation InterfaceLoc
             )
    : InheritableAttr(attr::IBOutletCollection, R)
              , interface(Interface)
              , interfaceLoc(InterfaceLoc)
  {


  }

  virtual IBOutletCollectionAttr *clone (ASTContext &C) const;
  virtual void printPretty(llvm::raw_ostream &OS,                           const PrintingPolicy &Policy) const;
  QualType getInterface() const {
    return interface;
  }

  SourceLocation getInterfaceLoc() const {
    return interfaceLoc;
  }



  static bool classof(const Attr *A) { return A->getKind() == attr::IBOutletCollection; }
  virtual bool isLateParsed() const { return 0; }
};

class InitPriorityAttr : public InheritableAttr {
unsigned priority;


 public:
  InitPriorityAttr(SourceRange R, ASTContext &Ctx
              , unsigned Priority
             )
    : InheritableAttr(attr::InitPriority, R)
              , priority(Priority)
  {

  }

  virtual InitPriorityAttr *clone (ASTContext &C) const;
  virtual void printPretty(llvm::raw_ostream &OS,                           const PrintingPolicy &Policy) const;
  unsigned getPriority() const {
    return priority;
  }



  static bool classof(const Attr *A) { return A->getKind() == attr::InitPriority; }
  virtual bool isLateParsed() const { return 0; }
};

class LockReturnedAttr : public InheritableAttr {
Expr * arg;


 public:
  LockReturnedAttr(SourceRange R, ASTContext &Ctx
              , Expr * Arg
             )
    : InheritableAttr(attr::LockReturned, R)
              , arg(Arg)
  {

  }

  virtual LockReturnedAttr *clone (ASTContext &C) const;
  virtual void printPretty(llvm::raw_ostream &OS,                           const PrintingPolicy &Policy) const;
  Expr * getArg() const {
    return arg;
  }



  static bool classof(const Attr *A) { return A->getKind() == attr::LockReturned; }
  virtual bool isLateParsed() const { return 1; }
};

class LockableAttr : public InheritableAttr {

 public:
  LockableAttr(SourceRange R, ASTContext &Ctx
             )
    : InheritableAttr(attr::Lockable, R)
  {
  }

  virtual LockableAttr *clone (ASTContext &C) const;
  virtual void printPretty(llvm::raw_ostream &OS,                           const PrintingPolicy &Policy) const;


  static bool classof(const Attr *A) { return A->getKind() == attr::Lockable; }
  virtual bool isLateParsed() const { return 0; }
};

class LocksExcludedAttr : public InheritableAttr {
  unsigned argsSize;
  Expr * *args;


 public:
  LocksExcludedAttr(SourceRange R, ASTContext &Ctx
              , Expr * *Args, unsigned ArgsSize
             )
    : InheritableAttr(attr::LocksExcluded, R)
              , argsSize(ArgsSize), args(new (Ctx, 16) Expr *[argsSize])
  {
    std::memcpy(args, Args, argsSize * sizeof(Expr *));

  }

  virtual LocksExcludedAttr *clone (ASTContext &C) const;
  virtual void printPretty(llvm::raw_ostream &OS,                           const PrintingPolicy &Policy) const;
  typedef Expr ** args_iterator;
  args_iterator args_begin() const {
    return args;
  }
  args_iterator args_end() const {
    return args + argsSize;
  }
  unsigned args_size() const {
    return argsSize;
  }



  static bool classof(const Attr *A) { return A->getKind() == attr::LocksExcluded; }
  virtual bool isLateParsed() const { return 1; }
};

class MBlazeInterruptHandlerAttr : public InheritableAttr {

 public:
  MBlazeInterruptHandlerAttr(SourceRange R, ASTContext &Ctx
             )
    : InheritableAttr(attr::MBlazeInterruptHandler, R)
  {
  }

  virtual MBlazeInterruptHandlerAttr *clone (ASTContext &C) const;
  virtual void printPretty(llvm::raw_ostream &OS,                           const PrintingPolicy &Policy) const;


  static bool classof(const Attr *A) { return A->getKind() == attr::MBlazeInterruptHandler; }
  virtual bool isLateParsed() const { return 0; }
};

class MBlazeSaveVolatilesAttr : public InheritableAttr {

 public:
  MBlazeSaveVolatilesAttr(SourceRange R, ASTContext &Ctx
             )
    : InheritableAttr(attr::MBlazeSaveVolatiles, R)
  {
  }

  virtual MBlazeSaveVolatilesAttr *clone (ASTContext &C) const;
  virtual void printPretty(llvm::raw_ostream &OS,                           const PrintingPolicy &Policy) const;


  static bool classof(const Attr *A) { return A->getKind() == attr::MBlazeSaveVolatiles; }
  virtual bool isLateParsed() const { return 0; }
};

class MSP430InterruptAttr : public InheritableAttr {
unsigned number;


 public:
  MSP430InterruptAttr(SourceRange R, ASTContext &Ctx
              , unsigned Number
             )
    : InheritableAttr(attr::MSP430Interrupt, R)
              , number(Number)
  {

  }

  virtual MSP430InterruptAttr *clone (ASTContext &C) const;
  virtual void printPretty(llvm::raw_ostream &OS,                           const PrintingPolicy &Policy) const;
  unsigned getNumber() const {
    return number;
  }



  static bool classof(const Attr *A) { return A->getKind() == attr::MSP430Interrupt; }
  virtual bool isLateParsed() const { return 0; }
};

class MallocAttr : public InheritableAttr {

 public:
  MallocAttr(SourceRange R, ASTContext &Ctx
             )
    : InheritableAttr(attr::Malloc, R)
  {
  }

  virtual MallocAttr *clone (ASTContext &C) const;
  virtual void printPretty(llvm::raw_ostream &OS,                           const PrintingPolicy &Policy) const;


  static bool classof(const Attr *A) { return A->getKind() == attr::Malloc; }
  virtual bool isLateParsed() const { return 0; }
};

class MaxFieldAlignmentAttr : public InheritableAttr {
unsigned alignment;


 public:
  MaxFieldAlignmentAttr(SourceRange R, ASTContext &Ctx
              , unsigned Alignment
             )
    : InheritableAttr(attr::MaxFieldAlignment, R)
              , alignment(Alignment)
  {

  }

  virtual MaxFieldAlignmentAttr *clone (ASTContext &C) const;
  virtual void printPretty(llvm::raw_ostream &OS,                           const PrintingPolicy &Policy) const;
  unsigned getAlignment() const {
    return alignment;
  }



  static bool classof(const Attr *A) { return A->getKind() == attr::MaxFieldAlignment; }
  virtual bool isLateParsed() const { return 0; }
};

class MayAliasAttr : public InheritableAttr {

 public:
  MayAliasAttr(SourceRange R, ASTContext &Ctx
             )
    : InheritableAttr(attr::MayAlias, R)
  {
  }

  virtual MayAliasAttr *clone (ASTContext &C) const;
  virtual void printPretty(llvm::raw_ostream &OS,                           const PrintingPolicy &Policy) const;


  static bool classof(const Attr *A) { return A->getKind() == attr::MayAlias; }
  virtual bool isLateParsed() const { return 0; }
};

class MinSizeAttr : public InheritableAttr {

 public:
  MinSizeAttr(SourceRange R, ASTContext &Ctx
             )
    : InheritableAttr(attr::MinSize, R)
  {
  }

  virtual MinSizeAttr *clone (ASTContext &C) const;
  virtual void printPretty(llvm::raw_ostream &OS,                           const PrintingPolicy &Policy) const;


  static bool classof(const Attr *A) { return A->getKind() == attr::MinSize; }
  virtual bool isLateParsed() const { return 0; }
};

class MsStructAttr : public InheritableAttr {

 public:
  MsStructAttr(SourceRange R, ASTContext &Ctx
             )
    : InheritableAttr(attr::MsStruct, R)
  {
  }

  virtual MsStructAttr *clone (ASTContext &C) const;
  virtual void printPretty(llvm::raw_ostream &OS,                           const PrintingPolicy &Policy) const;


  static bool classof(const Attr *A) { return A->getKind() == attr::MsStruct; }
  virtual bool isLateParsed() const { return 0; }
};

class MultipleInheritanceAttr : public InheritableAttr {

 public:
  MultipleInheritanceAttr(SourceRange R, ASTContext &Ctx
             )
    : InheritableAttr(attr::MultipleInheritance, R)
  {
  }

  virtual MultipleInheritanceAttr *clone (ASTContext &C) const;
  virtual void printPretty(llvm::raw_ostream &OS,                           const PrintingPolicy &Policy) const;


  static bool classof(const Attr *A) { return A->getKind() == attr::MultipleInheritance; }
  virtual bool isLateParsed() const { return 0; }
};

class NSBridgedAttr : public InheritableAttr {
IdentifierInfo * bridgedType;


 public:
  NSBridgedAttr(SourceRange R, ASTContext &Ctx
              , IdentifierInfo * BridgedType
             )
    : InheritableAttr(attr::NSBridged, R)
              , bridgedType(BridgedType)
  {

  }

  virtual NSBridgedAttr *clone (ASTContext &C) const;
  virtual void printPretty(llvm::raw_ostream &OS,                           const PrintingPolicy &Policy) const;
  IdentifierInfo * getBridgedType() const {
    return bridgedType;
  }



  static bool classof(const Attr *A) { return A->getKind() == attr::NSBridged; }
  virtual bool isLateParsed() const { return 0; }
};

class NSConsumedAttr : public InheritableParamAttr {

 public:
  NSConsumedAttr(SourceRange R, ASTContext &Ctx
             )
    : InheritableParamAttr(attr::NSConsumed, R)
  {
  }

  virtual NSConsumedAttr *clone (ASTContext &C) const;
  virtual void printPretty(llvm::raw_ostream &OS,                           const PrintingPolicy &Policy) const;


  static bool classof(const Attr *A) { return A->getKind() == attr::NSConsumed; }
  virtual bool isLateParsed() const { return 0; }
};

class NSConsumesSelfAttr : public InheritableAttr {

 public:
  NSConsumesSelfAttr(SourceRange R, ASTContext &Ctx
             )
    : InheritableAttr(attr::NSConsumesSelf, R)
  {
  }

  virtual NSConsumesSelfAttr *clone (ASTContext &C) const;
  virtual void printPretty(llvm::raw_ostream &OS,                           const PrintingPolicy &Policy) const;


  static bool classof(const Attr *A) { return A->getKind() == attr::NSConsumesSelf; }
  virtual bool isLateParsed() const { return 0; }
};

class NSReturnsAutoreleasedAttr : public InheritableAttr {

 public:
  NSReturnsAutoreleasedAttr(SourceRange R, ASTContext &Ctx
             )
    : InheritableAttr(attr::NSReturnsAutoreleased, R)
  {
  }

  virtual NSReturnsAutoreleasedAttr *clone (ASTContext &C) const;
  virtual void printPretty(llvm::raw_ostream &OS,                           const PrintingPolicy &Policy) const;


  static bool classof(const Attr *A) { return A->getKind() == attr::NSReturnsAutoreleased; }
  virtual bool isLateParsed() const { return 0; }
};

class NSReturnsNotRetainedAttr : public InheritableAttr {

 public:
  NSReturnsNotRetainedAttr(SourceRange R, ASTContext &Ctx
             )
    : InheritableAttr(attr::NSReturnsNotRetained, R)
  {
  }

  virtual NSReturnsNotRetainedAttr *clone (ASTContext &C) const;
  virtual void printPretty(llvm::raw_ostream &OS,                           const PrintingPolicy &Policy) const;


  static bool classof(const Attr *A) { return A->getKind() == attr::NSReturnsNotRetained; }
  virtual bool isLateParsed() const { return 0; }
};

class NSReturnsRetainedAttr : public InheritableAttr {

 public:
  NSReturnsRetainedAttr(SourceRange R, ASTContext &Ctx
             )
    : InheritableAttr(attr::NSReturnsRetained, R)
  {
  }

  virtual NSReturnsRetainedAttr *clone (ASTContext &C) const;
  virtual void printPretty(llvm::raw_ostream &OS,                           const PrintingPolicy &Policy) const;


  static bool classof(const Attr *A) { return A->getKind() == attr::NSReturnsRetained; }
  virtual bool isLateParsed() const { return 0; }
};

class NakedAttr : public InheritableAttr {

 public:
  NakedAttr(SourceRange R, ASTContext &Ctx
             )
    : InheritableAttr(attr::Naked, R)
  {
  }

  virtual NakedAttr *clone (ASTContext &C) const;
  virtual void printPretty(llvm::raw_ostream &OS,                           const PrintingPolicy &Policy) const;


  static bool classof(const Attr *A) { return A->getKind() == attr::Naked; }
  virtual bool isLateParsed() const { return 0; }
};

class NoAddressSafetyAnalysisAttr : public InheritableAttr {

 public:
  NoAddressSafetyAnalysisAttr(SourceRange R, ASTContext &Ctx
             )
    : InheritableAttr(attr::NoAddressSafetyAnalysis, R)
  {
  }

  virtual NoAddressSafetyAnalysisAttr *clone (ASTContext &C) const;
  virtual void printPretty(llvm::raw_ostream &OS,                           const PrintingPolicy &Policy) const;


  static bool classof(const Attr *A) { return A->getKind() == attr::NoAddressSafetyAnalysis; }
  virtual bool isLateParsed() const { return 0; }
};

class NoCommonAttr : public InheritableAttr {

 public:
  NoCommonAttr(SourceRange R, ASTContext &Ctx
             )
    : InheritableAttr(attr::NoCommon, R)
  {
  }

  virtual NoCommonAttr *clone (ASTContext &C) const;
  virtual void printPretty(llvm::raw_ostream &OS,                           const PrintingPolicy &Policy) const;


  static bool classof(const Attr *A) { return A->getKind() == attr::NoCommon; }
  virtual bool isLateParsed() const { return 0; }
};

class NoDebugAttr : public InheritableAttr {

 public:
  NoDebugAttr(SourceRange R, ASTContext &Ctx
             )
    : InheritableAttr(attr::NoDebug, R)
  {
  }

  virtual NoDebugAttr *clone (ASTContext &C) const;
  virtual void printPretty(llvm::raw_ostream &OS,                           const PrintingPolicy &Policy) const;


  static bool classof(const Attr *A) { return A->getKind() == attr::NoDebug; }
  virtual bool isLateParsed() const { return 0; }
};

class NoInlineAttr : public InheritableAttr {

 public:
  NoInlineAttr(SourceRange R, ASTContext &Ctx
             )
    : InheritableAttr(attr::NoInline, R)
  {
  }

  virtual NoInlineAttr *clone (ASTContext &C) const;
  virtual void printPretty(llvm::raw_ostream &OS,                           const PrintingPolicy &Policy) const;


  static bool classof(const Attr *A) { return A->getKind() == attr::NoInline; }
  virtual bool isLateParsed() const { return 0; }
};

class NoInstrumentFunctionAttr : public InheritableAttr {

 public:
  NoInstrumentFunctionAttr(SourceRange R, ASTContext &Ctx
             )
    : InheritableAttr(attr::NoInstrumentFunction, R)
  {
  }

  virtual NoInstrumentFunctionAttr *clone (ASTContext &C) const;
  virtual void printPretty(llvm::raw_ostream &OS,                           const PrintingPolicy &Policy) const;


  static bool classof(const Attr *A) { return A->getKind() == attr::NoInstrumentFunction; }
  virtual bool isLateParsed() const { return 0; }
};

class NoReturnAttr : public InheritableAttr {

 public:
  NoReturnAttr(SourceRange R, ASTContext &Ctx
             )
    : InheritableAttr(attr::NoReturn, R)
  {
  }

  virtual NoReturnAttr *clone (ASTContext &C) const;
  virtual void printPretty(llvm::raw_ostream &OS,                           const PrintingPolicy &Policy) const;


  static bool classof(const Attr *A) { return A->getKind() == attr::NoReturn; }
  virtual bool isLateParsed() const { return 0; }
};

class NoThreadSafetyAnalysisAttr : public InheritableAttr {

 public:
  NoThreadSafetyAnalysisAttr(SourceRange R, ASTContext &Ctx
             )
    : InheritableAttr(attr::NoThreadSafetyAnalysis, R)
  {
  }

  virtual NoThreadSafetyAnalysisAttr *clone (ASTContext &C) const;
  virtual void printPretty(llvm::raw_ostream &OS,                           const PrintingPolicy &Policy) const;


  static bool classof(const Attr *A) { return A->getKind() == attr::NoThreadSafetyAnalysis; }
  virtual bool isLateParsed() const { return 0; }
};

class NoThrowAttr : public InheritableAttr {

 public:
  NoThrowAttr(SourceRange R, ASTContext &Ctx
             )
    : InheritableAttr(attr::NoThrow, R)
  {
  }

  virtual NoThrowAttr *clone (ASTContext &C) const;
  virtual void printPretty(llvm::raw_ostream &OS,                           const PrintingPolicy &Policy) const;


  static bool classof(const Attr *A) { return A->getKind() == attr::NoThrow; }
  virtual bool isLateParsed() const { return 0; }
};

class NonNullAttr : public InheritableAttr {
  unsigned argsSize;
  unsigned *args;


 public:
  NonNullAttr(SourceRange R, ASTContext &Ctx
              , unsigned *Args, unsigned ArgsSize
             )
    : InheritableAttr(attr::NonNull, R)
              , argsSize(ArgsSize), args(new (Ctx, 16) unsigned[argsSize])
  {
    std::memcpy(args, Args, argsSize * sizeof(unsigned));

  }

  virtual NonNullAttr *clone (ASTContext &C) const;
  virtual void printPretty(llvm::raw_ostream &OS,                           const PrintingPolicy &Policy) const;
  typedef unsigned* args_iterator;
  args_iterator args_begin() const {
    return args;
  }
  args_iterator args_end() const {
    return args + argsSize;
  }
  unsigned args_size() const {
    return argsSize;
  }

bool isNonNull(unsigned idx) const {
    for (args_iterator i = args_begin(), e = args_end();
         i != e; ++i)
      if (*i == idx)
        return true;
    return false;
  } 

  static bool classof(const Attr *A) { return A->getKind() == attr::NonNull; }
  virtual bool isLateParsed() const { return 0; }
};

class ObjCExceptionAttr : public InheritableAttr {

 public:
  ObjCExceptionAttr(SourceRange R, ASTContext &Ctx
             )
    : InheritableAttr(attr::ObjCException, R)
  {
  }

  virtual ObjCExceptionAttr *clone (ASTContext &C) const;
  virtual void printPretty(llvm::raw_ostream &OS,                           const PrintingPolicy &Policy) const;


  static bool classof(const Attr *A) { return A->getKind() == attr::ObjCException; }
  virtual bool isLateParsed() const { return 0; }
};

class ObjCMethodFamilyAttr : public InheritableAttr {
public:
  enum FamilyKind {
    OMF_None,
    OMF_alloc,
    OMF_copy,
    OMF_init,
    OMF_mutableCopy,
    OMF_new
  };
private:
  FamilyKind family;


 public:
  ObjCMethodFamilyAttr(SourceRange R, ASTContext &Ctx
              , FamilyKind Family
             )
    : InheritableAttr(attr::ObjCMethodFamily, R)
              , family(Family)
  {

  }

  virtual ObjCMethodFamilyAttr *clone (ASTContext &C) const;
  virtual void printPretty(llvm::raw_ostream &OS,                           const PrintingPolicy &Policy) const;
  FamilyKind getFamily() const {
    return family;
  }



  static bool classof(const Attr *A) { return A->getKind() == attr::ObjCMethodFamily; }
  virtual bool isLateParsed() const { return 0; }
};

class ObjCNSObjectAttr : public InheritableAttr {

 public:
  ObjCNSObjectAttr(SourceRange R, ASTContext &Ctx
             )
    : InheritableAttr(attr::ObjCNSObject, R)
  {
  }

  virtual ObjCNSObjectAttr *clone (ASTContext &C) const;
  virtual void printPretty(llvm::raw_ostream &OS,                           const PrintingPolicy &Policy) const;


  static bool classof(const Attr *A) { return A->getKind() == attr::ObjCNSObject; }
  virtual bool isLateParsed() const { return 0; }
};

class ObjCPreciseLifetimeAttr : public Attr {

 public:
  ObjCPreciseLifetimeAttr(SourceRange R, ASTContext &Ctx
             )
    : Attr(attr::ObjCPreciseLifetime, R)
  {
  }

  virtual ObjCPreciseLifetimeAttr *clone (ASTContext &C) const;
  virtual void printPretty(llvm::raw_ostream &OS,                           const PrintingPolicy &Policy) const;


  static bool classof(const Attr *A) { return A->getKind() == attr::ObjCPreciseLifetime; }
  virtual bool isLateParsed() const { return 0; }
};

class ObjCRequiresPropertyDefsAttr : public InheritableAttr {

 public:
  ObjCRequiresPropertyDefsAttr(SourceRange R, ASTContext &Ctx
             )
    : InheritableAttr(attr::ObjCRequiresPropertyDefs, R)
  {
  }

  virtual ObjCRequiresPropertyDefsAttr *clone (ASTContext &C) const;
  virtual void printPretty(llvm::raw_ostream &OS,                           const PrintingPolicy &Policy) const;


  static bool classof(const Attr *A) { return A->getKind() == attr::ObjCRequiresPropertyDefs; }
  virtual bool isLateParsed() const { return 0; }
};

class ObjCRequiresSuperAttr : public InheritableAttr {

 public:
  ObjCRequiresSuperAttr(SourceRange R, ASTContext &Ctx
             )
    : InheritableAttr(attr::ObjCRequiresSuper, R)
  {
  }

  virtual ObjCRequiresSuperAttr *clone (ASTContext &C) const;
  virtual void printPretty(llvm::raw_ostream &OS,                           const PrintingPolicy &Policy) const;


  static bool classof(const Attr *A) { return A->getKind() == attr::ObjCRequiresSuper; }
  virtual bool isLateParsed() const { return 0; }
};

class ObjCReturnsInnerPointerAttr : public Attr {

 public:
  ObjCReturnsInnerPointerAttr(SourceRange R, ASTContext &Ctx
             )
    : Attr(attr::ObjCReturnsInnerPointer, R)
  {
  }

  virtual ObjCReturnsInnerPointerAttr *clone (ASTContext &C) const;
  virtual void printPretty(llvm::raw_ostream &OS,                           const PrintingPolicy &Policy) const;


  static bool classof(const Attr *A) { return A->getKind() == attr::ObjCReturnsInnerPointer; }
  virtual bool isLateParsed() const { return 0; }
};

class ObjCRootClassAttr : public Attr {

 public:
  ObjCRootClassAttr(SourceRange R, ASTContext &Ctx
             )
    : Attr(attr::ObjCRootClass, R)
  {
  }

  virtual ObjCRootClassAttr *clone (ASTContext &C) const;
  virtual void printPretty(llvm::raw_ostream &OS,                           const PrintingPolicy &Policy) const;


  static bool classof(const Attr *A) { return A->getKind() == attr::ObjCRootClass; }
  virtual bool isLateParsed() const { return 0; }
};

class OpenCLKernelAttr : public Attr {

 public:
  OpenCLKernelAttr(SourceRange R, ASTContext &Ctx
             )
    : Attr(attr::OpenCLKernel, R)
  {
  }

  virtual OpenCLKernelAttr *clone (ASTContext &C) const;
  virtual void printPretty(llvm::raw_ostream &OS,                           const PrintingPolicy &Policy) const;


  static bool classof(const Attr *A) { return A->getKind() == attr::OpenCLKernel; }
  virtual bool isLateParsed() const { return 0; }
};

class OverloadableAttr : public Attr {

 public:
  OverloadableAttr(SourceRange R, ASTContext &Ctx
             )
    : Attr(attr::Overloadable, R)
  {
  }

  virtual OverloadableAttr *clone (ASTContext &C) const;
  virtual void printPretty(llvm::raw_ostream &OS,                           const PrintingPolicy &Policy) const;


  static bool classof(const Attr *A) { return A->getKind() == attr::Overloadable; }
  virtual bool isLateParsed() const { return 0; }
};

class OverrideAttr : public InheritableAttr {

 public:
  OverrideAttr(SourceRange R, ASTContext &Ctx
             )
    : InheritableAttr(attr::Override, R)
  {
  }

  virtual OverrideAttr *clone (ASTContext &C) const;
  virtual void printPretty(llvm::raw_ostream &OS,                           const PrintingPolicy &Policy) const;


  static bool classof(const Attr *A) { return A->getKind() == attr::Override; }
  virtual bool isLateParsed() const { return 0; }
};

class OwnershipAttr : public InheritableAttr {
public:
  enum OwnershipKind {
    Holds,
    Returns,
    Takes
  };
private:
  OwnershipKind ownKind;

unsigned moduleLength;
char *module;

  unsigned argsSize;
  unsigned *args;


 public:
  OwnershipAttr(SourceRange R, ASTContext &Ctx
              , OwnershipKind OwnKind
              , llvm::StringRef Module
              , unsigned *Args, unsigned ArgsSize
             )
    : InheritableAttr(attr::Ownership, R)
              , ownKind(OwnKind)
              , moduleLength(Module.size()),module(new (Ctx, 1) char[moduleLength])
              , argsSize(ArgsSize), args(new (Ctx, 16) unsigned[argsSize])
  {

      std::memcpy(module, Module.data(), moduleLength);
    std::memcpy(args, Args, argsSize * sizeof(unsigned));

  }

  virtual OwnershipAttr *clone (ASTContext &C) const;
  virtual void printPretty(llvm::raw_ostream &OS,                           const PrintingPolicy &Policy) const;
  OwnershipKind getOwnKind() const {
    return ownKind;
  }

  llvm::StringRef getModule() const {
    return llvm::StringRef(module, moduleLength);
  }
  unsigned getModuleLength() const {
    return moduleLength;
  }
  void setModule(ASTContext &C, llvm::StringRef S) {
    moduleLength = S.size();
    this->module = new (C, 1) char [moduleLength];
    std::memcpy(this->module, S.data(), moduleLength);
  }

  typedef unsigned* args_iterator;
  args_iterator args_begin() const {
    return args;
  }
  args_iterator args_end() const {
    return args + argsSize;
  }
  unsigned args_size() const {
    return argsSize;
  }



  static bool classof(const Attr *A) { return A->getKind() == attr::Ownership; }
  virtual bool isLateParsed() const { return 0; }
};

class PackedAttr : public InheritableAttr {

 public:
  PackedAttr(SourceRange R, ASTContext &Ctx
             )
    : InheritableAttr(attr::Packed, R)
  {
  }

  virtual PackedAttr *clone (ASTContext &C) const;
  virtual void printPretty(llvm::raw_ostream &OS,                           const PrintingPolicy &Policy) const;


  static bool classof(const Attr *A) { return A->getKind() == attr::Packed; }
  virtual bool isLateParsed() const { return 0; }
};

class PascalAttr : public InheritableAttr {

 public:
  PascalAttr(SourceRange R, ASTContext &Ctx
             )
    : InheritableAttr(attr::Pascal, R)
  {
  }

  virtual PascalAttr *clone (ASTContext &C) const;
  virtual void printPretty(llvm::raw_ostream &OS,                           const PrintingPolicy &Policy) const;


  static bool classof(const Attr *A) { return A->getKind() == attr::Pascal; }
  virtual bool isLateParsed() const { return 0; }
};

class PcsAttr : public InheritableAttr {
public:
  enum PCSType {
    AAPCS,
    AAPCS_VFP
  };
private:
  PCSType pCS;


 public:
  PcsAttr(SourceRange R, ASTContext &Ctx
              , PCSType PCS
             )
    : InheritableAttr(attr::Pcs, R)
              , pCS(PCS)
  {

  }

  virtual PcsAttr *clone (ASTContext &C) const;
  virtual void printPretty(llvm::raw_ostream &OS,                           const PrintingPolicy &Policy) const;
  PCSType getPCS() const {
    return pCS;
  }



  static bool classof(const Attr *A) { return A->getKind() == attr::Pcs; }
  virtual bool isLateParsed() const { return 0; }
};

class PnaclCallAttr : public InheritableAttr {

 public:
  PnaclCallAttr(SourceRange R, ASTContext &Ctx
             )
    : InheritableAttr(attr::PnaclCall, R)
  {
  }

  virtual PnaclCallAttr *clone (ASTContext &C) const;
  virtual void printPretty(llvm::raw_ostream &OS,                           const PrintingPolicy &Policy) const;


  static bool classof(const Attr *A) { return A->getKind() == attr::PnaclCall; }
  virtual bool isLateParsed() const { return 0; }
};

class PtGuardedByAttr : public InheritableAttr {
Expr * arg;


 public:
  PtGuardedByAttr(SourceRange R, ASTContext &Ctx
              , Expr * Arg
             )
    : InheritableAttr(attr::PtGuardedBy, R)
              , arg(Arg)
  {

  }

  virtual PtGuardedByAttr *clone (ASTContext &C) const;
  virtual void printPretty(llvm::raw_ostream &OS,                           const PrintingPolicy &Policy) const;
  Expr * getArg() const {
    return arg;
  }



  static bool classof(const Attr *A) { return A->getKind() == attr::PtGuardedBy; }
  virtual bool isLateParsed() const { return 1; }
};

class PtGuardedVarAttr : public InheritableAttr {

 public:
  PtGuardedVarAttr(SourceRange R, ASTContext &Ctx
             )
    : InheritableAttr(attr::PtGuardedVar, R)
  {
  }

  virtual PtGuardedVarAttr *clone (ASTContext &C) const;
  virtual void printPretty(llvm::raw_ostream &OS,                           const PrintingPolicy &Policy) const;


  static bool classof(const Attr *A) { return A->getKind() == attr::PtGuardedVar; }
  virtual bool isLateParsed() const { return 0; }
};

class Ptr32Attr : public InheritableAttr {

 public:
  Ptr32Attr(SourceRange R, ASTContext &Ctx
             )
    : InheritableAttr(attr::Ptr32, R)
  {
  }

  virtual Ptr32Attr *clone (ASTContext &C) const;
  virtual void printPretty(llvm::raw_ostream &OS,                           const PrintingPolicy &Policy) const;


  static bool classof(const Attr *A) { return A->getKind() == attr::Ptr32; }
  virtual bool isLateParsed() const { return 0; }
};

class Ptr64Attr : public InheritableAttr {

 public:
  Ptr64Attr(SourceRange R, ASTContext &Ctx
             )
    : InheritableAttr(attr::Ptr64, R)
  {
  }

  virtual Ptr64Attr *clone (ASTContext &C) const;
  virtual void printPretty(llvm::raw_ostream &OS,                           const PrintingPolicy &Policy) const;


  static bool classof(const Attr *A) { return A->getKind() == attr::Ptr64; }
  virtual bool isLateParsed() const { return 0; }
};

class PureAttr : public InheritableAttr {

 public:
  PureAttr(SourceRange R, ASTContext &Ctx
             )
    : InheritableAttr(attr::Pure, R)
  {
  }

  virtual PureAttr *clone (ASTContext &C) const;
  virtual void printPretty(llvm::raw_ostream &OS,                           const PrintingPolicy &Policy) const;


  static bool classof(const Attr *A) { return A->getKind() == attr::Pure; }
  virtual bool isLateParsed() const { return 0; }
};

class RegparmAttr : public InheritableAttr {
unsigned numParams;


 public:
  RegparmAttr(SourceRange R, ASTContext &Ctx
              , unsigned NumParams
             )
    : InheritableAttr(attr::Regparm, R)
              , numParams(NumParams)
  {

  }

  virtual RegparmAttr *clone (ASTContext &C) const;
  virtual void printPretty(llvm::raw_ostream &OS,                           const PrintingPolicy &Policy) const;
  unsigned getNumParams() const {
    return numParams;
  }



  static bool classof(const Attr *A) { return A->getKind() == attr::Regparm; }
  virtual bool isLateParsed() const { return 0; }
};

class ReqdWorkGroupSizeAttr : public InheritableAttr {
unsigned xDim;

unsigned yDim;

unsigned zDim;


 public:
  ReqdWorkGroupSizeAttr(SourceRange R, ASTContext &Ctx
              , unsigned XDim
              , unsigned YDim
              , unsigned ZDim
             )
    : InheritableAttr(attr::ReqdWorkGroupSize, R)
              , xDim(XDim)
              , yDim(YDim)
              , zDim(ZDim)
  {



  }

  virtual ReqdWorkGroupSizeAttr *clone (ASTContext &C) const;
  virtual void printPretty(llvm::raw_ostream &OS,                           const PrintingPolicy &Policy) const;
  unsigned getXDim() const {
    return xDim;
  }

  unsigned getYDim() const {
    return yDim;
  }

  unsigned getZDim() const {
    return zDim;
  }



  static bool classof(const Attr *A) { return A->getKind() == attr::ReqdWorkGroupSize; }
  virtual bool isLateParsed() const { return 0; }
};

class ReturnsTwiceAttr : public InheritableAttr {

 public:
  ReturnsTwiceAttr(SourceRange R, ASTContext &Ctx
             )
    : InheritableAttr(attr::ReturnsTwice, R)
  {
  }

  virtual ReturnsTwiceAttr *clone (ASTContext &C) const;
  virtual void printPretty(llvm::raw_ostream &OS,                           const PrintingPolicy &Policy) const;


  static bool classof(const Attr *A) { return A->getKind() == attr::ReturnsTwice; }
  virtual bool isLateParsed() const { return 0; }
};

class ScopedLockableAttr : public InheritableAttr {

 public:
  ScopedLockableAttr(SourceRange R, ASTContext &Ctx
             )
    : InheritableAttr(attr::ScopedLockable, R)
  {
  }

  virtual ScopedLockableAttr *clone (ASTContext &C) const;
  virtual void printPretty(llvm::raw_ostream &OS,                           const PrintingPolicy &Policy) const;


  static bool classof(const Attr *A) { return A->getKind() == attr::ScopedLockable; }
  virtual bool isLateParsed() const { return 0; }
};

class SectionAttr : public InheritableAttr {
unsigned nameLength;
char *name;


 public:
  SectionAttr(SourceRange R, ASTContext &Ctx
              , llvm::StringRef Name
             )
    : InheritableAttr(attr::Section, R)
              , nameLength(Name.size()),name(new (Ctx, 1) char[nameLength])
  {
      std::memcpy(name, Name.data(), nameLength);
  }

  virtual SectionAttr *clone (ASTContext &C) const;
  virtual void printPretty(llvm::raw_ostream &OS,                           const PrintingPolicy &Policy) const;
  llvm::StringRef getName() const {
    return llvm::StringRef(name, nameLength);
  }
  unsigned getNameLength() const {
    return nameLength;
  }
  void setName(ASTContext &C, llvm::StringRef S) {
    nameLength = S.size();
    this->name = new (C, 1) char [nameLength];
    std::memcpy(this->name, S.data(), nameLength);
  }



  static bool classof(const Attr *A) { return A->getKind() == attr::Section; }
  virtual bool isLateParsed() const { return 0; }
};

class SentinelAttr : public InheritableAttr {
int sentinel;

int nullPos;


 public:
  SentinelAttr(SourceRange R, ASTContext &Ctx
              , int Sentinel
              , int NullPos
             )
    : InheritableAttr(attr::Sentinel, R)
              , sentinel(Sentinel)
              , nullPos(NullPos)
  {


  }

  virtual SentinelAttr *clone (ASTContext &C) const;
  virtual void printPretty(llvm::raw_ostream &OS,                           const PrintingPolicy &Policy) const;
  int getSentinel() const {
    return sentinel;
  }

  int getNullPos() const {
    return nullPos;
  }



  static bool classof(const Attr *A) { return A->getKind() == attr::Sentinel; }
  virtual bool isLateParsed() const { return 0; }
};

class SharedLockFunctionAttr : public InheritableAttr {
  unsigned argsSize;
  Expr * *args;


 public:
  SharedLockFunctionAttr(SourceRange R, ASTContext &Ctx
              , Expr * *Args, unsigned ArgsSize
             )
    : InheritableAttr(attr::SharedLockFunction, R)
              , argsSize(ArgsSize), args(new (Ctx, 16) Expr *[argsSize])
  {
    std::memcpy(args, Args, argsSize * sizeof(Expr *));

  }

  virtual SharedLockFunctionAttr *clone (ASTContext &C) const;
  virtual void printPretty(llvm::raw_ostream &OS,                           const PrintingPolicy &Policy) const;
  typedef Expr ** args_iterator;
  args_iterator args_begin() const {
    return args;
  }
  args_iterator args_end() const {
    return args + argsSize;
  }
  unsigned args_size() const {
    return argsSize;
  }



  static bool classof(const Attr *A) { return A->getKind() == attr::SharedLockFunction; }
  virtual bool isLateParsed() const { return 1; }
};

class SharedLocksRequiredAttr : public InheritableAttr {
  unsigned argsSize;
  Expr * *args;


 public:
  SharedLocksRequiredAttr(SourceRange R, ASTContext &Ctx
              , Expr * *Args, unsigned ArgsSize
             )
    : InheritableAttr(attr::SharedLocksRequired, R)
              , argsSize(ArgsSize), args(new (Ctx, 16) Expr *[argsSize])
  {
    std::memcpy(args, Args, argsSize * sizeof(Expr *));

  }

  virtual SharedLocksRequiredAttr *clone (ASTContext &C) const;
  virtual void printPretty(llvm::raw_ostream &OS,                           const PrintingPolicy &Policy) const;
  typedef Expr ** args_iterator;
  args_iterator args_begin() const {
    return args;
  }
  args_iterator args_end() const {
    return args + argsSize;
  }
  unsigned args_size() const {
    return argsSize;
  }



  static bool classof(const Attr *A) { return A->getKind() == attr::SharedLocksRequired; }
  virtual bool isLateParsed() const { return 1; }
};

class SharedTrylockFunctionAttr : public InheritableAttr {
Expr * successValue;

  unsigned argsSize;
  Expr * *args;


 public:
  SharedTrylockFunctionAttr(SourceRange R, ASTContext &Ctx
              , Expr * SuccessValue
              , Expr * *Args, unsigned ArgsSize
             )
    : InheritableAttr(attr::SharedTrylockFunction, R)
              , successValue(SuccessValue)
              , argsSize(ArgsSize), args(new (Ctx, 16) Expr *[argsSize])
  {

    std::memcpy(args, Args, argsSize * sizeof(Expr *));

  }

  virtual SharedTrylockFunctionAttr *clone (ASTContext &C) const;
  virtual void printPretty(llvm::raw_ostream &OS,                           const PrintingPolicy &Policy) const;
  Expr * getSuccessValue() const {
    return successValue;
  }

  typedef Expr ** args_iterator;
  args_iterator args_begin() const {
    return args;
  }
  args_iterator args_end() const {
    return args + argsSize;
  }
  unsigned args_size() const {
    return argsSize;
  }



  static bool classof(const Attr *A) { return A->getKind() == attr::SharedTrylockFunction; }
  virtual bool isLateParsed() const { return 1; }
};

class SingleInheritanceAttr : public InheritableAttr {

 public:
  SingleInheritanceAttr(SourceRange R, ASTContext &Ctx
             )
    : InheritableAttr(attr::SingleInheritance, R)
  {
  }

  virtual SingleInheritanceAttr *clone (ASTContext &C) const;
  virtual void printPretty(llvm::raw_ostream &OS,                           const PrintingPolicy &Policy) const;


  static bool classof(const Attr *A) { return A->getKind() == attr::SingleInheritance; }
  virtual bool isLateParsed() const { return 0; }
};

class StdCallAttr : public InheritableAttr {

 public:
  StdCallAttr(SourceRange R, ASTContext &Ctx
             )
    : InheritableAttr(attr::StdCall, R)
  {
  }

  virtual StdCallAttr *clone (ASTContext &C) const;
  virtual void printPretty(llvm::raw_ostream &OS,                           const PrintingPolicy &Policy) const;


  static bool classof(const Attr *A) { return A->getKind() == attr::StdCall; }
  virtual bool isLateParsed() const { return 0; }
};

class TLSModelAttr : public InheritableAttr {
unsigned modelLength;
char *model;


 public:
  TLSModelAttr(SourceRange R, ASTContext &Ctx
              , llvm::StringRef Model
             )
    : InheritableAttr(attr::TLSModel, R)
              , modelLength(Model.size()),model(new (Ctx, 1) char[modelLength])
  {
      std::memcpy(model, Model.data(), modelLength);
  }

  virtual TLSModelAttr *clone (ASTContext &C) const;
  virtual void printPretty(llvm::raw_ostream &OS,                           const PrintingPolicy &Policy) const;
  llvm::StringRef getModel() const {
    return llvm::StringRef(model, modelLength);
  }
  unsigned getModelLength() const {
    return modelLength;
  }
  void setModel(ASTContext &C, llvm::StringRef S) {
    modelLength = S.size();
    this->model = new (C, 1) char [modelLength];
    std::memcpy(this->model, S.data(), modelLength);
  }



  static bool classof(const Attr *A) { return A->getKind() == attr::TLSModel; }
  virtual bool isLateParsed() const { return 0; }
};

class ThisCallAttr : public InheritableAttr {

 public:
  ThisCallAttr(SourceRange R, ASTContext &Ctx
             )
    : InheritableAttr(attr::ThisCall, R)
  {
  }

  virtual ThisCallAttr *clone (ASTContext &C) const;
  virtual void printPretty(llvm::raw_ostream &OS,                           const PrintingPolicy &Policy) const;


  static bool classof(const Attr *A) { return A->getKind() == attr::ThisCall; }
  virtual bool isLateParsed() const { return 0; }
};

class TransparentUnionAttr : public InheritableAttr {

 public:
  TransparentUnionAttr(SourceRange R, ASTContext &Ctx
             )
    : InheritableAttr(attr::TransparentUnion, R)
  {
  }

  virtual TransparentUnionAttr *clone (ASTContext &C) const;
  virtual void printPretty(llvm::raw_ostream &OS,                           const PrintingPolicy &Policy) const;


  static bool classof(const Attr *A) { return A->getKind() == attr::TransparentUnion; }
  virtual bool isLateParsed() const { return 0; }
};

class TypeTagForDatatypeAttr : public InheritableAttr {
IdentifierInfo * argumentKind;

QualType matchingCType;

bool layoutCompatible;

bool mustBeNull;


 public:
  TypeTagForDatatypeAttr(SourceRange R, ASTContext &Ctx
              , IdentifierInfo * ArgumentKind
              , QualType MatchingCType
              , bool LayoutCompatible
              , bool MustBeNull
             )
    : InheritableAttr(attr::TypeTagForDatatype, R)
              , argumentKind(ArgumentKind)
              , matchingCType(MatchingCType)
              , layoutCompatible(LayoutCompatible)
              , mustBeNull(MustBeNull)
  {




  }

  virtual TypeTagForDatatypeAttr *clone (ASTContext &C) const;
  virtual void printPretty(llvm::raw_ostream &OS,                           const PrintingPolicy &Policy) const;
  IdentifierInfo * getArgumentKind() const {
    return argumentKind;
  }

  QualType getMatchingCType() const {
    return matchingCType;
  }

  bool getLayoutCompatible() const {
    return layoutCompatible;
  }

  bool getMustBeNull() const {
    return mustBeNull;
  }



  static bool classof(const Attr *A) { return A->getKind() == attr::TypeTagForDatatype; }
  virtual bool isLateParsed() const { return 0; }
};

class UnavailableAttr : public InheritableAttr {
unsigned messageLength;
char *message;


 public:
  UnavailableAttr(SourceRange R, ASTContext &Ctx
              , llvm::StringRef Message
             )
    : InheritableAttr(attr::Unavailable, R)
              , messageLength(Message.size()),message(new (Ctx, 1) char[messageLength])
  {
      std::memcpy(message, Message.data(), messageLength);
  }

  virtual UnavailableAttr *clone (ASTContext &C) const;
  virtual void printPretty(llvm::raw_ostream &OS,                           const PrintingPolicy &Policy) const;
  llvm::StringRef getMessage() const {
    return llvm::StringRef(message, messageLength);
  }
  unsigned getMessageLength() const {
    return messageLength;
  }
  void setMessage(ASTContext &C, llvm::StringRef S) {
    messageLength = S.size();
    this->message = new (C, 1) char [messageLength];
    std::memcpy(this->message, S.data(), messageLength);
  }



  static bool classof(const Attr *A) { return A->getKind() == attr::Unavailable; }
  virtual bool isLateParsed() const { return 0; }
};

class UnlockFunctionAttr : public InheritableAttr {
  unsigned argsSize;
  Expr * *args;


 public:
  UnlockFunctionAttr(SourceRange R, ASTContext &Ctx
              , Expr * *Args, unsigned ArgsSize
             )
    : InheritableAttr(attr::UnlockFunction, R)
              , argsSize(ArgsSize), args(new (Ctx, 16) Expr *[argsSize])
  {
    std::memcpy(args, Args, argsSize * sizeof(Expr *));

  }

  virtual UnlockFunctionAttr *clone (ASTContext &C) const;
  virtual void printPretty(llvm::raw_ostream &OS,                           const PrintingPolicy &Policy) const;
  typedef Expr ** args_iterator;
  args_iterator args_begin() const {
    return args;
  }
  args_iterator args_end() const {
    return args + argsSize;
  }
  unsigned args_size() const {
    return argsSize;
  }



  static bool classof(const Attr *A) { return A->getKind() == attr::UnlockFunction; }
  virtual bool isLateParsed() const { return 1; }
};

class UnusedAttr : public InheritableAttr {

 public:
  UnusedAttr(SourceRange R, ASTContext &Ctx
             )
    : InheritableAttr(attr::Unused, R)
  {
  }

  virtual UnusedAttr *clone (ASTContext &C) const;
  virtual void printPretty(llvm::raw_ostream &OS,                           const PrintingPolicy &Policy) const;


  static bool classof(const Attr *A) { return A->getKind() == attr::Unused; }
  virtual bool isLateParsed() const { return 0; }
};

class UsedAttr : public InheritableAttr {

 public:
  UsedAttr(SourceRange R, ASTContext &Ctx
             )
    : InheritableAttr(attr::Used, R)
  {
  }

  virtual UsedAttr *clone (ASTContext &C) const;
  virtual void printPretty(llvm::raw_ostream &OS,                           const PrintingPolicy &Policy) const;


  static bool classof(const Attr *A) { return A->getKind() == attr::Used; }
  virtual bool isLateParsed() const { return 0; }
};

class UuidAttr : public InheritableAttr {
unsigned guidLength;
char *guid;


 public:
  UuidAttr(SourceRange R, ASTContext &Ctx
              , llvm::StringRef Guid
             )
    : InheritableAttr(attr::Uuid, R)
              , guidLength(Guid.size()),guid(new (Ctx, 1) char[guidLength])
  {
      std::memcpy(guid, Guid.data(), guidLength);
  }

  virtual UuidAttr *clone (ASTContext &C) const;
  virtual void printPretty(llvm::raw_ostream &OS,                           const PrintingPolicy &Policy) const;
  llvm::StringRef getGuid() const {
    return llvm::StringRef(guid, guidLength);
  }
  unsigned getGuidLength() const {
    return guidLength;
  }
  void setGuid(ASTContext &C, llvm::StringRef S) {
    guidLength = S.size();
    this->guid = new (C, 1) char [guidLength];
    std::memcpy(this->guid, S.data(), guidLength);
  }



  static bool classof(const Attr *A) { return A->getKind() == attr::Uuid; }
  virtual bool isLateParsed() const { return 0; }
};

class VecReturnAttr : public InheritableAttr {

 public:
  VecReturnAttr(SourceRange R, ASTContext &Ctx
             )
    : InheritableAttr(attr::VecReturn, R)
  {
  }

  virtual VecReturnAttr *clone (ASTContext &C) const;
  virtual void printPretty(llvm::raw_ostream &OS,                           const PrintingPolicy &Policy) const;


  static bool classof(const Attr *A) { return A->getKind() == attr::VecReturn; }
  virtual bool isLateParsed() const { return 0; }
};

class VirtualInheritanceAttr : public InheritableAttr {

 public:
  VirtualInheritanceAttr(SourceRange R, ASTContext &Ctx
             )
    : InheritableAttr(attr::VirtualInheritance, R)
  {
  }

  virtual VirtualInheritanceAttr *clone (ASTContext &C) const;
  virtual void printPretty(llvm::raw_ostream &OS,                           const PrintingPolicy &Policy) const;


  static bool classof(const Attr *A) { return A->getKind() == attr::VirtualInheritance; }
  virtual bool isLateParsed() const { return 0; }
};

class VisibilityAttr : public InheritableAttr {
public:
  enum VisibilityType {
    Default,
    Hidden,
    Protected
  };
private:
  VisibilityType visibility;


 public:
  VisibilityAttr(SourceRange R, ASTContext &Ctx
              , VisibilityType Visibility
             )
    : InheritableAttr(attr::Visibility, R)
              , visibility(Visibility)
  {

  }

  virtual VisibilityAttr *clone (ASTContext &C) const;
  virtual void printPretty(llvm::raw_ostream &OS,                           const PrintingPolicy &Policy) const;
  VisibilityType getVisibility() const {
    return visibility;
  }



  static bool classof(const Attr *A) { return A->getKind() == attr::Visibility; }
  virtual bool isLateParsed() const { return 0; }
};

class WarnUnusedResultAttr : public InheritableAttr {

 public:
  WarnUnusedResultAttr(SourceRange R, ASTContext &Ctx
             )
    : InheritableAttr(attr::WarnUnusedResult, R)
  {
  }

  virtual WarnUnusedResultAttr *clone (ASTContext &C) const;
  virtual void printPretty(llvm::raw_ostream &OS,                           const PrintingPolicy &Policy) const;


  static bool classof(const Attr *A) { return A->getKind() == attr::WarnUnusedResult; }
  virtual bool isLateParsed() const { return 0; }
};

class WeakAttr : public InheritableAttr {

 public:
  WeakAttr(SourceRange R, ASTContext &Ctx
             )
    : InheritableAttr(attr::Weak, R)
  {
  }

  virtual WeakAttr *clone (ASTContext &C) const;
  virtual void printPretty(llvm::raw_ostream &OS,                           const PrintingPolicy &Policy) const;


  static bool classof(const Attr *A) { return A->getKind() == attr::Weak; }
  virtual bool isLateParsed() const { return 0; }
};

class WeakImportAttr : public InheritableAttr {

 public:
  WeakImportAttr(SourceRange R, ASTContext &Ctx
             )
    : InheritableAttr(attr::WeakImport, R)
  {
  }

  virtual WeakImportAttr *clone (ASTContext &C) const;
  virtual void printPretty(llvm::raw_ostream &OS,                           const PrintingPolicy &Policy) const;


  static bool classof(const Attr *A) { return A->getKind() == attr::WeakImport; }
  virtual bool isLateParsed() const { return 0; }
};

class WeakRefAttr : public InheritableAttr {

 public:
  WeakRefAttr(SourceRange R, ASTContext &Ctx
             )
    : InheritableAttr(attr::WeakRef, R)
  {
  }

  virtual WeakRefAttr *clone (ASTContext &C) const;
  virtual void printPretty(llvm::raw_ostream &OS,                           const PrintingPolicy &Policy) const;


  static bool classof(const Attr *A) { return A->getKind() == attr::WeakRef; }
  virtual bool isLateParsed() const { return 0; }
};

class Win64Attr : public InheritableAttr {

 public:
  Win64Attr(SourceRange R, ASTContext &Ctx
             )
    : InheritableAttr(attr::Win64, R)
  {
  }

  virtual Win64Attr *clone (ASTContext &C) const;
  virtual void printPretty(llvm::raw_ostream &OS,                           const PrintingPolicy &Policy) const;


  static bool classof(const Attr *A) { return A->getKind() == attr::Win64; }
  virtual bool isLateParsed() const { return 0; }
};

class WorkGroupSizeHintAttr : public InheritableAttr {
unsigned xDim;

unsigned yDim;

unsigned zDim;


 public:
  WorkGroupSizeHintAttr(SourceRange R, ASTContext &Ctx
              , unsigned XDim
              , unsigned YDim
              , unsigned ZDim
             )
    : InheritableAttr(attr::WorkGroupSizeHint, R)
              , xDim(XDim)
              , yDim(YDim)
              , zDim(ZDim)
  {



  }

  virtual WorkGroupSizeHintAttr *clone (ASTContext &C) const;
  virtual void printPretty(llvm::raw_ostream &OS,                           const PrintingPolicy &Policy) const;
  unsigned getXDim() const {
    return xDim;
  }

  unsigned getYDim() const {
    return yDim;
  }

  unsigned getZDim() const {
    return zDim;
  }



  static bool classof(const Attr *A) { return A->getKind() == attr::WorkGroupSizeHint; }
  virtual bool isLateParsed() const { return 0; }
};

class X86ForceAlignArgPointerAttr : public InheritableAttr {

 public:
  X86ForceAlignArgPointerAttr(SourceRange R, ASTContext &Ctx
             )
    : InheritableAttr(attr::X86ForceAlignArgPointer, R)
  {
  }

  virtual X86ForceAlignArgPointerAttr *clone (ASTContext &C) const;
  virtual void printPretty(llvm::raw_ostream &OS,                           const PrintingPolicy &Policy) const;


  static bool classof(const Attr *A) { return A->getKind() == attr::X86ForceAlignArgPointer; }
  virtual bool isLateParsed() const { return 0; }
};

#endif
