/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.report.pentaho.layoutprocessor;

import com.sun.star.report.pentaho.layoutprocessor.AbstractReportElementLayoutController;
import com.sun.star.report.pentaho.layoutprocessor.FormatValueUtility;
import com.sun.star.report.pentaho.layoutprocessor.OfficeRepeatingStructureLayoutController;
import com.sun.star.report.pentaho.layoutprocessor.TableCellLayoutController;
import com.sun.star.report.pentaho.layoutprocessor.VariablesCollection;
import com.sun.star.report.pentaho.model.FormattedTextElement;
import com.sun.star.report.pentaho.model.OfficeDocument;
import com.sun.star.report.pentaho.model.OfficeStyle;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jfree.layouting.util.AttributeMap;
import org.jfree.report.DataFlags;
import org.jfree.report.DataSourceException;
import org.jfree.report.ReportDataFactoryException;
import org.jfree.report.ReportProcessingException;
import org.jfree.report.expressions.FormulaExpression;
import org.jfree.report.flow.ReportTarget;
import org.jfree.report.flow.layoutprocessor.LayoutController;
import org.jfree.report.structure.Element;
import org.pentaho.reporting.libraries.formula.Formula;
import org.pentaho.reporting.libraries.formula.lvalues.LValue;
import org.pentaho.reporting.libraries.formula.parser.ParseException;

public class FormattedTextLayoutController
extends AbstractReportElementLayoutController {
    private static final Log LOGGER = LogFactory.getLog(FormattedTextLayoutController.class);

    private VariablesCollection getVariablesCollection() {
        for (LayoutController layoutController = this.getParent(); layoutController != null; layoutController = layoutController.getParent()) {
            if (!(layoutController instanceof OfficeRepeatingStructureLayoutController)) continue;
            OfficeRepeatingStructureLayoutController officeRepeatingStructureLayoutController = (OfficeRepeatingStructureLayoutController)layoutController;
            if (officeRepeatingStructureLayoutController.isNormalFlowProcessing()) {
                return null;
            }
            return officeRepeatingStructureLayoutController.getVariablesCollection();
        }
        return null;
    }

    @Override
    protected boolean isValueChanged() {
        try {
            FormattedTextElement formattedTextElement = (FormattedTextElement)this.getNode();
            FormulaExpression formulaExpression = formattedTextElement.getValueExpression();
            Formula formula = formulaExpression.getCompiledFormula();
            LValue lValue = formula.getRootReference();
            return this.isReferenceChanged(lValue);
        }
        catch (ParseException parseException) {
            LOGGER.debug("Parse Exception", parseException);
            return false;
        }
    }

    @Override
    protected LayoutController delegateContentGeneration(ReportTarget reportTarget) throws ReportProcessingException, ReportDataFactoryException, DataSourceException {
        FormattedTextElement formattedTextElement = (FormattedTextElement)this.getNode();
        VariablesCollection variablesCollection = this.getVariablesCollection();
        if (variablesCollection != null) {
            String string = variablesCollection.addVariable(formattedTextElement);
            AttributeMap attributeMap = new AttributeMap();
            attributeMap.setAttribute("http://jfreereport.sourceforge.net/namespaces/engine", "type", (Object)"variable-get");
            attributeMap.setAttribute("http://jfreereport.sourceforge.net/namespaces/engine", "namespace", (Object)"urn:oasis:names:tc:opendocument:xmlns:text:1.0");
            attributeMap.setAttribute("urn:oasis:names:tc:opendocument:xmlns:text:1.0", "name", (Object)string);
            String string2 = this.computeValueStyle();
            if (string2 != null) {
                attributeMap.setAttribute("urn:oasis:names:tc:opendocument:xmlns:style:1.0", "data-style-name", (Object)string2);
            }
            String string3 = this.computeValueType();
            attributeMap.setAttribute("urn:oasis:names:tc:opendocument:xmlns:office:1.0", "value-type", (Object)string3);
            reportTarget.startElement(attributeMap);
            reportTarget.endElement(attributeMap);
        } else {
            DataFlags dataFlags = FormatValueUtility.computeDataFlag(formattedTextElement, this.getFlowController());
            if (dataFlags != null) {
                if (dataFlags.getValue() instanceof String) {
                    reportTarget.processContent(dataFlags);
                } else {
                    Element element = this.getParentTableCell();
                    if (element != null && "string".equals(element.getAttribute("urn:oasis:names:tc:opendocument:xmlns:office:1.0", "value-type"))) {
                        reportTarget.processContent(dataFlags);
                    }
                }
            }
        }
        return this.join(this.getFlowController());
    }

    private OfficeDocument getDocument() {
        for (LayoutController layoutController = this.getParent(); layoutController != null; layoutController = layoutController.getParent()) {
            Object object = layoutController.getNode();
            if (!(object instanceof OfficeDocument)) continue;
            return (OfficeDocument)object;
        }
        return null;
    }

    private Element getParentTableCell() {
        for (LayoutController layoutController = this.getParent(); layoutController != null; layoutController = layoutController.getParent()) {
            if (!(layoutController instanceof TableCellLayoutController)) continue;
            TableCellLayoutController tableCellLayoutController = (TableCellLayoutController)layoutController;
            return tableCellLayoutController.getElement();
        }
        return null;
    }

    private String computeValueStyle() {
        Element element = this.getParentTableCell();
        if (element == null) {
            return null;
        }
        String string = (String)element.getAttribute("urn:oasis:names:tc:opendocument:xmlns:table:1.0", "style-name");
        if (string == null) {
            return null;
        }
        OfficeDocument officeDocument = this.getDocument();
        if (officeDocument == null) {
            return null;
        }
        OfficeStyle officeStyle = officeDocument.getStylesCollection().getStyle("table-cell", string);
        return (String)officeStyle.getAttribute("urn:oasis:names:tc:opendocument:xmlns:style:1.0", "data-style-name");
    }

    private String computeValueType() {
        Element element = this.getParentTableCell();
        if (element == null) {
            throw new IllegalStateException("A formatted text element must be a child of a Table-Cell.");
        }
        String string = (String)element.getAttribute("urn:oasis:names:tc:opendocument:xmlns:office:1.0", "value-type");
        if (string == null) {
            LOGGER.error("The Table-Cell does not have a office:value attribute defined. Your content will be messed up.");
            return "string";
        }
        return string;
    }
}

