/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.report.pentaho;

import com.sun.star.report.DataSource;
import com.sun.star.report.DataSourceException;
import org.jfree.report.ReportData;

public class StarReportData
implements ReportData {
    private final DataSource dataSource;
    private int currentRow;
    private final int rowCount;

    public StarReportData(DataSource dataSource) throws DataSourceException {
        if (dataSource == null) {
            throw new NullPointerException();
        }
        this.dataSource = dataSource;
        this.currentRow = 0;
        this.rowCount = dataSource.getRowCount();
    }

    @Override
    public boolean setCursorPosition(int n) throws org.jfree.report.DataSourceException {
        try {
            boolean bl = this.dataSource.absolute(n);
            if (bl) {
                this.currentRow = n;
            }
            return bl;
        }
        catch (DataSourceException dataSourceException) {
            throw new org.jfree.report.DataSourceException("Failed to move cursor", dataSourceException);
        }
    }

    @Override
    public void close() throws org.jfree.report.DataSourceException {
        try {
            this.dataSource.close();
        }
        catch (DataSourceException dataSourceException) {
            throw new org.jfree.report.DataSourceException("Failed to close datasource", dataSourceException);
        }
    }

    @Override
    public int getCursorPosition() throws org.jfree.report.DataSourceException {
        return this.currentRow;
    }

    @Override
    public boolean isAdvanceable() throws org.jfree.report.DataSourceException {
        return this.currentRow < this.rowCount;
    }

    @Override
    public boolean next() throws org.jfree.report.DataSourceException {
        try {
            if (this.dataSource.next()) {
                ++this.currentRow;
                return true;
            }
            return false;
        }
        catch (DataSourceException dataSourceException) {
            throw new org.jfree.report.DataSourceException("Failed to move cursor", dataSourceException);
        }
    }

    @Override
    public Object get(int n) throws org.jfree.report.DataSourceException {
        if (!this.isReadable()) {
            throw new org.jfree.report.DataSourceException("Failed to query column.");
        }
        try {
            return this.dataSource.getObject(n + 1);
        }
        catch (DataSourceException dataSourceException) {
            throw new org.jfree.report.DataSourceException("Failed to query column.", dataSourceException);
        }
    }

    @Override
    public int getColumnCount() throws org.jfree.report.DataSourceException {
        try {
            return this.dataSource.getColumnCount();
        }
        catch (DataSourceException dataSourceException) {
            throw new org.jfree.report.DataSourceException("Failed to query column count.", dataSourceException);
        }
    }

    @Override
    public String getColumnName(int n) throws org.jfree.report.DataSourceException {
        try {
            return this.dataSource.getColumnName(n + 1);
        }
        catch (DataSourceException dataSourceException) {
            throw new org.jfree.report.DataSourceException("Failed to query column name.", dataSourceException);
        }
    }

    @Override
    public boolean isReadable() throws org.jfree.report.DataSourceException {
        return this.currentRow > 0 && this.rowCount > 0;
    }
}

