/*
 * Decompiled with CFR 0.152.
 */
package org.openoffice.xmerge.converter.xml.sxc.pexcel.records;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.openoffice.xmerge.converter.xml.sxc.pexcel.records.CellValue;
import org.openoffice.xmerge.util.Debug;
import org.openoffice.xmerge.util.EndianConverter;

public class BlankCell
extends CellValue {
    public BlankCell(InputStream inputStream) throws IOException {
        this.read(inputStream);
    }

    public BlankCell(int n, int n2, int n3) throws IOException {
        this.setRow(n);
        this.setCol(n2);
        this.setIxfe(n3);
    }

    @Override
    public short getBiffType() {
        return 1;
    }

    @Override
    public void write(OutputStream outputStream) throws IOException {
        outputStream.write(this.getBiffType());
        outputStream.write(this.rw);
        outputStream.write(this.col);
        outputStream.write(this.ixfe);
        Debug.log((int)4, (String)"Writing BlankCell record");
    }

    @Override
    public int read(InputStream inputStream) throws IOException {
        int n = inputStream.read(this.rw);
        ++n;
        this.col = (byte)(this.col + inputStream.read());
        Debug.log((int)4, (String)("\tRow : " + EndianConverter.readShort((byte[])this.rw) + " Column : " + this.col + " ixfe : " + EndianConverter.readShort((byte[])this.ixfe)));
        return n += inputStream.read(this.ixfe);
    }

    @Override
    public String getString() throws IOException {
        return new String("");
    }
}

