/*
 * Decompiled with CFR 0.152.
 */
package sun.lwawt.macosx;

import java.awt.BufferCapabilities;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.Insets;
import java.awt.MenuBar;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.image.BufferedImage;
import sun.awt.CausedFocusEvent;
import sun.java2d.SurfaceData;
import sun.java2d.opengl.CGLLayer;
import sun.lwawt.LWWindowPeer;
import sun.lwawt.PlatformWindow;
import sun.lwawt.macosx.CEmbeddedFrame;
import sun.util.logging.PlatformLogger;

public class CPlatformEmbeddedFrame
implements PlatformWindow {
    private static final PlatformLogger focusLogger = PlatformLogger.getLogger("sun.lwawt.macosx.focus.CPlatformEmbeddedFrame");
    private CGLLayer windowLayer;
    private LWWindowPeer peer;
    private CEmbeddedFrame target;
    private volatile int screenX = 0;
    private volatile int screenY = 0;

    @Override
    public void initialize(Window window, LWWindowPeer lWWindowPeer, PlatformWindow platformWindow) {
        this.peer = lWWindowPeer;
        this.windowLayer = new CGLLayer(lWWindowPeer);
        this.target = (CEmbeddedFrame)window;
    }

    @Override
    public LWWindowPeer getPeer() {
        return this.peer;
    }

    @Override
    public long getLayerPtr() {
        return this.windowLayer.getPointer();
    }

    @Override
    public void dispose() {
        this.windowLayer.dispose();
    }

    @Override
    public void setBounds(int n, int n2, int n3, int n4) {
        this.screenX = n;
        this.screenY = n2;
        this.peer.notifyReshape(n, n2, n3, n4);
    }

    @Override
    public GraphicsDevice getGraphicsDevice() {
        GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        return graphicsEnvironment.getDefaultScreenDevice();
    }

    @Override
    public Point getLocationOnScreen() {
        return new Point(this.screenX, this.screenY);
    }

    @Override
    public FontMetrics getFontMetrics(Font font) {
        throw new RuntimeException("Not implemented");
    }

    @Override
    public SurfaceData getScreenSurface() {
        return this.windowLayer.getSurfaceData();
    }

    @Override
    public SurfaceData replaceSurfaceData() {
        return this.windowLayer.replaceSurfaceData();
    }

    @Override
    public Image createBackBuffer() {
        Rectangle rectangle = this.peer.getBounds();
        BufferedImage bufferedImage = null;
        if (!rectangle.isEmpty()) {
            int n = this.peer.isOpaque() ? 1 : 3;
            bufferedImage = this.peer.getGraphicsConfiguration().createCompatibleImage(rectangle.width, rectangle.height, n);
        }
        return bufferedImage;
    }

    @Override
    public void flip(int n, int n2, int n3, int n4, BufferCapabilities.FlipContents flipContents) {
        throw new RuntimeException("Not implemented");
    }

    @Override
    public void setVisible(boolean bl) {
    }

    @Override
    public void setTitle(String string) {
    }

    @Override
    public Insets getInsets() {
        return new Insets(0, 0, 0, 0);
    }

    @Override
    public void toFront() {
    }

    @Override
    public void toBack() {
    }

    @Override
    public void setMenuBar(MenuBar menuBar) {
    }

    @Override
    public void setAlwaysOnTop(boolean bl) {
    }

    @Override
    public void updateFocusableWindowState() {
    }

    @Override
    public boolean rejectFocusRequest(CausedFocusEvent.Cause cause) {
        if (cause != CausedFocusEvent.Cause.MOUSE_EVENT && !this.target.isParentWindowActive()) {
            focusLogger.fine("the embedder is inactive, so the request is rejected");
            return true;
        }
        return false;
    }

    @Override
    public boolean requestWindowFocus() {
        return true;
    }

    @Override
    public boolean isActive() {
        return true;
    }

    @Override
    public void setResizable(boolean bl) {
    }

    @Override
    public void setSizeConstraints(int n, int n2, int n3, int n4) {
    }

    @Override
    public Graphics transformGraphics(Graphics graphics) {
        return graphics;
    }

    @Override
    public void updateIconImages() {
    }

    @Override
    public void setOpacity(float f) {
    }

    @Override
    public void setOpaque(boolean bl) {
    }

    @Override
    public void enterFullScreenMode() {
    }

    @Override
    public void exitFullScreenMode() {
    }

    @Override
    public void setWindowState(int n) {
    }

    @Override
    public void setModalBlocked(boolean bl) {
    }
}

