/*
 * Decompiled with CFR 0.152.
 */
package sun.security.provider.certpath;

import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.Signature;
import java.security.SignatureException;
import java.security.cert.CertPathValidatorException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateParsingException;
import java.security.cert.X509Certificate;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import sun.security.provider.certpath.AlgorithmChecker;
import sun.security.provider.certpath.CertId;
import sun.security.provider.certpath.OCSP;
import sun.security.util.Debug;
import sun.security.util.DerInputStream;
import sun.security.util.DerValue;
import sun.security.util.ObjectIdentifier;
import sun.security.x509.AlgorithmId;
import sun.security.x509.Extension;
import sun.security.x509.X500Name;
import sun.security.x509.X509CertImpl;

public final class OCSPResponse {
    private static ResponseStatus[] rsvalues = ResponseStatus.values();
    private static final Debug DEBUG = Debug.getInstance("certpath");
    private static final boolean dump = false;
    private static final ObjectIdentifier OCSP_BASIC_RESPONSE_OID = ObjectIdentifier.newInternal(new int[]{1, 3, 6, 1, 5, 5, 7, 48, 1, 1});
    private static final ObjectIdentifier OCSP_NONCE_EXTENSION_OID = ObjectIdentifier.newInternal(new int[]{1, 3, 6, 1, 5, 5, 7, 48, 1, 2});
    private static final int CERT_STATUS_GOOD = 0;
    private static final int CERT_STATUS_REVOKED = 1;
    private static final int CERT_STATUS_UNKNOWN = 2;
    private static final int NAME_TAG = 1;
    private static final int KEY_TAG = 2;
    private static final String KP_OCSP_SIGNING_OID = "1.3.6.1.5.5.7.3.9";
    private final ResponseStatus responseStatus;
    private final Map<CertId, SingleResponse> singleResponseMap;
    private static final long MAX_CLOCK_SKEW = 900000L;

    OCSPResponse(byte[] byArray, Date date, X509Certificate object) throws IOException, CertPathValidatorException {
        Object object2;
        Object object3;
        X509CertImpl[] x509CertImplArray;
        DerValue[] derValueArray;
        int n;
        DerValue derValue = new DerValue(byArray);
        if (derValue.tag != 48) {
            throw new IOException("Bad encoding in OCSP response: expected ASN.1 SEQUENCE tag.");
        }
        DerInputStream derInputStream = derValue.getData();
        int n2 = derInputStream.getEnumerated();
        if (n2 < 0 || n2 >= rsvalues.length) {
            throw new IOException("Unknown OCSPResponse status: " + n2);
        }
        this.responseStatus = rsvalues[n2];
        if (DEBUG != null) {
            DEBUG.println("OCSP response status: " + (Object)((Object)this.responseStatus));
        }
        if (this.responseStatus != ResponseStatus.SUCCESSFUL) {
            this.singleResponseMap = Collections.emptyMap();
            return;
        }
        derValue = derInputStream.getDerValue();
        if (!derValue.isContextSpecific((byte)0)) {
            throw new IOException("Bad encoding in responseBytes element of OCSP response: expected ASN.1 context specific tag 0.");
        }
        DerValue derValue2 = derValue.data.getDerValue();
        if (derValue2.tag != 48) {
            throw new IOException("Bad encoding in responseBytes element of OCSP response: expected ASN.1 SEQUENCE tag.");
        }
        derInputStream = derValue2.data;
        ObjectIdentifier objectIdentifier = derInputStream.getOID();
        if (objectIdentifier.equals(OCSP_BASIC_RESPONSE_OID)) {
            if (DEBUG != null) {
                DEBUG.println("OCSP response type: basic");
            }
        } else {
            if (DEBUG != null) {
                DEBUG.println("OCSP response type: " + objectIdentifier);
            }
            throw new IOException("Unsupported OCSP response type: " + objectIdentifier);
        }
        DerInputStream derInputStream2 = new DerInputStream(derInputStream.getOctetString());
        DerValue[] derValueArray2 = derInputStream2.getSequence(2);
        if (derValueArray2.length < 3) {
            throw new IOException("Unexpected BasicOCSPResponse value");
        }
        DerValue derValue3 = derValueArray2[0];
        byte[] byArray2 = derValueArray2[0].toByteArray();
        if (derValue3.tag != 48) {
            throw new IOException("Bad encoding in tbsResponseData element of OCSP response: expected ASN.1 SEQUENCE tag.");
        }
        DerInputStream derInputStream3 = derValue3.data;
        DerValue derValue4 = derInputStream3.getDerValue();
        if (derValue4.isContextSpecific((byte)0) && derValue4.isConstructed() && derValue4.isContextSpecific()) {
            derValue4 = derValue4.data.getDerValue();
            n = derValue4.getInteger();
            if (derValue4.data.available() != 0) {
                throw new IOException("Bad encoding in version  element of OCSP response: bad format");
            }
            derValue4 = derInputStream3.getDerValue();
        }
        if ((n = (int)((byte)(derValue4.tag & 0x1F))) == 1) {
            if (DEBUG != null) {
                derValueArray = new X500Name(derValue4.getData());
                DEBUG.println("OCSP Responder name: " + derValueArray);
            }
        } else if (n != 2) {
            throw new IOException("Bad encoding in responderID element of OCSP response: expected ASN.1 context specific tag 0 or 1");
        }
        derValue4 = derInputStream3.getDerValue();
        if (DEBUG != null) {
            derValueArray = derValue4.getGeneralizedTime();
            DEBUG.println("OCSP response produced at: " + derValueArray);
        }
        derValueArray = derInputStream3.getSequence(1);
        this.singleResponseMap = new HashMap<CertId, SingleResponse>(derValueArray.length);
        if (DEBUG != null) {
            DEBUG.println("OCSP number of SingleResponses: " + derValueArray.length);
        }
        for (int i = 0; i < derValueArray.length; ++i) {
            SingleResponse singleResponse = new SingleResponse(derValueArray[i]);
            this.singleResponseMap.put(singleResponse.getCertId(), singleResponse);
        }
        if (derInputStream3.available() > 0 && (derValue4 = derInputStream3.getDerValue()).isContextSpecific((byte)1)) {
            DerValue[] derValueArray3 = derValue4.data.getSequence(3);
            for (int i = 0; i < derValueArray3.length; ++i) {
                x509CertImplArray = new Extension(derValueArray3[i]);
                if (DEBUG != null) {
                    DEBUG.println("OCSP extension: " + x509CertImplArray);
                }
                if (x509CertImplArray.getExtensionId().equals(OCSP_NONCE_EXTENSION_OID) || !x509CertImplArray.isCritical()) continue;
                throw new IOException("Unsupported OCSP critical extension: " + x509CertImplArray.getExtensionId());
            }
        }
        AlgorithmId algorithmId = AlgorithmId.parse(derValueArray2[1]);
        AlgorithmChecker.check(algorithmId);
        byte[] byArray3 = derValueArray2[2].getBitString();
        x509CertImplArray = null;
        if (derValueArray2.length > 3) {
            object3 = derValueArray2[3];
            if (!((DerValue)object3).isContextSpecific((byte)0)) {
                throw new IOException("Bad encoding in certs element of OCSP response: expected ASN.1 context specific tag 0.");
            }
            object2 = ((DerValue)object3).getData().getSequence(3);
            x509CertImplArray = new X509CertImpl[((DerValue[])object2).length];
            try {
                for (int i = 0; i < ((DerValue[])object2).length; ++i) {
                    x509CertImplArray[i] = new X509CertImpl(object2[i].toByteArray());
                }
            }
            catch (CertificateException certificateException) {
                throw new IOException("Bad encoding in X509 Certificate", certificateException);
            }
        }
        if (x509CertImplArray != null && x509CertImplArray[0] != null && !((Certificate)(object3 = x509CertImplArray[0])).equals(object) && ((X509Certificate)object3).getIssuerX500Principal().equals(((X509Certificate)object).getSubjectX500Principal())) {
            AlgorithmChecker.check((Certificate)object3);
            try {
                object2 = ((X509Certificate)object3).getExtendedKeyUsage();
                if (object2 == null || !object2.contains(KP_OCSP_SIGNING_OID)) {
                    throw new CertPathValidatorException("Responder's certificate not valid for signing OCSP responses");
                }
            }
            catch (CertificateParsingException certificateParsingException) {
                throw new CertPathValidatorException("Responder's certificate not valid for signing OCSP responses", certificateParsingException);
            }
            try {
                ((Certificate)object3).verify(((Certificate)object).getPublicKey());
                object = object3;
            }
            catch (GeneralSecurityException generalSecurityException) {
                object = null;
            }
        }
        if (object != null) {
            if (!this.verifyResponse(byArray2, (X509Certificate)object, algorithmId, byArray3)) {
                throw new CertPathValidatorException("Error verifying OCSP Responder's signature");
            }
        } else {
            throw new CertPathValidatorException("Unable to verify OCSP Responder's signature");
        }
    }

    ResponseStatus getResponseStatus() {
        return this.responseStatus;
    }

    private boolean verifyResponse(byte[] byArray, X509Certificate x509Certificate, AlgorithmId algorithmId, byte[] byArray2) throws CertPathValidatorException {
        try {
            Signature signature = Signature.getInstance(algorithmId.getName());
            signature.initVerify(x509Certificate);
            signature.update(byArray);
            if (signature.verify(byArray2)) {
                if (DEBUG != null) {
                    DEBUG.println("Verified signature of OCSP Responder");
                }
                return true;
            }
            if (DEBUG != null) {
                DEBUG.println("Error verifying signature of OCSP Responder");
            }
            return false;
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new CertPathValidatorException(invalidKeyException);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new CertPathValidatorException(noSuchAlgorithmException);
        }
        catch (SignatureException signatureException) {
            throw new CertPathValidatorException(signatureException);
        }
    }

    SingleResponse getSingleResponse(CertId certId) {
        return this.singleResponseMap.get(certId);
    }

    static final class SingleResponse
    implements OCSP.RevocationStatus {
        private final CertId certId;
        private final OCSP.RevocationStatus.CertStatus certStatus;
        private final Date thisUpdate;
        private final Date nextUpdate;
        private final Date revocationTime;
        private static OCSP.RevocationStatus.Reason[] values = OCSP.RevocationStatus.Reason.values();
        private final OCSP.RevocationStatus.Reason revocationReason;

        private SingleResponse(DerValue derValue) throws IOException {
            Object object;
            int n;
            DerValue[] derValueArray;
            if (derValue.tag != 48) {
                throw new IOException("Bad ASN.1 encoding in SingleResponse");
            }
            DerInputStream derInputStream = derValue.data;
            this.certId = new CertId(derInputStream.getDerValue().data);
            DerValue derValue2 = derInputStream.getDerValue();
            short s = (byte)(derValue2.tag & 0x1F);
            if (s == 1) {
                this.certStatus = OCSP.RevocationStatus.CertStatus.REVOKED;
                this.revocationTime = derValue2.data.getGeneralizedTime();
                if (derValue2.data.available() != 0) {
                    derValueArray = derValue2.data.getDerValue();
                    s = (byte)(derValueArray.tag & 0x1F);
                    this.revocationReason = s == 0 ? ((n = derValueArray.data.getEnumerated()) >= 0 && n < values.length ? values[n] : OCSP.RevocationStatus.Reason.UNSPECIFIED) : OCSP.RevocationStatus.Reason.UNSPECIFIED;
                } else {
                    this.revocationReason = OCSP.RevocationStatus.Reason.UNSPECIFIED;
                }
                if (DEBUG != null) {
                    DEBUG.println("Revocation time: " + this.revocationTime);
                    DEBUG.println("Revocation reason: " + (Object)((Object)this.revocationReason));
                }
            } else {
                this.revocationTime = null;
                this.revocationReason = OCSP.RevocationStatus.Reason.UNSPECIFIED;
                if (s == 0) {
                    this.certStatus = OCSP.RevocationStatus.CertStatus.GOOD;
                } else if (s == 2) {
                    this.certStatus = OCSP.RevocationStatus.CertStatus.UNKNOWN;
                } else {
                    throw new IOException("Invalid certificate status");
                }
            }
            this.thisUpdate = derInputStream.getGeneralizedTime();
            if (derInputStream.available() == 0) {
                this.nextUpdate = null;
            } else {
                derValue2 = derInputStream.getDerValue();
                s = (byte)(derValue2.tag & 0x1F);
                this.nextUpdate = s == 0 ? derValue2.data.getGeneralizedTime() : null;
            }
            if (derInputStream.available() > 0 && (derValue2 = derInputStream.getDerValue()).isContextSpecific((byte)1)) {
                derValueArray = derValue2.data.getSequence(3);
                for (n = 0; n < derValueArray.length; ++n) {
                    object = new Extension(derValueArray[n]);
                    if (DEBUG != null) {
                        DEBUG.println("OCSP single extension: " + object);
                    }
                    if (!((Extension)object).isCritical()) continue;
                    throw new IOException("Unsupported OCSP critical extension: " + ((Extension)object).getExtensionId());
                }
            }
            long l = System.currentTimeMillis();
            object = new Date(l + 900000L);
            Date date = new Date(l - 900000L);
            if (DEBUG != null) {
                String string = "";
                if (this.nextUpdate != null) {
                    string = " until " + this.nextUpdate;
                }
                DEBUG.println("Response's validity interval is from " + this.thisUpdate + string);
            }
            if (this.thisUpdate != null && ((Date)object).before(this.thisUpdate) || this.nextUpdate != null && date.after(this.nextUpdate)) {
                if (DEBUG != null) {
                    DEBUG.println("Response is unreliable: its validity interval is out-of-date");
                }
                throw new IOException("Response is unreliable: its validity interval is out-of-date");
            }
        }

        public OCSP.RevocationStatus.CertStatus getCertStatus() {
            return this.certStatus;
        }

        private CertId getCertId() {
            return this.certId;
        }

        public Date getRevocationTime() {
            return (Date)this.revocationTime.clone();
        }

        public OCSP.RevocationStatus.Reason getRevocationReason() {
            return this.revocationReason;
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("SingleResponse:  \n");
            stringBuilder.append(this.certId);
            stringBuilder.append("\nCertStatus: " + (Object)((Object)this.certStatus) + "\n");
            if (this.certStatus == OCSP.RevocationStatus.CertStatus.REVOKED) {
                stringBuilder.append("revocationTime is " + this.revocationTime + "\n");
                stringBuilder.append("revocationReason is " + (Object)((Object)this.revocationReason) + "\n");
            }
            stringBuilder.append("thisUpdate is " + this.thisUpdate + "\n");
            if (this.nextUpdate != null) {
                stringBuilder.append("nextUpdate is " + this.nextUpdate + "\n");
            }
            return stringBuilder.toString();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ResponseStatus {
        SUCCESSFUL,
        MALFORMED_REQUEST,
        INTERNAL_ERROR,
        TRY_LATER,
        UNUSED,
        SIG_REQUIRED,
        UNAUTHORIZED;

    }
}

