/*
 * Decompiled with CFR 0.152.
 */
package javax.crypto;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.security.Permission;
import java.security.PermissionCollection;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.crypto.CryptoPermission;
import javax.crypto.CryptoPolicyParser;
import javax.crypto.PermissionsEnumerator;

final class CryptoPermissions
extends PermissionCollection
implements Serializable {
    private static final long serialVersionUID = 4946547168093391015L;
    private Hashtable perms = new Hashtable(7);

    CryptoPermissions() {
    }

    void load(InputStream inputStream) throws IOException, CryptoPolicyParser.ParsingException {
        CryptoPolicyParser cryptoPolicyParser = new CryptoPolicyParser();
        cryptoPolicyParser.read(new BufferedReader(new InputStreamReader(inputStream, "UTF-8")));
        CryptoPermission[] cryptoPermissionArray = cryptoPolicyParser.getPermissions();
        for (int i = 0; i < cryptoPermissionArray.length; ++i) {
            this.add(cryptoPermissionArray[i]);
        }
    }

    boolean isEmpty() {
        return this.perms.isEmpty();
    }

    public void add(Permission permission) {
        if (this.isReadOnly()) {
            throw new SecurityException("Attempt to add a Permission to a readonly CryptoPermissions object");
        }
        if (!(permission instanceof CryptoPermission)) {
            return;
        }
        CryptoPermission cryptoPermission = (CryptoPermission)permission;
        PermissionCollection permissionCollection = this.getPermissionCollection(cryptoPermission);
        permissionCollection.add(cryptoPermission);
        String string = cryptoPermission.getAlgorithm();
        if (!this.perms.containsKey(string)) {
            this.perms.put(string, permissionCollection);
        }
    }

    public boolean implies(Permission permission) {
        if (!(permission instanceof CryptoPermission)) {
            return false;
        }
        CryptoPermission cryptoPermission = (CryptoPermission)permission;
        PermissionCollection permissionCollection = this.getPermissionCollection(cryptoPermission.getAlgorithm());
        return permissionCollection.implies(cryptoPermission);
    }

    public Enumeration elements() {
        return new PermissionsEnumerator(this.perms.elements());
    }

    CryptoPermissions getMinimum(CryptoPermissions cryptoPermissions) {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        if (cryptoPermissions == null) {
            return null;
        }
        if (this.perms.containsKey("CryptoAllPermission")) {
            return cryptoPermissions;
        }
        if (cryptoPermissions.perms.containsKey("CryptoAllPermission")) {
            return this;
        }
        CryptoPermissions cryptoPermissions2 = new CryptoPermissions();
        PermissionCollection permissionCollection = (PermissionCollection)cryptoPermissions.perms.get("*");
        int n = 0;
        if (permissionCollection != null) {
            n = ((CryptoPermission)permissionCollection.elements().nextElement()).getMaxKeySize();
        }
        Enumeration enumeration = this.perms.keys();
        while (enumeration.hasMoreElements()) {
            object4 = (String)enumeration.nextElement();
            object3 = (PermissionCollection)this.perms.get(object4);
            object2 = (PermissionCollection)cryptoPermissions.perms.get(object4);
            if (object2 == null) {
                if (permissionCollection == null) continue;
                object = this.getMinimum(n, (PermissionCollection)object3);
            } else {
                object = this.getMinimum((PermissionCollection)object3, (PermissionCollection)object2);
            }
            for (int i = 0; i < ((CryptoPermission[])object).length; ++i) {
                cryptoPermissions2.add(object[i]);
            }
        }
        object4 = (PermissionCollection)this.perms.get("*");
        if (object4 == null) {
            return cryptoPermissions2;
        }
        n = ((CryptoPermission)((PermissionCollection)object4).elements().nextElement()).getMaxKeySize();
        object3 = cryptoPermissions.perms.keys();
        while (object3.hasMoreElements()) {
            object2 = (String)object3.nextElement();
            if (this.perms.containsKey(object2)) continue;
            object = (PermissionCollection)cryptoPermissions.perms.get(object2);
            CryptoPermission[] cryptoPermissionArray = this.getMinimum(n, (PermissionCollection)object);
            for (int i = 0; i < cryptoPermissionArray.length; ++i) {
                cryptoPermissions2.add(cryptoPermissionArray[i]);
            }
        }
        return cryptoPermissions2;
    }

    private CryptoPermission[] getMinimum(PermissionCollection permissionCollection, PermissionCollection permissionCollection2) {
        Object[] objectArray;
        Vector<Object> vector = new Vector<Object>(2);
        Enumeration<Permission> enumeration = permissionCollection.elements();
        block0: while (enumeration.hasMoreElements()) {
            objectArray = (Object[])enumeration.nextElement();
            Enumeration<Permission> enumeration2 = permissionCollection2.elements();
            while (enumeration2.hasMoreElements()) {
                CryptoPermission cryptoPermission = (CryptoPermission)enumeration2.nextElement();
                if (cryptoPermission.implies((Permission)objectArray)) {
                    vector.addElement(objectArray);
                    continue block0;
                }
                if (!objectArray.implies(cryptoPermission)) continue;
                vector.addElement(cryptoPermission);
            }
        }
        objectArray = new CryptoPermission[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    private CryptoPermission[] getMinimum(int n, PermissionCollection permissionCollection) {
        Object[] objectArray;
        Vector<Object> vector = new Vector<Object>(1);
        Enumeration<Permission> enumeration = permissionCollection.elements();
        while (enumeration.hasMoreElements()) {
            objectArray = (Object[])enumeration.nextElement();
            if (objectArray.getMaxKeySize() <= n) {
                vector.addElement(objectArray);
                continue;
            }
            if (objectArray.getCheckParam()) {
                vector.addElement(new CryptoPermission(objectArray.getAlgorithm(), n, objectArray.getAlgorithmParameterSpec(), objectArray.getExemptionMechanism()));
                continue;
            }
            vector.addElement(new CryptoPermission(objectArray.getAlgorithm(), n, objectArray.getExemptionMechanism()));
        }
        objectArray = new CryptoPermission[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    PermissionCollection getPermissionCollection(String string) {
        if (this.perms.containsKey("CryptoAllPermission")) {
            return (PermissionCollection)this.perms.get("CryptoAllPermission");
        }
        PermissionCollection permissionCollection = (PermissionCollection)this.perms.get(string);
        if (permissionCollection == null) {
            permissionCollection = (PermissionCollection)this.perms.get("*");
        }
        return permissionCollection;
    }

    private PermissionCollection getPermissionCollection(CryptoPermission cryptoPermission) {
        String string = cryptoPermission.getAlgorithm();
        PermissionCollection permissionCollection = (PermissionCollection)this.perms.get(string);
        if (permissionCollection == null) {
            permissionCollection = cryptoPermission.newPermissionCollection();
        }
        return permissionCollection;
    }
}

