/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.tools;

import java.awt.Cursor;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.OpenBrowser;
import org.openstreetmap.josm.tools.Utils;

public class UrlLabel
extends JLabel
implements MouseListener {
    private String url = "";
    private String description = "";
    private int fontPlus;

    public UrlLabel() {
        this.addMouseListener(this);
        this.setCursor(Cursor.getPredefinedCursor(12));
    }

    public UrlLabel(String string) {
        this(string, string, 0);
    }

    public UrlLabel(String string, int n) {
        this(string, string, n);
    }

    public UrlLabel(String string, String string2) {
        this(string, string, 0);
    }

    public UrlLabel(String string, String string2, int n) {
        this();
        this.setUrl(string);
        this.setDescription(string2);
        this.fontPlus = n;
        if (n != 0) {
            this.setFont(this.getFont().deriveFont(0, this.getFont().getSize() + n));
        }
        this.refresh();
    }

    protected void refresh() {
        if (this.url != null) {
            this.setText("<html><a href=\"" + this.url + "\">" + this.description + "</a></html>");
            this.setCursor(Cursor.getPredefinedCursor(12));
            this.setToolTipText(String.format("<html>%s<br/>%s</html>", this.url, I18n.tr("Right click = copy to clipboard", new Object[0])));
        } else {
            this.setText("<html>" + this.description + "</html>");
            this.setCursor(null);
            this.setToolTipText(null);
        }
    }

    public void setUrl(String string) {
        this.url = string;
        this.refresh();
    }

    public void setDescription(String string) {
        this.description = string == null ? "" : string;
        this.description = this.description.replace("&", "&amp;").replace(">", "&gt;").replace("<", "&lt;");
        this.refresh();
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        if (SwingUtilities.isLeftMouseButton(mouseEvent)) {
            OpenBrowser.displayUrl(this.url);
        } else if (SwingUtilities.isRightMouseButton(mouseEvent)) {
            Utils.copyToClipboard(this.url);
        }
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }
}

