/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.projection;

import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.projection.AbstractProjection;
import org.openstreetmap.josm.data.projection.Ellipsoid;
import org.openstreetmap.josm.data.projection.ProjectionConfigurationException;
import org.openstreetmap.josm.data.projection.datum.GRS80Datum;
import org.openstreetmap.josm.data.projection.proj.ProjParameters;
import org.openstreetmap.josm.data.projection.proj.TransverseMercator;
import org.openstreetmap.josm.tools.I18n;

public class Epsg3008
extends AbstractProjection {
    public Epsg3008() {
        this.ellps = Ellipsoid.GRS80;
        this.proj = new TransverseMercator();
        try {
            this.proj.initialize(new ProjParameters(){
                {
                    this.ellps = Epsg3008.this.ellps;
                }
            });
        }
        catch (ProjectionConfigurationException projectionConfigurationException) {
            throw new RuntimeException(projectionConfigurationException);
        }
        this.datum = GRS80Datum.INSTANCE;
        this.lon_0 = 13.5;
        this.x_0 = 150000.0;
    }

    public String toString() {
        return I18n.tr("SWEREF99 13 30 / EPSG:3008 (Sweden)", new Object[0]);
    }

    public Integer getEpsgCode() {
        return 3008;
    }

    public int hashCode() {
        return this.toCode().hashCode();
    }

    public String getCacheDirectoryName() {
        return "epsg" + this.getEpsgCode();
    }

    public Bounds getWorldBoundsLatLon() {
        return new Bounds(new LatLon(55.2, 12.1), new LatLon(62.26, 14.65), false);
    }
}

