/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.imagery;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.gui.layer.ImageryLayer;
import org.openstreetmap.josm.tools.I18n;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OffsetBookmark {
    public static final List<OffsetBookmark> allBookmarks = new ArrayList<OffsetBookmark>();
    public String projectionCode;
    public String layerName;
    public String name;
    public double dx;
    public double dy;
    public double centerX;
    public double centerY;

    public boolean isUsable(ImageryLayer imageryLayer) {
        if (this.projectionCode == null) {
            return false;
        }
        if (!Main.getProjection().toCode().equals(this.projectionCode)) {
            return false;
        }
        return imageryLayer.getInfo().getName().equals(this.layerName);
    }

    public OffsetBookmark(String string, String string2, String string3, double d, double d2) {
        this(string, string2, string3, d, d2, 0.0, 0.0);
    }

    public OffsetBookmark(String string, String string2, String string3, double d, double d2, double d3, double d4) {
        this.projectionCode = string;
        this.layerName = string2;
        this.name = string3;
        this.dx = d;
        this.dy = d2;
        this.centerX = d3;
        this.centerY = d4;
    }

    public OffsetBookmark(Collection<String> collection) {
        ArrayList<String> arrayList = new ArrayList<String>(collection);
        this.projectionCode = arrayList.get(0);
        this.layerName = arrayList.get(1);
        this.name = arrayList.get(2);
        this.dx = Double.valueOf(arrayList.get(3));
        this.dy = Double.valueOf(arrayList.get(4));
        if (arrayList.size() >= 7) {
            this.centerX = Double.valueOf(arrayList.get(5));
            this.centerY = Double.valueOf(arrayList.get(6));
        }
        if (this.projectionCode == null) {
            System.err.println(I18n.tr("Projection ''{0}'' is not found, bookmark ''{1}'' is not usable", this.projectionCode, this.name));
        }
    }

    public ArrayList<String> getInfoArray() {
        ArrayList<String> arrayList = new ArrayList<String>(7);
        if (this.projectionCode != null) {
            arrayList.add(this.projectionCode);
        } else {
            arrayList.add("");
        }
        arrayList.add(this.layerName);
        arrayList.add(this.name);
        arrayList.add(String.valueOf(this.dx));
        arrayList.add(String.valueOf(this.dy));
        if (this.centerX != 0.0 || this.centerY != 0.0) {
            arrayList.add(String.valueOf(this.centerX));
            arrayList.add(String.valueOf(this.centerY));
        }
        return arrayList;
    }

    public static void loadBookmarks() {
        for (Collection<String> collection : Main.pref.getArray("imagery.offsets", Collections.<Collection<String>>emptySet())) {
            allBookmarks.add(new OffsetBookmark(collection));
        }
    }

    public static void saveBookmarks() {
        LinkedList<Collection<String>> linkedList = new LinkedList<Collection<String>>();
        for (OffsetBookmark offsetBookmark : allBookmarks) {
            linkedList.add(offsetBookmark.getInfoArray());
        }
        Main.pref.putArray("imagery.offsets", linkedList);
    }

    public static OffsetBookmark getBookmarkByName(ImageryLayer imageryLayer, String string) {
        for (OffsetBookmark offsetBookmark : allBookmarks) {
            if (!offsetBookmark.isUsable(imageryLayer) || !string.equals(offsetBookmark.name)) continue;
            return offsetBookmark;
        }
        return null;
    }

    public static void bookmarkOffset(String string, ImageryLayer imageryLayer) {
        LatLon latLon = Main.isDisplayingMapView() ? Main.getProjection().eastNorth2latlon(Main.map.mapView.getCenter()) : new LatLon(0.0, 0.0);
        OffsetBookmark offsetBookmark = new OffsetBookmark(Main.getProjection().toCode(), imageryLayer.getInfo().getName(), string, imageryLayer.getDx(), imageryLayer.getDy(), latLon.lon(), latLon.lat());
        ListIterator<OffsetBookmark> listIterator = allBookmarks.listIterator();
        while (listIterator.hasNext()) {
            OffsetBookmark offsetBookmark2 = listIterator.next();
            if (!offsetBookmark2.isUsable(imageryLayer) || !string.equals(offsetBookmark2.name)) continue;
            listIterator.set(offsetBookmark);
            OffsetBookmark.saveBookmarks();
            return;
        }
        allBookmarks.add(offsetBookmark);
        OffsetBookmark.saveBookmarks();
    }
}

