/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions;

import java.awt.event.ActionEvent;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import javax.swing.JOptionPane;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.command.MoveCommand;
import org.openstreetmap.josm.command.SequenceCommand;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Shortcut;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class MirrorAction
extends JosmAction {
    public MirrorAction() {
        super(I18n.tr("Mirror", new Object[0]), "mirror", I18n.tr("Mirror selected nodes and ways.", new Object[0]), Shortcut.registerShortcut("tools:mirror", I18n.tr("Tool: {0}", I18n.tr("Mirror", new Object[0])), 77, 5005), true);
        this.putValue("help", HelpUtil.ht("/Action/Mirror"));
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Collection<OsmPrimitive> collection = MirrorAction.getCurrentDataSet().getSelected();
        HashSet<Node> hashSet = new HashSet<Node>();
        for (OsmPrimitive osmPrimitive : collection) {
            if (osmPrimitive instanceof Node) {
                hashSet.add((Node)osmPrimitive);
                continue;
            }
            if (!(osmPrimitive instanceof Way)) continue;
            hashSet.addAll(((Way)osmPrimitive).getNodes());
        }
        if (hashSet.size() == 0) {
            JOptionPane.showMessageDialog(Main.parent, I18n.tr("Please select at least one node or way.", new Object[0]), I18n.tr("Information", new Object[0]), 1);
            return;
        }
        double d = 2.0E10;
        double d2 = -2.0E10;
        for (Node node : hashSet) {
            double d3 = node.getEastNorth().east();
            d = Math.min(d, d3);
            d2 = Math.max(d2, d3);
        }
        double d4 = (d + d2) / 2.0;
        LinkedList<Command> linkedList = new LinkedList<Command>();
        for (Node node : hashSet) {
            linkedList.add(new MoveCommand((OsmPrimitive)node, 2.0 * (d4 - node.getEastNorth().east()), 0.0));
        }
        Main.main.undoRedo.add(new SequenceCommand(I18n.tr("Mirror", new Object[0]), linkedList));
        Main.map.repaint();
    }

    @Override
    protected void updateEnabledState() {
        if (MirrorAction.getCurrentDataSet() == null) {
            this.setEnabled(false);
        } else {
            this.updateEnabledState(MirrorAction.getCurrentDataSet().getSelected());
        }
    }

    @Override
    protected void updateEnabledState(Collection<? extends OsmPrimitive> collection) {
        this.setEnabled(collection != null && !collection.isEmpty());
    }
}

