/*
 * Decompiled with CFR 0.152.
 */
package sun.security.ssl;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import sun.security.ssl.CipherBox;
import sun.security.ssl.Debug;
import sun.security.ssl.EngineArgs;
import sun.security.ssl.EngineWriter;
import sun.security.ssl.InputRecord;
import sun.security.ssl.MAC;
import sun.security.ssl.OutputRecord;
import sun.security.ssl.SSLEngineImpl;

final class EngineOutputRecord
extends OutputRecord {
    private SSLEngineImpl engine;
    private EngineWriter writer;
    private boolean finishedMsg = false;

    EngineOutputRecord(byte by, SSLEngineImpl sSLEngineImpl) {
        super(by, EngineOutputRecord.recordSize(by));
        this.engine = sSLEngineImpl;
        this.writer = sSLEngineImpl.writer;
    }

    private static int recordSize(byte by) {
        switch (by) {
            case 20: 
            case 21: {
                return 539;
            }
            case 22: {
                return 16921;
            }
            case 23: {
                return 0;
            }
        }
        throw new RuntimeException("Unknown record type: " + by);
    }

    void setFinishedMsg() {
        this.finishedMsg = true;
    }

    @Override
    public void flush() throws IOException {
        this.finishedMsg = false;
    }

    boolean isFinishedMsg() {
        return this.finishedMsg;
    }

    private void addMAC(MAC mAC, ByteBuffer byteBuffer) throws IOException {
        if (mAC.MAClen() != 0) {
            byte[] byArray = mAC.compute(this.contentType(), byteBuffer);
            byteBuffer.limit(byteBuffer.limit() + byArray.length);
            byteBuffer.put(byArray);
        }
    }

    void encrypt(CipherBox cipherBox, ByteBuffer byteBuffer) {
        cipherBox.encrypt(byteBuffer);
    }

    @Override
    void writeBuffer(OutputStream outputStream, byte[] byArray, int n, int n2, int n3) throws IOException {
        ByteBuffer byteBuffer = (ByteBuffer)ByteBuffer.allocate(n2).put(byArray, 0, n2).flip();
        this.writer.putOutboundData(byteBuffer);
    }

    void write(MAC mAC, CipherBox cipherBox) throws IOException {
        switch (this.contentType()) {
            case 20: 
            case 21: 
            case 22: {
                break;
            }
            default: {
                throw new RuntimeException("unexpected byte buffers");
            }
        }
        if (!this.isEmpty()) {
            this.addMAC(mAC);
            this.encrypt(cipherBox);
            this.write((OutputStream)null, false, (ByteArrayOutputStream)null);
        }
    }

    void write(EngineArgs engineArgs, MAC mAC, CipherBox cipherBox) throws IOException {
        int n;
        assert (this.contentType() == 23);
        if (mAC == MAC.NULL) {
            return;
        }
        if (engineArgs.getAppRemaining() == 0) {
            return;
        }
        if (this.engine.needToSplitPayload(cipherBox, this.protocolVersion)) {
            this.write(engineArgs, mAC, cipherBox, 1);
            engineArgs.resetLim();
            n = Math.min(engineArgs.getAppRemaining(), 15846);
        } else {
            n = Math.min(engineArgs.getAppRemaining(), 16384);
        }
        if (n > 0) {
            this.write(engineArgs, mAC, cipherBox, n);
        }
    }

    void write(EngineArgs engineArgs, MAC mAC, CipherBox cipherBox, int n) throws IOException {
        ByteBuffer byteBuffer = engineArgs.netData;
        int n2 = byteBuffer.position();
        int n3 = byteBuffer.limit();
        int n4 = n2 + 5;
        byteBuffer.position(n4);
        engineArgs.gather(n);
        byteBuffer.limit(byteBuffer.position());
        byteBuffer.position(n4);
        this.addMAC(mAC, byteBuffer);
        byteBuffer.limit(byteBuffer.position());
        byteBuffer.position(n4);
        this.encrypt(cipherBox, byteBuffer);
        if (debug != null && (Debug.isOn("record") || Debug.isOn("handshake")) && (debug != null && Debug.isOn("record") || this.contentType() == 20)) {
            System.out.println(Thread.currentThread().getName() + ", WRITE: " + this.protocolVersion + " " + InputRecord.contentName(this.contentType()) + ", length = " + n);
        }
        int n5 = byteBuffer.limit() - n4;
        byteBuffer.put(n2, this.contentType());
        byteBuffer.put(n2 + 1, this.protocolVersion.major);
        byteBuffer.put(n2 + 2, this.protocolVersion.minor);
        byteBuffer.put(n2 + 3, (byte)(n5 >> 8));
        byteBuffer.put(n2 + 4, (byte)n5);
        byteBuffer.limit(n3);
    }
}

